config() {
  NEW="$1"
  OLD="$(dirname $NEW)/$(basename $NEW .new)"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "$(cat $OLD | md5sum)" = "$(cat $NEW | md5sum)" ]; then
    # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}

preserve_perms() {
  NEW="$1"
  OLD="$(dirname $NEW)/$(basename $NEW .new)"
  if [ -e $OLD ]; then
    cp -a $OLD ${NEW}.incoming
    cat $NEW > ${NEW}.incoming
    mv ${NEW}.incoming $NEW
  fi
  config $NEW
}

if [ -x /usr/bin/update-desktop-database ]; then
  /usr/bin/update-desktop-database -q usr/share/applications >/dev/null 2>&1
fi

if [ -x /usr/bin/update-mime-database ]; then
  /usr/bin/update-mime-database usr/share/mime >/dev/null 2>&1
fi

config etc/rox/xdg/rox.sourceforge.net/MIME-types/application_postscript.new
config etc/rox/xdg/rox.sourceforge.net/MIME-types/text.new
config etc/rox/xdg/rox.sourceforge.net/MIME-types/text_html.new

preserve_perms etc/profile.d/rox-filer.sh.new
preserve_perms etc/profile.d/rox-filer.csh.new
( cd usr/doc ; rm -rf rox-filer-2.11 )
( cd usr/doc ; ln -sf /usr/libexec/ROX-Filer/Help rox-filer-2.11 )
( cd usr/libexec/ROX-Filer/ROX/MIME ; rm -rf application-x-java-archive.png )
( cd usr/libexec/ROX-Filer/ROX/MIME ; ln -sf application-x-jar.png application-x-java-archive.png )
( cd usr/libexec/ROX-Filer/images ; rm -rf rox-symlink.png )
( cd usr/libexec/ROX-Filer/images ; ln -sf symlink.png rox-symlink.png )
( cd usr/man/man1 ; rm -rf ROX-Filer.1.gz )
( cd usr/man/man1 ; ln -sf rox.1.gz ROX-Filer.1.gz )
