config() {
  NEW="$1"
  OLD="$(dirname $NEW)/$(basename $NEW .new)"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "$(cat $OLD | md5sum)" = "$(cat $NEW | md5sum)" ]; then
    # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}

preserve_perms() {
  NEW="$1"
  OLD="$(dirname $NEW)/$(basename $NEW .new)"
  if [ -e $OLD ]; then
    cp -a $OLD ${NEW}.incoming
    cat $NEW > ${NEW}.incoming
    mv ${NEW}.incoming $NEW
  fi
  config $NEW
}

preserve_perms etc/rc.d/rc.munge.new
config etc/default/munge.new
( cd usr/lib ; rm -rf libmunge.so )
( cd usr/lib ; ln -sf libmunge.so.2.0.0 libmunge.so )
( cd usr/lib ; rm -rf libmunge.so.2 )
( cd usr/lib ; ln -sf libmunge.so.2.0.0 libmunge.so.2 )
( cd usr/man/man3 ; rm -rf munge_ctx_copy.3.gz )
( cd usr/man/man3 ; ln -sf munge_ctx.3.gz munge_ctx_copy.3.gz )
( cd usr/man/man3 ; rm -rf munge_ctx_create.3.gz )
( cd usr/man/man3 ; ln -sf munge_ctx.3.gz munge_ctx_create.3.gz )
( cd usr/man/man3 ; rm -rf munge_ctx_destroy.3.gz )
( cd usr/man/man3 ; ln -sf munge_ctx.3.gz munge_ctx_destroy.3.gz )
( cd usr/man/man3 ; rm -rf munge_ctx_get.3.gz )
( cd usr/man/man3 ; ln -sf munge_ctx.3.gz munge_ctx_get.3.gz )
( cd usr/man/man3 ; rm -rf munge_ctx_set.3.gz )
( cd usr/man/man3 ; ln -sf munge_ctx.3.gz munge_ctx_set.3.gz )
( cd usr/man/man3 ; rm -rf munge_ctx_strerror.3.gz )
( cd usr/man/man3 ; ln -sf munge_ctx.3.gz munge_ctx_strerror.3.gz )
( cd usr/man/man3 ; rm -rf munge_decode.3.gz )
( cd usr/man/man3 ; ln -sf munge.3.gz munge_decode.3.gz )
( cd usr/man/man3 ; rm -rf munge_encode.3.gz )
( cd usr/man/man3 ; ln -sf munge.3.gz munge_encode.3.gz )
( cd usr/man/man3 ; rm -rf munge_enum_int_to_str.3.gz )
( cd usr/man/man3 ; ln -sf munge_enum.3.gz munge_enum_int_to_str.3.gz )
( cd usr/man/man3 ; rm -rf munge_enum_is_valid.3.gz )
( cd usr/man/man3 ; ln -sf munge_enum.3.gz munge_enum_is_valid.3.gz )
( cd usr/man/man3 ; rm -rf munge_enum_str_to_int.3.gz )
( cd usr/man/man3 ; ln -sf munge_enum.3.gz munge_enum_str_to_int.3.gz )
( cd usr/man/man3 ; rm -rf munge_strerror.3.gz )
( cd usr/man/man3 ; ln -sf munge.3.gz munge_strerror.3.gz )
