config() {
  NEW="$1"
  OLD="$(dirname $NEW)/$(basename $NEW .new)"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "$(cat $OLD | md5sum)" = "$(cat $NEW | md5sum)" ]; then
    # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}

preserve_perms() {
  NEW="$1"
  OLD="$(dirname $NEW)/$(basename $NEW .new)"
  if [ -e $OLD ]; then
    cp -a $OLD ${NEW}.incoming
    cat $NEW > ${NEW}.incoming
    mv ${NEW}.incoming $NEW
  fi
  config $NEW
}

preserve_perms etc/rc.d/rc.libvirt.new

config etc/libvirt/libvirt-admin.conf.new
config etc/libvirt/libvirt.conf.new
config etc/libvirt/libvirtd.conf.new
config etc/libvirt/lxc.conf.new
config etc/libvirt/network.conf.new
config etc/libvirt/qemu-lockd.conf.new
config etc/libvirt/qemu.conf.new
config etc/libvirt/virt-login-shell.conf.new
config etc/libvirt/virtinterfaced.conf.new
config etc/libvirt/virtlockd.conf.new
config etc/libvirt/virtlogd.conf.new
config etc/libvirt/virtlxcd.conf.new
config etc/libvirt/virtnetworkd.conf.new
config etc/libvirt/virtnodedevd.conf.new
config etc/libvirt/virtnwfilterd.conf.new
config etc/libvirt/virtproxyd.conf.new
config etc/libvirt/virtqemud.conf.new
config etc/libvirt/virtsecretd.conf.new
config etc/libvirt/virtstoraged.conf.new
config etc/libvirt/virtvboxd.conf.new
config etc/libvirt/nwfilter/allow-arp.xml.new
config etc/libvirt/nwfilter/allow-dhcp-server.xml.new
config etc/libvirt/nwfilter/allow-dhcp.xml.new
config etc/libvirt/nwfilter/allow-dhcpv6-server.xml.new
config etc/libvirt/nwfilter/allow-dhcpv6.xml.new
config etc/libvirt/nwfilter/allow-incoming-ipv4.xml.new
config etc/libvirt/nwfilter/allow-incoming-ipv6.xml.new
config etc/libvirt/nwfilter/allow-ipv4.xml.new
config etc/libvirt/nwfilter/allow-ipv6.xml.new
config etc/libvirt/nwfilter/clean-traffic-gateway.xml.new
config etc/libvirt/nwfilter/clean-traffic.xml.new
config etc/libvirt/nwfilter/no-arp-ip-spoofing.xml.new
config etc/libvirt/nwfilter/no-arp-mac-spoofing.xml.new
config etc/libvirt/nwfilter/no-arp-spoofing.xml.new
config etc/libvirt/nwfilter/no-ip-multicast.xml.new
config etc/libvirt/nwfilter/no-ip-spoofing.xml.new
config etc/libvirt/nwfilter/no-ipv6-multicast.xml.new
config etc/libvirt/nwfilter/no-ipv6-spoofing.xml.new
config etc/libvirt/nwfilter/no-mac-broadcast.xml.new
config etc/libvirt/nwfilter/no-mac-spoofing.xml.new
config etc/libvirt/nwfilter/no-other-l2-traffic.xml.new
config etc/libvirt/nwfilter/no-other-rarp-traffic.xml.new
config etc/libvirt/nwfilter/qemu-announce-self-rarp.xml.new
config etc/libvirt/nwfilter/qemu-announce-self.xml.new
config etc/libvirt/qemu/networks/default.xml.new
config etc/logrotate.d/libvirtd.new
config etc/logrotate.d/libvirtd.libxl.new
config etc/logrotate.d/libvirtd.lxc.new
config etc/logrotate.d/libvirtd.qemu.new
config etc/sasl2/libvirt.conf.new
config etc/sysctl.d/60-libvirtd.conf.new
( cd etc/libvirt/qemu/networks/autostart ; rm -rf default.xml )
( cd etc/libvirt/qemu/networks/autostart ; ln -sf ../default.xml default.xml )
( cd usr/lib ; rm -rf libvirt-admin.so )
( cd usr/lib ; ln -sf libvirt-admin.so.0 libvirt-admin.so )
( cd usr/lib ; rm -rf libvirt-admin.so.0 )
( cd usr/lib ; ln -sf libvirt-admin.so.0.10010.0 libvirt-admin.so.0 )
( cd usr/lib ; rm -rf libvirt-lxc.so )
( cd usr/lib ; ln -sf libvirt-lxc.so.0 libvirt-lxc.so )
( cd usr/lib ; rm -rf libvirt-lxc.so.0 )
( cd usr/lib ; ln -sf libvirt-lxc.so.0.10010.0 libvirt-lxc.so.0 )
( cd usr/lib ; rm -rf libvirt-qemu.so )
( cd usr/lib ; ln -sf libvirt-qemu.so.0 libvirt-qemu.so )
( cd usr/lib ; rm -rf libvirt-qemu.so.0 )
( cd usr/lib ; ln -sf libvirt-qemu.so.0.10010.0 libvirt-qemu.so.0 )
( cd usr/lib ; rm -rf libvirt.so )
( cd usr/lib ; ln -sf libvirt.so.0 libvirt.so )
( cd usr/lib ; rm -rf libvirt.so.0 )
( cd usr/lib ; ln -sf libvirt.so.0.10010.0 libvirt.so.0 )
