config() {
  NEW="$1"
  OLD="$(dirname $NEW)/$(basename $NEW .new)"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "$(cat $OLD | md5sum)" = "$(cat $NEW | md5sum)" ]; then
    # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}

preserve_perms() {
  NEW="$1"
  OLD="$(dirname $NEW)/$(basename $NEW .new)"
  if [ -e $OLD ]; then
    cp -a $OLD ${NEW}.incoming
    cat $NEW > ${NEW}.incoming
    mv ${NEW}.incoming $NEW
  fi
  config $NEW
}


preserve_perms etc/rc.d/rc.avahidaemon.new
preserve_perms etc/rc.d/rc.avahidnsconfd.new
preserve_perms etc/avahi/avahi-daemon.conf.new

if [ -x /usr/bin/update-desktop-database ]; then
  /usr/bin/update-desktop-database -q usr/share/applications >/dev/null 2>&1
fi

# Reload messagebus service
if [ -x etc/rc.d/rc.messagebus ]; then
  chroot . /etc/rc.d/rc.messagebus reload
fi

( cd usr/bin ; rm -rf avahi-browse-domains )
( cd usr/bin ; ln -sf avahi-browse avahi-browse-domains )
( cd usr/bin ; rm -rf avahi-publish-address )
( cd usr/bin ; ln -sf avahi-publish avahi-publish-address )
( cd usr/bin ; rm -rf avahi-publish-service )
( cd usr/bin ; ln -sf avahi-publish avahi-publish-service )
( cd usr/bin ; rm -rf avahi-resolve-address )
( cd usr/bin ; ln -sf avahi-resolve avahi-resolve-address )
( cd usr/bin ; rm -rf avahi-resolve-host-name )
( cd usr/bin ; ln -sf avahi-resolve avahi-resolve-host-name )
( cd usr/bin ; rm -rf bshell )
( cd usr/bin ; ln -sf bssh bshell )
( cd usr/bin ; rm -rf bvnc )
( cd usr/bin ; ln -sf bssh bvnc )
( cd usr/lib ; rm -rf libavahi-client.so )
( cd usr/lib ; ln -sf libavahi-client.so.3.2.9 libavahi-client.so )
( cd usr/lib ; rm -rf libavahi-client.so.3 )
( cd usr/lib ; ln -sf libavahi-client.so.3.2.9 libavahi-client.so.3 )
( cd usr/lib ; rm -rf libavahi-common.so )
( cd usr/lib ; ln -sf libavahi-common.so.3.5.4 libavahi-common.so )
( cd usr/lib ; rm -rf libavahi-common.so.3 )
( cd usr/lib ; ln -sf libavahi-common.so.3.5.4 libavahi-common.so.3 )
( cd usr/lib ; rm -rf libavahi-core.so )
( cd usr/lib ; ln -sf libavahi-core.so.7.1.0 libavahi-core.so )
( cd usr/lib ; rm -rf libavahi-core.so.7 )
( cd usr/lib ; ln -sf libavahi-core.so.7.1.0 libavahi-core.so.7 )
( cd usr/lib ; rm -rf libavahi-glib.so )
( cd usr/lib ; ln -sf libavahi-glib.so.1.0.2 libavahi-glib.so )
( cd usr/lib ; rm -rf libavahi-glib.so.1 )
( cd usr/lib ; ln -sf libavahi-glib.so.1.0.2 libavahi-glib.so.1 )
( cd usr/lib ; rm -rf libavahi-gobject.so )
( cd usr/lib ; ln -sf libavahi-gobject.so.0.0.5 libavahi-gobject.so )
( cd usr/lib ; rm -rf libavahi-gobject.so.0 )
( cd usr/lib ; ln -sf libavahi-gobject.so.0.0.5 libavahi-gobject.so.0 )
( cd usr/lib ; rm -rf libavahi-libevent.so )
( cd usr/lib ; ln -sf libavahi-libevent.so.1.0.0 libavahi-libevent.so )
( cd usr/lib ; rm -rf libavahi-libevent.so.1 )
( cd usr/lib ; ln -sf libavahi-libevent.so.1.0.0 libavahi-libevent.so.1 )
( cd usr/lib ; rm -rf libavahi-qt5.so )
( cd usr/lib ; ln -sf libavahi-qt5.so.1.0.2 libavahi-qt5.so )
( cd usr/lib ; rm -rf libavahi-qt5.so.1 )
( cd usr/lib ; ln -sf libavahi-qt5.so.1.0.2 libavahi-qt5.so.1 )
( cd usr/lib ; rm -rf libavahi-ui-gtk3.so )
( cd usr/lib ; ln -sf libavahi-ui-gtk3.so.0.1.4 libavahi-ui-gtk3.so )
( cd usr/lib ; rm -rf libavahi-ui-gtk3.so.0 )
( cd usr/lib ; ln -sf libavahi-ui-gtk3.so.0.1.4 libavahi-ui-gtk3.so.0 )
( cd usr/lib ; rm -rf libavahi-ui.so )
( cd usr/lib ; ln -sf libavahi-ui.so.0.1.4 libavahi-ui.so )
( cd usr/lib ; rm -rf libavahi-ui.so.0 )
( cd usr/lib ; ln -sf libavahi-ui.so.0.1.4 libavahi-ui.so.0 )
( cd usr/lib ; rm -rf libdns_sd.so )
( cd usr/lib ; ln -sf libdns_sd.so.1.0.0 libdns_sd.so )
( cd usr/lib ; rm -rf libdns_sd.so.1 )
( cd usr/lib ; ln -sf libdns_sd.so.1.0.0 libdns_sd.so.1 )
( cd usr/man/man1 ; rm -rf avahi-browse-domains.1 )
( cd usr/man/man1 ; ln -sf avahi-browse.1 avahi-browse-domains.1 )
( cd usr/man/man1 ; rm -rf avahi-publish-address.1 )
( cd usr/man/man1 ; ln -sf avahi-publish.1 avahi-publish-address.1 )
( cd usr/man/man1 ; rm -rf avahi-publish-service.1 )
( cd usr/man/man1 ; ln -sf avahi-publish.1 avahi-publish-service.1 )
( cd usr/man/man1 ; rm -rf avahi-resolve-address.1 )
( cd usr/man/man1 ; ln -sf avahi-resolve.1 avahi-resolve-address.1 )
( cd usr/man/man1 ; rm -rf avahi-resolve-host-name.1 )
( cd usr/man/man1 ; ln -sf avahi-resolve.1 avahi-resolve-host-name.1 )
( cd usr/man/man1 ; rm -rf bshell.1 )
( cd usr/man/man1 ; ln -sf bssh.1 bshell.1 )
( cd usr/man/man1 ; rm -rf bvnc.1 )
( cd usr/man/man1 ; ln -sf bssh.1 bvnc.1 )
