/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.java.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.TableModel;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CommonTokenStream;
import org.argouml.i18n.Translator;
import org.argouml.kernel.Project;
import org.argouml.kernel.ProjectManager;
import org.argouml.language.java.reveng.JavaLexer;
import org.argouml.language.java.reveng.JavaParser;
import org.argouml.language.java.reveng.Modeller;
import org.argouml.model.Model;
import org.argouml.profile.Profile;
import org.argouml.ui.CheckboxTableModel;
import org.argouml.ui.targetmanager.TargetManager;
import org.argouml.uml.diagram.ArgoDiagram;
import org.argouml.uml.diagram.DiagramElement;
import org.argouml.uml.diagram.DiagramFactory;
import org.argouml.uml.ui.ActionDeleteModelElements;
import org.argouml.util.ArgoDialog;

public class RESequenceDiagramDialog
extends ArgoDialog
implements ActionListener,
ItemListener {
    private static final Logger LOG = Logger.getLogger(RESequenceDiagramDialog.class.getName());
    private static final long serialVersionUID = -8595714827064181907L;
    private static final int X_OFFSET = 10;
    private final Project project;
    private final Object model;
    private Modeller modeller;
    private final Object classifier;
    private final Object operation;
    private final List<String> calls = new ArrayList<String>();
    private final List<String> calldata = new ArrayList<String>();
    private final Hashtable<String, String> types = new Hashtable();
    private final ArgoDiagram diagram;
    private CheckboxTableModel callTable;
    private JComboBox modeChoice;
    private JPanel changingPanel;
    private JPanel manuPanel;
    private JPanel autoPanel;
    private final boolean isNewSequenceDiagram;

    public RESequenceDiagramDialog(Object oper) {
        this(oper, null, null);
    }

    public RESequenceDiagramDialog(Object oper, DiagramElement figMessage, ArgoDiagram aDiagram) {
        super("NOT FUNCTIONAL!!! " + Translator.localize((String)"dialog.title.reverse-engineer-sequence-diagram") + (oper != null ? ' ' + Model.getFacade().getName(oper) + "()" : ""), 5, true);
        this.setResizable(false);
        this.project = ProjectManager.getManager().getCurrentProject();
        this.operation = oper;
        this.model = this.project.getUserDefinedModelList().get(0);
        Profile javaProfile = null;
        for (Profile profile : this.project.getProfileConfiguration().getProfiles()) {
            if (!"Java".equals(profile.getDisplayName())) continue;
            javaProfile = profile;
        }
        try {
            this.modeller = new Modeller(this.model, javaProfile, true, true, null);
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Modeller not ready, so no more generation of calls", ex);
        }
        this.classifier = Model.getFacade().getOwner(this.operation);
        if (figMessage != null) {
            this.diagram = aDiagram;
            this.isNewSequenceDiagram = false;
        } else {
            this.isNewSequenceDiagram = true;
            this.diagram = this.buildSequenceDiagram(this.classifier);
        }
        this.parseBody();
        JPanel contentPanel = this.getContentPanel();
        this.setContent(contentPanel);
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() != this.getOkButton() && e.getSource() == this.getCancelButton() && this.isNewSequenceDiagram) {
            Object newTarget = null;
            if (ActionDeleteModelElements.sureRemove((Object)this.diagram)) {
                Object collaboration = this.diagram.getNamespace();
                newTarget = this.getNewTarget(this.diagram);
                this.project.moveToTrash((Object)this.diagram);
                this.project.moveToTrash(collaboration);
            }
            if (newTarget != null) {
                TargetManager.getInstance().setTarget(newTarget);
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (this.modeChoice.getSelectedIndex() != 1) {
            this.changingPanel.remove(this.autoPanel);
            this.changingPanel.add((Component)this.manuPanel, "Center");
            this.pack();
        } else {
            this.changingPanel.remove(this.manuPanel);
            this.changingPanel.add((Component)this.autoPanel, "Center");
            this.pack();
        }
    }

    private Object getNewTarget(Object target) {
        ArgoDiagram firstDiagram;
        Object newTarget = null;
        newTarget = Model.getFacade().isAModelElement(target) && Model.getFacade().getNamespace(target) != null ? Model.getFacade().getNamespace(target) : (target instanceof ArgoDiagram ? (target != (firstDiagram = (ArgoDiagram)this.project.getDiagramList().get(0)) ? firstDiagram : (this.project.getDiagramList().size() > 1 ? this.project.getDiagramList().get(1) : this.project.getRoots().iterator().next())) : this.project.getRoots().iterator().next());
        return newTarget;
    }

    private JPanel getContentPanel() {
        JPanel content = new JPanel();
        content.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(2, 2, 2, 2);
        content.add((Component)new JLabel("Mode:"), constraints);
        constraints.gridy = 1;
        this.modeChoice = new JComboBox();
        this.modeChoice.addItem("Manually select calls of this operation");
        this.modeChoice.addItem("Traverse calls automatically with a chosen depth");
        this.modeChoice.addItemListener(this);
        content.add((Component)this.modeChoice, constraints);
        this.manuPanel = this.getManuallyTab();
        this.autoPanel = this.getAutomaticallyTab();
        constraints.gridy = 2;
        this.changingPanel = new JPanel(new BorderLayout(0, 0));
        this.changingPanel.add((Component)this.manuPanel, "Center");
        content.add((Component)this.changingPanel, constraints);
        return content;
    }

    private JPanel getAutomaticallyTab() {
        JPanel top = new JPanel();
        top.setLayout(new GridBagLayout());
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.anchor = 17;
        labelConstraints.gridy = 0;
        labelConstraints.gridx = 0;
        labelConstraints.insets = new Insets(10, 2, 2, 2);
        GridBagConstraints fieldConstraints = new GridBagConstraints();
        fieldConstraints.anchor = 17;
        fieldConstraints.fill = 0;
        fieldConstraints.gridy = 0;
        fieldConstraints.gridx = 1;
        fieldConstraints.weightx = 1.0;
        fieldConstraints.insets = new Insets(4, 2, 2, 2);
        JPanel depthPanel = new JPanel(new FlowLayout());
        JRadioButton unlimited = new JRadioButton("unlimited");
        JRadioButton limited = new JRadioButton("limit to", true);
        ButtonGroup group = new ButtonGroup();
        group.add(unlimited);
        group.add(limited);
        depthPanel.add(limited);
        depthPanel.add(new JSpinner(new SpinnerNumberModel(1, 0, 999, 1)));
        depthPanel.add(unlimited);
        labelConstraints.gridy = 0;
        fieldConstraints.gridy = 0;
        top.add((Component)new JLabel("Depth:"), labelConstraints);
        top.add((Component)depthPanel, fieldConstraints);
        labelConstraints.gridy = 1;
        fieldConstraints.gridy = 1;
        top.add((Component)new JLabel("Assumption table:"), labelConstraints);
        top.add((Component)new JButton("Update"), fieldConstraints);
        ArrayList<String> assumptions = new ArrayList<String>();
        assumptions.add("calls.hasMoreElements()");
        assumptions.add("methods != null && !methods.isEmpty()");
        Object[] data = null;
        JTable table = new JTable((TableModel)new CheckboxTableModel(assumptions.toArray(), data, "Conditions", "Assume true"));
        table.setShowVerticalLines(true);
        fieldConstraints.gridx = 0;
        fieldConstraints.gridy = 2;
        fieldConstraints.gridwidth = 2;
        fieldConstraints.anchor = 10;
        fieldConstraints.fill = 1;
        fieldConstraints.weighty = 1.0;
        top.add((Component)new JScrollPane(table), fieldConstraints);
        fieldConstraints.insets = new Insets(0, 2, 0, 2);
        JCheckBox checkbox1 = new JCheckBox("also process create calls", true);
        fieldConstraints.gridy = 3;
        top.add((Component)checkbox1, fieldConstraints);
        JCheckBox checkbox2 = new JCheckBox("also process local calls", true);
        fieldConstraints.gridy = 4;
        top.add((Component)checkbox2, fieldConstraints);
        JCheckBox checkbox3 = new JCheckBox("also process calls inside package", true);
        fieldConstraints.gridy = 5;
        top.add((Component)checkbox3, fieldConstraints);
        return top;
    }

    private JPanel getManuallyTab() {
        JPanel top = new JPanel();
        top.setLayout(new GridBagLayout());
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.anchor = 17;
        labelConstraints.gridx = 0;
        labelConstraints.gridy = 0;
        labelConstraints.insets = new Insets(10, 2, 2, 2);
        GridBagConstraints fieldConstraints = new GridBagConstraints();
        fieldConstraints.anchor = 17;
        fieldConstraints.fill = 0;
        fieldConstraints.gridx = 1;
        fieldConstraints.gridy = 0;
        fieldConstraints.weightx = 1.0;
        fieldConstraints.insets = new Insets(4, 2, 2, 2);
        top.add((Component)new JLabel("Method call table:"), labelConstraints);
        this.callTable = new CheckboxTableModel(this.calls.toArray(), this.calldata.toArray(), "Method calls", "Enable");
        JTable table = new JTable((TableModel)this.callTable);
        table.setShowVerticalLines(true);
        fieldConstraints.gridx = 0;
        fieldConstraints.gridy = 1;
        fieldConstraints.gridwidth = 2;
        fieldConstraints.anchor = 10;
        fieldConstraints.fill = 1;
        fieldConstraints.weighty = 1.0;
        top.add((Component)new JScrollPane(table), fieldConstraints);
        fieldConstraints.insets = new Insets(0, 2, 0, 2);
        JCheckBox checkbox1 = new JCheckBox("(un)check create calls", true);
        fieldConstraints.gridy = 2;
        top.add((Component)checkbox1, fieldConstraints);
        JCheckBox checkbox2 = new JCheckBox("(un)check local calls", true);
        fieldConstraints.gridy = 3;
        top.add((Component)checkbox2, fieldConstraints);
        JCheckBox checkbox3 = new JCheckBox("(un)check package calls", true);
        fieldConstraints.gridy = 4;
        top.add((Component)checkbox3, fieldConstraints);
        JCheckBox checkbox4 = new JCheckBox("(un)check far calls", true);
        fieldConstraints.gridy = 5;
        top.add((Component)checkbox4, fieldConstraints);
        return top;
    }

    private ArgoDiagram buildSequenceDiagram(Object theClassifier) {
        Object collaboration = Model.getCollaborationsFactory().buildCollaboration(Model.getFacade().getNamespace(theClassifier), theClassifier);
        ArgoDiagram newDiagram = DiagramFactory.getInstance().createDiagram(DiagramFactory.DiagramType.Sequence, collaboration, null);
        this.project.addMember((Object)newDiagram);
        TargetManager.getInstance().setTarget((Object)newDiagram);
        return newDiagram;
    }

    private void parseBody() {
        JavaLexer lexer = null;
        CommonTokenStream tokens = null;
        JavaParser parser = null;
        this.calls.clear();
        this.types.clear();
        if (this.modeller != null) {
            this.modeller.clearMethodCalls();
            this.modeller.clearLocalVariableDeclarations();
        }
        try {
            lexer = new JavaLexer(new ANTLRStringStream('{' + RESequenceDiagramDialog.getBody(this.operation) + '}'));
            tokens = new CommonTokenStream(lexer);
            parser = new JavaParser(tokens);
            parser.setModeller(this.modeller);
            parser.setParserMode(8);
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Parser not ready, so no more generation of calls", ex);
        }
        if (this.modeller != null && parser != null) {
            try {
                parser.block();
            }
            catch (Exception ex) {
                LOG.log(Level.FINE, "Parsing method body failed:", ex);
            }
            List<String> methodCalls = this.modeller.getMethodCalls();
            if (methodCalls != null) {
                this.calls.addAll(methodCalls);
                this.types.putAll(this.modeller.getLocalVariableDeclarations());
            }
        }
    }

    private static String getBody(Object operation) {
        String body = null;
        Collection methods = Model.getFacade().getMethods(operation);
        if (methods != null && !methods.isEmpty()) {
            Object expression = Model.getFacade().getBody(methods.iterator().next());
            body = (String)Model.getFacade().getBody(expression);
        }
        if (body == null) {
            body = "";
        }
        return body;
    }

    private void ensureDirectedAssociation(Object fromCls, Object toCls) {
        String fromName = Model.getFacade().getName(fromCls);
        String toName = Model.getFacade().getName(toCls);
        Object assocEnd = null;
        for (Object ae : Model.getFacade().getAssociationEnds(toCls)) {
            Object assoc = Model.getFacade().getAssociation(ae);
            if (Model.getFacade().getConnections(assoc).size() != 2 || Model.getFacade().getType(Model.getFacade().getNextEnd(ae)) != fromCls || Model.getFacade().getName(ae) != null || !Model.getFacade().isNavigable(ae)) continue;
            assocEnd = ae;
        }
        if (assocEnd == null) {
            String assocName = fromName + " -> " + toName;
            Modeller.buildDirectedAssociation(assocName, fromCls, toCls);
        }
    }

    private Object permissionLookup(Object comp, String clsName) {
        Iterator iter1;
        Object theClassifier = null;
        Collection cdeps = Model.getFacade().getClientDependencies(comp);
        Iterator iterator = iter1 = cdeps != null ? cdeps.iterator() : null;
        while (theClassifier == null && iter1 != null && iter1.hasNext()) {
            Iterator iter2;
            Object perm = iter1.next();
            if (!Model.getFacade().isAPackageImport(perm)) continue;
            Collection suppliers = Model.getFacade().getSuppliers(perm);
            Iterator iterator2 = iter2 = suppliers != null ? suppliers.iterator() : null;
            while (theClassifier == null && iter2 != null && iter2.hasNext()) {
                Object elem = iter2.next();
                if (!Model.getFacade().isAClassifier(elem) || !clsName.equals(Model.getFacade().getName(elem))) continue;
                theClassifier = elem;
            }
        }
        return theClassifier;
    }
}

