/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.OccurrenceIndicator;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.sxpath.XPathStaticContext;
import net.sf.saxon.sxpath.XPathVariable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;

public class XPathCompiler {
    private Processor processor;
    private IndependentContext env;
    private ArrayList<XPathVariable> declaredVariables = new ArrayList();

    protected XPathCompiler(Processor processor) {
        this.processor = processor;
        this.env = new IndependentContext(processor.getUnderlyingConfiguration());
    }

    public void setBackwardsCompatible(boolean option) {
        this.env.setBackwardsCompatibilityMode(option);
    }

    public boolean isBackwardsCompatible() {
        return this.env.isInBackwardsCompatibleMode();
    }

    public void setBaseURI(URI uri) {
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("Supplied base URI must be absolute");
        }
        this.env.setBaseURI(uri.toString());
    }

    public URI getBaseURI() {
        try {
            return new URI(this.env.getBaseURI());
        }
        catch (URISyntaxException err) {
            throw new IllegalStateException(err);
        }
    }

    public void declareNamespace(String prefix, String uri) {
        this.env.declareNamespace(prefix, uri);
    }

    public void importSchemaNamespace(String uri) {
        this.env.getImportedSchemaNamespaces().add(uri);
    }

    public void declareVariable(QName qname) {
        XPathVariable var = this.env.declareVariable(qname.getNamespaceURI(), qname.getLocalName());
        this.declaredVariables.add(var);
    }

    public void declareVariable(QName qname, ItemType itemType, OccurrenceIndicator occurrences) throws SaxonApiException {
        XPathVariable var = this.env.declareVariable(qname.getNamespaceURI(), qname.getLocalName());
        var.setRequiredType(SequenceType.makeSequenceType((net.sf.saxon.type.ItemType)itemType.getUnderlyingItemType(), (int)occurrences.getCardinality()));
        this.declaredVariables.add(var);
    }

    public XPathExecutable compile(String source) throws SaxonApiException {
        try {
            XPathEvaluator eval = new XPathEvaluator(this.processor.getUnderlyingConfiguration());
            eval.setStaticContext((XPathStaticContext)this.env);
            XPathExpression cexp = eval.createExpression(source);
            return new XPathExecutable(cexp, this.processor, this.env, this.declaredVariables);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public XPathExecutable compilePattern(String source) throws SaxonApiException {
        try {
            XPathEvaluator eval = new XPathEvaluator(this.processor.getUnderlyingConfiguration());
            eval.setStaticContext((XPathStaticContext)this.env);
            XPathExpression cexp = eval.createPattern(source);
            return new XPathExecutable(cexp, this.processor, this.env, this.declaredVariables);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public StaticContext getUnderlyingStaticContext() {
        return this.env;
    }
}

