/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.om.Item;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SchemaManager;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XQueryCompiler;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.trans.XPathException;

public class Processor {
    private Configuration config;
    private SchemaManager schemaManager;

    public Processor(boolean schemaAware) {
        if (schemaAware) {
            this.config = Configuration.makeSchemaAwareConfiguration(null, null);
            this.schemaManager = new SchemaManager(this.config);
        } else {
            this.config = new Configuration();
        }
    }

    public DocumentBuilder newDocumentBuilder() {
        return new DocumentBuilder(this.config);
    }

    public XPathCompiler newXPathCompiler() {
        return new XPathCompiler(this);
    }

    public XsltCompiler newXsltCompiler() {
        if (this.isSchemaAware() && !this.config.isSchemaAware(50)) {
            throw new UnsupportedOperationException("XSLT processing is not supported with this Saxon installation");
        }
        return new XsltCompiler(this);
    }

    public XQueryCompiler newXQueryCompiler() {
        if (this.isSchemaAware() && !this.config.isSchemaAware(51)) {
            throw new UnsupportedOperationException("XQuery processing is not supported with this Saxon installation");
        }
        return new XQueryCompiler(this);
    }

    public SchemaManager getSchemaManager() {
        return this.schemaManager;
    }

    public boolean isSchemaAware() {
        return this.config.isSchemaAware(52);
    }

    public String getSaxonProductVersion() {
        return Version.getProductVersion();
    }

    public void setXmlVersion(String version) {
        if (version.equals("1.0")) {
            this.config.setXMLVersion(10);
        } else if (version.equals("1.1")) {
            this.config.setXMLVersion(11);
        } else {
            throw new IllegalArgumentException("XmlVersion");
        }
    }

    public String getXmlVersion() {
        if (this.config.getXMLVersion() == 10) {
            return "1.0";
        }
        return "1.1";
    }

    public void setConfigurationProperty(String name, Object value) {
        this.config.setConfigurationProperty(name, value);
    }

    public Object getConfigurationProperty(String name) {
        return this.config.getConfigurationProperty(name);
    }

    public Configuration getUnderlyingConfiguration() {
        return this.config;
    }

    public void writeXdmValue(XdmValue value, Destination destination) throws SaxonApiException {
        try {
            Receiver out = destination.getReceiver(this.config);
            out.setPipelineConfiguration(this.config.makePipelineConfiguration());
            out = new NamespaceReducer(out);
            TreeReceiver tree = new TreeReceiver(out);
            tree.open();
            tree.startDocument(0);
            for (XdmItem item : value) {
                tree.append((Item)item.getUnderlyingValue(), 0, 2);
            }
            tree.endDocument();
            tree.close();
        }
        catch (XPathException err) {
            throw new SaxonApiException(err);
        }
    }
}

