/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.php.generator;

import java.util.TreeMap;
import javax.swing.Icon;
import org.apache.log4j.Logger;
import org.argouml.application.helpers.ResourceLoaderWrapper;
import org.argouml.language.php.generator.GeneratorPHP4;
import org.argouml.moduleloader.ModuleInterface;
import org.argouml.uml.generator.CodeGenerator;
import org.argouml.uml.generator.GeneratorHelper;
import org.argouml.uml.generator.GeneratorManager;
import org.argouml.uml.generator.Language;

public class ModulePHP4
implements ModuleInterface {
    private static final Logger LOG = Logger.getLogger(ModulePHP4.class);
    private Language myLang;
    private int version;
    static final int LANGUAGE_MAJOR_VERSION = 4;
    protected static final String LANGUAGE_NAME = "PHP";
    protected static final String ICON_NAME = "PHPNotation";
    protected static final TreeMap<String, String> TM_INFO_BLOCK_LOGGED = new TreeMap();

    public ModulePHP4() {
        this(4);
    }

    protected ModulePHP4(int n) {
        this.version = n;
    }

    public String getName() {
        return "Generator" + LANGUAGE_NAME.toUpperCase() + this.version;
    }

    public String getInfo(int n) {
        switch (n) {
            case 0: {
                return "notation and source code generator for " + LANGUAGE_NAME.toUpperCase() + this.version;
            }
            case 1: {
                return "Kai Schr\u00f6der";
            }
            case 2: {
                return "0.0.$Revision: 308 $";
            }
        }
        return null;
    }

    public boolean enable() {
        if (this.myLang == null) {
            this.myLang = GeneratorHelper.makeLanguage((String)(LANGUAGE_NAME + this.version), (Icon)ResourceLoaderWrapper.lookupIconResource((String)ICON_NAME));
        }
        GeneratorManager.getInstance().addGenerator(this.myLang, (CodeGenerator)this.getGeneratorPHP());
        this.logModuleInfo();
        return true;
    }

    protected GeneratorPHP4 getGeneratorPHP() {
        return new GeneratorPHP4(this.version);
    }

    public boolean disable() {
        GeneratorManager.getInstance().removeGenerator(this.myLang);
        return true;
    }

    protected final void logModuleInfo() {
        this.logModuleInfo(0);
    }

    protected final void logModuleInfo(int n) {
        if (!TM_INFO_BLOCK_LOGGED.containsKey(this.getClass().toString())) {
            StringBuffer stringBuffer = new StringBuffer("| Module ");
            stringBuffer.append(this.getName() + " " + this.getInfo(2) + " |");
            StringBuffer stringBuffer2 = new StringBuffer("| Copyright (c) 2006, ");
            stringBuffer2.append(this.getInfo(1) + " |");
            StringBuffer stringBuffer3 = new StringBuffer("| ");
            stringBuffer3.append(this.getInfo(0) + " |");
            if (stringBuffer.length() > n) {
                n = stringBuffer.length();
            }
            if (stringBuffer2.length() > n) {
                n = stringBuffer2.length();
            }
            if (stringBuffer3.length() > n) {
                n = stringBuffer3.length();
            }
            String string = "+";
            for (int i = 1; i <= n - 2; ++i) {
                string = string + "-";
            }
            string = string + "+";
            String string2 = "";
            for (int i = 1; i <= n; ++i) {
                string2 = string2 + " ";
            }
            while (stringBuffer.length() < n) {
                stringBuffer.insert(stringBuffer.length() - 2, " ");
                if (stringBuffer.length() >= n) continue;
                stringBuffer.insert(2, " ");
            }
            while (stringBuffer2.length() < n) {
                stringBuffer2.insert(stringBuffer2.length() - 2, " ");
            }
            while (stringBuffer3.length() < n) {
                stringBuffer3.insert(stringBuffer3.length() - 2, " ");
            }
            LOG.info((Object)string2);
            LOG.info((Object)string);
            LOG.info((Object)stringBuffer.toString());
            LOG.info((Object)string);
            LOG.info((Object)stringBuffer2.toString());
            LOG.info((Object)("| " + string2.substring(4) + " |"));
            LOG.info((Object)stringBuffer3.toString());
            LOG.info((Object)string);
            LOG.info((Object)string2);
            TM_INFO_BLOCK_LOGGED.put(this.getClass().toString(), "true");
        }
    }
}

