/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.model;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.argouml.application.helpers.ResourceLoaderWrapper;
import org.argouml.core.propertypanels.model.GetterSetterManager;
import org.argouml.core.propertypanels.model.IconIdentifiable;
import org.argouml.core.propertypanels.model.Named;
import org.argouml.i18n.Translator;
import org.argouml.kernel.Command;
import org.argouml.kernel.NonUndoableCommand;
import org.argouml.kernel.ProfileConfiguration;
import org.argouml.kernel.Project;
import org.argouml.kernel.ProjectManager;
import org.argouml.model.Model;
import org.argouml.model.ModelManagementHelper;
import org.argouml.model.PseudostateKind;
import org.argouml.profile.Profile;
import org.argouml.profile.ProfileException;
import org.argouml.ui.targetmanager.TargetManager;
import org.argouml.uml.ui.UMLAddDialog;
import org.argouml.util.ArgoFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GetterSetterManagerImpl
extends GetterSetterManager {
    private static final Logger LOG = Logger.getLogger(GetterSetterManagerImpl.class.getName());

    public GetterSetterManagerImpl(Class<?> type) {
        this.build(type);
    }

    private void build(Class<?> type) {
        this.addGetterSetter("action", new ActionGetterSetter());
        this.addGetterSetter("actualArgument", new ArgumentGetterSetter());
        this.addGetterSetter("aggregation", new AggregationGetterSetter());
        this.addGetterSetter("baseClass", new BaseClassGetterSetter());
        this.addGetterSetter("base", new BaseGetterSetter());
        this.addGetterSetter("body", new MethodExpressionGetterSetter());
        this.addGetterSetter("changeability", new ChangeabilityGetterSetter());
        this.addGetterSetter("classifier", new ClassifierGetterSetter());
        this.addGetterSetter("concurrency", new ConcurrencyGetterSetter());
        this.addGetterSetter("deferrableEvent", new DeferrableEventGetterSetter());
        this.addGetterSetter("definedTag", new TagDefinitionGetterSetter());
        this.addGetterSetter("derived", new DerivedGetterSetter());
        this.addGetterSetter("doActivity", new DoActivityActionGetterSetter());
        this.addGetterSetter("entry", new EntryActionGetterSetter());
        this.addGetterSetter("exit", new ExitActionGetterSetter());
        this.addGetterSetter("extensionPoint", new ExtensionPointGetterSetter());
        this.addGetterSetter("effect", new EffectGetterSetter());
        this.addGetterSetter("elementImport", new ElementImportGetterSetter());
        this.addGetterSetter("feature", new FeatureGetterSetter());
        this.addGetterSetter("guard", new GuardGetterSetter());
        this.addGetterSetter("internalTransition", new InternalTransitionGetterSetter());
        this.addGetterSetter("isAbstract", new AbstractGetterSetter());
        this.addGetterSetter("isActive", new ActiveGetterSetter());
        this.addGetterSetter("isLeaf", new LeafGetterSetter());
        this.addGetterSetter("isNavigable", new NavigableGetterSetter());
        this.addGetterSetter("isQuery", new QueryGetterSetter());
        this.addGetterSetter("isRoot", new RootGetterSetter());
        this.addGetterSetter("isSynch", new SynchGetterSetter());
        this.addGetterSetter("isAsynchronous", new AsynchronousGetterSetter());
        this.addGetterSetter("kind", new ParameterDirectionGetterSetter());
        this.addGetterSetter("literal", new LiteralGetterSetter());
        this.addGetterSetter("message", new MessageGetterSetter());
        this.addGetterSetter("method", new MethodGetterSetter());
        this.addGetterSetter("navigable", new NavigableGetterSetter());
        this.addGetterSetter("ordering", new OrderingGetterSetter());
        this.addGetterSetter("ownedElement", new OwnedElementGetterSetter());
        this.addGetterSetter("ownerScope", new OwnerScopeGetterSetter());
        this.addGetterSetter("parameter", new ParameterGetterSetter());
        this.addGetterSetter("qualifier", new QualifierGetterSetter());
        this.addGetterSetter("raisedException", new RaisedExceptionGetterSetter());
        this.addGetterSetter("raisedSignal", new RaisedExceptionGetterSetter());
        this.addGetterSetter("receiver", new ReceiverGetterSetter());
        this.addGetterSetter("reception", new ReceptionGetterSetter());
        this.addGetterSetter("region", new RegionGetterSetter());
        this.addGetterSetter("residentElement", new ResidentElementGetterSetter());
        this.addGetterSetter("sender", new SenderGetterSetter());
        this.addGetterSetter("subvertex", new SubvertexGetterSetter());
        this.addGetterSetter("targetScope", new TargetScopeGetterSetter());
        this.addGetterSetter("templateParameter", new TemplateParameterGetterSetter());
        this.addGetterSetter("trigger", new TriggerGetterSetter());
        this.addGetterSetter("visibility", new VisibilityGetterSetter());
        if (Model.getFacade().getUmlVersion().charAt(0) == '1') {
            this.addGetterSetter("association", new AssociationEndGetterSetter());
        } else {
            this.addGetterSetter("ownedOperation", new FeatureGetterSetter());
            this.addGetterSetter("association", new AssociationGetterSetter());
        }
    }

    private void addGetterSetter(String propertyName, GetterSetterManager.GetterSetter bgs) {
        this.getterSetterByPropertyName.put(propertyName, bgs);
    }

    @Override
    public void set(Object handle, Object value, String propertyName) {
        GetterSetterManager.GetterSetter bgs = (GetterSetterManager.GetterSetter)this.getterSetterByPropertyName.get(propertyName);
        if (bgs != null) {
            bgs.set(handle, value);
        }
    }

    @Override
    public Object get(Object handle, String propertyName, Class<?> type) {
        GetterSetterManager.GetterSetter bgs = (GetterSetterManager.GetterSetter)this.getterSetterByPropertyName.get(propertyName);
        if (bgs != null) {
            return bgs.get(handle, type);
        }
        return null;
    }

    @Override
    public Collection getOptions(Object umlElement, String propertyName, Collection<Class<?>> types) {
        GetterSetterManager.GetterSetter bgs = (GetterSetterManager.GetterSetter)this.getterSetterByPropertyName.get(propertyName);
        if (bgs instanceof GetterSetterManager.OptionGetterSetter) {
            LOG.log(Level.FINE, "OptionGetterSetter found for {0} of {1}", new Object[]{propertyName, bgs});
            GetterSetterManager.OptionGetterSetter ogs = (GetterSetterManager.OptionGetterSetter)bgs;
            return ogs.getOptions(umlElement, types);
        }
        return null;
    }

    @Override
    public boolean isFullBuildOnly(String propertyName) {
        GetterSetterManager.GetterSetter bgs = (GetterSetterManager.GetterSetter)this.getterSetterByPropertyName.get(propertyName);
        if (bgs instanceof GetterSetterManager.ListGetterSetter) {
            return ((GetterSetterManager.ListGetterSetter)bgs).isFullBuildOnly();
        }
        return false;
    }

    @Override
    public Object create(String propertyName, String language, String body) {
        GetterSetterManager.GetterSetter bgs = (GetterSetterManager.GetterSetter)this.getterSetterByPropertyName.get(propertyName);
        if (bgs instanceof GetterSetterManager.ExpressionGetterSetter) {
            return ((GetterSetterManager.ExpressionGetterSetter)bgs).create(language, body);
        }
        return null;
    }

    @Override
    public boolean isValidElement(String propertyName, Collection<Class<?>> types, Object element) {
        GetterSetterManager.GetterSetter bgs = (GetterSetterManager.GetterSetter)this.getterSetterByPropertyName.get(propertyName);
        if (bgs instanceof GetterSetterManager.ListGetterSetter) {
            return ((GetterSetterManager.ListGetterSetter)bgs).isValidElement(element, types);
        }
        return false;
    }

    @Override
    public Object getMetaType(String propertyName) {
        GetterSetterManager.GetterSetter bgs = (GetterSetterManager.GetterSetter)this.getterSetterByPropertyName.get(propertyName);
        if (bgs instanceof GetterSetterManager.ListGetterSetter) {
            return ((GetterSetterManager.ListGetterSetter)bgs).getMetaType();
        }
        return null;
    }

    @Override
    public Command getAddCommand(String propertyName, Object umlElement) {
        LOG.log(Level.INFO, "Finding getter/setter for {0}", propertyName);
        GetterSetterManager.GetterSetter bgs = (GetterSetterManager.GetterSetter)this.getterSetterByPropertyName.get(propertyName);
        if (bgs instanceof Addable) {
            LOG.log(Level.INFO, "Returning add command");
            return ((Addable)((Object)bgs)).getAddCommand(umlElement);
        }
        return null;
    }

    @Override
    public List<Command> getAdditionalCommands(String propertyName, Object umlElement) {
        GetterSetterManager.GetterSetter bgs = (GetterSetterManager.GetterSetter)this.getterSetterByPropertyName.get(propertyName);
        if (bgs instanceof GetterSetterManager.ListGetterSetter) {
            return ((GetterSetterManager.ListGetterSetter)bgs).getAdditionalCommands(umlElement);
        }
        return null;
    }

    @Override
    public Command getRemoveCommand(String propertyName, Object umlElement, Object objectToRemove) {
        GetterSetterManager.GetterSetter bgs = (GetterSetterManager.GetterSetter)this.getterSetterByPropertyName.get(propertyName);
        if (bgs instanceof Removeable) {
            return ((Removeable)((Object)bgs)).getRemoveCommand(umlElement, objectToRemove);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AssociationGetterSetter
    extends GetterSetterManager.ListGetterSetter {
        private AssociationGetterSetter() {
        }

        @Override
        public Collection getOptions(Object modelElement, Collection<Class<?>> types) {
            return Model.getFacade().getAssociations(modelElement);
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return null;
        }

        @Override
        public void set(Object element, Object x) {
        }

        @Override
        public boolean isValidElement(Object element, Collection<Class<?>> types) {
            return this.getOptions(element, types).contains(element);
        }

        @Override
        public Object getMetaType() {
            return Model.getMetaTypes().getAssociationEnd();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AssociationEndGetterSetter
    extends GetterSetterManager.ListGetterSetter {
        private AssociationEndGetterSetter() {
        }

        @Override
        public Collection getOptions(Object modelElement, Collection<Class<?>> types) {
            return Model.getFacade().getAssociationEnds(modelElement);
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return null;
        }

        @Override
        public void set(Object element, Object x) {
        }

        @Override
        public boolean isValidElement(Object element, Collection<Class<?>> types) {
            return this.getOptions(element, types).contains(element);
        }

        @Override
        public Object getMetaType() {
            return Model.getMetaTypes().getAssociationEnd();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QualifierGetterSetter
    extends GetterSetterManager.ListGetterSetter {
        private QualifierGetterSetter() {
        }

        @Override
        public Collection getOptions(Object modelElement, Collection<Class<?>> types) {
            return Model.getFacade().getQualifiers(modelElement);
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return null;
        }

        @Override
        public void set(Object element, Object x) {
        }

        @Override
        public boolean isValidElement(Object element, Collection<Class<?>> types) {
            return this.getOptions(element, types).contains(element);
        }

        @Override
        public Object getMetaType() {
            return Model.getMetaTypes().getAttribute();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BaseGetterSetter
    extends GetterSetterManager.ListGetterSetter
    implements Addable,
    Removeable {
        private BaseGetterSetter() {
        }

        @Override
        public Collection getOptions(Object modelElement, Collection<Class<?>> types) {
            return Model.getFacade().getBases(modelElement);
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return null;
        }

        @Override
        public void set(Object element, Object x) {
        }

        @Override
        public boolean isValidElement(Object element, Collection<Class<?>> types) {
            return this.getOptions(element, types).contains(element);
        }

        @Override
        public Object getMetaType() {
            return Model.getMetaTypes().getClassifier();
        }

        @Override
        public Command getAddCommand(Object modelElement) {
            return new AddCommand(modelElement);
        }

        @Override
        public Command getRemoveCommand(Object modelElement, Object objectToRemove) {
            return new RemoveCommand(modelElement, objectToRemove);
        }

        private class RemoveCommand
        extends NonUndoableCommand {
            private final Object target;
            private final Object objectToRemove;

            public RemoveCommand(Object target, Object objectToRemove) {
                this.target = target;
                this.objectToRemove = objectToRemove;
            }

            public Object execute() {
                Model.getCollaborationsHelper().removeBase(this.target, this.objectToRemove);
                return null;
            }
        }

        private class AddCommand
        extends AddModelElementCommand {
            public AddCommand(Object target) {
                super(target);
            }

            protected List getChoices() {
                ArrayList vec = new ArrayList();
                vec.addAll(Model.getCollaborationsHelper().getAllPossibleBases(this.getTarget()));
                return vec;
            }

            protected List getSelected() {
                ArrayList list = new ArrayList();
                list.addAll(Model.getFacade().getBases(this.getTarget()));
                return list;
            }

            protected String getDialogTitle() {
                return Translator.localize((String)"dialog.title.add-bases");
            }

            protected void doIt(Collection selected) {
                Object role = this.getTarget();
                Model.getCollaborationsHelper().setBases(role, selected);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BaseClassGetterSetter
    extends GetterSetterManager.ListGetterSetter
    implements Addable,
    Removeable {
        private BaseClassGetterSetter() {
        }

        @Override
        public Collection getOptions(Object modelElement, Collection<Class<?>> types) {
            LinkedList list = new LinkedList(Model.getFacade().getBaseClasses(modelElement));
            Collections.sort(list);
            return list;
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return null;
        }

        @Override
        public void set(Object element, Object x) {
        }

        @Override
        public boolean isValidElement(Object element, Collection<Class<?>> types) {
            return this.getOptions(element, types).contains(element);
        }

        @Override
        public Object getMetaType() {
            return Class.class;
        }

        @Override
        public Command getAddCommand(Object modelElement) {
            return new AddCommand(modelElement);
        }

        @Override
        public Command getRemoveCommand(Object modelElement, Object objectToRemove) {
            return new RemoveCommand(modelElement, objectToRemove);
        }

        private class RemoveCommand
        extends NonUndoableCommand {
            private final Object target;
            private final Object objectToRemove;

            public RemoveCommand(Object target, Object objectToRemove) {
                this.target = target;
                this.objectToRemove = objectToRemove;
            }

            public Object execute() {
                Model.getExtensionMechanismsHelper().removeBaseClass(this.target, this.objectToRemove);
                return null;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class AddCommand
        extends AddModelElementCommand {
            private final List<String> metaClasses;

            public AddCommand(Object target) {
                super(target);
                this.metaClasses = this.initMetaClasses();
            }

            private List<String> initMetaClasses() {
                Collection tmpMetaClasses = Model.getCoreHelper().getAllMetatypeNames();
                LinkedList<String> metaClasses = tmpMetaClasses instanceof List ? (LinkedList<String>)tmpMetaClasses : new LinkedList<String>(tmpMetaClasses);
                try {
                    Collections.sort(metaClasses);
                }
                catch (UnsupportedOperationException e) {
                    metaClasses = new LinkedList(tmpMetaClasses);
                    Collections.sort(metaClasses);
                }
                return metaClasses;
            }

            @Override
            protected List getChoices() {
                return Collections.unmodifiableList(this.metaClasses);
            }

            @Override
            protected List getSelected() {
                LinkedList list = new LinkedList(Model.getFacade().getBaseClasses(this.getTarget()));
                Collections.sort(list);
                return list;
            }

            @Override
            protected String getDialogTitle() {
                return Translator.localize((String)"dialog.title.add-baseclasses");
            }

            @Override
            protected void doIt(Collection selected) {
                Object stereo = this.getTarget();
                HashSet oldSet = new HashSet(this.getSelected());
                HashSet toBeRemoved = new HashSet(oldSet);
                for (Object o : selected) {
                    if (oldSet.contains(o)) {
                        toBeRemoved.remove(o);
                        continue;
                    }
                    Model.getExtensionMechanismsHelper().addBaseClass(stereo, o);
                }
                for (Object o : toBeRemoved) {
                    Model.getExtensionMechanismsHelper().removeBaseClass(stereo, o);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClassifierGetterSetter
    extends GetterSetterManager.ListGetterSetter
    implements Addable,
    Removeable {
        private ClassifierGetterSetter() {
        }

        @Override
        public Collection getOptions(Object modelElement, Collection<Class<?>> types) {
            return Model.getFacade().getClassifiers(modelElement);
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return null;
        }

        @Override
        public void set(Object element, Object x) {
        }

        @Override
        public boolean isValidElement(Object element, Collection<Class<?>> types) {
            return this.getOptions(element, types).contains(element);
        }

        @Override
        public Object getMetaType() {
            return Model.getMetaTypes().getClassifier();
        }

        @Override
        public Command getAddCommand(Object modelElement) {
            return new AddCommand(modelElement);
        }

        @Override
        public Command getRemoveCommand(Object modelElement, Object objectToRemove) {
            return new RemoveCommand(modelElement, objectToRemove);
        }

        private class RemoveCommand
        extends NonUndoableCommand {
            private final Object target;
            private final Object objectToRemove;

            public RemoveCommand(Object target, Object objectToRemove) {
                this.target = target;
                this.objectToRemove = objectToRemove;
            }

            public Object execute() {
                Model.getCommonBehaviorHelper().removeClassifier(this.target, this.objectToRemove);
                return null;
            }
        }

        private class AddCommand
        extends AddModelElementCommand {
            public AddCommand(Object target) {
                super(target);
            }

            protected List getChoices() {
                ArrayList list = new ArrayList();
                Project p = ProjectManager.getManager().getCurrentProject();
                Object model = p.getRoot();
                list.addAll(Model.getModelManagementHelper().getAllModelElementsOfKindWithModel(model, Model.getMetaTypes().getClassifier()));
                ProfileConfiguration profileConfiguration = p.getProfileConfiguration();
                ModelManagementHelper mmh = Model.getModelManagementHelper();
                Object classifierMetaType = Model.getMetaTypes().getClassifier();
                for (Profile profile : profileConfiguration.getProfiles()) {
                    try {
                        for (Object topPackage : profile.getProfilePackages()) {
                            if (!Model.getFacade().isAModel(topPackage)) continue;
                            list.addAll(mmh.getAllModelElementsOfKindWithModel(topPackage, classifierMetaType));
                        }
                    }
                    catch (ProfileException e) {
                        LOG.log(Level.SEVERE, "Exception", e);
                    }
                }
                return list;
            }

            protected List getSelected() {
                ArrayList list = new ArrayList();
                list.addAll(Model.getFacade().getClassifiers(this.getTarget()));
                return list;
            }

            protected String getDialogTitle() {
                return Translator.localize((String)"dialog.title.add-specifications");
            }

            protected void doIt(Collection selected) {
                Model.getCommonBehaviorHelper().setClassifiers(this.getTarget(), selected);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InternalTransitionGetterSetter
    extends GetterSetterManager.ListGetterSetter {
        private InternalTransitionGetterSetter() {
        }

        @Override
        public Collection getOptions(Object modelElement, Collection<Class<?>> types) {
            return Model.getFacade().getInternalTransitions(modelElement);
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return null;
        }

        @Override
        public void set(Object element, Object x) {
        }

        @Override
        public boolean isValidElement(Object element, Collection<Class<?>> types) {
            return this.getOptions(element, types).contains(element);
        }

        @Override
        public Object getMetaType() {
            return Model.getMetaTypes().getTransition();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReceiverGetterSetter
    extends GetterSetterManager.ListGetterSetter {
        private ReceiverGetterSetter() {
        }

        @Override
        public Collection getOptions(Object modelElement, Collection<Class<?>> types) {
            return Model.getFacade().getReceivedStimuli(modelElement);
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return null;
        }

        @Override
        public void set(Object element, Object x) {
        }

        @Override
        public boolean isValidElement(Object element, Collection<Class<?>> types) {
            return this.getOptions(element, types).contains(element);
        }

        @Override
        public Object getMetaType() {
            return Model.getMetaTypes().getAttribute();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LiteralGetterSetter
    extends GetterSetterManager.ListGetterSetter {
        private LiteralGetterSetter() {
        }

        @Override
        public Collection getOptions(Object modelElement, Collection<Class<?>> types) {
            return Model.getFacade().getEnumerationLiterals(modelElement);
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return null;
        }

        @Override
        public void set(Object element, Object x) {
        }

        @Override
        public boolean isValidElement(Object element, Collection<Class<?>> types) {
            return this.getOptions(element, types).contains(element);
        }

        @Override
        public Object getMetaType() {
            return Model.getMetaTypes().getEnumerationLiteral();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SenderGetterSetter
    extends GetterSetterManager.ListGetterSetter {
        private SenderGetterSetter() {
        }

        @Override
        public Collection getOptions(Object modelElement, Collection<Class<?>> types) {
            return Model.getFacade().getSentStimuli(modelElement);
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return null;
        }

        @Override
        public void set(Object element, Object x) {
        }

        @Override
        public boolean isValidElement(Object element, Collection<Class<?>> types) {
            return this.getOptions(element, types).contains(element);
        }

        @Override
        public Object getMetaType() {
            return Model.getMetaTypes().getAttribute();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MethodExpressionGetterSetter
    extends GetterSetterManager.ExpressionGetterSetter {
        private MethodExpressionGetterSetter() {
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return Model.getFacade().getBody(modelElement);
        }

        @Override
        public void set(Object modelElement, Object value) {
            LOG.log(Level.INFO, "About to call setBody {0} / {1}", new Object[]{modelElement, value});
            Model.getCoreHelper().setBody(modelElement, value);
        }

        @Override
        public Object create(String language, String body) {
            return Model.getDataTypesFactory().createProcedureExpression(language, body);
        }
    }

    private abstract class AddModelElementCommand
    extends NonUndoableCommand {
        private Object target;
        private boolean multiSelect = true;
        private boolean exclusive = true;

        protected AddModelElementCommand(Object target) {
            if (target == null) {
                throw new IllegalArgumentException("target expected");
            }
            this.target = target;
        }

        public Object execute() {
            UMLAddDialog dialog = new UMLAddDialog(this.getChoices(), this.getSelected(), this.getDialogTitle(), this.isMultiSelect(), this.isExclusive());
            int result = dialog.showDialog((Component)ArgoFrame.getFrame());
            if (result == 0) {
                this.doIt(dialog.getSelected());
            }
            return null;
        }

        protected abstract List getChoices();

        protected abstract List getSelected();

        protected abstract void doIt(Collection var1);

        protected Object getTarget() {
            return this.target;
        }

        public void setTarget(Object theTarget) {
            this.target = theTarget;
        }

        protected abstract String getDialogTitle();

        public boolean isExclusive() {
            return this.exclusive;
        }

        public boolean isMultiSelect() {
            return this.multiSelect;
        }

        public void setExclusive(boolean theExclusive) {
            this.exclusive = theExclusive;
        }

        public void setMultiSelect(boolean theMultiSelect) {
            this.multiSelect = theMultiSelect;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResidentElementGetterSetter
    extends GetterSetterManager.ListGetterSetter
    implements Addable,
    Removeable {
        private ResidentElementGetterSetter() {
        }

        @Override
        public Collection getOptions(Object modelElement, Collection<Class<?>> types) {
            Iterator it = Model.getFacade().getResidentElements(modelElement).iterator();
            ArrayList<Object> list = new ArrayList<Object>();
            while (it.hasNext()) {
                list.add(Model.getFacade().getResident(it.next()));
            }
            return list;
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return null;
        }

        @Override
        public void set(Object element, Object x) {
        }

        @Override
        public boolean isFullBuildOnly() {
            return true;
        }

        @Override
        public boolean isValidElement(Object element, Collection<Class<?>> types) {
            return this.getOptions(element, types).contains(element);
        }

        @Override
        public Object getMetaType() {
            return Model.getMetaTypes().getElementResidence();
        }

        @Override
        public Command getAddCommand(Object modelElement) {
            return new AddCommand(modelElement);
        }

        @Override
        public Command getRemoveCommand(Object modelElement, Object objectToRemove) {
            return new RemoveCommand(modelElement, objectToRemove);
        }

        private class RemoveCommand
        extends NonUndoableCommand {
            private final Object target;
            private final Object objectToRemove;

            public RemoveCommand(Object target, Object objectToRemove) {
                this.target = target;
                this.objectToRemove = objectToRemove;
            }

            public Object execute() {
                Collection current = Model.getFacade().getResidentElements(this.target);
                for (Object elementResidenceToDelete : current) {
                    if (Model.getFacade().getResident(elementResidenceToDelete) != this.objectToRemove) continue;
                    Model.getCoreHelper().removeElementResidence(this.target, elementResidenceToDelete);
                    Model.getUmlFactory().delete(elementResidenceToDelete);
                    return null;
                }
                return null;
            }
        }

        private class AddCommand
        extends AddModelElementCommand {
            public AddCommand(Object target) {
                super(target);
            }

            protected List getChoices() {
                ArrayList list = new ArrayList();
                Object model = ProjectManager.getManager().getCurrentProject().getModel();
                list.addAll(Model.getModelManagementHelper().getAllModelElementsOfKind(model, Model.getMetaTypes().getUMLClass()));
                list.addAll(Model.getModelManagementHelper().getAllModelElementsOfKind(model, Model.getMetaTypes().getInterface()));
                list.addAll(Model.getModelManagementHelper().getAllModelElementsOfKind(model, Model.getMetaTypes().getDataType()));
                list.addAll(Model.getModelManagementHelper().getAllModelElementsOfKind(model, Model.getMetaTypes().getDataValue()));
                list.addAll(Model.getModelManagementHelper().getAllModelElementsOfKind(model, Model.getMetaTypes().getAssociation()));
                list.addAll(Model.getModelManagementHelper().getAllModelElementsOfKind(model, Model.getMetaTypes().getDependency()));
                list.addAll(Model.getModelManagementHelper().getAllModelElementsOfKind(model, Model.getMetaTypes().getConstraint()));
                list.addAll(Model.getModelManagementHelper().getAllModelElementsOfKind(model, Model.getMetaTypes().getSignal()));
                return list;
            }

            protected List getSelected() {
                Iterator it = Model.getFacade().getResidentElements(this.getTarget()).iterator();
                ArrayList<Object> list = new ArrayList<Object>();
                while (it.hasNext()) {
                    list.add(Model.getFacade().getResident(it.next()));
                }
                return list;
            }

            protected String getDialogTitle() {
                return Translator.localize((String)"dialog.title.add-residentelements");
            }

            protected void doIt(Collection selected) {
                Collection current = Model.getFacade().getResidentElements(this.getTarget());
                ArrayList toRemove = new ArrayList(current);
                toRemove.removeAll(selected);
                selected.removeAll(current);
                for (Object elementResidenceToDelete : toRemove) {
                    Model.getCoreHelper().removeElementResidence(this.getTarget(), elementResidenceToDelete);
                    Model.getUmlFactory().delete(elementResidenceToDelete);
                }
                for (Object element : selected) {
                    if (Model.getFacade().isAElementResidence(element)) continue;
                    Model.getCoreFactory().buildElementResidence(element, this.getTarget());
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RegionGetterSetter
    extends GetterSetterManager.ListGetterSetter {
        private RegionGetterSetter() {
        }

        @Override
        public Collection getOptions(Object modelElement, Collection<Class<?>> types) {
            return Model.getStateMachinesHelper().getRegions(modelElement);
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return null;
        }

        @Override
        public void set(Object element, Object x) {
        }

        @Override
        public boolean isValidElement(Object element, Collection<Class<?>> types) {
            return this.getOptions(element, types).contains(element);
        }

        @Override
        public Object getMetaType() {
            return Model.getMetaTypes().getRegion();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReceptionGetterSetter
    extends GetterSetterManager.ListGetterSetter
    implements Addable,
    Removeable {
        private ReceptionGetterSetter() {
        }

        @Override
        public Collection getOptions(Object modelElement, Collection<Class<?>> types) {
            return Model.getFacade().getReceptions(modelElement);
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return null;
        }

        @Override
        public void set(Object element, Object x) {
        }

        @Override
        public boolean isValidElement(Object element, Collection<Class<?>> types) {
            return this.getOptions(element, types).contains(element);
        }

        @Override
        public Object getMetaType() {
            return Model.getMetaTypes().getReception();
        }

        @Override
        public Command getAddCommand(Object modelElement) {
            return new AddCommand(modelElement);
        }

        @Override
        public Command getRemoveCommand(Object modelElement, Object objectToRemove) {
            return new RemoveCommand(modelElement, objectToRemove);
        }

        private class RemoveCommand
        extends NonUndoableCommand {
            private final Object target;
            private final Object objectToRemove;

            public RemoveCommand(Object target, Object objectToRemove) {
                this.target = target;
                this.objectToRemove = objectToRemove;
            }

            public Object execute() {
                Model.getCommonBehaviorHelper().removeReception(this.target, this.objectToRemove);
                return null;
            }
        }

        private class AddCommand
        extends AddModelElementCommand {
            public AddCommand(Object target) {
                super(target);
            }

            protected List getChoices() {
                ArrayList list = new ArrayList();
                Object model = ProjectManager.getManager().getCurrentProject().getModel();
                list.addAll(Model.getModelManagementHelper().getAllModelElementsOfKind(model, Model.getMetaTypes().getReception()));
                return list;
            }

            protected List getSelected() {
                ArrayList list = new ArrayList();
                list.addAll(Model.getFacade().getReceptions(this.getTarget()));
                return list;
            }

            protected String getDialogTitle() {
                return Translator.localize((String)"dialog.title.add-imported-elements");
            }

            protected void doIt(Collection selected) {
                Model.getCommonBehaviorHelper().setReception(this.getTarget(), selected);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DeferrableEventGetterSetter
    extends GetterSetterManager.ListGetterSetter
    implements Addable,
    Removeable {
        private DeferrableEventGetterSetter() {
        }

        @Override
        public Collection getOptions(Object modelElement, Collection<Class<?>> types) {
            return Model.getFacade().getDeferrableEvents(modelElement);
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return null;
        }

        @Override
        public boolean isFullBuildOnly() {
            return false;
        }

        @Override
        public void set(Object element, Object x) {
        }

        @Override
        public boolean isValidElement(Object element, Collection<Class<?>> types) {
            return this.getOptions(element, types).contains(element);
        }

        @Override
        public Object getMetaType() {
            return Model.getMetaTypes().getEvent();
        }

        @Override
        public Command getAddCommand(Object modelElement) {
            return new AddCommand(modelElement);
        }

        @Override
        public Command getRemoveCommand(Object modelElement, Object objectToRemove) {
            return new RemoveCommand(modelElement, objectToRemove);
        }

        private class RemoveCommand
        extends NonUndoableCommand {
            private final Object target;
            private final Object objectToRemove;

            public RemoveCommand(Object target, Object objectToRemove) {
                this.target = target;
                this.objectToRemove = objectToRemove;
            }

            public Object execute() {
                Model.getStateMachinesHelper().removeDeferrableEvent(this.target, this.objectToRemove);
                return null;
            }
        }

        private class AddCommand
        extends AddModelElementCommand {
            public AddCommand(Object target) {
                super(target);
            }

            protected List getChoices() {
                ArrayList list = new ArrayList();
                Object parent = Model.getStateMachinesHelper().findNamespaceForEvent(this.getTarget(), null);
                list.addAll(Model.getModelManagementHelper().getAllModelElementsOfKind(parent, Model.getMetaTypes().getEvent()));
                return list;
            }

            protected List getSelected() {
                ArrayList list = new ArrayList();
                list.addAll(Model.getFacade().getDeferrableEvents(this.getTarget()));
                return list;
            }

            protected String getDialogTitle() {
                return Translator.localize((String)"dialog.title.add-events");
            }

            protected void doIt(Collection selected) {
                Object state = this.getTarget();
                assert (Model.getFacade().isAState(state));
                ArrayList oldOnes = new ArrayList(Model.getFacade().getDeferrableEvents(state));
                ArrayList toBeRemoved = new ArrayList(oldOnes);
                for (Object o : selected) {
                    if (oldOnes.contains(o)) {
                        toBeRemoved.remove(o);
                        continue;
                    }
                    Model.getStateMachinesHelper().addDeferrableEvent(state, o);
                }
                for (Object o : toBeRemoved) {
                    Model.getStateMachinesHelper().removeDeferrableEvent(state, o);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ElementImportGetterSetter
    extends GetterSetterManager.ListGetterSetter
    implements Addable,
    Removeable {
        private ElementImportGetterSetter() {
        }

        @Override
        public Collection getOptions(Object modelElement, Collection<Class<?>> types) {
            return Model.getFacade().getImportedElements(modelElement);
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return null;
        }

        @Override
        public boolean isFullBuildOnly() {
            return true;
        }

        @Override
        public void set(Object element, Object x) {
        }

        @Override
        public boolean isValidElement(Object element, Collection<Class<?>> types) {
            return this.getOptions(element, types).contains(element);
        }

        @Override
        public Object getMetaType() {
            return Model.getMetaTypes().getModelElement();
        }

        @Override
        public Command getAddCommand(Object modelElement) {
            return new AddElementImportCommand(modelElement);
        }

        @Override
        public Command getRemoveCommand(Object modelElement, Object objectToRemove) {
            return new RemoveElementImportCommand(modelElement, objectToRemove);
        }

        private class RemoveElementImportCommand
        extends NonUndoableCommand {
            private final Object target;
            private final Object objectToRemove;

            public RemoveElementImportCommand(Object target, Object objectToRemove) {
                this.target = target;
                this.objectToRemove = objectToRemove;
            }

            public Object execute() {
                Model.getModelManagementHelper().removeImportedElement(this.target, this.objectToRemove);
                return null;
            }
        }

        private class AddElementImportCommand
        extends AddModelElementCommand {
            public AddElementImportCommand(Object target) {
                super(target);
            }

            protected List getChoices() {
                ArrayList list = new ArrayList();
                list.addAll(Model.getModelManagementHelper().getAllPossibleImports(this.getTarget()));
                return list;
            }

            protected List getSelected() {
                ArrayList list = new ArrayList();
                list.addAll(Model.getFacade().getImportedElements(this.getTarget()));
                return list;
            }

            protected String getDialogTitle() {
                return Translator.localize((String)"dialog.title.add-imported-elements");
            }

            protected void doIt(Collection selected) {
                LOG.log(Level.INFO, "Setting {0} imported elements", selected.size());
                Model.getModelManagementHelper().setImportedElements(this.getTarget(), selected);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TemplateParameterGetterSetter
    extends GetterSetterManager.ListGetterSetter {
        private TemplateParameterGetterSetter() {
        }

        @Override
        public Collection getOptions(Object modelElement, Collection<Class<?>> types) {
            LOG.log(Level.FINE, "Getting template parameters for {0}", modelElement);
            return Model.getFacade().getTemplateParameters(modelElement);
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return null;
        }

        @Override
        public void set(Object element, Object x) {
        }

        @Override
        public boolean isValidElement(Object element, Collection<Class<?>> types) {
            return this.getOptions(element, types).contains(element);
        }

        @Override
        public Object getMetaType() {
            return Model.getMetaTypes().getTemplateParameter();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SubvertexGetterSetter
    extends GetterSetterManager.ListGetterSetter {
        private SubvertexGetterSetter() {
        }

        @Override
        public Collection getOptions(Object modelElement, Collection<Class<?>> types) {
            return Model.getFacade().getSubvertices(modelElement);
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return null;
        }

        @Override
        public void set(Object element, Object x) {
        }

        @Override
        public boolean isValidElement(Object element, Collection<Class<?>> types) {
            return this.getOptions(element, types).contains(element);
        }

        @Override
        public Object getMetaType() {
            return Model.getMetaTypes().getState();
        }

        @Override
        public List<Command> getAdditionalCommands(Object modelElement) {
            ArrayList<Command> commands = new ArrayList<Command>(6);
            commands.add((Command)new NewPseudoStateCommand(modelElement, Model.getPseudostateKind().getFork()));
            commands.add((Command)new NewPseudoStateCommand(modelElement, Model.getPseudostateKind().getJoin()));
            commands.add((Command)new NewPseudoStateCommand(modelElement, Model.getPseudostateKind().getChoice()));
            commands.add((Command)new NewPseudoStateCommand(modelElement, Model.getPseudostateKind().getDeepHistory()));
            commands.add((Command)new NewPseudoStateCommand(modelElement, Model.getPseudostateKind().getShallowHistory()));
            commands.add((Command)new NewPseudoStateCommand(modelElement, Model.getPseudostateKind().getInitial()));
            commands.add((Command)new NewPseudoStateCommand(modelElement, Model.getPseudostateKind().getJunction()));
            return commands;
        }

        private class NewPseudoStateCommand
        extends NonUndoableCommand
        implements IconIdentifiable,
        Named {
            private final String label;
            private final Object kind;
            private final Icon icon;
            private final Object target;

            NewPseudoStateCommand(Object target, Object kind) {
                String key;
                this.target = target;
                this.kind = kind;
                PseudostateKind kinds = Model.getPseudostateKind();
                if (kind == kinds.getFork()) {
                    key = "label.pseudostate.fork";
                } else if (kind == kinds.getJoin()) {
                    key = "label.pseudostate.join";
                } else if (kind == kinds.getChoice()) {
                    key = "label.pseudostate.choice";
                } else if (kind == kinds.getDeepHistory()) {
                    key = "label.pseudostate.deephistory";
                } else if (kind == kinds.getShallowHistory()) {
                    key = "label.pseudostate.shallowhistory";
                } else if (kind == kinds.getInitial()) {
                    key = "label.pseudostate.initial";
                } else if (kind == kinds.getJunction()) {
                    key = "label.pseudostate.junction";
                } else {
                    throw new IllegalArgumentException(kind + " is not a known PseudostateKind");
                }
                this.label = Translator.localize((String)key);
                String name = Model.getFacade().getName(kind).substring(0, 1).toUpperCase() + Model.getFacade().getName(kind).substring(1);
                this.icon = ResourceLoaderWrapper.lookupIcon((String)name);
            }

            public Object execute() {
                Object ps = Model.getStateMachinesFactory().buildPseudoState(this.target);
                if (this.kind != null) {
                    Model.getCoreHelper().setKind(ps, this.kind);
                }
                TargetManager.getInstance().setTarget(ps);
                return null;
            }

            public Icon getIcon() {
                return this.icon;
            }

            public String getName() {
                return this.label;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ActionGetterSetter
    extends GetterSetterManager.ListGetterSetter {
        private ActionGetterSetter() {
        }

        @Override
        public Collection getOptions(Object modelElement, Collection<Class<?>> types) {
            return Model.getFacade().getActions(modelElement);
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return null;
        }

        @Override
        public void set(Object element, Object x) {
        }

        @Override
        public boolean isValidElement(Object element, Collection<Class<?>> types) {
            return this.getOptions(element, types).contains(element);
        }

        @Override
        public Object getMetaType() {
            return Model.getMetaTypes().getAction();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DoActivityActionGetterSetter
    extends GetterSetterManager.ListGetterSetter {
        private DoActivityActionGetterSetter() {
        }

        @Override
        public Collection getOptions(Object modelElement, Collection<Class<?>> types) {
            ArrayList<Object> list = new ArrayList<Object>(1);
            list.add(Model.getFacade().getDoActivity(modelElement));
            return list;
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return null;
        }

        @Override
        public void set(Object element, Object x) {
        }

        @Override
        public boolean isValidElement(Object element, Collection<Class<?>> types) {
            return this.getOptions(element, types).contains(element);
        }

        @Override
        public Object getMetaType() {
            return Model.getMetaTypes().getAction();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExitActionGetterSetter
    extends GetterSetterManager.ListGetterSetter {
        private ExitActionGetterSetter() {
        }

        @Override
        public Collection getOptions(Object modelElement, Collection<Class<?>> types) {
            ArrayList<Object> list = new ArrayList<Object>(1);
            list.add(Model.getFacade().getExit(modelElement));
            return list;
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return null;
        }

        @Override
        public void set(Object element, Object x) {
        }

        @Override
        public boolean isValidElement(Object element, Collection<Class<?>> types) {
            return this.getOptions(element, types).contains(element);
        }

        @Override
        public Object getMetaType() {
            return Model.getMetaTypes().getAction();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryActionGetterSetter
    extends GetterSetterManager.ListGetterSetter {
        private EntryActionGetterSetter() {
        }

        @Override
        public Collection getOptions(Object modelElement, Collection<Class<?>> types) {
            ArrayList<Object> list = new ArrayList<Object>(1);
            list.add(Model.getFacade().getEntry(modelElement));
            return list;
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return null;
        }

        @Override
        public void set(Object element, Object x) {
        }

        @Override
        public boolean isValidElement(Object element, Collection<Class<?>> types) {
            return this.getOptions(element, types).contains(element);
        }

        @Override
        public Object getMetaType() {
            return Model.getMetaTypes().getAction();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ParameterGetterSetter
    extends GetterSetterManager.ListGetterSetter {
        private ParameterGetterSetter() {
        }

        @Override
        public Collection getOptions(Object modelElement, Collection<Class<?>> types) {
            return Model.getFacade().getParameters(modelElement);
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return null;
        }

        @Override
        public void set(Object element, Object x) {
        }

        @Override
        public boolean isValidElement(Object element, Collection<Class<?>> types) {
            return this.getOptions(element, types).contains(element);
        }

        @Override
        public Object getMetaType() {
            return Model.getMetaTypes().getParameter();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TriggerGetterSetter
    extends GetterSetterManager.ListGetterSetter {
        private TriggerGetterSetter() {
        }

        @Override
        public Collection getOptions(Object modelElement, Collection<Class<?>> types) {
            ArrayList<Object> l = new ArrayList<Object>(1);
            l.add(Model.getFacade().getTrigger(modelElement));
            return l;
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return null;
        }

        @Override
        public void set(Object element, Object x) {
        }

        @Override
        public boolean isValidElement(Object element, Collection<Class<?>> types) {
            return this.getOptions(element, types).contains(element);
        }

        @Override
        public Object getMetaType() {
            return Model.getMetaTypes().getEvent();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EffectGetterSetter
    extends GetterSetterManager.ListGetterSetter {
        private EffectGetterSetter() {
        }

        @Override
        public Collection getOptions(Object modelElement, Collection<Class<?>> types) {
            ArrayList<Object> l = new ArrayList<Object>(1);
            l.add(Model.getFacade().getEffect(modelElement));
            return l;
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return null;
        }

        @Override
        public void set(Object element, Object x) {
        }

        @Override
        public boolean isValidElement(Object element, Collection<Class<?>> types) {
            return this.getOptions(element, types).contains(element);
        }

        @Override
        public Object getMetaType() {
            return Model.getMetaTypes().getAction();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GuardGetterSetter
    extends GetterSetterManager.ListGetterSetter {
        private GuardGetterSetter() {
        }

        @Override
        public Collection getOptions(Object modelElement, Collection<Class<?>> types) {
            ArrayList<Object> l = new ArrayList<Object>(1);
            l.add(Model.getFacade().getGuard(modelElement));
            return l;
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return null;
        }

        @Override
        public void set(Object element, Object x) {
        }

        @Override
        public boolean isValidElement(Object element, Collection<Class<?>> types) {
            return this.getOptions(element, types).contains(element);
        }

        @Override
        public Object getMetaType() {
            return Model.getMetaTypes().getGuard();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExtensionPointGetterSetter
    extends GetterSetterManager.ListGetterSetter {
        private ExtensionPointGetterSetter() {
        }

        @Override
        public Collection getOptions(Object modelElement, Collection<Class<?>> types) {
            return Model.getFacade().getExtensionPoints(modelElement);
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return null;
        }

        @Override
        public void set(Object element, Object x) {
        }

        @Override
        public boolean isValidElement(Object element, Collection<Class<?>> types) {
            return this.getOptions(element, types).contains(element);
        }

        @Override
        public Object getMetaType() {
            return Model.getMetaTypes().getExtensionPoint();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArgumentGetterSetter
    extends GetterSetterManager.ListGetterSetter {
        private ArgumentGetterSetter() {
        }

        @Override
        public Collection getOptions(Object modelElement, Collection<Class<?>> types) {
            return Model.getFacade().getArguments(modelElement);
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return null;
        }

        @Override
        public void set(Object element, Object x) {
        }

        @Override
        public boolean isValidElement(Object element, Collection<Class<?>> types) {
            return this.getOptions(element, types).contains(element);
        }

        @Override
        public Object getMetaType() {
            return Model.getMetaTypes().getArgument();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MessageGetterSetter
    extends GetterSetterManager.ListGetterSetter {
        private MessageGetterSetter() {
        }

        @Override
        public Collection getOptions(Object modelElement, Collection<Class<?>> types) {
            return Model.getFacade().getMessages(modelElement);
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return null;
        }

        @Override
        public void set(Object element, Object x) {
        }

        @Override
        public boolean isValidElement(Object element, Collection<Class<?>> types) {
            return this.getOptions(element, types).contains(element);
        }

        @Override
        public Object getMetaType() {
            return Model.getMetaTypes().getMessage();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MethodGetterSetter
    extends GetterSetterManager.ListGetterSetter {
        private MethodGetterSetter() {
        }

        @Override
        public Collection getOptions(Object modelElement, Collection<Class<?>> types) {
            return Model.getFacade().getMethods(modelElement);
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return null;
        }

        @Override
        public void set(Object element, Object x) {
        }

        @Override
        public boolean isValidElement(Object element, Collection<Class<?>> types) {
            return this.getOptions(element, types).contains(element);
        }

        @Override
        public Object getMetaType() {
            return Model.getMetaTypes().getMethod();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RaisedExceptionGetterSetter
    extends GetterSetterManager.ListGetterSetter {
        private RaisedExceptionGetterSetter() {
        }

        @Override
        public Collection getOptions(Object modelElement, Collection<Class<?>> types) {
            return Model.getFacade().getRaisedExceptions(modelElement);
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return null;
        }

        @Override
        public void set(Object element, Object x) {
        }

        @Override
        public boolean isValidElement(Object element, Collection<Class<?>> types) {
            return this.getOptions(element, types).contains(element);
        }

        @Override
        public Object getMetaType() {
            return Model.getMetaTypes().getSignal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OwnedElementGetterSetter
    extends GetterSetterManager.ListGetterSetter {
        private OwnedElementGetterSetter() {
        }

        @Override
        public Collection getOptions(Object modelElement, Collection<Class<?>> types) {
            return Model.getFacade().getOwnedElements(modelElement);
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return null;
        }

        @Override
        public void set(Object element, Object x) {
        }

        @Override
        public boolean isValidElement(Object element, Collection<Class<?>> types) {
            return this.getOptions(element, types).contains(element);
        }

        @Override
        public Object getMetaType() {
            return Model.getMetaTypes().getOperation();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FeatureGetterSetter
    extends GetterSetterManager.ListGetterSetter {
        private FeatureGetterSetter() {
        }

        @Override
        public Collection getOptions(Object modelElement, Collection<Class<?>> types) {
            if (types.contains(Model.getMetaTypes().getOperation()) && types.contains(Model.getMetaTypes().getReception())) {
                return Model.getFacade().getOperationsAndReceptions(modelElement);
            }
            if (types.contains(Model.getMetaTypes().getAttribute())) {
                return Model.getFacade().getAttributes(modelElement);
            }
            return Collections.EMPTY_LIST;
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return null;
        }

        @Override
        public void set(Object element, Object x) {
        }

        @Override
        public boolean isValidElement(Object element, Collection<Class<?>> types) {
            return this.getOptions(element, types).contains(element);
        }

        @Override
        public Object getMetaType() {
            return Model.getMetaTypes().getOperation();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ChangeabilityGetterSetter
    extends GetterSetterManager.OptionGetterSetter {
        public static final String ADDONLY = "addonly";
        public static final String CHANGEABLE = "changeable";
        public static final String FROZEN = "frozen";

        public ChangeabilityGetterSetter() {
            this.setOptions(Arrays.asList(ADDONLY, CHANGEABLE, FROZEN));
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            Object kind = Model.getFacade().getChangeability(modelElement);
            if (kind == null) {
                return null;
            }
            if (kind.equals(Model.getChangeableKind().getAddOnly())) {
                return ADDONLY;
            }
            if (kind.equals(Model.getChangeableKind().getChangeable())) {
                return CHANGEABLE;
            }
            if (kind.equals(Model.getChangeableKind().getFrozen())) {
                return FROZEN;
            }
            return CHANGEABLE;
        }

        @Override
        public void set(Object modelElement, Object value) {
            if (value.equals(CHANGEABLE)) {
                Model.getCoreHelper().setReadOnly(modelElement, false);
            } else if (value.equals(ADDONLY)) {
                Model.getCoreHelper().setChangeability(modelElement, Model.getChangeableKind().getAddOnly());
            } else {
                Model.getCoreHelper().setReadOnly(modelElement, true);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConcurrencyGetterSetter
    extends GetterSetterManager.OptionGetterSetter {
        public static final String SEQUENTIAL = "sequential";
        public static final String GUARDED = "guarded";
        public static final String CONCURRENT = "concurrent";
        public static final String UNDEFINED = "undefined";

        public ConcurrencyGetterSetter() {
            this.setOptions(Arrays.asList(SEQUENTIAL, GUARDED, CONCURRENT, UNDEFINED));
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            Object kind = Model.getFacade().getConcurrency(modelElement);
            if (kind == null) {
                return UNDEFINED;
            }
            if (kind.equals(Model.getConcurrencyKind().getSequential())) {
                return SEQUENTIAL;
            }
            if (kind.equals(Model.getConcurrencyKind().getGuarded())) {
                return GUARDED;
            }
            if (kind.equals(Model.getConcurrencyKind().getConcurrent())) {
                return CONCURRENT;
            }
            return UNDEFINED;
        }

        @Override
        public void set(Object modelElement, Object value) {
            Object kind = null;
            if (value.equals(SEQUENTIAL)) {
                kind = Model.getConcurrencyKind().getSequential();
            } else if (value.equals(GUARDED)) {
                kind = Model.getConcurrencyKind().getGuarded();
            } else if (value.equals(CONCURRENT)) {
                kind = Model.getConcurrencyKind().getConcurrent();
            }
            Model.getCoreHelper().setConcurrency(modelElement, kind);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ParameterDirectionGetterSetter
    extends GetterSetterManager.OptionGetterSetter {
        public static final String IN = "in";
        public static final String OUT = "out";
        public static final String INOUT = "inout";
        public static final String RETURN = "return";

        public ParameterDirectionGetterSetter() {
            this.setOptions(Arrays.asList(IN, OUT, INOUT, RETURN));
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            Object kind = Model.getFacade().getKind(modelElement);
            if (kind == null) {
                return null;
            }
            if (kind.equals(Model.getDirectionKind().getInParameter())) {
                return IN;
            }
            if (kind.equals(Model.getDirectionKind().getInOutParameter())) {
                return INOUT;
            }
            if (kind.equals(Model.getDirectionKind().getOutParameter())) {
                return OUT;
            }
            return RETURN;
        }

        @Override
        public void set(Object modelElement, Object value) {
            Object kind = null;
            if (value == null) {
                kind = null;
            } else if (value.equals(IN)) {
                kind = Model.getDirectionKind().getInParameter();
            } else if (value.equals(OUT)) {
                kind = Model.getDirectionKind().getOutParameter();
            } else if (value.equals(INOUT)) {
                kind = Model.getDirectionKind().getInOutParameter();
            } else if (value.equals(RETURN)) {
                kind = Model.getDirectionKind().getReturnParameter();
            }
            Model.getCoreHelper().setKind(modelElement, kind);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AggregationGetterSetter
    extends GetterSetterManager.OptionGetterSetter {
        public static final String AGGREGATE = "aggregate";
        public static final String COMPOSITE = "composite";
        public static final String NONE = "none";

        public AggregationGetterSetter() {
            this.setOptions(Arrays.asList(AGGREGATE, COMPOSITE, NONE));
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            Object kind = Model.getFacade().getAggregation(modelElement);
            if (kind == null) {
                return null;
            }
            if (kind.equals(Model.getAggregationKind().getNone())) {
                return NONE;
            }
            if (kind.equals(Model.getAggregationKind().getAggregate())) {
                return AGGREGATE;
            }
            if (kind.equals(Model.getAggregationKind().getComposite())) {
                return COMPOSITE;
            }
            return NONE;
        }

        @Override
        public void set(Object modelElement, Object value) {
            Object kind = null;
            kind = value.equals(AGGREGATE) ? Model.getAggregationKind().getAggregate() : (value.equals(COMPOSITE) ? Model.getAggregationKind().getComposite() : Model.getAggregationKind().getNone());
            Model.getCoreHelper().setAggregation(modelElement, kind);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class VisibilityGetterSetter
    extends GetterSetterManager.OptionGetterSetter {
        public static final String PUBLIC = "public";
        public static final String PROTECTED = "protected";
        public static final String PRIVATE = "private";
        public static final String PACKAGE = "package";

        public VisibilityGetterSetter() {
            this.setOptions(Arrays.asList(PUBLIC, PACKAGE, PROTECTED, PRIVATE));
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            Object kind = Model.getFacade().getVisibility(modelElement);
            if (kind == null) {
                return null;
            }
            if (kind.equals(Model.getVisibilityKind().getPublic())) {
                return PUBLIC;
            }
            if (kind.equals(Model.getVisibilityKind().getPackage())) {
                return PACKAGE;
            }
            if (kind.equals(Model.getVisibilityKind().getProtected())) {
                return PROTECTED;
            }
            if (kind.equals(Model.getVisibilityKind().getPrivate())) {
                return PRIVATE;
            }
            return PUBLIC;
        }

        @Override
        public void set(Object modelElement, Object value) {
            Object kind = null;
            kind = value.equals(PUBLIC) ? Model.getVisibilityKind().getPublic() : (value.equals(PROTECTED) ? Model.getVisibilityKind().getProtected() : (value.equals(PACKAGE) ? Model.getVisibilityKind().getPackage() : Model.getVisibilityKind().getPrivate()));
            Model.getCoreHelper().setVisibility(modelElement, kind);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DerivedGetterSetter
    extends GetterSetterManager.GetterSetter {
        private static final String TagName = "derived";

        private DerivedGetterSetter() {
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            Object tv = Model.getFacade().getTaggedValue(modelElement, TagName);
            if (tv != null) {
                String tag = Model.getFacade().getValueOfTag(tv);
                return "true".equals(tag);
            }
            return false;
        }

        @Override
        public void set(Object modelElement, Object value) {
            Object taggedValue = Model.getFacade().getTaggedValue(modelElement, TagName);
            if (taggedValue == null) {
                taggedValue = Model.getExtensionMechanismsFactory().buildTaggedValue(TagName, "");
                Model.getExtensionMechanismsHelper().addTaggedValue(modelElement, taggedValue);
            }
            if (((Boolean)value).booleanValue()) {
                Model.getCommonBehaviorHelper().setValue(taggedValue, (Object)"true");
            } else {
                Model.getCommonBehaviorHelper().setValue(taggedValue, (Object)"false");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OrderingGetterSetter
    extends GetterSetterManager.GetterSetter {
        private OrderingGetterSetter() {
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return Model.getFacade().getOrdering(modelElement) == Model.getOrderingKind().getOrdered();
        }

        @Override
        public void set(Object modelElement, Object value) {
            if (((Boolean)value).booleanValue()) {
                Model.getCoreHelper().setOrdering(modelElement, Model.getOrderingKind().getOrdered());
            } else {
                Model.getCoreHelper().setOrdering(modelElement, Model.getOrderingKind().getUnordered());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SynchGetterSetter
    extends GetterSetterManager.GetterSetter {
        private SynchGetterSetter() {
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return Model.getFacade().isSynch(modelElement);
        }

        @Override
        public void set(Object modelElement, Object value) {
            Model.getActivityGraphsHelper().setSynch(modelElement, ((Boolean)value).booleanValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AsynchronousGetterSetter
    extends GetterSetterManager.GetterSetter {
        private AsynchronousGetterSetter() {
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return Model.getFacade().isAsynchronous(modelElement);
        }

        @Override
        public void set(Object modelElement, Object value) {
            Model.getCommonBehaviorHelper().setAsynchronous(modelElement, ((Boolean)value).booleanValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NavigableGetterSetter
    extends GetterSetterManager.GetterSetter {
        private NavigableGetterSetter() {
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return Model.getFacade().isNavigable(modelElement);
        }

        @Override
        public void set(Object modelElement, Object value) {
            Model.getCoreHelper().setNavigable(modelElement, ((Boolean)value).booleanValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueryGetterSetter
    extends GetterSetterManager.GetterSetter {
        private QueryGetterSetter() {
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return Model.getFacade().isQuery(modelElement);
        }

        @Override
        public void set(Object modelElement, Object value) {
            Model.getCoreHelper().setQuery(modelElement, ((Boolean)value).booleanValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TargetScopeGetterSetter
    extends GetterSetterManager.GetterSetter {
        private TargetScopeGetterSetter() {
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return Model.getFacade().isStatic(modelElement);
        }

        @Override
        public void set(Object modelElement, Object value) {
            Model.getCoreHelper().setStatic(modelElement, ((Boolean)value).booleanValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TagDefinitionGetterSetter
    extends GetterSetterManager.ListGetterSetter {
        private TagDefinitionGetterSetter() {
        }

        @Override
        public Collection getOptions(Object modelElement, Collection<Class<?>> types) {
            return new LinkedList(Model.getFacade().getTagDefinitions(modelElement));
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return null;
        }

        @Override
        public void set(Object element, Object x) {
        }

        @Override
        public boolean isValidElement(Object element, Collection<Class<?>> types) {
            return this.getOptions(element, types).contains(element);
        }

        @Override
        public Object getMetaType() {
            if (Model.getFacade().getUmlVersion().charAt(0) == '1') {
                return Model.getMetaTypes().getTagDefinition();
            }
            return Model.getMetaTypes().getProperty();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OwnerScopeGetterSetter
    extends GetterSetterManager.GetterSetter {
        private OwnerScopeGetterSetter() {
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return Model.getFacade().isStatic(modelElement);
        }

        @Override
        public void set(Object modelElement, Object value) {
            Model.getCoreHelper().setStatic(modelElement, ((Boolean)value).booleanValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ActiveGetterSetter
    extends GetterSetterManager.GetterSetter {
        private ActiveGetterSetter() {
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return Model.getFacade().isActive(modelElement);
        }

        @Override
        public void set(Object modelElement, Object value) {
            Model.getCoreHelper().setActive(modelElement, ((Boolean)value).booleanValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RootGetterSetter
    extends GetterSetterManager.GetterSetter {
        private RootGetterSetter() {
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return Model.getFacade().isRoot(modelElement);
        }

        @Override
        public void set(Object modelElement, Object value) {
            Model.getCoreHelper().setRoot(modelElement, ((Boolean)value).booleanValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LeafGetterSetter
    extends GetterSetterManager.GetterSetter {
        private LeafGetterSetter() {
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return Model.getFacade().isLeaf(modelElement);
        }

        @Override
        public void set(Object modelElement, Object value) {
            Model.getCoreHelper().setLeaf(modelElement, ((Boolean)value).booleanValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AbstractGetterSetter
    extends GetterSetterManager.GetterSetter {
        private AbstractGetterSetter() {
        }

        @Override
        public Object get(Object modelElement, Class<?> type) {
            return Model.getFacade().isAbstract(modelElement);
        }

        @Override
        public void set(Object modelElement, Object value) {
            Model.getCoreHelper().setAbstract(modelElement, ((Boolean)value).booleanValue());
        }
    }

    private static interface Removeable {
        public Command getRemoveCommand(Object var1, Object var2);
    }

    private static interface Addable {
        public Command getAddCommand(Object var1);
    }
}

