/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import org.tigris.gef.presentation.ArrowHead;

public class ArrowHeadGreater
extends ArrowHead {
    private static final long serialVersionUID = 4300767437944516708L;

    public void paint(Graphics g, Point start, Point end, Color lineColor, Color fillColor) {
        int xTo = end.x;
        int xFrom = start.x;
        double dx = xTo - xFrom;
        int yTo = end.y;
        int yFrom = start.y;
        double dy = yTo - yFrom;
        double denom = this.dist(dx, dy);
        if (denom == 0.0) {
            return;
        }
        double cos = (double)this.getHeight() / denom;
        double sin = (double)this.getWidth() / denom;
        double x = (double)xTo - cos * dx;
        double y = (double)yTo - cos * dy;
        int x1 = (int)(x - sin * dy);
        int y1 = (int)(y + sin * dx);
        int x2 = (int)(x + sin * dy);
        int y2 = (int)(y - sin * dx);
        Graphics graphics = g;
        graphics.setColor(lineColor);
        graphics.drawLine(x1, y1, xTo, yTo);
        graphics.drawLine(x2, y2, xTo, yTo);
    }
}

