/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.persistence.svg;

import java.awt.Color;

public class SvgUtility {
    public static String getColor(Color color) {
        String colorDescr = SvgUtility.getColorName(color);
        if (colorDescr != null) {
            return colorDescr;
        }
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        if (red < 15 && green < 15 && blue < 15) {
            return "#" + Integer.toHexString(color.getRed()) + " " + Integer.toHexString(color.getGreen()) + " " + Integer.toHexString(color.getBlue());
        }
        return "#" + SvgUtility.colorToHex(color.getRed()) + " " + SvgUtility.colorToHex(color.getGreen()) + " " + SvgUtility.colorToHex(color.getBlue());
    }

    private static String colorToHex(int integer) {
        if (integer > 255) {
            throw new IllegalArgumentException("Color value cannot be great than 255");
        }
        if (integer > 15) {
            return Integer.toHexString(integer);
        }
        return "0" + Integer.toHexString(integer);
    }

    private static String getColorName(Color color) {
        String colorName = null;
        if (color.equals(Color.white)) {
            colorName = "white";
        } else if (color.equals(Color.black)) {
            colorName = "black";
        } else if (color.equals(Color.red)) {
            colorName = "red";
        } else if (color.equals(Color.green)) {
            colorName = "green";
        } else if (color.equals(Color.blue)) {
            colorName = "blue";
        }
        return colorName;
    }
}

