/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.persistence.pgml;

import java.awt.Color;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.Diagram;
import org.tigris.gef.persistence.pgml.Container;
import org.tigris.gef.persistence.pgml.FigEdgeHandler;
import org.tigris.gef.persistence.pgml.FigGroupHandler;
import org.tigris.gef.persistence.pgml.FigLineHandler;
import org.tigris.gef.persistence.pgml.FigPolyHandler;
import org.tigris.gef.persistence.pgml.FigTextHandler;
import org.tigris.gef.persistence.pgml.HandlerFactory;
import org.tigris.gef.persistence.pgml.HandlerStack;
import org.tigris.gef.persistence.pgml.InitialHandler;
import org.tigris.gef.persistence.pgml.PrivateHandler;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigCircle;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigGroup;
import org.tigris.gef.presentation.FigLine;
import org.tigris.gef.presentation.FigPoly;
import org.tigris.gef.presentation.FigRRect;
import org.tigris.gef.presentation.FigRect;
import org.tigris.gef.presentation.FigText;
import org.tigris.gef.undo.UndoManager;
import org.tigris.gef.util.ColorFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class PGMLStackParser
implements HandlerStack,
HandlerFactory {
    private static final Log LOG = LogFactory.getLog(PGMLStackParser.class);
    private Stack handlerStack;
    private XMLReader xmlReader;
    private Map ownerRegistry;
    private Diagram diagram;
    private HashMap figRegistry;
    private HashMap translationTable = new HashMap();

    public PGMLStackParser(Map modelElementsByUuid) {
        this.ownerRegistry = modelElementsByUuid;
        this.diagram = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Diagram readDiagram(InputStream is, boolean closeStream) throws SAXException {
        if (UndoManager.getInstance().isGenerateMementos()) {
            UndoManager.getInstance().addMementoLock(this);
        }
        try {
            Diagram diagram = this.readDiagram(is, closeStream, (DefaultHandler)new InitialHandler(this));
            return diagram;
        }
        finally {
            UndoManager.getInstance().removeMementoLock(this);
        }
    }

    private synchronized Diagram readDiagram(InputStream is, boolean closeStream, DefaultHandler initialHandler) throws SAXException {
        this.handlerStack = new Stack();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(false);
            factory.setValidating(false);
            this.figRegistry = new HashMap();
            this.diagram = null;
            SAXParser parser = factory.newSAXParser();
            InputSource source = new InputSource(is);
            this.xmlReader = parser.getXMLReader();
            parser.parse(source, initialHandler);
            if (closeStream) {
                is.close();
            }
            return this.diagram;
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Diagram readDiagram(Reader reader, boolean closeStream) throws SAXException {
        boolean wasGenerateMementos = UndoManager.getInstance().isGenerateMementos();
        if (wasGenerateMementos) {
            // empty if block
        }
        Diagram diagram = this.readDiagram(reader, closeStream, (DefaultHandler)new InitialHandler(this));
        return diagram;
    }

    private synchronized Diagram readDiagram(Reader reader, boolean closeStream, DefaultHandler initialHandler) throws SAXException {
        this.handlerStack = new Stack();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(false);
            factory.setValidating(false);
            this.figRegistry = new HashMap();
            this.diagram = null;
            SAXParser parser = factory.newSAXParser();
            InputSource source = new InputSource(reader);
            this.xmlReader = parser.getXMLReader();
            parser.parse(source, initialHandler);
            if (closeStream) {
                reader.close();
            }
            return this.diagram;
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
    }

    public Diagram getDiagram() {
        return this.diagram;
    }

    public void setDiagram(Diagram theDiagram) {
        this.diagram = theDiagram;
    }

    public Object findOwner(String id) {
        return this.ownerRegistry.get(id);
    }

    public void addTranslation(String from, String to) {
        this.translationTable.put(from, to);
    }

    public void pushHandlerStack(DefaultHandler handler) {
        this.handlerStack.push(handler);
        if (this.xmlReader != null) {
            this.xmlReader.setContentHandler(handler);
            this.xmlReader.setErrorHandler(handler);
        }
    }

    public void popHandlerStack() {
        this.handlerStack.pop();
        if (this.xmlReader != null && this.handlerStack.size() > 0) {
            DefaultHandler handler = (DefaultHandler)this.handlerStack.peek();
            this.xmlReader.setContentHandler(handler);
            this.xmlReader.setErrorHandler(handler);
        }
    }

    public String translateType(String oldName) {
        String translated = (String)this.translationTable.get(oldName);
        if (translated == null) {
            return oldName;
        }
        return translated;
    }

    public DefaultHandler getHandler(HandlerStack stack, Object container, String uri, String localname, String qname, Attributes attributes) throws SAXException {
        StringTokenizer st;
        String clsName;
        String href = attributes.getValue("href");
        String clsNameBounds = attributes.getValue("description");
        Fig elementInstance = null;
        if (clsNameBounds != null && (elementInstance = this.constructFig(clsName = this.translateType((st = new StringTokenizer(clsNameBounds, ",;[] ")).nextToken()), href, this.getBounds(clsNameBounds), attributes)) instanceof HandlerFactory) {
            return ((HandlerFactory)((Object)elementInstance)).getHandler(stack, container, uri, localname, qname, attributes);
        }
        if (qname.equals("group")) {
            if (elementInstance instanceof FigGroup) {
                return this.getGroupHandler(container, (FigGroup)elementInstance, attributes);
            }
            if (elementInstance instanceof FigEdge) {
                this.setAttrs((FigEdge)elementInstance, attributes);
                if (container instanceof Container) {
                    ((Container)container).addObject(elementInstance);
                }
                return new FigEdgeHandler(this, (FigEdge)elementInstance);
            }
        }
        if (qname.equals("text")) {
            if (elementInstance == null) {
                elementInstance = new FigText(0, 0, 100, 100);
            }
            if (elementInstance instanceof FigText) {
                String textColor;
                String bold;
                String italic;
                String justification;
                String textsize;
                String font;
                FigText text = (FigText)elementInstance;
                this.setAttrs(text, attributes);
                if (container instanceof Container) {
                    ((Container)container).addObject(text);
                }
                if ((font = attributes.getValue("font")) != null && !font.equals("")) {
                    text.setFontFamily(font);
                }
                if ((textsize = attributes.getValue("textsize")) != null && !textsize.equals("")) {
                    int textsizeInt = Integer.parseInt(textsize);
                    text.setFontSize(textsizeInt);
                }
                if ((justification = attributes.getValue("justification")) != null && !justification.equals("")) {
                    text.setJustificationByName(justification);
                }
                if ((italic = attributes.getValue("italic")) != null && !italic.equals("")) {
                    text.setItalic(Boolean.valueOf(italic));
                }
                if ((bold = attributes.getValue("bold")) != null && !bold.equals("")) {
                    text.setBold(Boolean.valueOf(bold));
                }
                if ((textColor = attributes.getValue("textcolor")) != null && !textColor.equals("")) {
                    text.setTextColor(ColorFactory.getColor(textColor));
                }
                return new FigTextHandler(this, text);
            }
        }
        if (qname.equals("path") || qname.equals("line")) {
            if (elementInstance == null) {
                elementInstance = new FigPoly();
            }
            if (elementInstance instanceof FigLine) {
                this.setAttrs(elementInstance, attributes);
                if (container instanceof Container) {
                    ((Container)container).addObject(elementInstance);
                }
                return new FigLineHandler(this, (FigLine)elementInstance);
            }
            if (elementInstance instanceof FigPoly) {
                this.setAttrs(elementInstance, attributes);
                if (container instanceof Container) {
                    ((Container)container).addObject(elementInstance);
                }
                return new FigPolyHandler(this, (FigPoly)elementInstance);
            }
        }
        if (qname.equals("private")) {
            if (elementInstance != null) {
                LOG.warn((Object)("private element unexpectedly generated instance: " + elementInstance.toString()));
            }
            if (container instanceof Container) {
                return new PrivateHandler(this, (Container)container);
            }
            LOG.warn((Object)("private element with inappropriate container: " + container.toString()));
        }
        if (qname.equals("rectangle")) {
            String cornerRadius = attributes.getValue("rounding");
            int rInt = -1;
            if (cornerRadius != null && cornerRadius.length() > 0) {
                rInt = Integer.parseInt(cornerRadius);
            }
            if (elementInstance == null) {
                elementInstance = rInt >= 0 ? new FigRRect(0, 0, 80, 80) : new FigRect(0, 0, 80, 80);
            }
            if (elementInstance instanceof FigRRect && rInt >= 0) {
                ((FigRRect)elementInstance).setCornerRadius(rInt);
            }
            if (elementInstance instanceof Fig) {
                this.setAttrs(elementInstance, attributes);
                if (container instanceof Container) {
                    ((Container)container).addObject(elementInstance);
                }
                return null;
            }
        }
        if (qname.equals("ellipse")) {
            System.out.println("Found an ellipse");
            if (elementInstance == null) {
                System.out.println("Created a FigCircle");
                elementInstance = new FigCircle(0, 0, 50, 50);
            }
            if (elementInstance instanceof FigCircle) {
                FigCircle f = (FigCircle)elementInstance;
                this.setAttrs(f, attributes);
                String rx = attributes.getValue("rx");
                String ry = attributes.getValue("ry");
                int rxInt = rx == null || rx.equals("") ? 10 : Integer.parseInt(rx);
                int ryInt = ry == null || ry.equals("") ? 10 : Integer.parseInt(ry);
                f.setBounds(f.getX() - rxInt, f.getY() - ryInt, rxInt * 2, ryInt * 2);
                if (container instanceof Container) {
                    ((Container)container).addObject(elementInstance);
                }
                return null;
            }
        }
        LOG.info((Object)("Unrecognized element " + qname));
        if (elementInstance != null) {
            if (elementInstance instanceof Fig) {
                this.setAttrs(elementInstance, attributes);
            }
            if (container instanceof Container) {
                ((Container)container).addObject(elementInstance);
            }
        }
        return null;
    }

    protected Fig constructFig(String className, String href, Rectangle bounds, Attributes attributes) throws SAXException {
        try {
            Class<?> figClass = Class.forName(className);
            if (href != null) {
                int i;
                Constructor<?>[] constructors = figClass.getConstructors();
                for (i = 0; i < constructors.length; ++i) {
                    constructors[i].setAccessible(true);
                    if (constructors[i].getParameterTypes().length != 5 || !constructors[i].getParameterTypes()[0].equals(Object.class) || !constructors[i].getParameterTypes()[1].equals(Integer.TYPE) || !constructors[i].getParameterTypes()[2].equals(Integer.TYPE) || !constructors[i].getParameterTypes()[3].equals(Integer.TYPE) || !constructors[i].getParameterTypes()[4].equals(Integer.TYPE)) continue;
                    Object[] parameters = new Object[]{this.findOwner(href), new Integer(bounds.x), new Integer(bounds.y), new Integer(bounds.width), new Integer(bounds.height)};
                    return (Fig)constructors[i].newInstance(parameters);
                }
                for (i = 0; i < constructors.length; ++i) {
                    if (constructors[i].getParameterTypes().length != 3 || !constructors[i].getParameterTypes()[0].equals(Object.class) || !constructors[i].getParameterTypes()[1].equals(Integer.TYPE) || !constructors[i].getParameterTypes()[2].equals(Integer.TYPE)) continue;
                    Object[] parameters = new Object[]{this.findOwner(href), new Integer(bounds.x), new Integer(bounds.y)};
                    return (Fig)constructors[i].newInstance(parameters);
                }
                for (i = 0; i < constructors.length; ++i) {
                    if (constructors[i].getParameterTypes().length != 1 || !constructors[i].getParameterTypes()[0].equals(Object.class)) continue;
                    Object[] parameters = new Object[]{this.findOwner(href)};
                    return (Fig)constructors[i].newInstance(parameters);
                }
            }
            return (Fig)figClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new SAXException(e);
        }
        catch (IllegalAccessException e) {
            throw new SAXException(e);
        }
        catch (InstantiationException e) {
            throw new SAXException(e);
        }
        catch (InvocationTargetException e) {
            throw new SAXException(e);
        }
    }

    public void registerFig(Fig fig, String name) {
        this.figRegistry.put(name, fig);
    }

    public Fig findFig(String name) {
        return (Fig)this.figRegistry.get(name);
    }

    public static void setCommonAttrs(Fig f, Attributes attrList) {
        String visState;
        String context;
        String dasharray;
        String fillcolor;
        String fill;
        String strokecolor;
        String linewidth;
        String x = attrList.getValue("x");
        if (x != null && !x.equals("")) {
            String y = attrList.getValue("y");
            String w = attrList.getValue("width");
            String h = attrList.getValue("height");
            int xInt = Integer.parseInt(x);
            int yInt = y == null || y.equals("") ? 0 : Integer.parseInt(y);
            int wInt = w == null || w.equals("") ? 20 : Integer.parseInt(w);
            int hInt = h == null || h.equals("") ? 20 : Integer.parseInt(h);
            f.setBounds(xInt, yInt, wInt, hInt);
        }
        if ((linewidth = attrList.getValue("stroke")) != null && !linewidth.equals("")) {
            f.setLineWidth(Integer.parseInt(linewidth));
        }
        if ((strokecolor = attrList.getValue("strokecolor")) != null && !strokecolor.equals("")) {
            f.setLineColor(ColorFactory.getColor(strokecolor, Color.blue));
        }
        if ((fill = attrList.getValue("fill")) != null && !fill.equals("")) {
            f.setFilled(fill.equals("1") || fill.startsWith("t"));
        }
        if ((fillcolor = attrList.getValue("fillcolor")) != null && !fillcolor.equals("")) {
            f.setFillColor(ColorFactory.getColor(fillcolor, Color.white));
        }
        if ((dasharray = attrList.getValue("dasharray")) != null && !dasharray.equals("") && !dasharray.equals("solid")) {
            f.setDashed(true);
        }
        if ((context = attrList.getValue("context")) != null && !context.equals("")) {
            f.setContext(context);
        }
        if ((visState = attrList.getValue("visible")) != null && !visState.equals("")) {
            int visStateInt = Integer.parseInt(visState);
            f.setVisible(visStateInt != 0);
        }
    }

    protected void setAttrs(Fig f, Attributes attrList) throws SAXException {
        String name = attrList.getValue("name");
        if (name != null && !name.equals("")) {
            this.figRegistry.put(name, f);
        }
        PGMLStackParser.setCommonAttrs(f, attrList);
        String owner = attrList.getValue("href");
        if (owner != null && !owner.equals("")) {
            Object modelElement = this.findOwner(owner);
            if (modelElement == null) {
                throw new SAXException("Found href of " + owner + " with no matching element in model");
            }
            if (f.getOwner() != modelElement) {
                f.setOwner(modelElement);
            } else {
                LOG.info((Object)("Ignoring href on " + f.getClass().getName() + " as it's already set"));
            }
        }
    }

    private DefaultHandler getGroupHandler(Object container, FigGroup group, Attributes attributes) throws SAXException {
        if (container instanceof Container) {
            ((Container)container).addObject(group);
        }
        StringTokenizer st = new StringTokenizer(attributes.getValue("description"), ",;[] ");
        this.setAttrs(group, attributes);
        if (st.hasMoreElements()) {
            st.nextToken();
        }
        String xStr = null;
        String yStr = null;
        String wStr = null;
        String hStr = null;
        if (st.hasMoreElements()) {
            xStr = st.nextToken();
            yStr = st.nextToken();
            wStr = st.nextToken();
            hStr = st.nextToken();
        }
        if (xStr != null && !xStr.equals("")) {
            int x = Integer.parseInt(xStr);
            int y = Integer.parseInt(yStr);
            int w = Integer.parseInt(wStr);
            int h = Integer.parseInt(hStr);
            group.setBounds(x, y, w, h);
        }
        return new FigGroupHandler(this, group);
    }

    Rectangle getBounds(String boundsDescription) {
        try {
            int bracketPosn = boundsDescription.indexOf(91);
            if (bracketPosn < 0) {
                return null;
            }
            boundsDescription = boundsDescription.substring(bracketPosn + 1);
            StringTokenizer st = new StringTokenizer(boundsDescription, ", ]");
            String xStr = null;
            String yStr = null;
            String wStr = null;
            String hStr = null;
            if (st.hasMoreElements()) {
                xStr = st.nextToken();
                yStr = st.nextToken();
                wStr = st.nextToken();
                hStr = st.nextToken();
            }
            if (xStr != null && !xStr.equals("")) {
                int x = Integer.parseInt(xStr);
                int y = Integer.parseInt(yStr);
                int w = Integer.parseInt(wStr);
                int h = Integer.parseInt(hStr);
                return new Rectangle(x, y, w, h);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Exception extracting bounds from description", (Throwable)e);
        }
        return null;
    }
}

