/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Layer;
import org.tigris.gef.base.Selection;
import org.tigris.gef.base.SelectionLowerRight;
import org.tigris.gef.base.SelectionMove;
import org.tigris.gef.base.SelectionNoop;
import org.tigris.gef.base.SelectionReshape;
import org.tigris.gef.base.SelectionResize;
import org.tigris.gef.di.DiagramElement;
import org.tigris.gef.event.GraphSelectionEvent;
import org.tigris.gef.event.GraphSelectionListener;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigNode;
import org.tigris.gef.presentation.Handle;
import org.tigris.gef.undo.Memento;
import org.tigris.gef.undo.UndoManager;
import org.tigris.gef.util.VetoableChangeEventSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionManager
implements Serializable,
KeyListener,
MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 3232261288542010603L;
    private List<Selection> selections = new ArrayList<Selection>();
    private Editor editor;
    private EventListenerList _listeners = new EventListenerList();
    private DragMemento dragMemento;
    private Fig _dragTopMostFig;
    private Fig _dragLeftMostFig;
    private Collection<FigNode> _draggingNodes;
    private List<FigEdge> _draggingMovingEdges;
    private List<FigEdge> _draggingNonMovingEdges;
    private List<Fig> _draggingOthers;

    public SelectionManager(Editor ed) {
        this.editor = ed;
    }

    protected void addSelection(Selection s) {
        this.selections.add(s);
    }

    protected void addFig(Fig f) {
        if (f.isSelectable()) {
            this.selections.add(SelectionManager.makeSelectionFor(f));
        }
    }

    @Deprecated
    protected void addAllFigs(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.addFig((Fig)it.next());
        }
    }

    protected void addFigs(Collection<? extends DiagramElement> figs) {
        for (DiagramElement diagramElement : figs) {
            this.addFig((Fig)diagramElement);
        }
    }

    protected void removeAllElements() {
        this.selections.clear();
    }

    protected void removeSelection(Selection s) {
        if (s != null) {
            this.selections.remove(s);
        }
    }

    protected void removeFig(Fig f) {
        Selection s = this.findSelectionFor(f);
        if (s != null) {
            this.selections.remove(s);
        }
    }

    protected void allDamaged() {
        Rectangle bounds = this.getBounds();
        this.editor.scaleRect(bounds);
        this.editor.damaged(bounds);
    }

    public void select(Fig f) {
        if (UndoManager.getInstance().isGenerateMementos()) {
            UndoManager.getInstance().addMemento(new SelectionMemento());
        }
        this.allDamaged();
        this.removeAllElements();
        this.addFig(f);
        this.editor.damageAll();
        this.fireSelectionChanged();
    }

    public void addToSelection(Fig fig) {
        if (UndoManager.getInstance().isGenerateMementos()) {
            UndoManager.getInstance().addMemento(new SelectionMemento());
        }
        this.addFig(fig);
        this.editor.damageAll();
        this.fireSelectionChanged();
    }

    public void deselect(Fig f) {
        if (UndoManager.getInstance().isGenerateMementos()) {
            UndoManager.getInstance().addMemento(new SelectionMemento());
        }
        if (this.containsFig(f)) {
            this.removeFig(f);
            this.editor.damageAll();
            this.fireSelectionChanged();
        }
    }

    public void toggle(Fig f) {
        if (UndoManager.getInstance().isGenerateMementos()) {
            UndoManager.getInstance().addMemento(new SelectionMemento());
        }
        this.editor.damageAll();
        if (this.containsFig(f)) {
            this.removeFig(f);
        } else {
            this.addFig(f);
        }
        this.editor.damageAll();
        this.fireSelectionChanged();
    }

    public void deselectAll() {
        if (this.getSelections().size() > 0) {
            if (UndoManager.getInstance().isGenerateMementos()) {
                UndoManager.getInstance().addMemento(new SelectionMemento());
            }
            Rectangle damagedArea = this.getBounds();
            this.removeAllElements();
            this.editor.damaged(damagedArea);
            this.fireSelectionChanged();
        }
    }

    @Deprecated
    public void select(Collection items) {
        if (UndoManager.getInstance().isGenerateMementos()) {
            UndoManager.getInstance().addMemento(new SelectionMemento());
        }
        this.allDamaged();
        this.removeAllElements();
        this.addAllFigs(items);
        this.allDamaged();
        this.fireSelectionChanged();
    }

    public void selectFigs(Collection<? extends DiagramElement> items) {
        if (UndoManager.getInstance().isGenerateMementos()) {
            UndoManager.getInstance().addMemento(new SelectionMemento());
        }
        this.allDamaged();
        this.removeAllElements();
        this.addFigs(items);
        this.allDamaged();
        this.fireSelectionChanged();
    }

    public void toggle(Vector items) {
        if (UndoManager.getInstance().isGenerateMementos()) {
            UndoManager.getInstance().addMemento(new SelectionMemento());
        }
        this.allDamaged();
        Enumeration figs = ((Vector)items.clone()).elements();
        while (figs.hasMoreElements()) {
            Fig f = (Fig)figs.nextElement();
            if (this.containsFig(f)) {
                this.removeFig(f);
                continue;
            }
            this.addFig(f);
        }
        this.allDamaged();
        this.fireSelectionChanged();
    }

    public Selection findSelectionFor(Fig f) {
        ArrayList<Selection> sels = new ArrayList<Selection>(this.getSelections());
        for (Selection sel : sels) {
            if (!sel.contains(f)) continue;
            return sel;
        }
        return null;
    }

    public Selection findSelectionAt(int x, int y) {
        ArrayList<Selection> sels = new ArrayList<Selection>(this.getSelections());
        for (Selection sel : sels) {
            if (!sel.contains(x, y)) continue;
            return sel;
        }
        return null;
    }

    public boolean contains(Selection s) {
        return this.selections.contains(s);
    }

    public boolean containsFig(Fig f) {
        return this.findSelectionFor(f) != null;
    }

    public boolean getLocked() {
        for (Selection sel : this.selections) {
            if (!sel.getLocked()) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.selections.size();
    }

    @Deprecated
    public Vector selections() {
        return new Vector<Selection>(this.selections);
    }

    public List<Selection> getSelections() {
        return Collections.unmodifiableList(new ArrayList<Selection>(this.selections));
    }

    public Vector<Fig> getFigs() {
        Vector<Fig> figs = new Vector<Fig>(this.selections.size());
        int selCount = this.selections.size();
        for (int i = 0; i < selCount; ++i) {
            figs.addElement(this.selections.get(i).getContent());
        }
        return figs;
    }

    public List<Fig> getSelectedFigs() {
        ArrayList<Fig> figs = new ArrayList<Fig>(this.selections.size());
        int selCount = this.selections.size();
        for (int i = 0; i < selCount; ++i) {
            figs.add(this.selections.get(i).getContent());
        }
        return figs;
    }

    public List getDraggableFigs() {
        ArrayList<Fig> figs = new ArrayList<Fig>(this.getFigs());
        for (Fig o : this.getFigs()) {
            if (!(o instanceof FigNode)) continue;
            this.addDragDependents(figs, (FigNode)o);
        }
        return figs;
    }

    public void endTrans() {
        int selSize = this.selections.size();
        ArrayList affected = new ArrayList();
        for (int i = 0; i < selSize; ++i) {
            Selection s = this.selections.get(i);
            this.addEnclosed(affected, s.getContent());
        }
        int size = affected.size();
        for (int i = 0; i < size; ++i) {
            Fig f = (Fig)affected.get(i);
            f.endTrans();
        }
    }

    public void paint(Graphics g) {
        for (Selection sel : this.selections) {
            sel.paint(g);
        }
    }

    public void damage() {
        for (Selection sel : this.selections) {
            sel.damage();
        }
    }

    public boolean contains(int x, int y) {
        for (Selection sel : this.selections) {
            if (!sel.contains(x, y)) continue;
            return true;
        }
        return false;
    }

    public boolean hit(Rectangle r) {
        for (Selection sel : this.selections) {
            if (!sel.hit(r)) continue;
            return true;
        }
        return false;
    }

    public Rectangle getBounds() {
        int size = this.selections.size();
        if (size == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle r = this.selections.get(0).getBounds();
        for (Selection sel : this.selections) {
            r.add(sel.getBounds());
        }
        return r;
    }

    public Rectangle getContentBounds() {
        Rectangle r = null;
        Iterator<Selection> it = this.selections.iterator();
        if (it.hasNext()) {
            r = it.next().getContentBounds();
        } else {
            return new Rectangle(0, 0, 0, 0);
        }
        while (it.hasNext()) {
            Selection sel = it.next();
            r.add(sel.getContentBounds());
        }
        return r;
    }

    public Point getLocation() {
        int size = this.selections.size();
        if (size < 1) {
            return new Point(0, 0);
        }
        Selection sel = null;
        int lowestX = Integer.MAX_VALUE;
        int lowestY = Integer.MAX_VALUE;
        Point pt = null;
        for (int i = 0; i < size; ++i) {
            sel = this.selections.get(i);
            pt = sel.getLocation();
            if (pt.getX() < (double)lowestX) {
                lowestX = (int)pt.getX();
            }
            if (!(pt.getY() < (double)lowestY)) continue;
            lowestY = (int)pt.getY();
        }
        pt = null;
        sel = null;
        return new Point(lowestX, lowestY);
    }

    public void reorder(int func, Layer lay) {
        for (Selection sel : this.selections) {
            sel.reorder(func, lay);
        }
    }

    public void translate(int dx, int dy) {
        Fig f;
        int i;
        Vector affected = new Vector();
        Vector<FigEdge> nonMovingEdges = new Vector<FigEdge>();
        Vector<FigEdge> movingEdges = new Vector<FigEdge>();
        Vector<FigNode> nodes = new Vector<FigNode>();
        int selSize = this.selections.size();
        for (Selection sel : this.selections) {
            this.addEnclosed(affected, sel.getContent());
        }
        int size = affected.size();
        for (i = 0; i < size; ++i) {
            f = (Fig)affected.elementAt(i);
            int fx = f.getX();
            int fy = f.getY();
            dx = Math.max(-fx, dx);
            dy = Math.max(-fy, dy);
        }
        for (i = 0; i < size; ++i) {
            f = (Fig)affected.elementAt(i);
            if (!(f instanceof FigNode)) {
                f.translate(dx, dy);
                continue;
            }
            FigNode fn = (FigNode)f;
            nodes.addElement(fn);
            fn.superTranslate(dx, dy);
            Collection<FigEdge> figEdges = fn.getFigEdges(null);
            for (FigEdge fe : figEdges) {
                if (nonMovingEdges.contains(fe) && !movingEdges.contains(fe)) {
                    movingEdges.addElement(fe);
                    continue;
                }
                nonMovingEdges.addElement(fe);
            }
        }
        int meSize = movingEdges.size();
        for (int i2 = 0; i2 < meSize; ++i2) {
            FigEdge fe = (FigEdge)movingEdges.elementAt(i2);
            fe.translateEdge(dx, dy);
        }
        int fnSize = nodes.size();
        for (int i3 = 0; i3 < fnSize; ++i3) {
            FigNode fn = (FigNode)nodes.elementAt(i3);
            fn.updateEdges();
        }
    }

    protected void addEnclosed(Collection affected, Fig f) {
        if (!affected.contains(f)) {
            affected.add(f);
            Vector enclosed = f.getEnclosedFigs();
            if (enclosed != null) {
                int size = enclosed.size();
                for (int i = 0; i < size; ++i) {
                    this.addEnclosed(affected, (Fig)enclosed.get(i));
                }
            }
        }
    }

    public void startDrag() {
        ArrayList draggingFigs = new ArrayList();
        this._draggingNodes = new HashSet<FigNode>();
        this._draggingMovingEdges = new ArrayList<FigEdge>();
        this._draggingNonMovingEdges = new ArrayList<FigEdge>();
        this._draggingOthers = new ArrayList<Fig>();
        int selectionCount = this.selections.size();
        for (int selectionIndex = 0; selectionIndex < selectionCount; ++selectionIndex) {
            Selection selection = this.selections.get(selectionIndex);
            this.addEnclosed(draggingFigs, selection.getContent());
        }
        int figCount = draggingFigs.size();
        for (int figIndex = 0; figIndex < figCount; ++figIndex) {
            Fig fig = (Fig)draggingFigs.get(figIndex);
            if (fig instanceof FigEdge) {
                FigEdge figEdge = (FigEdge)fig;
                this.checkDragEdge(figEdge, draggingFigs, this._draggingNonMovingEdges);
                continue;
            }
            if (!(fig instanceof FigNode)) {
                this._draggingOthers.add(fig);
                continue;
            }
            FigNode figNode = (FigNode)fig;
            this._draggingNodes.add(figNode);
            this.addDragDependents(this._draggingNodes, figNode);
            Collection<FigEdge> figEdges = figNode.getFigEdges(null);
            for (FigEdge figEdge : figEdges) {
                this.checkDragEdge(figEdge, draggingFigs, this._draggingNonMovingEdges);
            }
        }
        Collection<FigNode> topLeftList = this._draggingNodes.size() > 0 ? this._draggingNodes : this._draggingOthers;
        for (FigNode o : topLeftList) {
            Fig fig = o;
            if (this._dragLeftMostFig == null || fig.getX() < this._dragLeftMostFig.getX()) {
                this._dragLeftMostFig = fig;
            }
            if (this._dragTopMostFig != null && fig.getY() >= this._dragTopMostFig.getY()) continue;
            this._dragTopMostFig = fig;
        }
        if (UndoManager.getInstance().isGenerateMementos()) {
            this.dragMemento = new DragMemento(this._draggingNodes, this._draggingOthers, this._draggingMovingEdges, this._draggingNonMovingEdges);
        }
        UndoManager.getInstance().addMementoLock(this);
    }

    private void addDragDependents(Collection draggingNodes, FigNode figNode) {
        if (figNode.getDragDependencies() != null) {
            for (Fig fig : figNode.getDragDependencies()) {
                if (draggingNodes.contains(fig)) continue;
                draggingNodes.add(fig);
            }
        }
    }

    private void checkDragEdge(FigEdge figEdge, List draggingFigs, List draggingNonMovingEdges) {
        FigNode dest = figEdge.getDestFigNode();
        FigNode source = figEdge.getSourceFigNode();
        if (draggingFigs.contains(dest) && draggingFigs.contains(source)) {
            if (!this._draggingMovingEdges.contains(figEdge)) {
                this._draggingMovingEdges.add(figEdge);
            }
        } else if (!draggingNonMovingEdges.contains(figEdge)) {
            draggingNonMovingEdges.add(figEdge);
        }
    }

    public void drag(int dx, int dy) {
        if (this._dragLeftMostFig == null || this._dragTopMostFig == null) {
            return;
        }
        Rectangle dirtyRegion = this._dragLeftMostFig.getBounds();
        Rectangle figBounds = this._dragLeftMostFig.getBounds();
        dx = Math.max(-this._dragLeftMostFig.getX(), dx);
        dy = Math.max(-this._dragTopMostFig.getY(), dy);
        for (FigNode figNode : this._draggingNodes) {
            figNode.getBounds(figBounds);
            dirtyRegion.add(figBounds.x, figBounds.y);
            dirtyRegion.add(figBounds.x + dx, figBounds.y + dy);
            dirtyRegion.add(figBounds.x + figBounds.width, figBounds.y + figBounds.height);
            dirtyRegion.add(figBounds.x + figBounds.width + dx, figBounds.y + figBounds.height + dy);
            figNode.superTranslate(dx, dy);
        }
        for (Fig fig : this._draggingOthers) {
            fig.getBounds(figBounds);
            dirtyRegion.add(figBounds.x, figBounds.y);
            dirtyRegion.add(figBounds.x + dx, figBounds.y + dy);
            dirtyRegion.add(figBounds.x + figBounds.width, figBounds.y + figBounds.height);
            dirtyRegion.add(figBounds.x + figBounds.width + dx, figBounds.y + figBounds.height + dy);
            fig.translate(dx, dy);
            fig.translateAnnotations();
        }
        for (FigEdge figEdge : this._draggingMovingEdges) {
            figEdge.getBounds(figBounds);
            dirtyRegion.add(figBounds.x, figBounds.y);
            dirtyRegion.add(figBounds.x + dx, figBounds.y + dy);
            dirtyRegion.add(figBounds.x + figBounds.width, figBounds.y + figBounds.height);
            dirtyRegion.add(figBounds.x + figBounds.width + dx, figBounds.y + figBounds.height + dy);
            figEdge.translateEdge(dx, dy);
            figEdge.translateAnnotations();
        }
        for (FigEdge figEdge : this._draggingNonMovingEdges) {
            figEdge.getBounds(figBounds);
            dirtyRegion.add(figBounds);
            figEdge.computeRoute();
            figEdge.getBounds(figBounds);
            dirtyRegion.add(figBounds);
            figEdge.translateAnnotations();
        }
        int extraDirt = 24;
        dirtyRegion.x -= extraDirt;
        dirtyRegion.y -= extraDirt;
        dirtyRegion.width += 2 * extraDirt;
        dirtyRegion.height += 2 * extraDirt;
        Layer layer = this._dragLeftMostFig.getLayer();
        if (layer == null && this._dragLeftMostFig.getOwner() instanceof Fig) {
            layer = ((Fig)this._dragLeftMostFig.getOwner()).getLayer();
        }
        if (layer != null) {
            List<Editor> editors = layer.getEditors();
            int editorCount = editors.size();
            Rectangle dirtyRegionScaled = new Rectangle();
            for (int editorIndex = 0; editorIndex < editorCount; ++editorIndex) {
                Editor ed = editors.get(editorIndex);
                double editorScale = ed.getScale();
                dirtyRegionScaled.x = (int)Math.floor((double)dirtyRegion.x * editorScale);
                dirtyRegionScaled.y = (int)Math.floor((double)dirtyRegion.y * editorScale);
                dirtyRegionScaled.width = (int)Math.floor((double)dirtyRegion.width * editorScale) + 1;
                dirtyRegionScaled.height = (int)Math.floor((double)dirtyRegion.height * editorScale) + 1;
                ed.damaged(dirtyRegionScaled);
            }
        } else {
            System.out.println("Selection manager: layer is null");
        }
    }

    public void stopDrag() {
        UndoManager.getInstance().removeMementoLock(this);
        if (this.dragMemento != null) {
            UndoManager.getInstance().addMemento(this.dragMemento);
        }
        this.dragMemento = null;
        this.cleanup();
    }

    private void cleanup() {
        this._dragTopMostFig = null;
        this._dragLeftMostFig = null;
        this._draggingNodes = null;
        this._draggingMovingEdges = null;
        this._draggingNonMovingEdges = null;
        this._draggingOthers = null;
    }

    public Point getDragLocation() {
        return new Point(this._dragLeftMostFig.getX(), this._dragTopMostFig.getY());
    }

    public void hitHandle(Rectangle r, Handle h) {
        if (this.size() == 1) {
            this.selections.get(0).hitHandle(r, h);
        } else {
            h.index = -1;
        }
    }

    public void dragHandle(int mx, int my, int an_x, int an_y, Handle h) {
        if (this.size() != 1) {
            return;
        }
        Selection sel = this.selections.get(0);
        sel.dragHandle(mx, my, an_x, an_y, h);
    }

    public void cleanUp() {
        for (Selection sel : this.selections) {
            Fig f = sel.getContent();
            f.cleanUp();
        }
    }

    public void removeFromGraph() {
        ArrayList<Selection> sels = new ArrayList<Selection>(this.selections);
        for (Selection sel : sels) {
            sel.delete();
        }
    }

    public void dispose() {
        ArrayList<Selection> sels = new ArrayList<Selection>(this.selections);
        for (Selection s : sels) {
            Fig f = s.getContent();
            Object o = f.getOwner();
            if (!(o instanceof VetoableChangeEventSource)) continue;
            Vector v = (Vector)((VetoableChangeEventSource)o).getVetoableChangeListeners().clone();
            Enumeration vv = v.elements();
            vv = v.elements();
            Object firstElem = null;
            boolean firstIteration = true;
            while (vv.hasMoreElements()) {
                Object elem = vv.nextElement();
                if (!(elem instanceof Fig)) continue;
                if (firstIteration) {
                    firstElem = elem;
                    firstIteration = false;
                    continue;
                }
                ((Fig)elem).removeFromDiagram();
            }
            ((Fig)firstElem).deleteFromModel();
        }
    }

    public void deleteFromModel() {
        for (Selection sel : this.getSelections()) {
            Fig f = sel.getContent();
            f.deleteFromModel();
        }
    }

    @Override
    public void keyTyped(KeyEvent ke) {
        ArrayList<Selection> list = new ArrayList<Selection>(this.selections);
        Iterator sels = list.iterator();
        while (sels.hasNext() && !ke.isConsumed()) {
            ((Selection)sels.next()).keyTyped(ke);
        }
    }

    @Override
    public void keyReleased(KeyEvent ke) {
        ArrayList<Selection> list = new ArrayList<Selection>(this.selections);
        Iterator sels = list.iterator();
        while (sels.hasNext() && !ke.isConsumed()) {
            ((Selection)sels.next()).keyReleased(ke);
        }
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        ArrayList<Selection> list = new ArrayList<Selection>(this.selections);
        Iterator sels = list.iterator();
        while (sels.hasNext() && !ke.isConsumed()) {
            ((Selection)sels.next()).keyPressed(ke);
        }
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        ArrayList<Selection> list = new ArrayList<Selection>(this.selections);
        Iterator sels = list.iterator();
        while (sels.hasNext() && !me.isConsumed()) {
            ((Selection)sels.next()).mouseMoved(me);
        }
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        ArrayList<Selection> list = new ArrayList<Selection>(this.selections);
        Iterator sels = list.iterator();
        while (sels.hasNext() && !me.isConsumed()) {
            ((Selection)sels.next()).mouseDragged(me);
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        ArrayList<Selection> list = new ArrayList<Selection>(this.selections);
        Iterator sels = list.iterator();
        while (sels.hasNext() && !me.isConsumed()) {
            ((Selection)sels.next()).mouseClicked(me);
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        ArrayList<Selection> list = new ArrayList<Selection>(this.selections);
        Iterator sels = list.iterator();
        while (sels.hasNext() && !me.isConsumed()) {
            ((Selection)sels.next()).mousePressed(me);
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        ArrayList<Selection> list = new ArrayList<Selection>(this.selections);
        Iterator sels = list.iterator();
        while (sels.hasNext() && !me.isConsumed()) {
            ((Selection)sels.next()).mouseReleased(me);
        }
    }

    @Override
    public void mouseExited(MouseEvent me) {
        ArrayList<Selection> list = new ArrayList<Selection>(this.selections);
        Iterator sels = list.iterator();
        while (sels.hasNext() && !me.isConsumed()) {
            ((Selection)sels.next()).mouseExited(me);
        }
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        ArrayList<Selection> list = new ArrayList<Selection>(this.selections);
        Iterator sels = list.iterator();
        while (sels.hasNext() && !me.isConsumed()) {
            ((Selection)sels.next()).mouseEntered(me);
        }
    }

    public void addGraphSelectionListener(GraphSelectionListener listener) {
        this._listeners.add(GraphSelectionListener.class, listener);
    }

    public void removeGraphSelectionListener(GraphSelectionListener listener) {
        this._listeners.remove(GraphSelectionListener.class, listener);
    }

    protected void fireSelectionChanged() {
        this.cleanup();
        Object[] listeners = this._listeners.getListenerList();
        GraphSelectionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != GraphSelectionListener.class) continue;
            if (e == null) {
                e = new GraphSelectionEvent(this.editor, this.getFigs());
            }
            ((GraphSelectionListener)listeners[i + 1]).selectionChanged(e);
        }
        this.updatePropertySheet();
    }

    public void updatePropertySheet() {
    }

    public Class findCommonSuperClass() {
        Iterator<Selection> selectionIter = this.selections.iterator();
        HashMap<String, Integer> superclasses = new HashMap<String, Integer>();
        int maxCount = 0;
        Class<?> maxClass = null;
        while (selectionIter.hasNext()) {
            Class<?> figClass = selectionIter.next().getContent().getClass();
            int count = 0;
            if (superclasses.containsKey(figClass.getName())) {
                count = (Integer)superclasses.get(figClass.getName());
                superclasses.put(figClass.getName(), new Integer(++count));
            } else {
                count = 1;
                superclasses.put(figClass.getName(), new Integer(count));
            }
            if (count > maxCount) {
                maxCount = count;
                maxClass = figClass;
            }
            for (Class<?> superClass = figClass.getSuperclass(); superClass != null && !superClass.equals(Fig.class); superClass = superClass.getSuperclass()) {
                if (superclasses.containsKey(superClass.getName())) {
                    count = (Integer)superclasses.get(superClass.getName());
                    superclasses.put(superClass.getName(), new Integer(++count));
                } else {
                    count = 1;
                    superclasses.put(superClass.getName(), new Integer(count));
                }
                if (count <= maxCount) continue;
                maxCount = count;
                maxClass = superClass;
            }
        }
        if (maxCount == this.selections.size()) {
            return maxClass;
        }
        return Fig.class;
    }

    public Object findFirstSelectionOfType(Class type) {
        Iterator<Selection> selectionIter = this.selections.iterator();
        while (selectionIter.hasNext()) {
            Fig selectionObj = selectionIter.next().getContent();
            if (!selectionObj.getClass().equals(type)) continue;
            return selectionObj;
        }
        return null;
    }

    public static Selection makeSelectionFor(Fig f) {
        Selection customSelection = f.makeSelection();
        if (customSelection != null) {
            return customSelection;
        }
        if (f.isReshapable()) {
            return new SelectionReshape(f);
        }
        if (f.isLowerRightResizable()) {
            return new SelectionLowerRight(f);
        }
        if (f.isResizable()) {
            return new SelectionResize(f);
        }
        if (f.isMovable()) {
            return new SelectionMove(f);
        }
        return new SelectionNoop(f);
    }

    class SelectionMemento
    extends Memento {
        ArrayList prevSelections;

        public SelectionMemento() {
            this.prevSelections = new ArrayList(SelectionManager.this.selections);
        }

        public void undo() {
            ArrayList curSelections = new ArrayList(SelectionManager.this.selections);
            SelectionManager.this.selections = this.prevSelections;
            this.prevSelections = curSelections;
            SelectionManager.this.editor.damageAll();
        }

        public void redo() {
            this.undo();
        }

        public String toString() {
            return (this.isStartChain() ? "*" : " ") + "SelectionMemento";
        }
    }

    class DragMemento
    extends Memento {
        Collection draggingNodes;
        List draggingOthers;
        List bounds;
        List movingEdges;
        List nonMovingEdges;
        List points;

        public DragMemento(Collection draggingNodes, List draggingOthers, List movingEdges, List nonMovingEdges) {
            this.bounds = new ArrayList(draggingNodes.size() + draggingOthers.size());
            this.draggingNodes = draggingNodes;
            for (FigNode node : draggingNodes) {
                Rectangle rect = node.getBounds();
                this.bounds.add(rect);
            }
            this.draggingOthers = draggingOthers;
            for (Fig fig : draggingOthers) {
                Rectangle rect = fig.getBounds();
                this.bounds.add(rect);
            }
            this.points = new ArrayList(nonMovingEdges.size() + movingEdges.size());
            this.movingEdges = movingEdges;
            for (FigEdge edge : movingEdges) {
                Point[] pts = edge.getPoints();
                this.points.add(pts);
            }
            this.nonMovingEdges = nonMovingEdges;
            for (FigEdge edge : nonMovingEdges) {
                Point[] pts = edge.getPoints();
                this.points.add(pts);
            }
        }

        public void undo() {
            UndoManager.getInstance().addMementoLock(this);
            Iterator boundsIt = this.bounds.iterator();
            ArrayList<Rectangle> oldBounds = new ArrayList<Rectangle>(this.draggingNodes.size() + this.draggingOthers.size());
            for (FigNode figNode : this.draggingNodes) {
                Rectangle rect = (Rectangle)boundsIt.next();
                oldBounds.add(figNode.getBounds());
                figNode.setBounds(rect);
                figNode.damage();
            }
            for (Fig fig : this.draggingOthers) {
                Rectangle rect = (Rectangle)boundsIt.next();
                oldBounds.add(fig.getBounds());
                fig.setBounds(rect);
                fig.damage();
            }
            this.bounds = oldBounds;
            Iterator pointsIt = this.points.iterator();
            ArrayList<Point[]> oldPoints = new ArrayList<Point[]>(this.nonMovingEdges.size() + this.movingEdges.size());
            for (FigEdge figEdge : this.movingEdges) {
                Point[] pts = (Point[])pointsIt.next();
                oldPoints.add(figEdge.getPoints());
                figEdge.setPoints(pts);
                figEdge.damage();
            }
            for (FigEdge figEdge : this.nonMovingEdges) {
                Point[] pts = (Point[])pointsIt.next();
                oldPoints.add(figEdge.getPoints());
                figEdge.setPoints(pts);
                figEdge.damage();
            }
            this.points = oldPoints;
            UndoManager.getInstance().removeMementoLock(this);
        }

        public void redo() {
            this.undo();
        }

        public String toString() {
            return (this.isStartChain() ? "*" : " ") + "DragMemento";
        }
    }
}

