/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.toolbar.toolbutton;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

public abstract class DecoratedIcon
extends ImageIcon {
    public static final int ROLLOVER = 0;
    public static final int STANDARD = 1;
    protected int[][] _buffer;
    protected int _popupIconWidth = 11;
    protected int _popupIconHeight = 16;
    private int _popupIconOffset = 5;
    private ImageIcon _imageIcon;

    DecoratedIcon(ImageIcon imageIcon) {
        this._imageIcon = imageIcon;
    }

    protected void init(int[][] nArray) {
        this._buffer = nArray;
        this._popupIconWidth = this._buffer[0].length;
        this._popupIconHeight = this._buffer.length;
        int n = this._imageIcon.getIconWidth() + this._popupIconOffset + this._popupIconWidth;
        int n2 = this._imageIcon.getIconHeight();
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(this._imageIcon.getImage(), null, null);
        this.setImage(bufferedImage);
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        super.paintIcon(component, graphics, n, n2);
        int n3 = n + this._imageIcon.getIconWidth() + this._popupIconOffset;
        Color[] colorArray = new Color[]{component.getBackground(), UIManager.getColor("controlDkShadow"), UIManager.getColor("controlText"), UIManager.getColor("controlHighlight")};
        for (int i = 0; i < this._popupIconWidth; ++i) {
            for (int j = 0; j < this._popupIconHeight; ++j) {
                if (this._buffer[j][i] == 0) continue;
                graphics.setColor(colorArray[this._buffer[j][i]]);
                graphics.drawLine(n3 + i, n2 + j, n3 + i, n2 + j);
            }
        }
    }
}

