/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.model.mdr;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import org.argouml.model.UmlException;
import org.argouml.model.XmiReferenceRuntimeException;
import org.argouml.model.mdr.MDRModelImplementation;
import org.argouml.model.mdr.XmiReaderImpl;
import org.argouml.model.mdr.XmiReference;
import org.netbeans.api.xmi.XMIInputConfig;
import org.netbeans.lib.jmi.util.DebugException;
import org.netbeans.lib.jmi.xmi.XmiContext;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XmiReferenceResolverImpl
extends XmiContext {
    private static final Logger LOG = Logger.getLogger(XmiReferenceResolverImpl.class.getName());
    private Map<String, Map<String, Object>> idToObject = Collections.synchronizedMap(new HashMap());
    private Map<String, XmiReference> mofidToXmiref;
    private String topSystemId;
    private Map<String, URL> pendingProfiles = new HashMap<String, URL>();
    private URI baseUri;
    private List<String> modulesPath = new ArrayList<String>();
    private Map<String, URL> urlMap = new HashMap<String, URL>();
    private Map<String, String> reverseUrlMap = new HashMap<String, String>();
    private boolean profile;
    private Map<String, String> public2SystemIds;
    private String modelPublicId;
    private MDRModelImplementation modelImpl;
    protected static final String[] CLASSPATH_MODEL_SUFFIXES = new String[]{"xml", "xmi"};

    XmiReferenceResolverImpl(RefPackage[] extents, XMIInputConfig config, Map<String, XmiReference> objectToXmiref, Map<String, String> publicIds, Map<String, Map<String, Object>> idToObject, List<String> searchDirs, boolean isProfile, String publicId, String systemId, MDRModelImplementation modelImplementation) {
        super(extents, config);
        this.modelImpl = modelImplementation;
        this.mofidToXmiref = objectToXmiref;
        this.modulesPath = searchDirs;
        this.profile = isProfile;
        this.public2SystemIds = publicIds;
        this.idToObject = idToObject;
        this.modelPublicId = publicId;
        if (isProfile) {
            if (publicId == null) {
                LOG.log(Level.WARNING, "Profile load with null public ID.  Using system ID - " + systemId);
                this.modelPublicId = publicId = systemId;
            }
            if (this.public2SystemIds.containsKey(this.modelPublicId)) {
                if (systemId.equals(this.public2SystemIds.get(publicId))) {
                    LOG.log(Level.WARNING, "Loaded profile is being re-read publicId = \"" + publicId + "\";  systemId = \"" + systemId + "\".");
                } else {
                    LOG.log(Level.WARNING, "Profile with the duplicate publicId is being loaded! publicId = \"" + publicId + "\"; existing systemId = \"" + this.public2SystemIds.get(publicId) + "\"; new systemId = \"" + systemId + "\".");
                }
            }
            this.public2SystemIds.put(publicId, systemId);
        }
    }

    public void register(String systemId, String xmiId, RefObject object) {
        LOG.log(Level.FINE, "Registering XMI ID {0} in system ID {1} to object with MOF ID {2}", new Object[]{xmiId, systemId, object.refMofId()});
        if (this.topSystemId == null) {
            this.topSystemId = systemId;
            try {
                this.baseUri = new URI(systemId.substring(0, systemId.lastIndexOf(47) + 1));
            }
            catch (URISyntaxException e) {
                LOG.log(Level.WARNING, "Bad URI syntax for base URI from XMI document " + systemId, e);
                this.baseUri = null;
            }
            LOG.log(Level.FINE, "Top system ID set to {0}", this.topSystemId);
        }
        String resolvedSystemId = systemId;
        if (this.profile && systemId.equals(this.topSystemId)) {
            resolvedSystemId = this.modelPublicId;
        } else if (this.reverseUrlMap.get(systemId) != null) {
            resolvedSystemId = this.reverseUrlMap.get(systemId);
        } else {
            LOG.log(Level.FINE, "Unable to map systemId - {0}", systemId);
        }
        RefObject o = this.getReferenceInt(resolvedSystemId, xmiId);
        if (o == null) {
            if (this.mofidToXmiref.containsKey(object.refMofId())) {
                XmiReference ref = this.mofidToXmiref.get(object.refMofId());
                LOG.log(Level.FINE, "register called twice for the same object - ignoring second");
                LOG.log(Level.FINE, " - first reference = {0}#{1}", new Object[]{ref.getSystemId(), ref.getXmiId()});
                LOG.log(Level.FINE, " - 2nd reference   = {0}#{1}", new Object[]{systemId, xmiId});
                LOG.log(Level.FINE, " -   resolved system id = {0}", resolvedSystemId);
            } else {
                this.registerInt(resolvedSystemId, xmiId, object);
                super.register(resolvedSystemId, xmiId, object);
            }
        } else if (o.equals(object)) {
            super.register(resolvedSystemId, xmiId, object);
        } else {
            LOG.log(Level.SEVERE, "Collision - multiple elements with same xmi.id : " + xmiId);
            throw new IllegalStateException("Multiple elements with same xmi.id");
        }
    }

    private RefObject getReferenceInt(String docId, String xmiId) {
        Map<String, Object> map = this.idToObject.get(docId);
        if (map != null) {
            RefObject result = (RefObject)map.get(xmiId);
            if (result == null) {
                LOG.log(Level.FINE, "No internal reference for - {0}#{1}", new Object[]{docId, xmiId});
            }
            return result;
        }
        return null;
    }

    private void registerInt(String docId, String xmiId, RefObject object) {
        Map<String, Object> map = this.idToObject.get(docId);
        if (map == null) {
            map = new HashMap<String, Object>();
            this.idToObject.put(docId, map);
        }
        map.put(xmiId, object);
        this.mofidToXmiref.put(object.refMofId(), new XmiReference(docId, xmiId));
    }

    public RefObject getReference(String docId, String xmiId) {
        RefObject ro = this.getReferenceInt(docId, xmiId);
        if (ro == null && !this.idToObject.containsKey(docId)) {
            ro = super.getReference(docId, xmiId);
        }
        if (ro == null) {
            LOG.log(Level.SEVERE, "Failed to resolve " + docId + "#" + xmiId);
        }
        return ro;
    }

    Map<String, Object> getIdToObjectMap() {
        return this.getIdToObjectMaps().get(this.topSystemId);
    }

    Map<String, Map<String, Object>> getIdToObjectMaps() {
        return this.idToObject;
    }

    void clearIdMaps() {
        this.getIdToObjectMap().clear();
        this.mofidToXmiref.clear();
        this.topSystemId = null;
    }

    public URL toURL(String systemId) {
        LOG.log(Level.FINE, "attempting to resolve Xmi Href --> {0}", systemId);
        String suffix = this.getSuffix(systemId);
        String exts = "\\.jar|\\.zip";
        String suffixWithExt = suffix.replaceAll(exts, "");
        URL modelUrl = this.urlMap.get(suffixWithExt);
        if (modelUrl == null) {
            if (this.public2SystemIds.containsKey(systemId)) {
                modelUrl = this.getValidURL(this.public2SystemIds.get(systemId));
            }
            if (modelUrl == null) {
                modelUrl = this.getValidURL(this.fixupURL(systemId));
            }
            if (modelUrl == null) {
                String modelUrlAsString = this.findModuleURL(suffix);
                if (modelUrlAsString != null && !"".equals(modelUrlAsString)) {
                    modelUrl = this.getValidURL(modelUrlAsString);
                }
                if (modelUrl == null) {
                    modelUrl = this.findModelUrlOnClasspath(systemId);
                }
                if (modelUrl == null) {
                    modelUrl = super.toURL(systemId);
                }
            }
            if (modelUrl != null) {
                LOG.log(Level.INFO, "Referenced model --> {0}", modelUrl);
                this.urlMap.put(suffixWithExt, modelUrl);
                this.pendingProfiles.put(systemId, modelUrl);
                String relativeUri = systemId;
                try {
                    if (this.baseUri != null) {
                        relativeUri = this.baseUri.relativize(modelUrl.toURI()).toString();
                        LOG.log(Level.FINE, "  system ID {0} modelUrl {1}\n  relativized as {2}", new Object[]{systemId, modelUrl, relativeUri});
                    } else {
                        relativeUri = systemId;
                    }
                }
                catch (URISyntaxException e) {
                    LOG.log(Level.SEVERE, "Error relativizing system ID " + systemId, e);
                    relativeUri = systemId;
                }
                this.reverseUrlMap.put(modelUrl.toString(), relativeUri);
                this.reverseUrlMap.put(systemId, relativeUri);
            }
        }
        return modelUrl;
    }

    private String findModuleURL(String moduleName) {
        if (this.modulesPath == null) {
            return null;
        }
        LOG.log(Level.FINE, "findModuleURL: modulesPath.size() = {0}", this.modulesPath.size());
        for (String moduleDirectory : this.modulesPath) {
            String urlString;
            File candidate = new File(moduleDirectory, moduleName);
            LOG.log(Level.FINE, "candidate {0} exists={1}", new Object[]{candidate, candidate.exists()});
            if (!candidate.exists()) continue;
            try {
                urlString = candidate.toURI().toURL().toExternalForm();
            }
            catch (MalformedURLException e) {
                return null;
            }
            return this.fixupURL(urlString);
        }
        if (this.public2SystemIds.containsKey(moduleName)) {
            LOG.log(Level.FINE, "Couldn't find user model ({0}) in modulesPath, attempt to use a model stored within the zargo file.", moduleName);
            return moduleName;
        }
        return null;
    }

    private String getSuffix(String systemId) {
        int lastSlash = systemId.lastIndexOf("/");
        if (lastSlash > 0) {
            String suffix = systemId.substring(lastSlash + 1);
            return suffix;
        }
        return systemId;
    }

    private URL findModelUrlOnClasspath(String systemId) {
        String dot = ".";
        String modelName = systemId;
        if (this.public2SystemIds.containsKey(systemId)) {
            modelName = this.public2SystemIds.get(systemId);
        } else {
            int filenameIndex = systemId.lastIndexOf("/");
            if (filenameIndex > 0) {
                modelName = systemId.substring(filenameIndex + 1, systemId.length());
            } else {
                LOG.log(Level.WARNING, "Received systemId with no '/'" + systemId);
            }
            if (modelName.lastIndexOf(".") > 0) {
                modelName = modelName.substring(0, modelName.lastIndexOf("."));
            }
        }
        URL modelUrl = Thread.currentThread().getContextClassLoader().getResource(modelName);
        if (modelUrl == null) {
            modelUrl = ((Object)((Object)this)).getClass().getResource(modelName);
        }
        if (modelUrl == null && CLASSPATH_MODEL_SUFFIXES != null && CLASSPATH_MODEL_SUFFIXES.length > 0) {
            for (String suffix : CLASSPATH_MODEL_SUFFIXES) {
                LOG.log(Level.FINE, "searching for model reference --> {0}", modelUrl);
                modelUrl = Thread.currentThread().getContextClassLoader().getResource(modelName + "." + suffix);
                if (modelUrl != null || (modelUrl = ((Object)((Object)this)).getClass().getResource(modelName)) != null) break;
            }
        }
        return modelUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL getValidURL(String systemId) {
        InputStream stream = null;
        URL url = null;
        try {
            url = new URL(systemId);
            stream = url.openStream();
            stream.close();
        }
        catch (MalformedURLException e) {
            url = null;
        }
        catch (IOException e) {
            url = null;
        }
        finally {
            stream = null;
        }
        return url;
    }

    private String fixupURL(String url) {
        String suffix = this.getSuffix(url);
        if (suffix.endsWith(".zargo")) {
            url = "jar:" + url + "!/" + suffix.substring(0, suffix.length() - 6) + ".xmi";
        } else if (suffix.endsWith(".zip") || suffix.endsWith(".jar")) {
            url = "jar:" + url + "!/" + suffix.substring(0, suffix.length() - 4);
        }
        return url;
    }

    public void readExternalDocument(String arg0) {
        URL url = this.pendingProfiles.remove(arg0);
        if (url != null) {
            InputSource is = new InputSource(url.toExternalForm());
            is.setPublicId(arg0);
            XmiReaderImpl reader = new XmiReaderImpl(this.modelImpl);
            try {
                reader.parse(is, true);
            }
            catch (UmlException e) {
                LOG.log(Level.SEVERE, "Error reading referenced profile " + arg0);
                throw new XmiReferenceRuntimeException(arg0, e);
            }
        }
        if (!this.public2SystemIds.containsKey(arg0)) {
            try {
                super.readExternalDocument(arg0);
            }
            catch (DebugException e) {
                LOG.log(Level.SEVERE, "Error reading external document " + arg0);
                throw new XmiReferenceRuntimeException(arg0, e);
            }
        }
    }
}

