/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import org.openide.ErrorManager;
import org.openide.util.Cancellable;

public final class RequestProcessor {
    private static RequestProcessor DEFAULT = new RequestProcessor();
    private static RequestProcessor UNLIMITED = new RequestProcessor("Default RequestProcessor", 50);
    private static Timer starterThread = new Timer(true);
    private static ErrorManager logger;
    private static int counter;
    static final boolean SLOW;
    String name;
    boolean stopped = false;
    private Object processorLock = new Object();
    private HashSet processors = new HashSet();
    private List queue = new LinkedList();
    private int running = 0;
    private int throughput;
    private boolean interruptThread;

    public RequestProcessor() {
        this(null, 1);
    }

    public RequestProcessor(String string) {
        this(string, 1);
    }

    public RequestProcessor(String string, int n) {
        this(string, n, false);
    }

    public RequestProcessor(String string, int n, boolean bl) {
        this.throughput = n;
        this.name = string != null ? string : "OpenIDE-request-processor-" + counter++;
        this.interruptThread = bl;
    }

    public static RequestProcessor getDefault() {
        return UNLIMITED;
    }

    public Task post(Runnable runnable) {
        return this.post(runnable, 0, 1);
    }

    public Task post(Runnable runnable, int n) {
        return this.post(runnable, n, 1);
    }

    public Task post(Runnable runnable, int n, int n2) {
        Task task = new Task(runnable, n2);
        task.schedule(n);
        return task;
    }

    public Task create(Runnable runnable) {
        return new Task(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRequestProcessorThread() {
        Thread thread = Thread.currentThread();
        Object object = this.processorLock;
        synchronized (object) {
            return this.processors.contains(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this == UNLIMITED || this == DEFAULT) {
            throw new IllegalArgumentException("Can't stop shared RP's");
        }
        Object object = this.processorLock;
        synchronized (object) {
            this.stopped = true;
            Iterator iterator = this.processors.iterator();
            while (iterator.hasNext()) {
                ((Processor)iterator.next()).interrupt();
            }
        }
    }

    public static Task postRequest(Runnable runnable) {
        return DEFAULT.post(runnable);
    }

    public static Task postRequest(Runnable runnable, int n) {
        return DEFAULT.post(runnable, n);
    }

    public static Task postRequest(Runnable runnable, int n, int n2) {
        return DEFAULT.post(runnable, n, n2);
    }

    public static Task createRequest(Runnable runnable) {
        return DEFAULT.create(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ErrorManager logger() {
        Timer timer = starterThread;
        synchronized (timer) {
            if (logger == null) {
                logger = ErrorManager.getDefault().getInstance("org.openide.util.RequestProcessor");
            }
            return logger;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueue(Item item) {
        Object object = this.processorLock;
        synchronized (object) {
            if (item.getTask() == null) {
                return;
            }
            this.prioritizedEnqueue(item);
            if (this.running < this.throughput) {
                ++this.running;
                Processor processor = Processor.get();
                this.processors.add(processor);
                processor.setName(this.name);
                processor.attachTo(this);
            }
        }
    }

    private void prioritizedEnqueue(Item item) {
        int n = item.getPriority();
        if (this.queue.isEmpty()) {
            this.queue.add(item);
            item.enqueued = true;
            return;
        }
        if (n > ((Item)this.queue.get(this.queue.size() - 1)).getPriority()) {
            ListIterator<Item> listIterator = this.queue.listIterator();
            while (listIterator.hasNext()) {
                Item item2 = (Item)listIterator.next();
                if (n <= item2.getPriority()) continue;
                listIterator.set(item);
                listIterator.add(item2);
                item.enqueued = true;
                return;
            }
            throw new IllegalStateException("Prioritized enqueue failed!");
        }
        this.queue.add(item);
        item.enqueued = true;
    }

    Task askForWork(Processor processor, String string) {
        if (this.stopped || this.queue.isEmpty()) {
            this.processors.remove(processor);
            Processor.put(processor, string);
            --this.running;
            return null;
        }
        Item item = (Item)this.queue.remove(0);
        Task task = item.getTask();
        item.clear(processor);
        return task;
    }

    static {
        counter = 0;
        SLOW = Boolean.getBoolean("org.openide.util.RequestProcessor.Item.SLOW");
    }

    private static class Processor
    extends Thread {
        private static Stack pool = new Stack();
        private static final int INACTIVE_TIMEOUT = 60000;
        private RequestProcessor source;
        private Task todo;
        private boolean idle = true;
        private Object lock = new Object();

        public Processor() {
            super(Processor.getTopLevelThreadGroup(), "Inactive RequestProcessor thread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Processor get() {
            Stack stack = pool;
            synchronized (stack) {
                if (pool.isEmpty()) {
                    Processor processor = new Processor();
                    processor.idle = false;
                    processor.start();
                    return processor;
                }
                Processor processor = (Processor)pool.pop();
                processor.idle = false;
                return processor;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void put(Processor processor, String string) {
            Stack stack = pool;
            synchronized (stack) {
                processor.setName("Inactive RequestProcessor thread [Was:" + processor.getName() + "/" + string + "]");
                processor.idle = true;
                pool.push(processor);
            }
        }

        void setPrio(int n) {
            if (n != this.getPriority()) {
                this.setPriority(n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void attachTo(RequestProcessor requestProcessor) {
            Object object = this.lock;
            synchronized (object) {
                this.source = requestProcessor;
                this.lock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Object object;
                RequestProcessor requestProcessor = null;
                Object object2 = this.lock;
                synchronized (object2) {
                    try {
                        if (this.source == null) {
                            this.lock.wait(60000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    requestProcessor = this.source;
                    this.source = null;
                    if (requestProcessor == null) {
                        object = pool;
                        synchronized (object) {
                            if (this.idle) {
                                pool.remove(this);
                                break;
                            }
                            continue;
                        }
                    }
                }
                object2 = null;
                object = RequestProcessor.logger();
                boolean bl = ((ErrorManager)object).isLoggable(1);
                if (bl) {
                    ((ErrorManager)object).log(1, "Begining work " + this.getName());
                }
                while (true) {
                    Object object3 = requestProcessor.processorLock;
                    synchronized (object3) {
                        this.todo = requestProcessor.askForWork(this, (String)object2);
                        if (this.todo == null) {
                            break;
                        }
                    }
                    this.setPrio(this.todo.getPriority());
                    try {
                        if (bl) {
                            RequestProcessor.logger().log("  Executing " + this.todo);
                        }
                        this.todo.run();
                        if (bl) {
                            RequestProcessor.logger().log("  Execution finished in" + this.getName());
                        }
                        object2 = this.todo.debug();
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        ErrorManager.getDefault().notify(outOfMemoryError);
                    }
                    catch (StackOverflowError stackOverflowError) {
                        stackOverflowError.printStackTrace();
                        Processor.doNotify(this.todo, stackOverflowError);
                    }
                    catch (Throwable throwable) {
                        Processor.doNotify(this.todo, throwable);
                    }
                    object3 = requestProcessor.processorLock;
                    synchronized (object3) {
                        this.todo = null;
                        Thread.interrupted();
                    }
                }
                if (!bl) continue;
                RequestProcessor.logger().log(1, "Work finished " + this.getName());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void doEvaluate(Task task, Object object, RequestProcessor requestProcessor) {
            Object object2;
            Task task2 = this.todo;
            boolean bl = Thread.interrupted();
            try {
                this.todo = task;
                task.run();
                Object var7_6 = null;
                object2 = object;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                Object object3 = object;
                synchronized (object3) {
                    this.todo = task2;
                    if ((bl || this.todo.item == null) && requestProcessor.interruptThread) {
                        Thread.currentThread().interrupt();
                    }
                }
                throw throwable;
            }
            synchronized (object2) {
                this.todo = task2;
                if ((bl || this.todo.item == null) && requestProcessor.interruptThread) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        public void interruptTask(Task task, RequestProcessor requestProcessor) {
            if (task != this.todo) {
                return;
            }
            if (requestProcessor.interruptThread) {
                this.interrupt();
            }
        }

        private static void doNotify(Task task, Throwable throwable) {
            ErrorManager errorManager = ErrorManager.getDefault();
            errorManager.annotate(throwable, 4096, null, null, SLOW ? task.item : null, null);
            errorManager.notify(throwable);
        }

        static ThreadGroup getTopLevelThreadGroup() {
            PrivilegedAction privilegedAction = new PrivilegedAction(){

                public Object run() {
                    ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                    while (threadGroup.getParent() != null) {
                        threadGroup = threadGroup.getParent();
                    }
                    return threadGroup;
                }
            };
            return (ThreadGroup)AccessController.doPrivileged(privilegedAction);
        }
    }

    private static class Item
    extends Exception {
        private final RequestProcessor owner;
        private Object action;
        private boolean enqueued;

        Item(Task task, RequestProcessor requestProcessor) {
            super("Posted StackTrace");
            this.action = task;
            this.owner = requestProcessor;
        }

        Task getTask() {
            Object object = this.action;
            return object instanceof Task ? (Task)object : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean clear(Processor processor) {
            Object object = this.owner.processorLock;
            synchronized (object) {
                this.action = processor;
                return this.enqueued ? this.owner.queue.remove(this) : true;
            }
        }

        Processor getProcessor() {
            Object object = this.action;
            return object instanceof Processor ? (Processor)object : null;
        }

        int getPriority() {
            return this.getTask().getPriority();
        }

        public Throwable fillInStackTrace() {
            return SLOW ? super.fillInStackTrace() : this;
        }
    }

    public final class Task
    extends org.openide.util.Task
    implements Cancellable {
        private Item item;
        private int priority;
        private long time;
        private Thread lastThread;

        Task(Runnable runnable) {
            super(runnable);
            this.priority = 1;
            this.time = 0L;
            this.lastThread = null;
        }

        Task(Runnable runnable, int n) {
            super(runnable);
            this.priority = 1;
            this.time = 0L;
            this.lastThread = null;
            if (n < 1) {
                n = 1;
            }
            if (n > 10) {
                n = 10;
            }
            this.priority = n;
        }

        public void run() {
            this.lastThread = Thread.currentThread();
            super.run();
            this.lastThread = null;
        }

        public int getDelay() {
            long l = this.time - System.currentTimeMillis();
            if (l < 0L) {
                return 0;
            }
            if (l > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void schedule(int n) {
            Item item;
            if (RequestProcessor.this.stopped) {
                throw new IllegalStateException("RequestProcessor already stopped!");
            }
            this.time = System.currentTimeMillis() + (long)n;
            Object object = RequestProcessor.this.processorLock;
            synchronized (object) {
                this.notifyRunning();
                if (this.item != null) {
                    this.item.clear(null);
                }
                item = this.item = new Item(this, RequestProcessor.this);
            }
            if (n == 0) {
                RequestProcessor.this.enqueue(item);
            } else {
                starterThread.schedule(new TimerTask(this, item){
                    private final /* synthetic */ Item val$localItem;
                    private final /* synthetic */ Task this$1;
                    {
                        this.this$1 = task;
                        this.val$localItem = item;
                    }

                    public void run() {
                        try {
                            Task.access$200(this.this$1).enqueue(this.val$localItem);
                        }
                        catch (RuntimeException runtimeException) {
                            ErrorManager.getDefault().notify(runtimeException);
                        }
                    }
                }, n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean cancel() {
            Object object = RequestProcessor.this.processorLock;
            synchronized (object) {
                boolean bl;
                if (this.item == null) {
                    bl = false;
                } else {
                    Processor processor = this.item.getProcessor();
                    bl = this.item.clear(null);
                    if (processor != null) {
                        processor.interruptTask(this, RequestProcessor.this);
                        this.item = null;
                    }
                }
                if (bl) {
                    this.notifyFinished();
                }
                return bl;
            }
        }

        public int getPriority() {
            return this.priority;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setPriority(int n) {
            if (this.priority == n) {
                return;
            }
            if (n < 1) {
                n = 1;
            }
            if (n > 10) {
                n = 10;
            }
            this.priority = n;
            Object object = RequestProcessor.this.processorLock;
            synchronized (object) {
                if (this.item == null) {
                    return;
                }
                if (RequestProcessor.this.queue.remove(this.item)) {
                    RequestProcessor.this.prioritizedEnqueue(this.item);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitFinished() {
            if (RequestProcessor.this.isRequestProcessorThread()) {
                boolean bl;
                Object object = RequestProcessor.this.processorLock;
                synchronized (object) {
                    bl = !this.isFinished() && (this.item == null || this.item.clear(null));
                }
                if (bl) {
                    object = (Processor)Thread.currentThread();
                    ((Processor)object).doEvaluate(this, RequestProcessor.this.processorLock, RequestProcessor.this);
                } else if (this.lastThread != Thread.currentThread()) {
                    super.waitFinished();
                }
            } else {
                super.waitFinished();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitFinished(long l) throws InterruptedException {
            if (RequestProcessor.this.isRequestProcessorThread()) {
                boolean bl;
                Object object = RequestProcessor.this.processorLock;
                synchronized (object) {
                    bl = !this.isFinished() && (this.item == null || this.item.clear(null));
                }
                if (bl) {
                    throw new InterruptedException("Cannot wait with timeout " + l + " from the RequestProcessor thread for task: " + this);
                }
                if (this.lastThread != Thread.currentThread()) {
                    return super.waitFinished(l);
                }
                return true;
            }
            return super.waitFinished(l);
        }

        public String toString() {
            return "RequestProcessor.Task [" + RequestProcessor.this.name + ", " + this.priority + "] for " + super.toString();
        }

        static /* synthetic */ RequestProcessor access$200(Task task) {
            return task.RequestProcessor.this;
        }
    }
}

