/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.ribbon;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JRibbonComponent;
import org.pushingpixels.flamingo.api.ribbon.RibbonElementPriority;
import org.pushingpixels.flamingo.api.ribbon.resize.IconRibbonBandResizePolicy;
import org.pushingpixels.flamingo.api.ribbon.resize.RibbonBandResizePolicy;
import org.pushingpixels.flamingo.internal.ui.ribbon.AbstractBandControlPanelUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.BasicRibbonBandUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.JBandControlPanel;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonGallery;

public class BasicBandControlPanelUI
extends AbstractBandControlPanelUI {
    private JSeparator[] groupSeparators;
    private JLabel[] groupLabels;
    protected ChangeListener changeListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicBandControlPanelUI();
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new ControlPanelLayout();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                BasicBandControlPanelUI.this.syncGroupHeaders();
                BasicBandControlPanelUI.this.controlPanel.revalidate();
            }
        };
        ((JBandControlPanel)this.controlPanel).addChangeListener(this.changeListener);
    }

    @Override
    protected void uninstallListeners() {
        ((JBandControlPanel)this.controlPanel).removeChangeListener(this.changeListener);
        this.changeListener = null;
        super.uninstallListeners();
    }

    @Override
    protected void installComponents() {
        super.installComponents();
        this.syncGroupHeaders();
    }

    @Override
    protected void uninstallComponents() {
        if (this.groupSeparators != null) {
            for (JComponent jComponent : this.groupSeparators) {
                this.controlPanel.remove(jComponent);
            }
        }
        if (this.groupLabels != null) {
            for (JComponent jComponent : this.groupLabels) {
                if (jComponent == null) continue;
                this.controlPanel.remove(jComponent);
            }
        }
        super.uninstallComponents();
    }

    protected void syncGroupHeaders() {
        int n;
        JComponent jComponent;
        int n2;
        int n3;
        JComponent[] jComponentArray;
        if (this.groupSeparators != null) {
            jComponentArray = this.groupSeparators;
            n3 = jComponentArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                jComponent = jComponentArray[n2];
                this.controlPanel.remove(jComponent);
            }
        }
        if (this.groupLabels != null) {
            jComponentArray = this.groupLabels;
            n3 = jComponentArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                jComponent = jComponentArray[n2];
                if (jComponent == null) continue;
                this.controlPanel.remove(jComponent);
            }
        }
        if ((n = ((JBandControlPanel)this.controlPanel).getControlPanelGroupCount()) > 1) {
            this.groupSeparators = new JSeparator[n - 1];
            for (n3 = 0; n3 < n - 1; ++n3) {
                this.groupSeparators[n3] = new JSeparator(1);
                this.controlPanel.add(this.groupSeparators[n3]);
            }
        }
        if (n > 0) {
            this.groupLabels = new JLabel[n];
            for (n3 = 0; n3 < n; ++n3) {
                String string = ((JBandControlPanel)this.controlPanel).getControlPanelGroupTitle(n3);
                if (string == null) continue;
                this.groupLabels[n3] = new JLabel(string);
                this.controlPanel.add(this.groupLabels[n3]);
            }
        }
    }

    private class ControlPanelLayout
    implements LayoutManager {
        private ControlPanelLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            int n = BasicBandControlPanelUI.this.dummy.getPreferredSize().height;
            int n2 = BasicBandControlPanelUI.this.getLayoutGap() * 3 / 4;
            int n3 = n - 2 * n2;
            switch (n3 % 3) {
                case 1: {
                    n += 2;
                    break;
                }
                case 2: {
                    ++n;
                }
            }
            Insets insets = container.getInsets();
            return new Dimension(container.getWidth(), n + insets.top + insets.bottom);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        @Override
        public void layoutContainer(Container container) {
            AbstractRibbonBand abstractRibbonBand = ((JBandControlPanel)container).getRibbonBand();
            RibbonBandResizePolicy ribbonBandResizePolicy = abstractRibbonBand.getCurrentResizePolicy();
            if (ribbonBandResizePolicy == null) {
                return;
            }
            boolean bl = container.getComponentOrientation().isLeftToRight();
            Insets insets = container.getInsets();
            int n = BasicBandControlPanelUI.this.getLayoutGap();
            int n2 = bl ? insets.left + n / 2 : container.getWidth() - insets.right - n / 2;
            int n3 = container.getHeight() - insets.top - insets.bottom;
            if (SwingUtilities.getAncestorOfClass(BasicRibbonBandUI.CollapsedButtonPopupPanel.class, container) != null) {
                List<RibbonBandResizePolicy> list = abstractRibbonBand.getResizePolicies();
                list.get(0).install(n3, n);
            } else {
                if (ribbonBandResizePolicy instanceof IconRibbonBandResizePolicy) {
                    return;
                }
                ribbonBandResizePolicy.install(n3, n);
            }
            int n4 = 0;
            for (JBandControlPanel.ControlPanelGroup controlPanelGroup : ((JBandControlPanel)BasicBandControlPanelUI.this.controlPanel).getControlPanelGroups()) {
                int n5;
                int n6;
                if (n4 > 0) {
                    n6 = BasicBandControlPanelUI.this.groupSeparators[n4 - 1].getPreferredSize().width;
                    n5 = bl ? n2 - n + (n - n6) / 2 : n2 + n / 2 - (n - n6) / 2;
                    BasicBandControlPanelUI.this.groupSeparators[n4 - 1].setBounds(n5, insets.top, n6, n3);
                }
                n6 = 0;
                n5 = controlPanelGroup.isCoreContent();
                if (n5 != 0) {
                    int n7;
                    int n8;
                    Object object;
                    int n9 = n3 / 3;
                    int n10 = controlPanelGroup.getGroupTitle() != null ? 1 : 0;
                    var16_19 = 0;
                    if (n10 != 0) {
                        object = BasicBandControlPanelUI.this.groupLabels[n4];
                        int n11 = ((JComponent)object).getPreferredSize().width;
                        int n12 = Math.min(n9 - n / 4, ((JComponent)object).getPreferredSize().height);
                        n8 = n9 - n12;
                        int n13 = n7 = n12 > 0 ? ((JComponent)object).getBaseline(n11, n12) : 0;
                        if (bl) {
                            ((Component)object).setBounds(n2 + n, insets.top + n8 - n12 + n7, n11, n12);
                        } else {
                            ((Component)object).setBounds(n2 - n - n11, insets.top + n8 - n12 + n7, n11, n12);
                        }
                        var16_19 = n + n11;
                    }
                    object = controlPanelGroup.getRibbonComps();
                    Map<JRibbonComponent, Integer> map = controlPanelGroup.getRibbonCompsRowSpans();
                    ArrayList<JRibbonComponent> arrayList = new ArrayList<JRibbonComponent>();
                    n7 = n8 = n10 != 0 ? 1 : 0;
                    for (int i = 0; i < object.size(); ++i) {
                        JRibbonComponent jRibbonComponent = (JRibbonComponent)object.get(i);
                        var24_52 = jRibbonComponent.getPreferredSize().width;
                        var25_53 = map.get(jRibbonComponent);
                        var26_54 = n7 + var25_53;
                        if (var26_54 > 3) {
                            if (bl) {
                                if (n6 != 0) {
                                    n2 += n;
                                }
                                n2 += var16_19;
                            } else {
                                if (n6 != 0) {
                                    n2 -= n;
                                }
                                n2 -= var16_19;
                            }
                            n6 = 1;
                            var16_19 = 0;
                            n7 = n8;
                            arrayList.clear();
                        }
                        int n14 = Math.min(var25_53 * n9 - n / 4, jRibbonComponent.getPreferredSize().height);
                        int n15 = var25_53 * n9 - n14;
                        int n16 = n7 * n9 + insets.top;
                        if (bl) {
                            jRibbonComponent.setBounds(n2, n16 + n15, var24_52, n14);
                        } else {
                            jRibbonComponent.setBounds(n2 - var24_52, n16 + n15, var24_52, n14);
                        }
                        var16_19 = Math.max(var16_19, var24_52);
                        arrayList.add(jRibbonComponent);
                        jRibbonComponent.putClientProperty("flamingo.internal.ribbonBandControlPanel.topRow", n7 == 0);
                        jRibbonComponent.putClientProperty("flamingo.internal.ribbonBandControlPanel.midRow", n7 > 0 && n7 < 2);
                        jRibbonComponent.putClientProperty("flamingo.internal.ribbonBandControlPanel.bottomRow", n7 == 2);
                        for (JRibbonComponent jRibbonComponent2 : arrayList) {
                            Rectangle rectangle = jRibbonComponent2.getBounds();
                            if (bl) {
                                jRibbonComponent2.setBounds(rectangle.x, rectangle.y, var16_19, rectangle.height);
                            } else {
                                jRibbonComponent2.setBounds(rectangle.x + rectangle.width - var16_19, rectangle.y, var16_19, rectangle.height);
                            }
                            jRibbonComponent2.doLayout();
                        }
                        n7 += var25_53;
                    }
                    if (n7 > 0 && n7 <= 3) {
                        if (bl) {
                            if (n6 != 0) {
                                n2 += n;
                            }
                            n2 += var16_19;
                        } else {
                            if (n6 != 0) {
                                n2 -= n;
                            }
                            n2 -= var16_19;
                        }
                        n6 = 1;
                    }
                } else {
                    for (RibbonElementPriority ribbonElementPriority : RibbonElementPriority.values()) {
                        for (JRibbonGallery jRibbonGallery : controlPanelGroup.getRibbonGalleries(ribbonElementPriority)) {
                            int n17 = jRibbonGallery.getPreferredWidth(jRibbonGallery.getDisplayPriority(), n3);
                            if (bl) {
                                jRibbonGallery.setBounds(n2, insets.top, n17, n3);
                                if (n6 != 0) {
                                    n2 += n;
                                }
                                n2 += n17;
                            } else {
                                jRibbonGallery.setBounds(n2 - n17, insets.top, n17, n3);
                                if (n6 != 0) {
                                    n2 -= n;
                                }
                                n2 -= n17;
                            }
                            n6 = 1;
                        }
                    }
                    HashMap hashMap = new HashMap();
                    for (RibbonElementPriority ribbonElementPriority : RibbonElementPriority.values()) {
                        for (AbstractCommandButton abstractCommandButton : controlPanelGroup.getRibbonButtons(ribbonElementPriority)) {
                            CommandButtonDisplayState commandButtonDisplayState = abstractCommandButton.getDisplayState();
                            if (hashMap.get(commandButtonDisplayState) == null) {
                                hashMap.put(commandButtonDisplayState, new ArrayList());
                            }
                            ((List)hashMap.get(commandButtonDisplayState)).add(abstractCommandButton);
                        }
                    }
                    List list = (List)hashMap.get(CommandButtonDisplayState.BIG);
                    if (list != null) {
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            AbstractCommandButton abstractCommandButton = (AbstractCommandButton)iterator.next();
                            int n18 = abstractCommandButton.getPreferredSize().width;
                            if (n6 != 0) {
                                n2 = bl ? (n2 += n) : (n2 -= n);
                            }
                            if (bl) {
                                abstractCommandButton.setBounds(n2, insets.top, n18, n3);
                            } else {
                                abstractCommandButton.setBounds(n2 - n18, insets.top, n18, n3);
                            }
                            abstractCommandButton.putClientProperty("flamingo.internal.ribbonBandControlPanel.topRow", Boolean.FALSE);
                            abstractCommandButton.putClientProperty("flamingo.internal.ribbonBandControlPanel.midRow", Boolean.FALSE);
                            abstractCommandButton.putClientProperty("flamingo.internal.ribbonBandControlPanel.bottomRow", Boolean.FALSE);
                            n2 = bl ? (n2 += n18) : (n2 -= n18);
                            n6 = 1;
                        }
                    }
                    var16_19 = n * 3 / 4;
                    int n19 = (n3 - 2 * var16_19) / 3;
                    int n20 = 0;
                    int n21 = 0;
                    List list2 = (List)hashMap.get(CommandButtonDisplayState.MEDIUM);
                    if (list2 != null) {
                        for (AbstractCommandButton abstractCommandButton : list2) {
                            int n22 = abstractCommandButton.getPreferredSize().width;
                            n21 = Math.max(n21, n22);
                            if (n6 != 0 && n20 == 0) {
                                n2 = bl ? (n2 += n) : (n2 -= n);
                            }
                            var24_52 = (n19 + var16_19) * n20;
                            var25_53 = (n19 + var16_19) * (n20 + 1) - var16_19;
                            if (bl) {
                                abstractCommandButton.setBounds(n2, insets.top + var24_52, n22, var25_53 - var24_52);
                            } else {
                                abstractCommandButton.setBounds(n2 - n22, insets.top + var24_52, n22, var25_53 - var24_52);
                            }
                            abstractCommandButton.putClientProperty("flamingo.internal.ribbonBandControlPanel.topRow", n20 == 0);
                            abstractCommandButton.putClientProperty("flamingo.internal.ribbonBandControlPanel.midRow", n20 == 1);
                            abstractCommandButton.putClientProperty("flamingo.internal.ribbonBandControlPanel.bottomRow", n20 == 2);
                            if (++n20 != 3) continue;
                            n20 = 0;
                            n2 = bl ? (n2 += n21) : (n2 -= n21);
                            n6 = 1;
                            n21 = 0;
                        }
                    }
                    if (n21 > 0) {
                        n2 = bl ? (n2 += n21) : (n2 -= n21);
                        n6 = 1;
                    }
                    n20 = 0;
                    n21 = 0;
                    List list3 = (List)hashMap.get(CommandButtonDisplayState.SMALL);
                    if (list3 != null) {
                        for (AbstractCommandButton abstractCommandButton : list3) {
                            var24_52 = abstractCommandButton.getPreferredSize().width;
                            n21 = Math.max(n21, var24_52);
                            if (n6 != 0 && n20 == 0) {
                                n2 = bl ? (n2 += n) : (n2 -= n);
                            }
                            var25_53 = (n19 + var16_19) * n20;
                            var26_54 = (n19 + var16_19) * (n20 + 1) - var16_19;
                            if (bl) {
                                abstractCommandButton.setBounds(n2, insets.top + var25_53, var24_52, var26_54 - var25_53);
                            } else {
                                abstractCommandButton.setBounds(n2 - var24_52, insets.top + var25_53, var24_52, var26_54 - var25_53);
                            }
                            abstractCommandButton.putClientProperty("flamingo.internal.ribbonBandControlPanel.topRow", n20 == 0);
                            abstractCommandButton.putClientProperty("flamingo.internal.ribbonBandControlPanel.midRow", n20 == 1);
                            abstractCommandButton.putClientProperty("flamingo.internal.ribbonBandControlPanel.bottomRow", n20 == 2);
                            if (++n20 != 3) continue;
                            n20 = 0;
                            n2 = bl ? (n2 += n21) : (n2 -= n21);
                            n6 = 1;
                            n21 = 0;
                        }
                    }
                    if (n20 < 3 && n21 > 0) {
                        n2 = bl ? (n2 += n21) : (n2 -= n21);
                        n6 = 1;
                    }
                }
                n2 = bl ? (n2 += n * 3 / 2) : (n2 -= n * 3 / 2);
                ++n4;
            }
        }
    }
}

