/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpd;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.Map;
import net.sf.mpxj.CurrencySymbolPosition;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.TimeUnit;

public final class MPDUtility {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int DURATION_UNITS_MASK = 31;

    public static CurrencySymbolPosition getSymbolPosition(int n) {
        return switch (n) {
            case 1 -> CurrencySymbolPosition.AFTER;
            case 2 -> CurrencySymbolPosition.BEFORE_WITH_SPACE;
            case 3 -> CurrencySymbolPosition.AFTER_WITH_SPACE;
            default -> CurrencySymbolPosition.BEFORE;
        };
    }

    public static final TimeUnit getDurationTimeUnits(int n) {
        return switch (n & 0x1F) {
            case 3 -> TimeUnit.MINUTES;
            case 4 -> TimeUnit.ELAPSED_MINUTES;
            case 5 -> TimeUnit.HOURS;
            case 6 -> TimeUnit.ELAPSED_HOURS;
            case 8 -> TimeUnit.ELAPSED_DAYS;
            case 9 -> TimeUnit.WEEKS;
            case 10 -> TimeUnit.ELAPSED_WEEKS;
            case 11 -> TimeUnit.MONTHS;
            case 12 -> TimeUnit.ELAPSED_MONTHS;
            default -> TimeUnit.DAYS;
        };
    }

    public static Duration getAdjustedDuration(ProjectFile projectFile, int n, TimeUnit timeUnit) {
        return switch (timeUnit) {
            case TimeUnit.MINUTES, TimeUnit.ELAPSED_MINUTES -> {
                double var4_3 = (double)n / 10.0;
                yield Duration.getInstance(var4_3, timeUnit);
            }
            case TimeUnit.HOURS, TimeUnit.ELAPSED_HOURS -> {
                double var4_4 = (double)n / 600.0;
                yield Duration.getInstance(var4_4, timeUnit);
            }
            case TimeUnit.DAYS -> {
                double var4_5 = projectFile.getProjectProperties().getMinutesPerDay().doubleValue() * 10.0;
                double var6_12 = 0.0;
                if (var4_5 != 0.0) {
                    var6_12 = (double)n / var4_5;
                }
                yield Duration.getInstance(var6_12, timeUnit);
            }
            case TimeUnit.ELAPSED_DAYS -> {
                double var4_6 = 14400.0;
                double var6_13 = (double)n / var4_6;
                yield Duration.getInstance(var6_13, timeUnit);
            }
            case TimeUnit.WEEKS -> {
                double var4_7 = projectFile.getProjectProperties().getMinutesPerWeek().doubleValue() * 10.0;
                double var6_14 = 0.0;
                if (var4_7 != 0.0) {
                    var6_14 = (double)n / var4_7;
                }
                yield Duration.getInstance(var6_14, timeUnit);
            }
            case TimeUnit.ELAPSED_WEEKS -> {
                double var4_8 = 100800.0;
                double var6_15 = (double)n / var4_8;
                yield Duration.getInstance(var6_15, timeUnit);
            }
            case TimeUnit.ELAPSED_MONTHS -> {
                double var4_9 = 432000.0;
                double var6_16 = (double)n / var4_9;
                yield Duration.getInstance(var6_16, timeUnit);
            }
            case TimeUnit.MONTHS -> {
                double var4_10 = (double)n / 96000.0;
                yield Duration.getInstance(var4_10, timeUnit);
            }
            default -> Duration.getInstance(n, timeUnit);
        };
    }

    public static final Duration getDuration(double d, TimeUnit timeUnit) {
        return Duration.getInstance(switch (timeUnit) {
            case TimeUnit.MINUTES, TimeUnit.ELAPSED_MINUTES -> d / 10.0;
            case TimeUnit.HOURS, TimeUnit.ELAPSED_HOURS -> d / 600.0;
            case TimeUnit.DAYS -> d / 4800.0;
            case TimeUnit.ELAPSED_DAYS -> d / 14400.0;
            case TimeUnit.WEEKS -> d / 24000.0;
            case TimeUnit.ELAPSED_WEEKS -> d / 100800.0;
            case TimeUnit.MONTHS -> d / 96000.0;
            case TimeUnit.ELAPSED_MONTHS -> d / 432000.0;
            default -> d;
        }, timeUnit);
    }

    public static void dumpRow(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object object = entry.getValue();
            System.out.println(entry.getKey() + " = " + String.valueOf(object) + " ( " + (object == null ? "" : object.getClass().getName()) + ")");
        }
    }

    public static final String hexdump(byte[] byArray, int n, int n2, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (byArray != null) {
            int n3;
            int n4 = n + n2;
            for (n3 = n; n3 < n4; ++n3) {
                stringBuilder.append(" ");
                stringBuilder.append(HEX_DIGITS[(byArray[n3] & 0xF0) >> 4]);
                stringBuilder.append(HEX_DIGITS[byArray[n3] & 0xF]);
            }
            if (bl) {
                stringBuilder.append("   ");
                for (n3 = n; n3 < n4; ++n3) {
                    char c = (char)byArray[n3];
                    if (c > '\u00c8' || c < '\u001b') {
                        c = ' ';
                    }
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static final String hexdump(byte[] byArray, boolean bl) {
        int n = 0;
        if (byArray != null) {
            n = byArray.length;
        }
        return MPDUtility.hexdump(byArray, 0, n, bl);
    }

    public static final String hexdump(byte[] byArray, boolean bl, int n, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (byArray != null) {
            DecimalFormat decimalFormat = new DecimalFormat("00000");
            for (int i = 0; i < byArray.length; i += n) {
                if (i + n > byArray.length) {
                    n = byArray.length - i;
                }
                stringBuilder.append(string);
                stringBuilder.append(decimalFormat.format(i));
                stringBuilder.append(":");
                stringBuilder.append(MPDUtility.hexdump(byArray, i, n, bl));
                stringBuilder.append('\n');
            }
        }
        return stringBuilder.toString();
    }

    public static final void fileHexDump(String string, byte[] byArray) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(MPDUtility.hexdump(byArray, true, 16, "").getBytes());
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static final void fileHexDump(String string, InputStream inputStream) {
        try {
            byte[] byArray = new byte[inputStream.available()];
            inputStream.read(byArray);
            MPDUtility.fileHexDump(string, byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static final void fileDump(String string, byte[] byArray) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

