/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.ganttproject;

import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.sax.SAXSource;
import net.sf.mpxj.ChildTaskContainer;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.CustomField;
import net.sf.mpxj.DataType;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectCalendarWeek;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.common.Pair;
import net.sf.mpxj.common.ResourceFieldLists;
import net.sf.mpxj.common.TaskFieldLists;
import net.sf.mpxj.ganttproject.CustomProperty;
import net.sf.mpxj.ganttproject.schema.Allocation;
import net.sf.mpxj.ganttproject.schema.Allocations;
import net.sf.mpxj.ganttproject.schema.Calendars;
import net.sf.mpxj.ganttproject.schema.CustomPropertyDefinition;
import net.sf.mpxj.ganttproject.schema.CustomResourceProperty;
import net.sf.mpxj.ganttproject.schema.CustomTaskProperty;
import net.sf.mpxj.ganttproject.schema.Date;
import net.sf.mpxj.ganttproject.schema.DayTypes;
import net.sf.mpxj.ganttproject.schema.DefaultWeek;
import net.sf.mpxj.ganttproject.schema.Depend;
import net.sf.mpxj.ganttproject.schema.Project;
import net.sf.mpxj.ganttproject.schema.Rate;
import net.sf.mpxj.ganttproject.schema.Resource;
import net.sf.mpxj.ganttproject.schema.Resources;
import net.sf.mpxj.ganttproject.schema.Role;
import net.sf.mpxj.ganttproject.schema.Roles;
import net.sf.mpxj.ganttproject.schema.Taskproperty;
import net.sf.mpxj.ganttproject.schema.Tasks;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.reader.AbstractProjectReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class GanttProjectReader
extends AbstractProjectReader {
    private ProjectFile m_projectFile;
    private ProjectCalendar m_mpxjCalendar;
    private EventManager m_eventManager;
    private List<ProjectListener> m_projectListeners;
    private DateFormat m_localeDateFormat;
    private DateFormat m_dateFormat;
    private Map<String, Pair<FieldType, String>> m_resourcePropertyDefinitions;
    private Map<String, Pair<FieldType, String>> m_taskPropertyDefinitions;
    private Map<String, String> m_roleDefinitions;
    private static final Map<String, CustomProperty> RESOURCE_PROPERTY_TYPES = new HashMap<String, CustomProperty>();
    private static final Map<String, CustomProperty> TASK_PROPERTY_TYPES;
    private static final int[] PRIORITY;
    static final RelationType[] RELATION;
    private static JAXBContext CONTEXT;
    private static JAXBException CONTEXT_EXCEPTION;

    @Override
    public void addProjectListener(ProjectListener projectListener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(projectListener);
    }

    @Override
    public ProjectFile read(InputStream inputStream) throws MPXJException {
        try {
            this.m_projectFile = new ProjectFile();
            this.m_eventManager = this.m_projectFile.getEventManager();
            this.m_resourcePropertyDefinitions = new HashMap<String, Pair<FieldType, String>>();
            this.m_taskPropertyDefinitions = new HashMap<String, Pair<FieldType, String>>();
            this.m_roleDefinitions = new HashMap<String, String>();
            this.m_dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SS'Z'");
            ProjectConfig projectConfig = this.m_projectFile.getProjectConfig();
            projectConfig.setAutoResourceUniqueID(false);
            projectConfig.setAutoTaskUniqueID(false);
            projectConfig.setAutoOutlineLevel(true);
            projectConfig.setAutoOutlineNumber(true);
            projectConfig.setAutoWBS(true);
            this.m_projectFile.getProjectProperties().setFileApplication("GanttProject");
            this.m_projectFile.getProjectProperties().setFileType("GAN");
            this.m_eventManager.addProjectListeners(this.m_projectListeners);
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            SAXSource sAXSource = new SAXSource(xMLReader, new InputSource(inputStream));
            if (CONTEXT == null) {
                throw CONTEXT_EXCEPTION;
            }
            Unmarshaller unmarshaller = CONTEXT.createUnmarshaller();
            Project project = (Project)unmarshaller.unmarshal(sAXSource);
            this.readProjectProperties(project);
            this.readCalendars(project);
            this.readResources(project);
            this.readTasks(project);
            this.readRelationships(project);
            this.readResourceAssignments(project);
            projectConfig.updateUniqueCounters();
            ProjectFile projectFile = this.m_projectFile;
            return projectFile;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new MPXJException("Failed to parse file", parserConfigurationException);
        }
        catch (JAXBException jAXBException) {
            throw new MPXJException("Failed to parse file", jAXBException);
        }
        catch (SAXException sAXException) {
            throw new MPXJException("Failed to parse file", sAXException);
        }
        finally {
            this.m_projectFile = null;
            this.m_mpxjCalendar = null;
            this.m_eventManager = null;
            this.m_projectListeners = null;
            this.m_localeDateFormat = null;
            this.m_resourcePropertyDefinitions = null;
            this.m_taskPropertyDefinitions = null;
            this.m_roleDefinitions = null;
        }
    }

    private void readProjectProperties(Project project) {
        ProjectProperties projectProperties = this.m_projectFile.getProjectProperties();
        projectProperties.setName(project.getName());
        projectProperties.setCompany(project.getCompany());
        projectProperties.setDefaultDurationUnits(TimeUnit.DAYS);
        this.m_localeDateFormat = DateFormat.getDateInstance(3, new Locale(project.getLocale()));
    }

    private void readCalendars(Project project) {
        this.m_mpxjCalendar = this.m_projectFile.addCalendar();
        this.m_mpxjCalendar.setName("Standard");
        Calendars calendars = project.getCalendars();
        this.setWorkingDays(this.m_mpxjCalendar, calendars);
        this.setExceptions(this.m_mpxjCalendar, calendars);
        this.m_eventManager.fireCalendarReadEvent(this.m_mpxjCalendar);
    }

    private void setWorkingDays(ProjectCalendar projectCalendar, Calendars calendars) {
        DayTypes dayTypes = calendars.getDayTypes();
        DefaultWeek defaultWeek = dayTypes.getDefaultWeek();
        projectCalendar.setWorkingDay(Day.MONDAY, this.isWorkingDay(defaultWeek.getMon()));
        projectCalendar.setWorkingDay(Day.TUESDAY, this.isWorkingDay(defaultWeek.getTue()));
        projectCalendar.setWorkingDay(Day.WEDNESDAY, this.isWorkingDay(defaultWeek.getWed()));
        projectCalendar.setWorkingDay(Day.THURSDAY, this.isWorkingDay(defaultWeek.getThu()));
        projectCalendar.setWorkingDay(Day.FRIDAY, this.isWorkingDay(defaultWeek.getFri()));
        projectCalendar.setWorkingDay(Day.SATURDAY, this.isWorkingDay(defaultWeek.getSat()));
        projectCalendar.setWorkingDay(Day.SUNDAY, this.isWorkingDay(defaultWeek.getSun()));
        for (Day day : Day.values()) {
            if (!projectCalendar.isWorkingDay(day)) continue;
            ProjectCalendarHours projectCalendarHours = projectCalendar.addCalendarHours(day);
            projectCalendarHours.addRange(ProjectCalendarWeek.DEFAULT_WORKING_MORNING);
            projectCalendarHours.addRange(ProjectCalendarWeek.DEFAULT_WORKING_AFTERNOON);
        }
    }

    private boolean isWorkingDay(Integer n) {
        return NumberHelper.getInt(n) == 0;
    }

    private void setExceptions(ProjectCalendar projectCalendar, Calendars calendars) {
        List<Date> list = calendars.getDate();
        for (Date date : list) {
            this.addException(projectCalendar, date);
        }
    }

    private void addException(ProjectCalendar projectCalendar, Date date) {
        String string = date.getYear();
        if (string != null && !string.isEmpty()) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(1, Integer.parseInt(string));
            calendar.set(2, NumberHelper.getInt(date.getMonth()));
            calendar.set(5, NumberHelper.getInt(date.getDate()));
            java.util.Date date2 = calendar.getTime();
            ProjectCalendarException projectCalendarException = projectCalendar.addCalendarException(date2, date2);
            if ("WORKING_DAY".equals(date.getType())) {
                projectCalendarException.addRange(ProjectCalendarWeek.DEFAULT_WORKING_MORNING);
                projectCalendarException.addRange(ProjectCalendarWeek.DEFAULT_WORKING_AFTERNOON);
            }
        }
    }

    private void readResources(Project project) {
        Resources resources = project.getResources();
        this.readResourceCustomPropertyDefinitions(resources);
        this.readRoleDefinitions(project);
        for (Resource resource : resources.getResource()) {
            this.readResource(resource);
        }
    }

    private void readResourceCustomPropertyDefinitions(Resources resources) {
        CustomField customField = this.m_projectFile.getCustomFields().getCustomField(ResourceField.TEXT1);
        customField.setAlias("Phone");
        for (CustomPropertyDefinition customPropertyDefinition : resources.getCustomPropertyDefinition()) {
            String string = customPropertyDefinition.getType();
            FieldType fieldType = RESOURCE_PROPERTY_TYPES.get(string).getField();
            if (fieldType == null) {
                fieldType = RESOURCE_PROPERTY_TYPES.get("text").getField();
            }
            if (fieldType == null) continue;
            customField = this.m_projectFile.getCustomFields().getCustomField(fieldType);
            customField.setAlias(customPropertyDefinition.getName());
            String string2 = customPropertyDefinition.getDefaultValue();
            if (string2 != null && string2.isEmpty()) {
                string2 = null;
            }
            this.m_resourcePropertyDefinitions.put(customPropertyDefinition.getId(), new Pair<FieldType, String>(fieldType, string2));
        }
    }

    private void readTaskCustomPropertyDefinitions(Tasks tasks) {
        for (Taskproperty taskproperty : tasks.getTaskproperties().getTaskproperty()) {
            if (!"custom".equals(taskproperty.getType())) continue;
            String string = taskproperty.getValuetype();
            FieldType fieldType = TASK_PROPERTY_TYPES.get(string).getField();
            if (fieldType == null) {
                fieldType = TASK_PROPERTY_TYPES.get("text").getField();
            }
            if (fieldType == null) continue;
            CustomField customField = this.m_projectFile.getCustomFields().getCustomField(fieldType);
            customField.setAlias(taskproperty.getName());
            String string2 = taskproperty.getDefaultvalue();
            if (string2 != null && string2.isEmpty()) {
                string2 = null;
            }
            this.m_taskPropertyDefinitions.put(taskproperty.getId(), new Pair<FieldType, String>(fieldType, string2));
        }
    }

    private void readRoleDefinitions(Project project) {
        this.m_roleDefinitions.put("Default:1", "project manager");
        for (Roles roles : project.getRoles()) {
            if ("Default".equals(roles.getRolesetName())) continue;
            for (Role role : roles.getRole()) {
                this.m_roleDefinitions.put(role.getId(), role.getName());
            }
        }
    }

    private void readResource(Resource resource) {
        net.sf.mpxj.Resource resource2 = this.m_projectFile.addResource();
        resource2.setUniqueID(NumberHelper.getInt(resource.getId()) + 1);
        resource2.setName(resource.getName());
        resource2.setEmailAddress(resource.getContacts());
        resource2.setText(1, resource.getPhone());
        resource2.setGroup(this.m_roleDefinitions.get(resource.getFunction()));
        Rate rate = resource.getRate();
        if (rate != null) {
            resource2.setStandardRate(new net.sf.mpxj.Rate(rate.getValueAttribute(), TimeUnit.DAYS));
        }
        this.readResourceCustomFields(resource, resource2);
        this.m_eventManager.fireResourceReadEvent(resource2);
    }

    private void readResourceCustomFields(Resource resource, net.sf.mpxj.Resource resource2) {
        HashMap<FieldType, Object> hashMap = new HashMap<FieldType, Object>();
        for (Pair<FieldType, String> object : this.m_resourcePropertyDefinitions.values()) {
            hashMap.put(object.getFirst(), object.getSecond());
        }
        for (CustomResourceProperty customResourceProperty : resource.getCustomProperty()) {
            Pair<FieldType, String> pair = this.m_resourcePropertyDefinitions.get(customResourceProperty.getDefinitionId());
            if (pair == null) continue;
            String string = customResourceProperty.getValueAttribute();
            if (string.isEmpty()) {
                string = null;
            }
            if (string == null) continue;
            Object object = switch (pair.getFirst().getDataType()) {
                case DataType.NUMERIC -> {
                    if (string.indexOf(46) == -1) {
                        yield Integer.valueOf(string);
                    }
                    yield Double.valueOf(string);
                }
                case DataType.DATE -> {
                    try {
                        yield this.m_localeDateFormat.parse(string);
                    }
                    catch (ParseException var9_13) {
                        yield null;
                    }
                }
                case DataType.BOOLEAN -> string.equals("true");
                default -> string;
            };
            if (object == null) continue;
            hashMap.put(pair.getFirst(), object);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            if (entry.getValue() == null) continue;
            resource2.set((FieldType)entry.getKey(), entry.getValue());
        }
    }

    private void readTaskCustomFields(net.sf.mpxj.ganttproject.schema.Task task, Task task2) {
        HashMap<FieldType, Object> hashMap = new HashMap<FieldType, Object>();
        for (Pair<FieldType, String> object : this.m_taskPropertyDefinitions.values()) {
            hashMap.put(object.getFirst(), object.getSecond());
        }
        for (CustomTaskProperty customTaskProperty : task.getCustomproperty()) {
            Pair<FieldType, String> pair = this.m_taskPropertyDefinitions.get(customTaskProperty.getTaskpropertyId());
            if (pair == null) continue;
            String string = customTaskProperty.getValueAttribute();
            if (string.isEmpty()) {
                string = null;
            }
            if (string == null) continue;
            Object object = switch (pair.getFirst().getDataType()) {
                case DataType.NUMERIC -> {
                    if (string.indexOf(46) == -1) {
                        yield Integer.valueOf(string);
                    }
                    yield Double.valueOf(string);
                }
                case DataType.DATE -> {
                    try {
                        yield this.m_dateFormat.parse(string);
                    }
                    catch (ParseException var9_13) {
                        yield null;
                    }
                }
                case DataType.BOOLEAN -> string.equals("true");
                default -> string;
            };
            if (object == null) continue;
            hashMap.put(pair.getFirst(), object);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            if (entry.getValue() == null) continue;
            task2.set((FieldType)entry.getKey(), entry.getValue());
        }
    }

    private void readTasks(Project project) {
        Tasks tasks = project.getTasks();
        this.readTaskCustomPropertyDefinitions(tasks);
        for (net.sf.mpxj.ganttproject.schema.Task task : tasks.getTask()) {
            this.readTask(this.m_projectFile, task);
        }
    }

    private void readTask(ChildTaskContainer childTaskContainer, net.sf.mpxj.ganttproject.schema.Task task) {
        Task task2 = childTaskContainer.addTask();
        task2.setUniqueID(NumberHelper.getInt(task.getId()) + 1);
        task2.setName(task.getName());
        task2.setPercentageComplete(task.getComplete());
        task2.setPriority(this.getPriority(task.getPriority()));
        task2.setHyperlink(task.getWebLink());
        Duration duration = Duration.getInstance(NumberHelper.getDouble(task.getDuration()), TimeUnit.DAYS);
        task2.setDuration(duration);
        if (duration.getDuration() == 0.0) {
            task2.setMilestone(true);
        } else {
            task2.setStart(task.getStart());
            task2.setFinish(this.m_mpxjCalendar.getDate(task.getStart(), task2.getDuration(), false));
        }
        task2.setConstraintDate(task.getThirdDate());
        if (task2.getConstraintDate() != null) {
            task2.setConstraintType(ConstraintType.START_NO_EARLIER_THAN);
        }
        this.readTaskCustomFields(task, task2);
        this.m_eventManager.fireTaskReadEvent(task2);
        for (net.sf.mpxj.ganttproject.schema.Task task3 : task.getTask()) {
            this.readTask(task2, task3);
        }
    }

    private Priority getPriority(Integer n) {
        int n2;
        int n3 = n == null ? 500 : ((n2 = n.intValue()) < 0 || n2 >= PRIORITY.length ? 500 : PRIORITY[n2]);
        return Priority.getInstance(n3);
    }

    private void readRelationships(Project project) {
        for (net.sf.mpxj.ganttproject.schema.Task task : project.getTasks().getTask()) {
            this.readRelationships(task);
        }
    }

    private void readRelationships(net.sf.mpxj.ganttproject.schema.Task task) {
        for (Depend depend : task.getDepend()) {
            Task task2 = this.m_projectFile.getTaskByUniqueID(NumberHelper.getInt(task.getId()) + 1);
            Task task3 = this.m_projectFile.getTaskByUniqueID(NumberHelper.getInt(depend.getId()) + 1);
            if (task2 == null || task3 == null) continue;
            Duration duration = Duration.getInstance(NumberHelper.getInt(depend.getDifference()), TimeUnit.DAYS);
            Relation relation = task3.addPredecessor(task2, this.getRelationType(depend.getType()), duration);
            this.m_eventManager.fireRelationReadEvent(relation);
        }
    }

    private RelationType getRelationType(Integer n) {
        int n2;
        RelationType relationType = null;
        if (n != null && (n2 = NumberHelper.getInt(n)) > 0 && n2 < RELATION.length) {
            relationType = RELATION[n2];
        }
        if (relationType == null) {
            relationType = RelationType.FINISH_START;
        }
        return relationType;
    }

    private void readResourceAssignments(Project project) {
        Allocations allocations = project.getAllocations();
        if (allocations != null) {
            for (Allocation allocation : allocations.getAllocation()) {
                this.readResourceAssignment(allocation);
            }
        }
    }

    private void readResourceAssignment(Allocation allocation) {
        Integer n = NumberHelper.getInt(allocation.getTaskId()) + 1;
        Integer n2 = NumberHelper.getInt(allocation.getResourceId()) + 1;
        Task task = this.m_projectFile.getTaskByUniqueID(n);
        net.sf.mpxj.Resource resource = this.m_projectFile.getResourceByUniqueID(n2);
        if (task != null && resource != null) {
            ResourceAssignment resourceAssignment = task.addResourceAssignment(resource);
            resourceAssignment.setUnits(allocation.getLoad());
            this.m_eventManager.fireAssignmentReadEvent(resourceAssignment);
        }
    }

    static {
        CustomProperty customProperty = new CustomProperty(ResourceFieldLists.CUSTOM_NUMBER);
        RESOURCE_PROPERTY_TYPES.put("int", customProperty);
        RESOURCE_PROPERTY_TYPES.put("double", customProperty);
        RESOURCE_PROPERTY_TYPES.put("text", new CustomProperty(ResourceFieldLists.CUSTOM_TEXT, 1));
        RESOURCE_PROPERTY_TYPES.put("date", new CustomProperty(ResourceFieldLists.CUSTOM_DATE));
        RESOURCE_PROPERTY_TYPES.put("boolean", new CustomProperty(ResourceFieldLists.CUSTOM_FLAG));
        TASK_PROPERTY_TYPES = new HashMap<String, CustomProperty>();
        customProperty = new CustomProperty(TaskFieldLists.CUSTOM_NUMBER);
        TASK_PROPERTY_TYPES.put("int", customProperty);
        TASK_PROPERTY_TYPES.put("double", customProperty);
        TASK_PROPERTY_TYPES.put("text", new CustomProperty(TaskFieldLists.CUSTOM_TEXT));
        TASK_PROPERTY_TYPES.put("date", new CustomProperty(TaskFieldLists.CUSTOM_DATE));
        TASK_PROPERTY_TYPES.put("boolean", new CustomProperty(TaskFieldLists.CUSTOM_FLAG));
        PRIORITY = new int[]{400, 500, 600, 100, 900};
        RELATION = new RelationType[]{null, RelationType.START_START, RelationType.FINISH_START, RelationType.FINISH_FINISH, RelationType.START_FINISH};
        try {
            System.setProperty("com.sun.xml.bind.v2.runtime.JAXBContextImpl.fastBoot", "true");
            CONTEXT = JAXBContext.newInstance("net.sf.mpxj.ganttproject.schema", GanttProjectReader.class.getClassLoader());
        }
        catch (JAXBException jAXBException) {
            CONTEXT_EXCEPTION = jAXBException;
            CONTEXT = null;
        }
    }
}

