/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.fasttrack;

import java.io.PrintWriter;
import net.sf.mpxj.fasttrack.AbstractColumn;
import net.sf.mpxj.fasttrack.FastTrackUtility;
import net.sf.mpxj.fasttrack.FixedSizeItemsBlock;

class DurationColumn
extends AbstractColumn {
    private int m_timeUnitValue;

    DurationColumn() {
    }

    @Override
    protected int postHeaderSkipBytes() {
        return 18;
    }

    @Override
    protected int readData(byte[] byArray, int n) {
        FixedSizeItemsBlock fixedSizeItemsBlock = new FixedSizeItemsBlock().read(byArray, n);
        n = fixedSizeItemsBlock.getOffset();
        this.m_timeUnitValue = FastTrackUtility.getByte(byArray, n);
        byte[][] byArray2 = fixedSizeItemsBlock.getData();
        this.m_data = new Double[byArray2.length];
        for (int i = 0; i < byArray2.length; ++i) {
            Double d = FastTrackUtility.getDouble(byArray2[i], 0);
            if (d != null && this.m_timeUnitValue == 10) {
                d = d * 3.0;
            }
            this.m_data[i] = d;
        }
        return n;
    }

    @Override
    protected void dumpData(PrintWriter printWriter) {
        printWriter.println("  [Data");
        for (Object object : this.m_data) {
            printWriter.println("    " + String.valueOf(object));
        }
        printWriter.println("  ]");
    }

    public int getTimeUnitValue() {
        return this.m_timeUnitValue;
    }
}

