/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.grouping.core.transform.sorting;

import com.projectlibre1.configuration.FieldDictionary;
import com.projectlibre1.field.Field;
import com.projectlibre1.field.FieldConverter;
import com.projectlibre1.grouping.core.model.NodeModel;
import com.projectlibre1.grouping.core.transform.CommonTransform;
import com.projectlibre1.grouping.core.transform.HierarchicObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.collections.Closure;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class NodeSorter
extends CommonTransform
implements Comparator {
    protected boolean showSummary = true;
    protected boolean showEmptyLines = true;
    protected boolean showEndEmptyLines = true;
    protected List fields = null;
    protected NodeModel model;
    protected boolean showEmptySummaries = true;
    protected boolean showAssignments = true;
    protected boolean preserveHierarchy = true;
    private GenericObjectPool pool = new GenericObjectPool(new ListFactory(this));
    protected ListIterator currentSorter = null;

    public NodeModel getModel() {
        return this.model;
    }

    public void setModel(NodeModel nodeModel) {
        this.model = nodeModel;
    }

    @Override
    public boolean isShowEmptyLines() {
        return this.showEmptyLines;
    }

    @Override
    public void setShowEmptyLines(boolean bl) {
        this.showEmptyLines = bl;
    }

    @Override
    public boolean isShowEndEmptyLines() {
        return this.showEndEmptyLines;
    }

    @Override
    public void setShowEndEmptyLines(boolean bl) {
        this.showEndEmptyLines = bl;
    }

    @Override
    public boolean isShowSummary() {
        return this.showSummary;
    }

    @Override
    public void setShowSummary(boolean bl) {
        this.showSummary = bl;
    }

    @Override
    public boolean isShowEmptySummaries() {
        return this.showEmptySummaries;
    }

    @Override
    public void setShowEmptySummaries(boolean bl) {
        this.showEmptySummaries = bl;
    }

    @Override
    public boolean isShowAssignments() {
        return this.showAssignments;
    }

    @Override
    public void setShowAssignments(boolean bl) {
        this.showAssignments = bl;
    }

    @Override
    public boolean isPreserveHierarchy() {
        return this.preserveHierarchy;
    }

    @Override
    public void setPreserveHierarchy(boolean bl) {
        this.preserveHierarchy = bl;
    }

    public List sortList(List list, boolean bl) {
        return this.sortList(list, this, bl);
    }

    public List sortList(List list, Comparator comparator, boolean bl) {
        Collections.sort(list, comparator);
        if (bl) {
            for (HierarchicObject hierarchicObject : list) {
                if (hierarchicObject.getChildren().size() <= 0) continue;
                this.sortList(hierarchicObject.getChildren(), comparator, true);
            }
        }
        return list;
    }

    public List getList() {
        try {
            return (List)this.pool.borrowObject();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void recycleList(List list) {
        try {
            list.clear();
            this.pool.returnObject(list);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void setRedefinitionCallBack(Closure closure) {
    }

    protected String getFieldName(String string) {
        Field field = FieldDictionary.getInstance().getFieldFromId(string);
        return field.getName();
    }

    protected String toString(Object object) {
        return FieldConverter.toString(object, object.getClass(), null);
    }

    protected String toString(String string, Object object) {
        Field field = FieldDictionary.getInstance().getFieldFromId(string);
        if (field.hasOptions()) {
            return field.convertValueToStringUsingOptions(object);
        }
        return this.toString(object);
    }

    public String getGroupName(Object object) {
        return "";
    }

    public String getGroupName(String string, Object object) {
        return this.getFieldName(string) + ": " + String.valueOf(object);
    }

    public String getStringGroupName(String string, Object object) {
        return string + ": " + String.valueOf(object);
    }

    public int compare(Object object, Object object2) {
        List list = this.getSubTransforms();
        if (list != null) {
            this.currentSorter = list.listIterator();
            while (this.currentSorter.hasNext()) {
                NodeSorter nodeSorter = (NodeSorter)this.currentSorter.next();
                int n = nodeSorter.compare(object, object2);
                if (n == 0) continue;
                this.currentSorter.previous();
                return n;
            }
        }
        return 0;
    }

    public ListIterator getCurrentSorter() {
        if (this.currentSorter != null) {
            return this.currentSorter;
        }
        if (this.getSubTransforms() == null) {
            return null;
        }
        return this.getSubTransforms().listIterator();
    }

    private class ListFactory
    extends BasePoolableObjectFactory {
        private ListFactory(NodeSorter nodeSorter) {
        }

        @Override
        public Object makeObject() {
            return new ArrayList();
        }

        @Override
        public void activateObject(Object object) {
        }
    }
}

