/**
 * libggz - Programming in C with comfort, safety and network awareness.
 * This library is part of the ggz-base-libs package.
 *
 * ggz_threads.h: GC-safe multithreading.
 *
 * Copyright (C) 2008 Josef Spillner
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef GGZ_THREADS_H
#define GGZ_THREADS_H

/* The macro USE_LIBGGZ_GC must be set to 1 if libggz was built with GC. */
#define USE_LIBGGZ_GC 0

#if USE_LIBGGZ_GC
#define GC_THREADS
/* Only for gc >= 7.0 */
/*#include <gc.h>*/
#define GC_REDIRECT_TO_LOCAL
#include <gc/gc_local_alloc.h>
#else
#include <pthread.h>
#endif

#endif /* GGZ_THREADS_H */
