#
#	SDL::GraphicTool   -	zooming and rotating graphic tool
#
#	Copyright (C) 2002 Russell E. Valentine
#	Copyright (C) 2002 David J. Goehrig

package SDL::Tool::Graphic;

use SDL;

sub new {
	my $proto = shift;
	my $class = ref($proto) || $proto;
	$self = {};

	bless $self, $class;
	$self;
}


sub DESTROY {

}


sub zoom {
	my ( $self, $surface, $zoomx, $zoomy, $smooth) = @_;
	if($surface->isa('SDL::Surface')) {
		my $newSurface = $$surface{-surface};
		$$surface{-surface} = SDL::GFXZoom($newSurface, $zoomx, $zoomy, $smooth);
	} else {
		$surface = SDL::GFXZoom($surface, $zoomx, $zoomy, $smooth);
	}
}

sub rotoZoom {
	my ( $self, $surface, $angle, $zoom, $smooth) = @_;
	if($surface->isa('SDL::Surface')) {
		my $newSurface = $$surface{-surface};
		$$surface{-surface} = SDL::GFXRotoZoom($newSurface, $angle, $zoom, $smooth);
	} else {
		$surface = SDL::GFXRotoZoom($surface, $angle, $zoom, $smooth);
	}
}

1;

__END__;

=pod

=head1 NAME

SDL::Tool::Graphic

=head1 DESCRIPTION

L<SDL::Tool::Graphic> is a module for zooming and rotating L<SDL::Surface> objects.

=head1 METHODS

=head2 zoom ( surface, xzoom, yzoom, smooth )

C<SDL::Tool::Graphic::zoom> scales a L<SDL::Surface> along the two axis independently.

=head2 rotoZoom ( surface, angle, zoom, smooth )

C<SDL::Tool::Graphic::rotoZoom> rotates and fixed axis zooms a L<SDL::Surface>.

=head1 AUTHOR

Russell E. Valentine

=head1 SEE ALSO

L<perl> L<SDL::Surface>

=cut
