/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.model.v156;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.directory.studio.apacheds.configuration.StudioEntityResolver;
import org.apache.directory.studio.apacheds.configuration.model.AbstractServerXmlIO;
import org.apache.directory.studio.apacheds.configuration.model.ServerConfiguration;
import org.apache.directory.studio.apacheds.configuration.model.ServerXmlIO;
import org.apache.directory.studio.apacheds.configuration.model.ServerXmlIOException;
import org.apache.directory.studio.apacheds.configuration.model.v156.ExtendedOperationEnum;
import org.apache.directory.studio.apacheds.configuration.model.v156.IndexedAttribute;
import org.apache.directory.studio.apacheds.configuration.model.v156.InterceptorEnum;
import org.apache.directory.studio.apacheds.configuration.model.v156.Messages;
import org.apache.directory.studio.apacheds.configuration.model.v156.Partition;
import org.apache.directory.studio.apacheds.configuration.model.v156.ServerConfigurationV156;
import org.apache.directory.studio.apacheds.configuration.model.v156.SupportedMechanismEnum;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerXmlIOV156
extends AbstractServerXmlIO
implements ServerXmlIO {
    private static final String ATTRIBUTE_ACCESS_CONTROL_ENABLED = "accessControlEnabled";
    private static final String ATTRIBUTE_ADDRESS = "address";
    private static final String ATTRIBUTE_ALLOW_ANONYMOUS_ACCESS = "allowAnonymousAccess";
    private static final String ATTRIBUTE_ATTRIBUTE_ID = "attributeId";
    private static final String ATTRIBUTE_BACKLOG = "backLog";
    private static final String ATTRIBUTE_CACHE_SIZE = "cacheSize";
    private static final String ATTRIBUTE_DENORMALIZE_OP_ATTRS_ENABLED = "denormalizeOpAttrsEnabled";
    private static final String ATTRIBUTE_ENABLESSL = "enableSSL";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_INSTANCE_ID = "instanceId";
    private static final String ATTRIBUTE_MAXPDUSIZE = "maxPDUSize";
    private static final String ATTRIBUTE_MAX_SIZE_LIMIT = "maxSizeLimit";
    private static final String ATTRIBUTE_MAX_TIME_LIMIT = "maxTimeLimit";
    private static final String ATTRIBUTE_MECH_NAME = "mech-name";
    private static final String ATTRIBUTE_NBTHREADS = "nbThreads";
    private static final String ATTRIBUTE_NTLM_PROVIDER_FQCN = "ntlmProviderFqcn";
    private static final String ATTRIBUTE_PORT = "port";
    private static final String ATTRIBUTE_OPTIMIZER_ENABLED = "optimizerEnabled";
    private static final String ATTRIBUTE_REPLICAID = "replicaId";
    private static final String ATTRIBUTE_SASL_HOST = "saslHost";
    private static final String ATTRIBUTE_SASL_PRINCIPAL = "saslPrincipal";
    private static final String ATTRIBUTE_SEARCH_BASE_DN = "searchBaseDn";
    private static final String ATTRIBUTE_SUFFIX = "suffix";
    private static final String ATTRIBUTE_SYNC_ON_WRITE = "syncOnWrite";
    private static final String ATTRIBUTE_SYNCH_PERIOD_MILLIS = "syncPeriodMillis";
    private static final String ATTRIBUTE_WORKING_DIRECTORY = "workingDirectory";
    private static final String ELEMENT_ACI_AUTHORIZATION_INTERCEPTOR = "aciAuthorizationInterceptor";
    private static final String ELEMENT_APACHE_DS = "apacheDS";
    private static final String ELEMENT_AUTHENTICATION_INTERCEPTOR = "authenticationInterceptor";
    private static final String ELEMENT_BEANS = "beans";
    private static final String ELEMENT_CHANGE_PASSWORD_SERVER = "changePasswordServer";
    private static final String ELEMENT_COLLECTIVE_ATTRIBUTE_INTERCEPTOR = "collectiveAttributeInterceptor";
    private static final String ELEMENT_CRAM_MD5_MECHANISM_HANDLER = "cramMd5MechanismHandler";
    private static final String ELEMENT_DEFAULT_AUTHORIZATION_INTERCEPTOR = "defaultAuthorizationInterceptor";
    private static final String ELEMENT_DEFAULT_DIRECTORY_SERVICE = "defaultDirectoryService";
    private static final String ELEMENT_DIGEST_MD5_MECHANISM_HANDLER = "digestMd5MechanismHandler";
    private static final String ELEMENT_DNS_SERVER = "dnsServer";
    private static final String ELEMENT_EVENT_INTERCEPTOR = "eventInterceptor";
    private static final String ELEMENT_EXCEPTION_INTERCEPTOR = "exceptionInterceptor";
    private static final String ELEMENT_EXTENDED_OPERATION_HANDLERS = "extendedOperationHandlers";
    private static final String ELEMENT_GRACEFUL_SHUTDOWN_HANDLER = "gracefulShutdownHandler";
    private static final String ELEMENT_GSSAPI_MECHANISM_HANDLER = "gssapiMechanismHandler";
    private static final String ELEMENT_INDEXED_ATTRIBUTES = "indexedAttributes";
    private static final String ELEMENT_INTERCEPTORS = "interceptors";
    private static final String ELEMENT_JDBM_INDEX = "jdbmIndex";
    private static final String ELEMENT_JDBM_PARTITION = "jdbmPartition";
    private static final String ELEMENT_KDC_SERVER = "kdcServer";
    private static final String ELEMENT_LAUNCH_DIAGNOSTIC_UI_HANDLER = "launchDiagnosticUiHandler";
    private static final String ELEMENT_LDAP_SERVER = "ldapServer";
    private static final String ELEMENT_NORMALIZATION_INTERCEPTOR = "normalizationInterceptor";
    private static final String ELEMENT_NTLM_MECHANISM_HANDLER = "ntlmMechanismHandler";
    private static final String ELEMENT_NTP_SERVER = "ntpServer";
    private static final String ELEMENT_OPERATIONAL_ATTRIBUTE_INTERCEPTOR = "operationalAttributeInterceptor";
    private static final String ELEMENT_PARTITIONS = "partitions";
    private static final String ELEMENT_REFERRAL_INTERCEPTOR = "referralInterceptor";
    private static final String ELEMENT_REPLICATION_INTERCEPTOR = "replicationInterceptor";
    private static final String ELEMENT_SASL_MECHANISM_HANDLERS = "saslMechanismHandlers";
    private static final String ELEMENT_SASL_REALMS = "saslRealms";
    private static final String ELEMENT_SCHEMA_INTERCEPTOR = "schemaInterceptor";
    private static final String ELEMENT_SIMPLE_MECHANISM_HANDLER = "simpleMechanismHandler";
    private static final String ELEMENT_START_TLS_HANDLER = "startTlsHandler";
    private static final String ELEMENT_SUBENTRY_INTERCEPTOR = "subentryInterceptor";
    private static final String ELEMENT_SYSTEM_PARTITION = "systemPartition";
    private static final String ELEMENT_TCP_TRANSPORT = "tcpTransport";
    private static final String ELEMENT_TRANSPORTS = "transports";
    private static final String ELEMENT_TRIGGER_INTERCEPTOR = "triggerInterceptor";
    private static final String ELEMENT_UDP_TRANSPORT = "udpTransport";
    private static final String ELEMENT_VALUE = "value";
    private static final Namespace NAMESPACE_APACHEDS = new Namespace(null, "http://apacheds.org/config/1.5.6");
    private static final Namespace NAMESPACE_SPRINGFRAMEWORK = new Namespace("s", "http://www.springframework.org/schema/beans");
    private static final Namespace NAMESPACE_XBEAN_SPRING = new Namespace("spring", "http://xbean.apache.org/schemas/spring/1.0");
    private static final String SUPPORTED_MECHANISM_CRAM_MD5 = "CRAM-MD5";
    private static final String SUPPORTED_MECHANISM_DIGEST_MD5 = "DIGEST-MD5";
    private static final String SUPPORTED_MECHANISM_GSS_SPNEGO = "GSS-SPNEGO";
    private static final String SUPPORTED_MECHANISM_GSSAPI = "GSSAPI";
    private static final String SUPPORTED_MECHANISM_NTLM = "NTLM";
    private static final String SUPPORTED_MECHANISM_SIMPLE = "SIMPLE";
    private static final String VALUE_ADDRESS_0_0_0_0 = "0.0.0.0";
    private static final String VALUE_ADDRESS_LOCALHOST = "localhost";
    private static final String VALUE_BACKLOG = "50";
    private static final String VALUE_CHANGEPASSWORDSERVER_NB_THREADS = "2";
    private static final String VALUE_DEFAULT = "default";
    private static final String VALUE_DIRECTORY_SERVICE = "directoryService";
    private static final String VALUE_EXAMPLE_DOT_COM = "example.com";
    private static final String VALUE_KDCSERVER_NB_THREADS = "4";
    private static final String VALUE_LDAPSERVER_NB_THREADS = "8";
    private static final String VALUE_MAXPDUSIZE = "2000000";
    private static final String VALUE_NTPSERVER_NB_THREADS = "1";
    private static final String VALUE_REPLICAID = "1";

    @Override
    protected boolean isValid(Document document) {
        Element rootElement = document.getRootElement();
        if (rootElement != null && ELEMENT_BEANS.equalsIgnoreCase(rootElement.getName())) {
            return rootElement.getNamespaceForURI(NAMESPACE_APACHEDS.getURI()) != null;
        }
        return false;
    }

    @Override
    public ServerConfiguration parse(InputStream is) throws ServerXmlIOException {
        try {
            SAXReader reader = new SAXReader();
            reader.setEntityResolver((EntityResolver)new StudioEntityResolver());
            Document document = reader.read(is);
            ServerConfigurationV156 serverConfiguration = new ServerConfigurationV156();
            this.parse(document, serverConfiguration);
            return serverConfiguration;
        }
        catch (Exception e) {
            if (e instanceof ServerXmlIOException) {
                throw (ServerXmlIOException)e;
            }
            ServerXmlIOException exception = new ServerXmlIOException(e.getMessage(), e.getCause());
            exception.setStackTrace(e.getStackTrace());
            throw exception;
        }
    }

    private void parse(Document document, ServerConfigurationV156 serverConfiguration) throws NumberFormatException, AbstractServerXmlIO.BooleanFormatException, ServerXmlIOException {
        Element rootElement = document.getRootElement();
        this.readDefaultDirectoryServiceBean(rootElement, serverConfiguration);
        this.readChangePasswordServerBean(rootElement, serverConfiguration);
        this.readKdcServerBean(rootElement, serverConfiguration);
        this.readNtpServerBean(rootElement, serverConfiguration);
        this.readDnsServerBean(rootElement, serverConfiguration);
        this.readLdapServerBean(rootElement, serverConfiguration);
    }

    private void readDefaultDirectoryServiceBean(Element element, ServerConfigurationV156 serverConfiguration) throws ServerXmlIOException, NumberFormatException, AbstractServerXmlIO.BooleanFormatException {
        Element defaultDirectoryServiceElement = element.element(ELEMENT_DEFAULT_DIRECTORY_SERVICE);
        if (defaultDirectoryServiceElement == null) {
            throw new ServerXmlIOException(Messages.getString("ServerXmlIOV156.ErrorDefaultDirectoryService"));
        }
        Attribute accessControlEnabledAttribute = defaultDirectoryServiceElement.attribute(ATTRIBUTE_ACCESS_CONTROL_ENABLED);
        if (accessControlEnabledAttribute == null) {
            throw new ServerXmlIOException(Messages.getString("ServerXmlIOV156.ErrorAccessControlEnabled"));
        }
        serverConfiguration.setEnableAccessControl(this.parseBoolean(accessControlEnabledAttribute.getValue()));
        Attribute denormalizeOpAttrsEnabledAttribute = defaultDirectoryServiceElement.attribute(ATTRIBUTE_DENORMALIZE_OP_ATTRS_ENABLED);
        if (denormalizeOpAttrsEnabledAttribute == null) {
            throw new ServerXmlIOException(Messages.getString("ServerXmlIOV156.ErrorDenormalizeOpAttrsEnabled"));
        }
        serverConfiguration.setDenormalizeOpAttr(this.parseBoolean(denormalizeOpAttrsEnabledAttribute.getValue()));
        Attribute synchPeriodMillisAttribute = defaultDirectoryServiceElement.attribute(ATTRIBUTE_SYNCH_PERIOD_MILLIS);
        if (synchPeriodMillisAttribute == null) {
            throw new ServerXmlIOException(Messages.getString("ServerXmlIOV156.ErrorSyncPeriodMillis"));
        }
        serverConfiguration.setSynchronizationPeriod(Integer.parseInt(synchPeriodMillisAttribute.getValue()));
        this.readSystemPartition(defaultDirectoryServiceElement, serverConfiguration);
        this.readPartitions(defaultDirectoryServiceElement, serverConfiguration);
        this.readInterceptors(defaultDirectoryServiceElement, serverConfiguration);
    }

    private void readSystemPartition(Element element, ServerConfigurationV156 serverConfiguration) throws ServerXmlIOException, NumberFormatException, AbstractServerXmlIO.BooleanFormatException {
        Element systemPartitionElement = element.element(ELEMENT_SYSTEM_PARTITION);
        if (systemPartitionElement == null) {
            throw new ServerXmlIOException(Messages.getString("ServerXmlIOV156.ErrorSystemPartition"));
        }
        Element jdbmPartitionElement = systemPartitionElement.element(ELEMENT_JDBM_PARTITION);
        if (jdbmPartitionElement == null) {
            throw new ServerXmlIOException(Messages.getString("ServerXmlIOV156.ErrorJDBMPartition"));
        }
        Partition systemPartition = new Partition();
        systemPartition.setSystemPartition(true);
        this.readPartition(jdbmPartitionElement, systemPartition);
        serverConfiguration.addPartition(systemPartition);
    }

    private void readPartition(Element element, Partition partition) throws ServerXmlIOException, NumberFormatException, AbstractServerXmlIO.BooleanFormatException {
        Attribute idAttribute = element.attribute(ATTRIBUTE_ID);
        if (idAttribute == null) {
            throw new ServerXmlIOException(Messages.getString("ServerXmlIOV156.ErrorId"));
        }
        partition.setId(idAttribute.getValue());
        Attribute cacheSizeAttribute = element.attribute(ATTRIBUTE_CACHE_SIZE);
        if (cacheSizeAttribute == null) {
            throw new ServerXmlIOException(Messages.getString("ServerXmlIOV156.ErrorCacheSize"));
        }
        partition.setCacheSize(Integer.parseInt(cacheSizeAttribute.getValue()));
        Attribute suffixAttribute = element.attribute(ATTRIBUTE_SUFFIX);
        if (suffixAttribute == null) {
            throw new ServerXmlIOException(Messages.getString("ServerXmlIOV156.ErrorSuffix"));
        }
        partition.setSuffix(suffixAttribute.getValue());
        Attribute optimizerEnabledAttribute = element.attribute(ATTRIBUTE_OPTIMIZER_ENABLED);
        if (optimizerEnabledAttribute == null) {
            throw new ServerXmlIOException(Messages.getString("ServerXmlIOV156.ErrorOptimizerEnabled"));
        }
        partition.setEnableOptimizer(this.parseBoolean(optimizerEnabledAttribute.getValue()));
        Attribute syncOnWriteAttribute = element.attribute(ATTRIBUTE_SYNC_ON_WRITE);
        if (syncOnWriteAttribute == null) {
            throw new ServerXmlIOException(Messages.getString("ServerXmlIOV156.ErrorSyncOnWrite"));
        }
        partition.setSynchronizationOnWrite(this.parseBoolean(syncOnWriteAttribute.getValue()));
        partition.setIndexedAttributes(this.readIndexedAttributes(element));
    }

    private List<IndexedAttribute> readIndexedAttributes(Element element) throws NumberFormatException {
        ArrayList<IndexedAttribute> indexedAttributes = new ArrayList<IndexedAttribute>();
        Element indexedAttributesElement = element.element(ELEMENT_INDEXED_ATTRIBUTES);
        if (indexedAttributesElement != null) {
            Iterator i = indexedAttributesElement.elementIterator(ELEMENT_JDBM_INDEX);
            while (i.hasNext()) {
                Attribute cacheSizeAttribute;
                Element jdbmIndexElement = (Element)i.next();
                Attribute attributeIdAttribute = jdbmIndexElement.attribute(ATTRIBUTE_ATTRIBUTE_ID);
                if (attributeIdAttribute == null || (cacheSizeAttribute = jdbmIndexElement.attribute(ATTRIBUTE_CACHE_SIZE)) == null) continue;
                indexedAttributes.add(new IndexedAttribute(attributeIdAttribute.getValue(), Integer.parseInt(cacheSizeAttribute.getValue())));
            }
        }
        return indexedAttributes;
    }

    private void readPartitions(Element element, ServerConfigurationV156 serverConfiguration) throws NumberFormatException, ServerXmlIOException, AbstractServerXmlIO.BooleanFormatException {
        Element partitionsElement = element.element(ELEMENT_PARTITIONS);
        if (partitionsElement != null) {
            Iterator i = partitionsElement.elementIterator(ELEMENT_JDBM_PARTITION);
            while (i.hasNext()) {
                Element jdbmPartitionElement = (Element)i.next();
                Partition partition = new Partition();
                this.readPartition(jdbmPartitionElement, partition);
                serverConfiguration.addPartition(partition);
            }
        }
    }

    private void readInterceptors(Element element, ServerConfigurationV156 serverConfiguration) {
        Element interceptorsElement = element.element(ELEMENT_INTERCEPTORS);
        if (interceptorsElement != null) {
            Iterator i = interceptorsElement.elementIterator();
            while (i.hasNext()) {
                Element interceptorElement = (Element)i.next();
                String interceptorElementName = interceptorElement.getName();
                if (ELEMENT_NORMALIZATION_INTERCEPTOR.equalsIgnoreCase(interceptorElementName)) {
                    serverConfiguration.addInterceptor(InterceptorEnum.NORMALIZATION);
                    continue;
                }
                if (ELEMENT_AUTHENTICATION_INTERCEPTOR.equalsIgnoreCase(interceptorElementName)) {
                    serverConfiguration.addInterceptor(InterceptorEnum.AUTHENTICATION);
                    continue;
                }
                if (ELEMENT_REFERRAL_INTERCEPTOR.equalsIgnoreCase(interceptorElementName)) {
                    serverConfiguration.addInterceptor(InterceptorEnum.REFERRAL);
                    continue;
                }
                if (ELEMENT_ACI_AUTHORIZATION_INTERCEPTOR.equalsIgnoreCase(interceptorElementName)) {
                    serverConfiguration.addInterceptor(InterceptorEnum.ACI_AUTHORIZATION);
                    continue;
                }
                if (ELEMENT_DEFAULT_AUTHORIZATION_INTERCEPTOR.equalsIgnoreCase(interceptorElementName)) {
                    serverConfiguration.addInterceptor(InterceptorEnum.DEFAULT_AUTHORIZATION);
                    continue;
                }
                if (ELEMENT_EXCEPTION_INTERCEPTOR.equalsIgnoreCase(interceptorElementName)) {
                    serverConfiguration.addInterceptor(InterceptorEnum.EXCEPTION);
                    continue;
                }
                if (ELEMENT_OPERATIONAL_ATTRIBUTE_INTERCEPTOR.equalsIgnoreCase(interceptorElementName)) {
                    serverConfiguration.addInterceptor(InterceptorEnum.OPERATIONAL_ATTRIBUTE);
                    continue;
                }
                if (ELEMENT_SCHEMA_INTERCEPTOR.equalsIgnoreCase(interceptorElementName)) {
                    serverConfiguration.addInterceptor(InterceptorEnum.SCHEMA);
                    continue;
                }
                if (ELEMENT_SUBENTRY_INTERCEPTOR.equalsIgnoreCase(interceptorElementName)) {
                    serverConfiguration.addInterceptor(InterceptorEnum.SUBENTRY);
                    continue;
                }
                if (ELEMENT_COLLECTIVE_ATTRIBUTE_INTERCEPTOR.equalsIgnoreCase(interceptorElementName)) {
                    serverConfiguration.addInterceptor(InterceptorEnum.COLLECTIVE_ATTRIBUTE);
                    continue;
                }
                if (ELEMENT_EVENT_INTERCEPTOR.equalsIgnoreCase(interceptorElementName)) {
                    serverConfiguration.addInterceptor(InterceptorEnum.EVENT);
                    continue;
                }
                if (ELEMENT_TRIGGER_INTERCEPTOR.equalsIgnoreCase(interceptorElementName)) {
                    serverConfiguration.addInterceptor(InterceptorEnum.TRIGGER);
                    continue;
                }
                if (!ELEMENT_REPLICATION_INTERCEPTOR.equalsIgnoreCase(interceptorElementName)) continue;
                serverConfiguration.addInterceptor(InterceptorEnum.REPLICATION);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readChangePasswordServerBean(Element element, ServerConfigurationV156 serverConfiguration) throws NumberFormatException, ServerXmlIOException, AbstractServerXmlIO.BooleanFormatException {
        serverConfiguration.setEnableChangePassword(false);
        Element changePasswordServerElement = element.element(ELEMENT_CHANGE_PASSWORD_SERVER);
        if (changePasswordServerElement == null) return;
        serverConfiguration.setEnableChangePassword(true);
        Element transportsElement = changePasswordServerElement.element(ELEMENT_TRANSPORTS);
        if (transportsElement == null) throw new ServerXmlIOException(Messages.getString("ServerXmlIOV156.ErrorChangePasswordServerPort"));
        Element tcpTransportElement = transportsElement.element(ELEMENT_TRANSPORTS);
        if (transportsElement == null) throw new ServerXmlIOException(Messages.getString("ServerXmlIOV156.ErrorChangePasswordServerPort"));
        Attribute portAttribute = tcpTransportElement.attribute(ATTRIBUTE_PORT);
        if (portAttribute == null) throw new ServerXmlIOException(Messages.getString("ServerXmlIOV156.ErrorChangePasswordServerPort"));
        serverConfiguration.setChangePasswordPort(Integer.parseInt(portAttribute.getValue()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readKdcServerBean(Element element, ServerConfigurationV156 serverConfiguration) throws NumberFormatException, ServerXmlIOException, AbstractServerXmlIO.BooleanFormatException {
        serverConfiguration.setEnableKerberos(false);
        Element kdcServerElement = element.element(ELEMENT_KDC_SERVER);
        if (kdcServerElement == null) return;
        serverConfiguration.setEnableKerberos(true);
        Element transportsElement = kdcServerElement.element(ELEMENT_TRANSPORTS);
        if (transportsElement == null) throw new ServerXmlIOException(Messages.getString("ServerXmlIOV156.ErrorKdcServerPort"));
        Element tcpTransportElement = transportsElement.element(ELEMENT_TRANSPORTS);
        if (transportsElement == null) throw new ServerXmlIOException(Messages.getString("ServerXmlIOV156.ErrorKdcServerPort"));
        Attribute portAttribute = tcpTransportElement.attribute(ATTRIBUTE_PORT);
        if (portAttribute == null) throw new ServerXmlIOException(Messages.getString("ServerXmlIOV156.ErrorKdcServerPort"));
        serverConfiguration.setKerberosPort(Integer.parseInt(portAttribute.getValue()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readNtpServerBean(Element element, ServerConfigurationV156 serverConfiguration) throws NumberFormatException, ServerXmlIOException, AbstractServerXmlIO.BooleanFormatException {
        serverConfiguration.setEnableNtp(false);
        Element ntpServerElement = element.element(ELEMENT_NTP_SERVER);
        if (ntpServerElement == null) return;
        serverConfiguration.setEnableNtp(true);
        Element transportsElement = ntpServerElement.element(ELEMENT_TRANSPORTS);
        if (transportsElement == null) throw new ServerXmlIOException(Messages.getString("ServerXmlIOV156.ErrorNtpServerPort"));
        Element tcpTransportElement = transportsElement.element(ELEMENT_TRANSPORTS);
        if (transportsElement == null) throw new ServerXmlIOException(Messages.getString("ServerXmlIOV156.ErrorNtpServerPort"));
        Attribute portAttribute = tcpTransportElement.attribute(ATTRIBUTE_PORT);
        if (portAttribute == null) throw new ServerXmlIOException(Messages.getString("ServerXmlIOV156.ErrorNtpServerPort"));
        serverConfiguration.setNtpPort(Integer.parseInt(portAttribute.getValue()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readDnsServerBean(Element element, ServerConfigurationV156 serverConfiguration) throws NumberFormatException, ServerXmlIOException, AbstractServerXmlIO.BooleanFormatException {
        serverConfiguration.setEnableDns(false);
        Element dnsServerElement = element.element(ELEMENT_DNS_SERVER);
        if (dnsServerElement == null) return;
        Element transportsElement = dnsServerElement.element(ELEMENT_TRANSPORTS);
        if (transportsElement == null) throw new ServerXmlIOException(Messages.getString("ServerXmlIOV156.ErrorDnsServerPort"));
        Element tcpTransportElement = transportsElement.element(ELEMENT_TRANSPORTS);
        if (transportsElement == null) throw new ServerXmlIOException(Messages.getString("ServerXmlIOV156.ErrorDnsServerPort"));
        Attribute portAttribute = tcpTransportElement.attribute(ATTRIBUTE_PORT);
        if (portAttribute == null) throw new ServerXmlIOException(Messages.getString("ServerXmlIOV156.ErrorDnsServerPort"));
        serverConfiguration.setDnsPort(Integer.parseInt(portAttribute.getValue()));
    }

    private void readLdapServerBean(Element element, ServerConfigurationV156 serverConfiguration) throws NumberFormatException, ServerXmlIOException, AbstractServerXmlIO.BooleanFormatException {
        serverConfiguration.setEnableLdap(false);
        serverConfiguration.setEnableLdaps(false);
        Element ldapServerElement = element.element(ELEMENT_LDAP_SERVER);
        if (ldapServerElement != null) {
            Element SaslRealmsElement;
            Attribute allowAnonymousAccessAttribute = ldapServerElement.attribute(ATTRIBUTE_ALLOW_ANONYMOUS_ACCESS);
            if (allowAnonymousAccessAttribute == null) {
                throw new ServerXmlIOException(Messages.getString("ServerXmlIOV156.ErrorAllowAnonymousAccess"));
            }
            serverConfiguration.setAllowAnonymousAccess(this.parseBoolean(allowAnonymousAccessAttribute.getValue()));
            Attribute saslHostAttribute = ldapServerElement.attribute(ATTRIBUTE_SASL_HOST);
            if (saslHostAttribute == null) {
                throw new ServerXmlIOException(Messages.getString("ServerXmlIOV156.ErrorSaslHost"));
            }
            serverConfiguration.setSaslHost(saslHostAttribute.getValue());
            Attribute saslPrincipalAttribute = ldapServerElement.attribute(ATTRIBUTE_SASL_PRINCIPAL);
            if (saslPrincipalAttribute == null) {
                throw new ServerXmlIOException(Messages.getString("ServerXmlIOV156.ErrorSaslPrincipal"));
            }
            serverConfiguration.setSaslPrincipal(saslPrincipalAttribute.getValue());
            Attribute searchBaseDnAttribute = ldapServerElement.attribute(ATTRIBUTE_SEARCH_BASE_DN);
            if (searchBaseDnAttribute == null) {
                throw new ServerXmlIOException(Messages.getString("ServerXmlIOV156.ErrorSearchBaseDn"));
            }
            serverConfiguration.setSearchBaseDn(searchBaseDnAttribute.getValue());
            Attribute maxTimeLimitAttribute = ldapServerElement.attribute(ATTRIBUTE_MAX_TIME_LIMIT);
            if (maxTimeLimitAttribute == null) {
                throw new ServerXmlIOException(Messages.getString("ServerXmlIOV156.ErrorMaxTimeLimit"));
            }
            serverConfiguration.setMaxTimeLimit(Integer.parseInt(maxTimeLimitAttribute.getValue()));
            Attribute maxSizeLimitAttribute = ldapServerElement.attribute(ATTRIBUTE_MAX_SIZE_LIMIT);
            if (maxSizeLimitAttribute == null) {
                throw new ServerXmlIOException(Messages.getString("ServerXmlIOV156.ErrorMaxSizeLimit"));
            }
            serverConfiguration.setMaxSizeLimit(Integer.parseInt(maxSizeLimitAttribute.getValue()));
            Element transportsElement = ldapServerElement.element(ELEMENT_TRANSPORTS);
            if (transportsElement != null) {
                Iterator iterator = transportsElement.elementIterator(ELEMENT_TCP_TRANSPORT);
                while (iterator.hasNext()) {
                    Element tcpTransportElement = (Element)iterator.next();
                    Attribute portAttribute = tcpTransportElement.attribute(ATTRIBUTE_PORT);
                    if (portAttribute == null) {
                        throw new ServerXmlIOException(Messages.getString("ServerXmlIOV156.ErrorLdapServerPort"));
                    }
                    boolean enableSsl = false;
                    Attribute enableSslAttribut = tcpTransportElement.attribute(ATTRIBUTE_ENABLESSL);
                    if (enableSslAttribut != null) {
                        enableSsl = this.parseBoolean(enableSslAttribut.getValue());
                    }
                    if (enableSsl) {
                        serverConfiguration.setEnableLdaps(true);
                        serverConfiguration.setLdapsPort(Integer.parseInt(portAttribute.getValue()));
                        continue;
                    }
                    serverConfiguration.setEnableLdap(true);
                    serverConfiguration.setLdapPort(Integer.parseInt(portAttribute.getValue()));
                }
            } else {
                throw new ServerXmlIOException(Messages.getString("ServerXmlIOV156.ErrorLdapServerPort"));
            }
            Element supportedMechanismsElement = ldapServerElement.element(ELEMENT_SASL_MECHANISM_HANDLERS);
            if (supportedMechanismsElement != null) {
                Iterator iterator = supportedMechanismsElement.elementIterator();
                while (iterator.hasNext()) {
                    Attribute ntlmProviderFcqnAttribute;
                    String mechNameValue;
                    Element supportedMechanismValueElement = (Element)iterator.next();
                    String supportedMechanismValue = supportedMechanismValueElement.getName();
                    Attribute mechNameAttribute = supportedMechanismValueElement.attribute(ATTRIBUTE_MECH_NAME);
                    String string = mechNameValue = mechNameAttribute == null ? null : mechNameAttribute.getValue();
                    if (ELEMENT_SIMPLE_MECHANISM_HANDLER.equalsIgnoreCase(supportedMechanismValue) && SUPPORTED_MECHANISM_SIMPLE.equalsIgnoreCase(mechNameValue)) {
                        serverConfiguration.addSupportedMechanism(SupportedMechanismEnum.SIMPLE);
                        continue;
                    }
                    if (ELEMENT_CRAM_MD5_MECHANISM_HANDLER.equalsIgnoreCase(supportedMechanismValue) && SUPPORTED_MECHANISM_CRAM_MD5.equalsIgnoreCase(mechNameValue)) {
                        serverConfiguration.addSupportedMechanism(SupportedMechanismEnum.CRAM_MD5);
                        continue;
                    }
                    if (ELEMENT_DIGEST_MD5_MECHANISM_HANDLER.equalsIgnoreCase(supportedMechanismValue) && SUPPORTED_MECHANISM_DIGEST_MD5.equalsIgnoreCase(mechNameValue)) {
                        serverConfiguration.addSupportedMechanism(SupportedMechanismEnum.DIGEST_MD5);
                        continue;
                    }
                    if (ELEMENT_GSSAPI_MECHANISM_HANDLER.equalsIgnoreCase(supportedMechanismValue) && SUPPORTED_MECHANISM_GSSAPI.equalsIgnoreCase(mechNameValue)) {
                        serverConfiguration.addSupportedMechanism(SupportedMechanismEnum.GSSAPI);
                        continue;
                    }
                    if (ELEMENT_NTLM_MECHANISM_HANDLER.equalsIgnoreCase(supportedMechanismValue) && SUPPORTED_MECHANISM_NTLM.equalsIgnoreCase(mechNameValue)) {
                        ntlmProviderFcqnAttribute = supportedMechanismValueElement.attribute(ATTRIBUTE_NTLM_PROVIDER_FQCN);
                        if (ntlmProviderFcqnAttribute != null) {
                            SupportedMechanismEnum ntlmSupportedMechanism = SupportedMechanismEnum.NTLM;
                            ntlmSupportedMechanism.setNtlmProviderFqcn(ntlmProviderFcqnAttribute.getValue());
                            serverConfiguration.addSupportedMechanism(ntlmSupportedMechanism);
                            continue;
                        }
                        serverConfiguration.addSupportedMechanism(SupportedMechanismEnum.NTLM);
                        continue;
                    }
                    if (!ELEMENT_NTLM_MECHANISM_HANDLER.equalsIgnoreCase(supportedMechanismValue) || !SUPPORTED_MECHANISM_GSS_SPNEGO.equalsIgnoreCase(mechNameValue)) continue;
                    ntlmProviderFcqnAttribute = supportedMechanismValueElement.attribute(ATTRIBUTE_NTLM_PROVIDER_FQCN);
                    if (ntlmProviderFcqnAttribute != null) {
                        SupportedMechanismEnum gssSpnegoSupportedMechanism = SupportedMechanismEnum.GSS_SPNEGO;
                        gssSpnegoSupportedMechanism.setNtlmProviderFqcn(ntlmProviderFcqnAttribute.getValue());
                        serverConfiguration.addSupportedMechanism(gssSpnegoSupportedMechanism);
                        continue;
                    }
                    serverConfiguration.addSupportedMechanism(SupportedMechanismEnum.GSS_SPNEGO);
                }
            }
            if ((SaslRealmsElement = ldapServerElement.element(ELEMENT_SASL_REALMS)) != null) {
                Iterator iterator = SaslRealmsElement.elementIterator(ELEMENT_VALUE);
                while (iterator.hasNext()) {
                    Element saslRealmValueElement = (Element)iterator.next();
                    serverConfiguration.addSaslRealm(saslRealmValueElement.getText().trim());
                }
            }
            this.readExtendedOperations(ldapServerElement, serverConfiguration);
            return;
        }
    }

    private void readExtendedOperations(Element element, ServerConfigurationV156 serverConfiguration) {
        Element interceptorsElement = element.element(ELEMENT_EXTENDED_OPERATION_HANDLERS);
        if (interceptorsElement != null) {
            Iterator i = interceptorsElement.elementIterator();
            while (i.hasNext()) {
                Element extendedOperationElement = (Element)i.next();
                String extendedOperationElementName = extendedOperationElement.getName();
                if (ELEMENT_START_TLS_HANDLER.equalsIgnoreCase(extendedOperationElementName)) {
                    serverConfiguration.addExtendedOperation(ExtendedOperationEnum.START_TLS);
                }
                if (ELEMENT_GRACEFUL_SHUTDOWN_HANDLER.equalsIgnoreCase(extendedOperationElementName)) {
                    serverConfiguration.addExtendedOperation(ExtendedOperationEnum.GRACEFUL_SHUTDOWN);
                }
                if (!ELEMENT_LAUNCH_DIAGNOSTIC_UI_HANDLER.equalsIgnoreCase(extendedOperationElementName)) continue;
                serverConfiguration.addExtendedOperation(ExtendedOperationEnum.LAUNCH_DIAGNOSTIC_UI);
            }
        }
    }

    @Override
    public String toXml(ServerConfiguration serverConfiguration) throws IOException {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(new QName(ELEMENT_BEANS, NAMESPACE_XBEAN_SPRING));
        root.add(NAMESPACE_SPRINGFRAMEWORK);
        root.add(NAMESPACE_APACHEDS);
        this.createDefaultDirectoryServiceBean(root, (ServerConfigurationV156)serverConfiguration);
        this.createChangePasswordServerBean(root, (ServerConfigurationV156)serverConfiguration);
        this.createKdcServerBean(root, (ServerConfigurationV156)serverConfiguration);
        this.createNtpServerBean(root, (ServerConfigurationV156)serverConfiguration);
        this.createDnsServerBean(root, (ServerConfigurationV156)serverConfiguration);
        this.createLdapServerBean(root, (ServerConfigurationV156)serverConfiguration);
        this.createApacheDSBean(root, (ServerConfigurationV156)serverConfiguration);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        OutputFormat outformat = OutputFormat.createPrettyPrint();
        outformat.setEncoding("UTF-8");
        XMLWriter writer = new XMLWriter((OutputStream)os, outformat);
        writer.write(document);
        writer.flush();
        writer.close();
        return ((Object)os).toString();
    }

    private void createDefaultDirectoryServiceBean(Element root, ServerConfigurationV156 serverConfiguration) {
        Element defaultDirectoryServiceElement = root.addElement(ELEMENT_DEFAULT_DIRECTORY_SERVICE);
        defaultDirectoryServiceElement.addAttribute(ATTRIBUTE_ID, VALUE_DIRECTORY_SERVICE);
        defaultDirectoryServiceElement.addAttribute(ATTRIBUTE_INSTANCE_ID, VALUE_DEFAULT);
        defaultDirectoryServiceElement.addAttribute(ATTRIBUTE_REPLICAID, "1");
        defaultDirectoryServiceElement.addAttribute(ATTRIBUTE_WORKING_DIRECTORY, VALUE_EXAMPLE_DOT_COM);
        defaultDirectoryServiceElement.addAttribute(ATTRIBUTE_ALLOW_ANONYMOUS_ACCESS, "" + serverConfiguration.isAllowAnonymousAccess());
        defaultDirectoryServiceElement.addAttribute(ATTRIBUTE_ACCESS_CONTROL_ENABLED, "" + serverConfiguration.isEnableAccessControl());
        defaultDirectoryServiceElement.addAttribute(ATTRIBUTE_DENORMALIZE_OP_ATTRS_ENABLED, "" + serverConfiguration.isDenormalizeOpAttr());
        defaultDirectoryServiceElement.addAttribute(ATTRIBUTE_SYNCH_PERIOD_MILLIS, "" + serverConfiguration.getSynchronizationPeriod());
        defaultDirectoryServiceElement.addAttribute(ATTRIBUTE_MAXPDUSIZE, VALUE_MAXPDUSIZE);
        Element systemPartitionElement = defaultDirectoryServiceElement.addElement(ELEMENT_SYSTEM_PARTITION);
        this.createSystemPartitionBean(systemPartitionElement, serverConfiguration);
        Element partitionsElement = defaultDirectoryServiceElement.addElement(ELEMENT_PARTITIONS);
        this.createUserPartitions(partitionsElement, serverConfiguration);
        Element interceptorsElement = defaultDirectoryServiceElement.addElement(ELEMENT_INTERCEPTORS);
        this.createInterceptors(interceptorsElement, serverConfiguration);
    }

    private void createSystemPartitionBean(Element systemPartitionElement, ServerConfigurationV156 serverConfiguration) {
        Partition systemPartition = null;
        for (Partition partition : serverConfiguration.getPartitions()) {
            if (!partition.isSystemPartition()) continue;
            systemPartition = partition;
            break;
        }
        if (systemPartition != null) {
            this.createPartition(systemPartitionElement, systemPartition);
        }
    }

    private void createUserPartitions(Element partitionsElement, ServerConfigurationV156 serverConfiguration) {
        for (Partition partition : serverConfiguration.getPartitions()) {
            if (partition.isSystemPartition()) continue;
            this.createPartition(partitionsElement, partition);
        }
    }

    private void createPartition(Element element, Partition partition) {
        Element jdbmPartitionElement = element.addElement(ELEMENT_JDBM_PARTITION);
        jdbmPartitionElement.addAttribute(ATTRIBUTE_ID, partition.getId());
        jdbmPartitionElement.addAttribute(ATTRIBUTE_CACHE_SIZE, "" + partition.getCacheSize());
        jdbmPartitionElement.addAttribute(ATTRIBUTE_SUFFIX, partition.getSuffix());
        jdbmPartitionElement.addAttribute(ATTRIBUTE_OPTIMIZER_ENABLED, "" + partition.isEnableOptimizer());
        jdbmPartitionElement.addAttribute(ATTRIBUTE_SYNC_ON_WRITE, "" + partition.isSynchronizationOnWrite());
        this.createIndexedAttributes(jdbmPartitionElement, partition.getIndexedAttributes());
    }

    private void createIndexedAttributes(Element element, List<IndexedAttribute> indexedAttributes) {
        Element indexedAttributeElement = element.addElement(ELEMENT_INDEXED_ATTRIBUTES);
        if (indexedAttributes != null) {
            for (IndexedAttribute indexedAttribute : indexedAttributes) {
                Element jdbmIndexElement = indexedAttributeElement.addElement(ELEMENT_JDBM_INDEX);
                jdbmIndexElement.addAttribute(ATTRIBUTE_ATTRIBUTE_ID, indexedAttribute.getAttributeId());
                jdbmIndexElement.addAttribute(ATTRIBUTE_CACHE_SIZE, "" + indexedAttribute.getCacheSize());
            }
        }
    }

    private void createInterceptors(Element interceptorsElement, ServerConfigurationV156 serverConfiguration) {
        List<InterceptorEnum> interceptors = serverConfiguration.getInterceptors();
        if (interceptors.contains((Object)InterceptorEnum.NORMALIZATION)) {
            interceptorsElement.addElement(ELEMENT_NORMALIZATION_INTERCEPTOR);
        }
        if (interceptors.contains((Object)InterceptorEnum.AUTHENTICATION)) {
            interceptorsElement.addElement(ELEMENT_AUTHENTICATION_INTERCEPTOR);
        }
        if (interceptors.contains((Object)InterceptorEnum.REFERRAL)) {
            interceptorsElement.addElement(ELEMENT_REFERRAL_INTERCEPTOR);
        }
        if (interceptors.contains((Object)InterceptorEnum.ACI_AUTHORIZATION)) {
            interceptorsElement.addElement(ELEMENT_ACI_AUTHORIZATION_INTERCEPTOR);
        }
        if (interceptors.contains((Object)InterceptorEnum.DEFAULT_AUTHORIZATION)) {
            interceptorsElement.addElement(ELEMENT_DEFAULT_AUTHORIZATION_INTERCEPTOR);
        }
        if (interceptors.contains((Object)InterceptorEnum.EXCEPTION)) {
            interceptorsElement.addElement(ELEMENT_EXCEPTION_INTERCEPTOR);
        }
        if (interceptors.contains((Object)InterceptorEnum.OPERATIONAL_ATTRIBUTE)) {
            interceptorsElement.addElement(ELEMENT_OPERATIONAL_ATTRIBUTE_INTERCEPTOR);
        }
        if (interceptors.contains((Object)InterceptorEnum.SCHEMA)) {
            interceptorsElement.addElement(ELEMENT_SCHEMA_INTERCEPTOR);
        }
        if (interceptors.contains((Object)InterceptorEnum.SUBENTRY)) {
            interceptorsElement.addElement(ELEMENT_SUBENTRY_INTERCEPTOR);
        }
        if (interceptors.contains((Object)InterceptorEnum.COLLECTIVE_ATTRIBUTE)) {
            interceptorsElement.addElement(ELEMENT_COLLECTIVE_ATTRIBUTE_INTERCEPTOR);
        }
        if (interceptors.contains((Object)InterceptorEnum.EVENT)) {
            interceptorsElement.addElement(ELEMENT_EVENT_INTERCEPTOR);
        }
        if (interceptors.contains((Object)InterceptorEnum.TRIGGER)) {
            interceptorsElement.addElement(ELEMENT_TRIGGER_INTERCEPTOR);
        }
        if (interceptors.contains((Object)InterceptorEnum.REPLICATION)) {
            // empty if block
        }
    }

    private void createChangePasswordServerBean(Element root, ServerConfigurationV156 serverConfiguration) {
        if (serverConfiguration.isEnableChangePassword()) {
            Element changePasswordServerElement = root.addElement(ELEMENT_CHANGE_PASSWORD_SERVER);
            changePasswordServerElement.addAttribute(ATTRIBUTE_ID, ELEMENT_CHANGE_PASSWORD_SERVER);
            Element transportsElement = changePasswordServerElement.addElement(ELEMENT_TRANSPORTS);
            Element tcpTransportElement = transportsElement.addElement(ELEMENT_TCP_TRANSPORT);
            tcpTransportElement.addAttribute(ATTRIBUTE_PORT, "" + serverConfiguration.getChangePasswordPort());
            tcpTransportElement.addAttribute(ATTRIBUTE_NBTHREADS, VALUE_CHANGEPASSWORDSERVER_NB_THREADS);
            tcpTransportElement.addAttribute(ATTRIBUTE_BACKLOG, VALUE_BACKLOG);
            Element udpTransportElement = transportsElement.addElement(ELEMENT_UDP_TRANSPORT);
            udpTransportElement.addAttribute(ATTRIBUTE_PORT, "" + serverConfiguration.getChangePasswordPort());
            udpTransportElement.addAttribute(ATTRIBUTE_NBTHREADS, VALUE_CHANGEPASSWORDSERVER_NB_THREADS);
            udpTransportElement.addAttribute(ATTRIBUTE_BACKLOG, VALUE_BACKLOG);
            changePasswordServerElement.addElement(VALUE_DIRECTORY_SERVICE).setText("#directoryService");
        }
    }

    private void createKdcServerBean(Element root, ServerConfigurationV156 serverConfiguration) {
        if (serverConfiguration.isEnableKerberos()) {
            Element kdcServerElement = root.addElement(ELEMENT_KDC_SERVER);
            kdcServerElement.addAttribute(ATTRIBUTE_ID, ELEMENT_KDC_SERVER);
            Element transportsElement = kdcServerElement.addElement(ELEMENT_TRANSPORTS);
            Element tcpTransportElement = transportsElement.addElement(ELEMENT_TCP_TRANSPORT);
            tcpTransportElement.addAttribute(ATTRIBUTE_PORT, "" + serverConfiguration.getKerberosPort());
            tcpTransportElement.addAttribute(ATTRIBUTE_NBTHREADS, VALUE_KDCSERVER_NB_THREADS);
            tcpTransportElement.addAttribute(ATTRIBUTE_BACKLOG, VALUE_BACKLOG);
            Element udpTransportElement = transportsElement.addElement(ELEMENT_UDP_TRANSPORT);
            udpTransportElement.addAttribute(ATTRIBUTE_PORT, "" + serverConfiguration.getKerberosPort());
            udpTransportElement.addAttribute(ATTRIBUTE_NBTHREADS, VALUE_CHANGEPASSWORDSERVER_NB_THREADS);
            udpTransportElement.addAttribute(ATTRIBUTE_BACKLOG, VALUE_BACKLOG);
            kdcServerElement.addElement(VALUE_DIRECTORY_SERVICE).setText("#directoryService");
        }
    }

    private void createNtpServerBean(Element root, ServerConfigurationV156 serverConfiguration) {
        if (serverConfiguration.isEnableNtp()) {
            Element ntpServerElement = root.addElement(ELEMENT_NTP_SERVER);
            ntpServerElement.addAttribute(ATTRIBUTE_ID, ELEMENT_NTP_SERVER);
            Element transportsElement = ntpServerElement.addElement(ELEMENT_TRANSPORTS);
            Element tcpTransportElement = transportsElement.addElement(ELEMENT_TCP_TRANSPORT);
            tcpTransportElement.addAttribute(ATTRIBUTE_PORT, "" + serverConfiguration.getNtpPort());
            Element udpTransportElement = transportsElement.addElement(ELEMENT_UDP_TRANSPORT);
            udpTransportElement.addAttribute(ATTRIBUTE_PORT, "" + serverConfiguration.getNtpPort());
            udpTransportElement.addAttribute(ATTRIBUTE_NBTHREADS, "1");
        }
    }

    private void createDnsServerBean(Element root, ServerConfigurationV156 serverConfiguration) {
        if (serverConfiguration.isEnableDns()) {
            Element dnsServerElement = root.addElement(ELEMENT_DNS_SERVER);
            dnsServerElement.addAttribute(ATTRIBUTE_ID, ELEMENT_DNS_SERVER);
            Element transportsElement = dnsServerElement.addElement(ELEMENT_TRANSPORTS);
            Element tcpTransportElement = transportsElement.addElement(ELEMENT_TCP_TRANSPORT);
            tcpTransportElement.addAttribute(ATTRIBUTE_PORT, "" + serverConfiguration.getDnsPort());
            Element udpTransportElement = transportsElement.addElement(ELEMENT_UDP_TRANSPORT);
            udpTransportElement.addAttribute(ATTRIBUTE_PORT, "" + serverConfiguration.getDnsPort());
            dnsServerElement.addElement(VALUE_DIRECTORY_SERVICE).setText("#directoryService");
        }
    }

    private void createLdapServerBean(Element root, ServerConfigurationV156 serverConfiguration) {
        Element ldapServerElement = root.addElement(ELEMENT_LDAP_SERVER);
        ldapServerElement.addAttribute(ATTRIBUTE_ID, ELEMENT_LDAP_SERVER);
        ldapServerElement.addAttribute(ATTRIBUTE_ALLOW_ANONYMOUS_ACCESS, "" + serverConfiguration.isAllowAnonymousAccess());
        ldapServerElement.addAttribute(ATTRIBUTE_SASL_HOST, "" + serverConfiguration.getSaslHost());
        ldapServerElement.addAttribute(ATTRIBUTE_SASL_PRINCIPAL, "" + serverConfiguration.getSaslPrincipal());
        ldapServerElement.addAttribute(ATTRIBUTE_SEARCH_BASE_DN, "ou=users,ou=system");
        ldapServerElement.addAttribute(ATTRIBUTE_MAX_TIME_LIMIT, "" + serverConfiguration.getMaxTimeLimit());
        ldapServerElement.addAttribute(ATTRIBUTE_MAX_SIZE_LIMIT, "" + serverConfiguration.getMaxSizeLimit());
        if (serverConfiguration.isEnableLdap() || serverConfiguration.isEnableLdaps()) {
            Element tcpTransportElement;
            Element transportsElement = ldapServerElement.addElement(ELEMENT_TRANSPORTS);
            if (serverConfiguration.isEnableLdap()) {
                tcpTransportElement = transportsElement.addElement(ELEMENT_TCP_TRANSPORT);
                tcpTransportElement.addAttribute(ATTRIBUTE_ADDRESS, VALUE_ADDRESS_0_0_0_0);
                tcpTransportElement.addAttribute(ATTRIBUTE_PORT, "" + serverConfiguration.getLdapPort());
                tcpTransportElement.addAttribute(ATTRIBUTE_NBTHREADS, VALUE_LDAPSERVER_NB_THREADS);
                tcpTransportElement.addAttribute(ATTRIBUTE_BACKLOG, VALUE_BACKLOG);
                tcpTransportElement.addAttribute(ATTRIBUTE_ENABLESSL, "false");
            }
            if (serverConfiguration.isEnableLdaps()) {
                tcpTransportElement = transportsElement.addElement(ELEMENT_TCP_TRANSPORT);
                tcpTransportElement.addAttribute(ATTRIBUTE_ADDRESS, VALUE_ADDRESS_LOCALHOST);
                tcpTransportElement.addAttribute(ATTRIBUTE_PORT, "" + serverConfiguration.getLdapsPort());
                tcpTransportElement.addAttribute(ATTRIBUTE_ENABLESSL, "true");
            }
        }
        ldapServerElement.addElement(VALUE_DIRECTORY_SERVICE).setText("#directoryService");
        Element saslMechanismHandlersElement = ldapServerElement.addElement(ELEMENT_SASL_MECHANISM_HANDLERS);
        for (SupportedMechanismEnum supportedMechanism : serverConfiguration.getSupportedMechanisms()) {
            switch (supportedMechanism) {
                case SIMPLE: {
                    Element simpleMechanismHandlerElement = saslMechanismHandlersElement.addElement(ELEMENT_SIMPLE_MECHANISM_HANDLER);
                    simpleMechanismHandlerElement.addAttribute(ATTRIBUTE_MECH_NAME, SUPPORTED_MECHANISM_SIMPLE);
                    break;
                }
                case CRAM_MD5: {
                    Element cramMd5MechanismHandlerElement = saslMechanismHandlersElement.addElement(ELEMENT_CRAM_MD5_MECHANISM_HANDLER);
                    cramMd5MechanismHandlerElement.addAttribute(ATTRIBUTE_MECH_NAME, SUPPORTED_MECHANISM_CRAM_MD5);
                    break;
                }
                case DIGEST_MD5: {
                    Element digestMd5MechanismHandlerElement = saslMechanismHandlersElement.addElement(ELEMENT_DIGEST_MD5_MECHANISM_HANDLER);
                    digestMd5MechanismHandlerElement.addAttribute(ATTRIBUTE_MECH_NAME, SUPPORTED_MECHANISM_DIGEST_MD5);
                    break;
                }
                case GSSAPI: {
                    Element gssapiMechanismHandlerElement = saslMechanismHandlersElement.addElement(ELEMENT_GSSAPI_MECHANISM_HANDLER);
                    gssapiMechanismHandlerElement.addAttribute(ATTRIBUTE_MECH_NAME, SUPPORTED_MECHANISM_GSSAPI);
                    break;
                }
                case NTLM: {
                    Element ntlmMechanismHandlerElement = saslMechanismHandlersElement.addElement(ELEMENT_NTLM_MECHANISM_HANDLER);
                    ntlmMechanismHandlerElement.addAttribute(ATTRIBUTE_MECH_NAME, SUPPORTED_MECHANISM_NTLM);
                    ntlmMechanismHandlerElement.addAttribute(ATTRIBUTE_NTLM_PROVIDER_FQCN, supportedMechanism.getNtlmProviderFqcn());
                    break;
                }
                case GSS_SPNEGO: {
                    Element gssSpnegoMechanismHandlerElement = saslMechanismHandlersElement.addElement(ELEMENT_NTLM_MECHANISM_HANDLER);
                    gssSpnegoMechanismHandlerElement.addAttribute(ATTRIBUTE_MECH_NAME, SUPPORTED_MECHANISM_GSS_SPNEGO);
                    gssSpnegoMechanismHandlerElement.addAttribute(ATTRIBUTE_NTLM_PROVIDER_FQCN, supportedMechanism.getNtlmProviderFqcn());
                }
            }
        }
        Element saslRealmsElement = ldapServerElement.addElement(ELEMENT_SASL_REALMS);
        for (String saslRealm : serverConfiguration.getSaslRealms()) {
            saslRealmsElement.addElement(new QName(ELEMENT_VALUE, NAMESPACE_SPRINGFRAMEWORK)).setText(saslRealm);
        }
        Element extendedOperationsElement = ldapServerElement.addElement(ELEMENT_EXTENDED_OPERATION_HANDLERS);
        List<ExtendedOperationEnum> extendedOperations = serverConfiguration.getExtendedOperations();
        if (extendedOperations.contains((Object)ExtendedOperationEnum.START_TLS)) {
            extendedOperationsElement.addElement(ELEMENT_START_TLS_HANDLER);
        }
        if (extendedOperations.contains((Object)ExtendedOperationEnum.GRACEFUL_SHUTDOWN)) {
            extendedOperationsElement.addElement(ELEMENT_GRACEFUL_SHUTDOWN_HANDLER);
        }
        if (extendedOperations.contains((Object)ExtendedOperationEnum.LAUNCH_DIAGNOSTIC_UI)) {
            extendedOperationsElement.addElement(ELEMENT_LAUNCH_DIAGNOSTIC_UI_HANDLER);
        }
    }

    private void createApacheDSBean(Element root, ServerConfigurationV156 serverConfiguration) {
        Element apacheDSElement = root.addElement(ELEMENT_APACHE_DS);
        apacheDSElement.addAttribute(ATTRIBUTE_ID, ELEMENT_APACHE_DS);
        apacheDSElement.addElement(ELEMENT_LDAP_SERVER).setText("#ldapServer");
    }
}

