/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.model.v153;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import org.apache.directory.studio.apacheds.configuration.StudioEntityResolver;
import org.apache.directory.studio.apacheds.configuration.model.AbstractServerXmlIO;
import org.apache.directory.studio.apacheds.configuration.model.ServerConfiguration;
import org.apache.directory.studio.apacheds.configuration.model.ServerXmlIO;
import org.apache.directory.studio.apacheds.configuration.model.ServerXmlIOException;
import org.apache.directory.studio.apacheds.configuration.model.v153.ExtendedOperationEnum;
import org.apache.directory.studio.apacheds.configuration.model.v153.IndexedAttribute;
import org.apache.directory.studio.apacheds.configuration.model.v153.InterceptorEnum;
import org.apache.directory.studio.apacheds.configuration.model.v153.Messages;
import org.apache.directory.studio.apacheds.configuration.model.v153.Partition;
import org.apache.directory.studio.apacheds.configuration.model.v153.SaslQualityOfProtectionEnum;
import org.apache.directory.studio.apacheds.configuration.model.v153.ServerConfigurationV153;
import org.apache.directory.studio.apacheds.configuration.model.v153.SupportedMechanismEnum;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerXmlIOV153
extends AbstractServerXmlIO
implements ServerXmlIO {
    private static final String ATTRIBUTE_ACCESS_CONTROL_ENABLED = "accessControlEnabled";
    private static final String ATTRIBUTE_ALLOW_ANONYMOUS_ACCESS = "allowAnonymousAccess";
    private static final String ATTRIBUTE_ATTRIBUTE_ID = "attributeId";
    private static final String ATTRIBUTE_CACHE_SIZE = "cacheSize";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_DENORMALIZE_OP_ATTRS_ENABLED = "denormalizeOpAttrsEnabled";
    private static final String ATTRIBUTE_ENABLE_LDAPS = "enableLdaps";
    private static final String ATTRIBUTE_ENABLED = "enabled";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_INSTANCE_ID = "instanceId";
    private static final String ATTRIBUTE_IP_PORT = "ipPort";
    private static final String ATTRIBUTE_KEY = "key";
    private static final String ATTRIBUTE_LOCAL = "local";
    private static final String ATTRIBUTE_MAX_SIZE_LIMIT = "maxSizeLimit";
    private static final String ATTRIBUTE_MAX_THREADS = "maxThreads";
    private static final String ATTRIBUTE_MAX_TIME_LIMIT = "maxTimeLimit";
    private static final String ATTRIBUTE_MECH_NAME = "mech-name";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_NTLM_PROVIDER_FQCN = "ntlmProviderFqcn";
    private static final String ATTRIBUTE_OPTIMIZER_ENABLED = "optimizerEnabled";
    private static final String ATTRIBUTE_SASL_HOST = "saslHost";
    private static final String ATTRIBUTE_SASL_PRINCIPAL = "saslPrincipal";
    private static final String ATTRIBUTE_SEARCH_BASE_DN = "searchBaseDn";
    private static final String ATTRIBUTE_SUFFIX = "suffix";
    private static final String ATTRIBUTE_SYNC_ON_WRITE = "syncOnWrite";
    private static final String ATTRIBUTE_SYNCH_PERIOD_MILLIS = "synchPeriodMillis";
    private static final String ATTRIBUTE_WORKING_DIRECTORY = "workingDirectory";
    private static final String ELEMENT_ACI_AUTHORIZATION_INTERCEPTOR = "aciAuthorizationInterceptor";
    private static final String ELEMENT_APACHE_DS = "apacheDS";
    private static final String ELEMENT_AUTHENTICATION_INTERCEPTOR = "authenticationInterceptor";
    private static final String ELEMENT_BEAN = "bean";
    private static final String ELEMENT_BEANS = "beans";
    private static final String ELEMENT_CHANGE_PASSWORD_SERVER = "changePasswordServer";
    private static final String ELEMENT_COLLECTIVE_ATTRIBUTE_INTERCEPTOR = "collectiveAttributeInterceptor";
    private static final String ELEMENT_CONTEXT_ENTRY = "contextEntry";
    private static final String ELEMENT_CRAM_MD5_MECHANISM_HANDLER = "cramMd5MechanismHandler";
    private static final String ELEMENT_DATAGRAM_ACCEPTOR = "datagramAcceptor";
    private static final String ELEMENT_DEFAULT_AUTHORIZATION_INTERCEPTOR = "defaultAuthorizationInterceptor";
    private static final String ELEMENT_DEFAULT_DIRECTORY_SERVICE = "defaultDirectoryService";
    private static final String ELEMENT_DIGEST_MD5_MECHANISM_HANDLER = "digestMd5MechanismHandler";
    private static final String ELEMENT_DNS_SERVER = "dnsServer";
    private static final String ELEMENT_ENTRY = "entry";
    private static final String ELEMENT_EVENT_INTERCEPTOR = "eventInterceptor";
    private static final String ELEMENT_EXCEPTION_INTERCEPTOR = "exceptionInterceptor";
    private static final String ELEMENT_EXTENDED_OPERATION_HANDLERS = "extendedOperationHandlers";
    private static final String ELEMENT_GRACEFUL_SHUTDOWN_HANDLER = "gracefulShutdownHandler";
    private static final String ELEMENT_GSSAPI_MECHANISM_HANDLER = "gssapiMechanismHandler";
    private static final String ELEMENT_INDEXED_ATTRIBUTES = "indexedAttributes";
    private static final String ELEMENT_INTERCEPTORS = "interceptors";
    private static final String ELEMENT_JDBM_INDEX = "jdbmIndex";
    private static final String ELEMENT_JDBM_PARTITION = "jdbmPartition";
    private static final String ELEMENT_KDC_SERVER = "kdcServer";
    private static final String ELEMENT_LAUNCH_DIAGNOSTIC_UI_HANDLER = "launchDiagnosticUiHandler";
    private static final String ELEMENT_LDAP_SERVER = "ldapServer";
    private static final String ELEMENT_LDAPS_SERVER = "ldapsServer";
    private static final String ELEMENT_LIST = "list";
    private static final String ELEMENT_LOGIC_EXECUTOR = "logicExecutor";
    private static final String ELEMENT_MAP = "map";
    private static final String ELEMENT_NORMALIZATION_INTERCEPTOR = "normalizationInterceptor";
    private static final String ELEMENT_NTLM_MECHANISM_HANDLER = "ntlmMechanismHandler";
    private static final String ELEMENT_NTP_SERVER = "ntpServer";
    private static final String ELEMENT_OPERATIONAL_ATTRIBUTE_INTERCEPTOR = "operationalAttributeInterceptor";
    private static final String ELEMENT_PARTITIONS = "partitions";
    private static final String ELEMENT_PROPERTY = "property";
    private static final String ELEMENT_REF = "ref";
    private static final String ELEMENT_REFERRAL_INTERCEPTOR = "referralInterceptor";
    private static final String ELEMENT_REPLICATION_INTERCEPTOR = "replicationInterceptor";
    private static final String ELEMENT_SASL_MECHANISM_HANDLERS = "saslMechanismHandlers";
    private static final String ELEMENT_SASL_QOP = "saslQop";
    private static final String ELEMENT_SASL_REALMS = "saslRealms";
    private static final String ELEMENT_SCHEMA_INTERCEPTOR = "schemaInterceptor";
    private static final String ELEMENT_SIMPLE_MECHANISM_HANDLER = "simpleMechanismHandler";
    private static final String ELEMENT_SOCKET_ACCEPTOR = "socketAcceptor";
    private static final String ELEMENT_STANDARD_THREAD_POOL = "standardThreadPool";
    private static final String ELEMENT_START_TLS_HANDLER = "startTlsHandler";
    private static final String ELEMENT_SUBENTRY_INTERCEPTOR = "subentryInterceptor";
    private static final String ELEMENT_SYSTEM_PARTITION = "systemPartition";
    private static final String ELEMENT_TRIGGER_INTERCEPTOR = "triggerInterceptor";
    private static final String ELEMENT_VALUE = "value";
    private static final Namespace NAMESPACE_APACHEDS = new Namespace(null, "http://apacheds.org/config/1.0");
    private static final Namespace NAMESPACE_SPRINGFRAMEWORK = new Namespace("s", "http://www.springframework.org/schema/beans");
    private static final Namespace NAMESPACE_XBEAN_SPRING = new Namespace("spring", "http://xbean.apache.org/schemas/spring/1.0");
    private static final String SASL_QOP_AUTH = "auth";
    private static final String SASL_QOP_AUTH_CONF = "auth-conf";
    private static final String SASL_QOP_AUTH_INT = "auth-int";
    private static final String SUPPORTED_MECHANISM_CRAM_MD5 = "CRAM-MD5";
    private static final String SUPPORTED_MECHANISM_DIGEST_MD5 = "DIGEST-MD5";
    private static final String SUPPORTED_MECHANISM_GSS_SPNEGO = "GSS-SPNEGO";
    private static final String SUPPORTED_MECHANISM_GSSAPI = "GSSAPI";
    private static final String SUPPORTED_MECHANISM_NTLM = "NTLM";
    private static final String SUPPORTED_MECHANISM_SIMPLE = "SIMPLE";
    private static final String VALUE_ARGUMENTS = "arguments";
    private static final String VALUE_CUSTOM_EDITORS = "customEditors";
    private static final String VALUE_DEFAULT = "default";
    private static final String VALUE_DIRECTORY_SERVICE = "directoryService";
    private static final String VALUE_EXAMPLE_DOT_COM = "example.com";

    @Override
    protected boolean isValid(Document document) {
        Element apacheDSElement;
        Element rootElement = document.getRootElement();
        if (rootElement != null && ELEMENT_BEANS.equalsIgnoreCase(rootElement.getName()) && (apacheDSElement = rootElement.element(ELEMENT_APACHE_DS)) != null) {
            Element ldapServerElement = rootElement.element(ELEMENT_LDAP_SERVER);
            return ldapServerElement != null;
        }
        return false;
    }

    @Override
    public ServerConfiguration parse(InputStream is) throws ServerXmlIOException {
        try {
            SAXReader reader = new SAXReader();
            reader.setEntityResolver((EntityResolver)new StudioEntityResolver());
            Document document = reader.read(is);
            ServerConfigurationV153 serverConfiguration = new ServerConfigurationV153();
            this.parse(document, serverConfiguration);
            return serverConfiguration;
        }
        catch (Exception e) {
            if (e instanceof ServerXmlIOException) {
                throw (ServerXmlIOException)e;
            }
            ServerXmlIOException exception = new ServerXmlIOException(e.getMessage(), e.getCause());
            exception.setStackTrace(e.getStackTrace());
            throw exception;
        }
    }

    private void parse(Document document, ServerConfigurationV153 serverConfiguration) throws NumberFormatException, AbstractServerXmlIO.BooleanFormatException, ServerXmlIOException {
        Element rootElement = document.getRootElement();
        this.readDefaultDirectoryServiceBean(rootElement, serverConfiguration);
        this.readStandardThreadPoolBean(rootElement, serverConfiguration);
        this.readChangePasswordServerBean(rootElement, serverConfiguration);
        this.readKdcServerBean(rootElement, serverConfiguration);
        this.readNtpServerBean(rootElement, serverConfiguration);
        this.readDnsServerBean(rootElement, serverConfiguration);
        this.readLdapsServerBean(rootElement, serverConfiguration);
        this.readLdapServerBean(rootElement, serverConfiguration);
        this.readApacheDSBean(rootElement, serverConfiguration);
    }

    private void readDefaultDirectoryServiceBean(Element element, ServerConfigurationV153 serverConfiguration) throws ServerXmlIOException, NumberFormatException, AbstractServerXmlIO.BooleanFormatException {
        Element defaultDirectoryServiceElement = element.element(ELEMENT_DEFAULT_DIRECTORY_SERVICE);
        if (defaultDirectoryServiceElement == null) {
            throw new ServerXmlIOException(Messages.getString("ServerXmlIOV153.ErrorDefaultDirectoryService"));
        }
        Attribute accessControlEnabledAttribute = defaultDirectoryServiceElement.attribute(ATTRIBUTE_ACCESS_CONTROL_ENABLED);
        if (accessControlEnabledAttribute == null) {
            throw new ServerXmlIOException(Messages.getString("ServerXmlIOV153.ErrorAccessControlEnabled"));
        }
        serverConfiguration.setEnableAccessControl(this.parseBoolean(accessControlEnabledAttribute.getValue()));
        Attribute denormalizeOpAttrsEnabledAttribute = defaultDirectoryServiceElement.attribute(ATTRIBUTE_DENORMALIZE_OP_ATTRS_ENABLED);
        if (denormalizeOpAttrsEnabledAttribute == null) {
            throw new ServerXmlIOException(Messages.getString("ServerXmlIOV153.ErrorDenormalizedOpAttrsEnabled"));
        }
        serverConfiguration.setDenormalizeOpAttr(this.parseBoolean(denormalizeOpAttrsEnabledAttribute.getValue()));
        this.readSystemPartition(defaultDirectoryServiceElement, serverConfiguration);
        this.readPartitions(defaultDirectoryServiceElement, serverConfiguration);
        this.readInterceptors(defaultDirectoryServiceElement, serverConfiguration);
    }

    private void readStandardThreadPoolBean(Element element, ServerConfigurationV153 serverConfiguration) throws ServerXmlIOException, NumberFormatException {
        Element standardThreadPoolElement = element.element(ELEMENT_STANDARD_THREAD_POOL);
        if (standardThreadPoolElement == null) {
            throw new ServerXmlIOException(Messages.getString("ServerXmlIOV153.ErrorStandardThreadPool"));
        }
        Attribute maxThreadsAttribute = standardThreadPoolElement.attribute(ATTRIBUTE_MAX_THREADS);
        if (maxThreadsAttribute == null) {
            throw new ServerXmlIOException(Messages.getString("ServerXmlIOV153.ErrorMaxThreads"));
        }
        serverConfiguration.setMaxThreads(Integer.parseInt(maxThreadsAttribute.getValue()));
    }

    private void readSystemPartition(Element element, ServerConfigurationV153 serverConfiguration) throws ServerXmlIOException, NumberFormatException, AbstractServerXmlIO.BooleanFormatException {
        Element systemPartitionElement = element.element(ELEMENT_SYSTEM_PARTITION);
        if (systemPartitionElement == null) {
            throw new ServerXmlIOException(Messages.getString("ServerXmlIOV153.ErrorSystemPartition"));
        }
        Element jdbmPartitionElement = systemPartitionElement.element(ELEMENT_JDBM_PARTITION);
        if (jdbmPartitionElement == null) {
            throw new ServerXmlIOException(Messages.getString("ServerXmlIOV153.ErrorJDBMPartition"));
        }
        Partition systemPartition = new Partition();
        systemPartition.setSystemPartition(true);
        this.readPartition(jdbmPartitionElement, systemPartition);
        serverConfiguration.addPartition(systemPartition);
    }

    private void readPartition(Element element, Partition partition) throws ServerXmlIOException, NumberFormatException, AbstractServerXmlIO.BooleanFormatException {
        Attribute idAttribute = element.attribute(ATTRIBUTE_ID);
        if (idAttribute == null) {
            throw new ServerXmlIOException(Messages.getString("ServerXmlIOV153.ErrorId"));
        }
        partition.setId(idAttribute.getValue());
        Attribute cacheSizeAttribute = element.attribute(ATTRIBUTE_CACHE_SIZE);
        if (cacheSizeAttribute == null) {
            throw new ServerXmlIOException(Messages.getString("ServerXmlIOV153.ErrorCacheSize"));
        }
        partition.setCacheSize(Integer.parseInt(cacheSizeAttribute.getValue()));
        Attribute suffixAttribute = element.attribute(ATTRIBUTE_SUFFIX);
        if (suffixAttribute == null) {
            throw new ServerXmlIOException(Messages.getString("ServerXmlIOV153.ErrorSuffix"));
        }
        partition.setSuffix(suffixAttribute.getValue());
        Attribute optimizerEnabledAttribute = element.attribute(ATTRIBUTE_OPTIMIZER_ENABLED);
        if (optimizerEnabledAttribute == null) {
            throw new ServerXmlIOException(Messages.getString("ServerXmlIOV153.ErrorOptimizerEnabled"));
        }
        partition.setEnableOptimizer(this.parseBoolean(optimizerEnabledAttribute.getValue()));
        Attribute syncOnWriteAttribute = element.attribute(ATTRIBUTE_SYNC_ON_WRITE);
        if (syncOnWriteAttribute == null) {
            throw new ServerXmlIOException(Messages.getString("ServerXmlIOV153.ErrorSyncOnWrite"));
        }
        partition.setSynchronizationOnWrite(this.parseBoolean(syncOnWriteAttribute.getValue()));
        partition.setIndexedAttributes(this.readIndexedAttributes(element));
        partition.setContextEntry(this.readContextEntry(element));
    }

    private List<IndexedAttribute> readIndexedAttributes(Element element) throws NumberFormatException {
        ArrayList<IndexedAttribute> indexedAttributes = new ArrayList<IndexedAttribute>();
        Element indexedAttributesElement = element.element(ELEMENT_INDEXED_ATTRIBUTES);
        if (indexedAttributesElement != null) {
            Iterator i = indexedAttributesElement.elementIterator(ELEMENT_JDBM_INDEX);
            while (i.hasNext()) {
                Attribute cacheSizeAttribute;
                Element jdbmIndexElement = (Element)i.next();
                Attribute attributeIdAttribute = jdbmIndexElement.attribute(ATTRIBUTE_ATTRIBUTE_ID);
                if (attributeIdAttribute == null || (cacheSizeAttribute = jdbmIndexElement.attribute(ATTRIBUTE_CACHE_SIZE)) == null) continue;
                indexedAttributes.add(new IndexedAttribute(attributeIdAttribute.getValue(), Integer.parseInt(cacheSizeAttribute.getValue())));
            }
        }
        return indexedAttributes;
    }

    private Attributes readContextEntry(Element element) throws ServerXmlIOException {
        Element contextEntryElement = element.element(ELEMENT_CONTEXT_ENTRY);
        if (contextEntryElement == null) {
            throw new ServerXmlIOException(Messages.getString("ServerXmlIOV153.ErrorContextEntry"));
        }
        String linkedBeanId = contextEntryElement.getText().trim();
        linkedBeanId = linkedBeanId.substring(1, linkedBeanId.length());
        boolean foundBean = false;
        Iterator i = element.getDocument().getRootElement().elementIterator(ELEMENT_BEAN);
        while (i.hasNext()) {
            Element beanElement = (Element)i.next();
            Attribute idAttribute = beanElement.attribute(ATTRIBUTE_ID);
            if (idAttribute == null || !linkedBeanId.equalsIgnoreCase(idAttribute.getValue())) continue;
            foundBean = true;
            boolean foundProperty = false;
            Iterator i2 = beanElement.elementIterator(ELEMENT_PROPERTY);
            while (i2.hasNext()) {
                Element propertyElement = (Element)i2.next();
                Attribute nameAttribute = propertyElement.attribute(ATTRIBUTE_NAME);
                if (nameAttribute == null || !nameAttribute.getValue().equalsIgnoreCase(VALUE_ARGUMENTS)) continue;
                foundProperty = true;
                Element listElement = propertyElement.element(ELEMENT_LIST);
                if (listElement == null) continue;
                Iterator i3 = listElement.elementIterator(ELEMENT_VALUE);
                while (i3.hasNext()) {
                    Element valueElement = (Element)i3.next();
                    String value = valueElement.getText().trim();
                    if (value.indexOf(58) == -1) continue;
                    return this.readContextEntry(valueElement.getText().trim());
                }
            }
            if (foundProperty) continue;
            throw new ServerXmlIOException(Messages.getString("ServerXmlIOV153.ErrorArguments"));
        }
        if (!foundBean) {
            throw new ServerXmlIOException(NLS.bind((String)Messages.getString("ServerXmlIOV153.ErrorBean"), (Object[])new String[]{linkedBeanId}));
        }
        return null;
    }

    private void readPartitions(Element element, ServerConfigurationV153 serverConfiguration) throws NumberFormatException, ServerXmlIOException, AbstractServerXmlIO.BooleanFormatException {
        Element partitionsElement = element.element(ELEMENT_PARTITIONS);
        if (partitionsElement != null) {
            Iterator i = partitionsElement.elementIterator(ELEMENT_JDBM_PARTITION);
            while (i.hasNext()) {
                Element jdbmPartitionElement = (Element)i.next();
                Partition partition = new Partition();
                this.readPartition(jdbmPartitionElement, partition);
                serverConfiguration.addPartition(partition);
            }
        }
    }

    private void readInterceptors(Element element, ServerConfigurationV153 serverConfiguration) {
        Element interceptorsElement = element.element(ELEMENT_INTERCEPTORS);
        if (interceptorsElement != null) {
            Iterator i = interceptorsElement.elementIterator();
            while (i.hasNext()) {
                Element interceptorElement = (Element)i.next();
                String interceptorElementName = interceptorElement.getName();
                if (ELEMENT_NORMALIZATION_INTERCEPTOR.equalsIgnoreCase(interceptorElementName)) {
                    serverConfiguration.addInterceptor(InterceptorEnum.NORMALIZATION);
                    continue;
                }
                if (ELEMENT_AUTHENTICATION_INTERCEPTOR.equalsIgnoreCase(interceptorElementName)) {
                    serverConfiguration.addInterceptor(InterceptorEnum.AUTHENTICATION);
                    continue;
                }
                if (ELEMENT_REFERRAL_INTERCEPTOR.equalsIgnoreCase(interceptorElementName)) {
                    serverConfiguration.addInterceptor(InterceptorEnum.REFERRAL);
                    continue;
                }
                if (ELEMENT_ACI_AUTHORIZATION_INTERCEPTOR.equalsIgnoreCase(interceptorElementName)) {
                    serverConfiguration.addInterceptor(InterceptorEnum.ACI_AUTHORIZATION);
                    continue;
                }
                if (ELEMENT_DEFAULT_AUTHORIZATION_INTERCEPTOR.equalsIgnoreCase(interceptorElementName)) {
                    serverConfiguration.addInterceptor(InterceptorEnum.DEFAULT_AUTHORIZATION);
                    continue;
                }
                if (ELEMENT_EXCEPTION_INTERCEPTOR.equalsIgnoreCase(interceptorElementName)) {
                    serverConfiguration.addInterceptor(InterceptorEnum.EXCEPTION);
                    continue;
                }
                if (ELEMENT_OPERATIONAL_ATTRIBUTE_INTERCEPTOR.equalsIgnoreCase(interceptorElementName)) {
                    serverConfiguration.addInterceptor(InterceptorEnum.OPERATIONAL_ATTRIBUTE);
                    continue;
                }
                if (ELEMENT_SCHEMA_INTERCEPTOR.equalsIgnoreCase(interceptorElementName)) {
                    serverConfiguration.addInterceptor(InterceptorEnum.SCHEMA);
                    continue;
                }
                if (ELEMENT_SUBENTRY_INTERCEPTOR.equalsIgnoreCase(interceptorElementName)) {
                    serverConfiguration.addInterceptor(InterceptorEnum.SUBENTRY);
                    continue;
                }
                if (ELEMENT_COLLECTIVE_ATTRIBUTE_INTERCEPTOR.equalsIgnoreCase(interceptorElementName)) {
                    serverConfiguration.addInterceptor(InterceptorEnum.COLLECTIVE_ATTRIBUTE);
                    continue;
                }
                if (ELEMENT_EVENT_INTERCEPTOR.equalsIgnoreCase(interceptorElementName)) {
                    serverConfiguration.addInterceptor(InterceptorEnum.EVENT);
                    continue;
                }
                if (ELEMENT_TRIGGER_INTERCEPTOR.equalsIgnoreCase(interceptorElementName)) {
                    serverConfiguration.addInterceptor(InterceptorEnum.TRIGGER);
                    continue;
                }
                if (!ELEMENT_REPLICATION_INTERCEPTOR.equalsIgnoreCase(interceptorElementName)) continue;
                serverConfiguration.addInterceptor(InterceptorEnum.REPLICATION);
            }
        }
    }

    private void readChangePasswordServerBean(Element element, ServerConfigurationV153 serverConfiguration) throws NumberFormatException, ServerXmlIOException, AbstractServerXmlIO.BooleanFormatException {
        Element changePasswordServerElement = element.element(ELEMENT_CHANGE_PASSWORD_SERVER);
        if (changePasswordServerElement != null) {
            Attribute enabledAttribute = changePasswordServerElement.attribute(ATTRIBUTE_ENABLED);
            if (enabledAttribute == null) {
                serverConfiguration.setEnableChangePassword(false);
            } else {
                serverConfiguration.setEnableChangePassword(this.parseBoolean(enabledAttribute.getValue()));
            }
            Attribute ipPortAttribute = changePasswordServerElement.attribute(ATTRIBUTE_IP_PORT);
            if (ipPortAttribute == null) {
                throw new ServerXmlIOException(Messages.getString("ServerXmlIOV153.ErrorChangePasswordServer"));
            }
            serverConfiguration.setChangePasswordPort(Integer.parseInt(ipPortAttribute.getValue()));
        }
    }

    private void readKdcServerBean(Element element, ServerConfigurationV153 serverConfiguration) throws NumberFormatException, ServerXmlIOException, AbstractServerXmlIO.BooleanFormatException {
        Element kdcServerElement = element.element(ELEMENT_KDC_SERVER);
        if (kdcServerElement != null) {
            Attribute enabledAttribute = kdcServerElement.attribute(ATTRIBUTE_ENABLED);
            if (enabledAttribute == null) {
                serverConfiguration.setEnableKerberos(false);
            } else {
                serverConfiguration.setEnableKerberos(this.parseBoolean(enabledAttribute.getValue()));
            }
            Attribute ipPortAttribute = kdcServerElement.attribute(ATTRIBUTE_IP_PORT);
            if (ipPortAttribute == null) {
                throw new ServerXmlIOException(Messages.getString("ServerXmlIOV153.ErrorKdcServerPort"));
            }
            serverConfiguration.setKerberosPort(Integer.parseInt(ipPortAttribute.getValue()));
        }
    }

    private void readNtpServerBean(Element element, ServerConfigurationV153 serverConfiguration) throws NumberFormatException, ServerXmlIOException, AbstractServerXmlIO.BooleanFormatException {
        Element ntpServerElement = element.element(ELEMENT_NTP_SERVER);
        if (ntpServerElement != null) {
            Attribute enabledAttribute = ntpServerElement.attribute(ATTRIBUTE_ENABLED);
            if (enabledAttribute == null) {
                serverConfiguration.setEnableNtp(false);
            } else {
                serverConfiguration.setEnableNtp(this.parseBoolean(enabledAttribute.getValue()));
            }
            Attribute ipPortAttribute = ntpServerElement.attribute(ATTRIBUTE_IP_PORT);
            if (ipPortAttribute == null) {
                throw new ServerXmlIOException(Messages.getString("ServerXmlIOV153.ErrorNtpServerPort"));
            }
            serverConfiguration.setNtpPort(Integer.parseInt(ipPortAttribute.getValue()));
        }
    }

    private void readDnsServerBean(Element element, ServerConfigurationV153 serverConfiguration) throws NumberFormatException, ServerXmlIOException, AbstractServerXmlIO.BooleanFormatException {
        Element dnsServerElement = element.element(ELEMENT_DNS_SERVER);
        if (dnsServerElement != null) {
            Attribute enabledAttribute = dnsServerElement.attribute(ATTRIBUTE_ENABLED);
            if (enabledAttribute == null) {
                serverConfiguration.setEnableDns(false);
            } else {
                serverConfiguration.setEnableDns(this.parseBoolean(enabledAttribute.getValue()));
            }
            Attribute ipPortAttribute = dnsServerElement.attribute(ATTRIBUTE_IP_PORT);
            if (ipPortAttribute == null) {
                throw new ServerXmlIOException(Messages.getString("ServerXmlIOV153.ErrorDnsServerPort"));
            }
            serverConfiguration.setDnsPort(Integer.parseInt(ipPortAttribute.getValue()));
        }
    }

    private void readLdapsServerBean(Element element, ServerConfigurationV153 serverConfiguration) throws NumberFormatException, ServerXmlIOException, AbstractServerXmlIO.BooleanFormatException {
        Iterator i = element.getDocument().getRootElement().elementIterator(ELEMENT_LDAP_SERVER);
        while (i.hasNext()) {
            Element ldapServerElement = (Element)i.next();
            Attribute idAttribute = ldapServerElement.attribute(ATTRIBUTE_ID);
            if (idAttribute == null) {
                throw new ServerXmlIOException(Messages.getString("ServerXmlIOV153.ErrorLdapServerId"));
            }
            if (!ELEMENT_LDAPS_SERVER.equalsIgnoreCase(idAttribute.getValue())) continue;
            Attribute enableLdapsAttribute = ldapServerElement.attribute(ATTRIBUTE_ENABLE_LDAPS);
            if (enableLdapsAttribute == null) {
                serverConfiguration.setEnableLdaps(false);
            } else {
                Attribute enabledAttribute = ldapServerElement.attribute(ATTRIBUTE_ENABLED);
                if (enabledAttribute == null) {
                    serverConfiguration.setEnableLdaps(false);
                } else {
                    serverConfiguration.setEnableLdaps(this.parseBoolean(enableLdapsAttribute.getValue()) && this.parseBoolean(enabledAttribute.getValue()));
                }
            }
            Attribute ipPortAttribute = ldapServerElement.attribute(ATTRIBUTE_IP_PORT);
            if (ipPortAttribute == null) {
                throw new ServerXmlIOException(Messages.getString("ServerXmlIOV153.ErrorLdapsServerPort"));
            }
            serverConfiguration.setLdapsPort(Integer.parseInt(ipPortAttribute.getValue()));
            return;
        }
    }

    private void readLdapServerBean(Element element, ServerConfigurationV153 serverConfiguration) throws NumberFormatException, ServerXmlIOException, AbstractServerXmlIO.BooleanFormatException {
        Iterator i = element.getDocument().getRootElement().elementIterator(ELEMENT_LDAP_SERVER);
        while (i.hasNext()) {
            Element SaslRealmsElement;
            Element SaslQopElement;
            Element ldapServerElement = (Element)i.next();
            Attribute idAttribute = ldapServerElement.attribute(ATTRIBUTE_ID);
            if (idAttribute == null) {
                throw new ServerXmlIOException(Messages.getString("ServerXmlIOV153.ErrorLdapServerId"));
            }
            if (!ELEMENT_LDAP_SERVER.equalsIgnoreCase(idAttribute.getValue())) continue;
            Attribute enabledAttribute = ldapServerElement.attribute(ATTRIBUTE_ENABLED);
            if (enabledAttribute == null) {
                serverConfiguration.setEnableLdap(true);
            } else {
                serverConfiguration.setEnableLdap(this.parseBoolean(enabledAttribute.getValue()));
            }
            Attribute ipPortAttribute = ldapServerElement.attribute(ATTRIBUTE_IP_PORT);
            if (ipPortAttribute == null) {
                throw new ServerXmlIOException(Messages.getString("ServerXmlIOV153.ErrorLdapServerPort"));
            }
            serverConfiguration.setLdapPort(Integer.parseInt(ipPortAttribute.getValue()));
            Attribute allowAnonymousAccessAttribute = ldapServerElement.attribute(ATTRIBUTE_ALLOW_ANONYMOUS_ACCESS);
            if (allowAnonymousAccessAttribute == null) {
                throw new ServerXmlIOException(Messages.getString("ServerXmlIOV153.ErrorAllowAnonymousAccess"));
            }
            serverConfiguration.setAllowAnonymousAccess(this.parseBoolean(allowAnonymousAccessAttribute.getValue()));
            Attribute saslHostAttribute = ldapServerElement.attribute(ATTRIBUTE_SASL_HOST);
            if (saslHostAttribute == null) {
                throw new ServerXmlIOException(Messages.getString("ServerXmlIOV153.ErrorSaslHost"));
            }
            serverConfiguration.setSaslHost(saslHostAttribute.getValue());
            Attribute saslPrincipalAttribute = ldapServerElement.attribute(ATTRIBUTE_SASL_PRINCIPAL);
            if (saslPrincipalAttribute == null) {
                throw new ServerXmlIOException(Messages.getString("ServerXmlIOV153.ErrorSaslPrincipal"));
            }
            serverConfiguration.setSaslPrincipal(saslPrincipalAttribute.getValue());
            Attribute searchBaseDnAttribute = ldapServerElement.attribute(ATTRIBUTE_SEARCH_BASE_DN);
            if (searchBaseDnAttribute == null) {
                throw new ServerXmlIOException(Messages.getString("ServerXmlIOV153.ErrorSearchBaseDn"));
            }
            serverConfiguration.setSearchBaseDn(searchBaseDnAttribute.getValue());
            Attribute maxTimeLimitAttribute = ldapServerElement.attribute(ATTRIBUTE_MAX_TIME_LIMIT);
            if (maxTimeLimitAttribute == null) {
                throw new ServerXmlIOException(Messages.getString("ServerXmlIOV153.ErrorMaxTimeLimit"));
            }
            serverConfiguration.setMaxTimeLimit(Integer.parseInt(maxTimeLimitAttribute.getValue()));
            Attribute maxSizeLimitAttribute = ldapServerElement.attribute(ATTRIBUTE_MAX_SIZE_LIMIT);
            if (maxSizeLimitAttribute == null) {
                throw new ServerXmlIOException(Messages.getString("ServerXmlIOV153.ErrorMaxSizeLimit"));
            }
            serverConfiguration.setMaxSizeLimit(Integer.parseInt(maxSizeLimitAttribute.getValue()));
            Element supportedMechanismsElement = ldapServerElement.element(ELEMENT_SASL_MECHANISM_HANDLERS);
            if (supportedMechanismsElement != null) {
                Iterator iterator = supportedMechanismsElement.elementIterator();
                while (iterator.hasNext()) {
                    Attribute ntlmProviderFcqnAttribute;
                    String mechNameValue;
                    Element supportedMechanismValueElement = (Element)iterator.next();
                    String supportedMechanismValue = supportedMechanismValueElement.getName();
                    Attribute mechNameAttribute = supportedMechanismValueElement.attribute(ATTRIBUTE_MECH_NAME);
                    String string = mechNameValue = mechNameAttribute == null ? null : mechNameAttribute.getValue();
                    if (ELEMENT_SIMPLE_MECHANISM_HANDLER.equalsIgnoreCase(supportedMechanismValue) && SUPPORTED_MECHANISM_SIMPLE.equalsIgnoreCase(mechNameValue)) {
                        serverConfiguration.addSupportedMechanism(SupportedMechanismEnum.SIMPLE);
                        continue;
                    }
                    if (ELEMENT_CRAM_MD5_MECHANISM_HANDLER.equalsIgnoreCase(supportedMechanismValue) && SUPPORTED_MECHANISM_CRAM_MD5.equalsIgnoreCase(mechNameValue)) {
                        serverConfiguration.addSupportedMechanism(SupportedMechanismEnum.CRAM_MD5);
                        continue;
                    }
                    if (ELEMENT_DIGEST_MD5_MECHANISM_HANDLER.equalsIgnoreCase(supportedMechanismValue) && SUPPORTED_MECHANISM_DIGEST_MD5.equalsIgnoreCase(mechNameValue)) {
                        serverConfiguration.addSupportedMechanism(SupportedMechanismEnum.DIGEST_MD5);
                        continue;
                    }
                    if (ELEMENT_GSSAPI_MECHANISM_HANDLER.equalsIgnoreCase(supportedMechanismValue) && SUPPORTED_MECHANISM_GSSAPI.equalsIgnoreCase(mechNameValue)) {
                        serverConfiguration.addSupportedMechanism(SupportedMechanismEnum.GSSAPI);
                        continue;
                    }
                    if (ELEMENT_NTLM_MECHANISM_HANDLER.equalsIgnoreCase(supportedMechanismValue) && SUPPORTED_MECHANISM_NTLM.equalsIgnoreCase(mechNameValue)) {
                        ntlmProviderFcqnAttribute = supportedMechanismValueElement.attribute(ATTRIBUTE_NTLM_PROVIDER_FQCN);
                        if (ntlmProviderFcqnAttribute != null) {
                            SupportedMechanismEnum ntlmSupportedMechanism = SupportedMechanismEnum.NTLM;
                            ntlmSupportedMechanism.setNtlmProviderFqcn(ntlmProviderFcqnAttribute.getValue());
                            serverConfiguration.addSupportedMechanism(ntlmSupportedMechanism);
                            continue;
                        }
                        serverConfiguration.addSupportedMechanism(SupportedMechanismEnum.NTLM);
                        continue;
                    }
                    if (!ELEMENT_NTLM_MECHANISM_HANDLER.equalsIgnoreCase(supportedMechanismValue) || !SUPPORTED_MECHANISM_GSS_SPNEGO.equalsIgnoreCase(mechNameValue)) continue;
                    ntlmProviderFcqnAttribute = supportedMechanismValueElement.attribute(ATTRIBUTE_NTLM_PROVIDER_FQCN);
                    if (ntlmProviderFcqnAttribute != null) {
                        SupportedMechanismEnum gssSpnegoSupportedMechanism = SupportedMechanismEnum.GSS_SPNEGO;
                        gssSpnegoSupportedMechanism.setNtlmProviderFqcn(ntlmProviderFcqnAttribute.getValue());
                        serverConfiguration.addSupportedMechanism(gssSpnegoSupportedMechanism);
                        continue;
                    }
                    serverConfiguration.addSupportedMechanism(SupportedMechanismEnum.GSS_SPNEGO);
                }
            }
            if ((SaslQopElement = ldapServerElement.element(ELEMENT_SASL_QOP)) != null) {
                Iterator iterator = SaslQopElement.elementIterator(ELEMENT_VALUE);
                while (iterator.hasNext()) {
                    Element saslQopValueElement = (Element)iterator.next();
                    String saslQopValue = saslQopValueElement.getText().trim();
                    if (SASL_QOP_AUTH.equalsIgnoreCase(saslQopValue)) {
                        serverConfiguration.addSaslQop(SaslQualityOfProtectionEnum.AUTH);
                        continue;
                    }
                    if (SASL_QOP_AUTH_INT.equalsIgnoreCase(saslQopValue)) {
                        serverConfiguration.addSaslQop(SaslQualityOfProtectionEnum.AUTH_INT);
                        continue;
                    }
                    if (!SASL_QOP_AUTH_CONF.equalsIgnoreCase(saslQopValue)) continue;
                    serverConfiguration.addSaslQop(SaslQualityOfProtectionEnum.AUTH_CONF);
                }
            }
            if ((SaslRealmsElement = ldapServerElement.element(ELEMENT_SASL_REALMS)) != null) {
                Iterator iterator = SaslRealmsElement.elementIterator(ELEMENT_VALUE);
                while (iterator.hasNext()) {
                    Element saslRealmValueElement = (Element)iterator.next();
                    serverConfiguration.addSaslRealm(saslRealmValueElement.getText().trim());
                }
            }
            this.readExtendedOperations(ldapServerElement, serverConfiguration);
            return;
        }
    }

    private void readExtendedOperations(Element element, ServerConfigurationV153 serverConfiguration) {
        Element interceptorsElement = element.element(ELEMENT_EXTENDED_OPERATION_HANDLERS);
        if (interceptorsElement != null) {
            Iterator i = interceptorsElement.elementIterator();
            while (i.hasNext()) {
                Element extendedOperationElement = (Element)i.next();
                String extendedOperationElementName = extendedOperationElement.getName();
                if (ELEMENT_START_TLS_HANDLER.equalsIgnoreCase(extendedOperationElementName)) {
                    serverConfiguration.addExtendedOperation(ExtendedOperationEnum.START_TLS);
                }
                if (ELEMENT_GRACEFUL_SHUTDOWN_HANDLER.equalsIgnoreCase(extendedOperationElementName)) {
                    serverConfiguration.addExtendedOperation(ExtendedOperationEnum.GRACEFUL_SHUTDOWN);
                }
                if (!ELEMENT_LAUNCH_DIAGNOSTIC_UI_HANDLER.equalsIgnoreCase(extendedOperationElementName)) continue;
                serverConfiguration.addExtendedOperation(ExtendedOperationEnum.LAUNCH_DIAGNOSTIC_UI);
            }
        }
    }

    private void readApacheDSBean(Element element, ServerConfigurationV153 serverConfiguration) throws ServerXmlIOException, NumberFormatException {
        Element apacheDsElement = element.element(ELEMENT_APACHE_DS);
        if (apacheDsElement != null) {
            Attribute synchPeriodMillisAttribute = apacheDsElement.attribute(ATTRIBUTE_SYNCH_PERIOD_MILLIS);
            if (synchPeriodMillisAttribute == null) {
                throw new ServerXmlIOException(Messages.getString("ServerXmlIOV153.ErrorSynchPeriodMillis"));
            }
            serverConfiguration.setSynchronizationPeriod(Integer.parseInt(synchPeriodMillisAttribute.getValue()));
        }
    }

    @Override
    public String toXml(ServerConfiguration serverConfiguration) throws IOException {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(new QName(ELEMENT_BEANS, NAMESPACE_XBEAN_SPRING));
        root.add(NAMESPACE_SPRINGFRAMEWORK);
        root.add(NAMESPACE_APACHEDS);
        this.createDefaultDirectoryServiceBean(root, (ServerConfigurationV153)serverConfiguration);
        Element standardThreadPoolElement = root.addElement(ELEMENT_STANDARD_THREAD_POOL);
        standardThreadPoolElement.addAttribute(ATTRIBUTE_ID, ELEMENT_STANDARD_THREAD_POOL);
        standardThreadPoolElement.addAttribute(ATTRIBUTE_MAX_THREADS, "" + ((ServerConfigurationV153)serverConfiguration).getMaxThreads());
        Element datagramAcceptorElement = root.addElement(ELEMENT_DATAGRAM_ACCEPTOR);
        datagramAcceptorElement.addAttribute(ATTRIBUTE_ID, ELEMENT_DATAGRAM_ACCEPTOR);
        datagramAcceptorElement.addAttribute(ELEMENT_LOGIC_EXECUTOR, "#standardThreadPool");
        Element socketAcceptorElement = root.addElement(ELEMENT_SOCKET_ACCEPTOR);
        socketAcceptorElement.addAttribute(ATTRIBUTE_ID, ELEMENT_SOCKET_ACCEPTOR);
        socketAcceptorElement.addAttribute(ELEMENT_LOGIC_EXECUTOR, "#standardThreadPool");
        this.createChangePasswordServerBean(root, (ServerConfigurationV153)serverConfiguration);
        this.createKdcServerBean(root, (ServerConfigurationV153)serverConfiguration);
        this.createNtpServerBean(root, (ServerConfigurationV153)serverConfiguration);
        this.createDnsServerBean(root, (ServerConfigurationV153)serverConfiguration);
        this.createLdapsServerBean(root, (ServerConfigurationV153)serverConfiguration);
        this.createLdapServerBean(root, (ServerConfigurationV153)serverConfiguration);
        this.createApacheDSBean(root, (ServerConfigurationV153)serverConfiguration);
        this.createCustomEditorConfigurerBean(root);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        OutputFormat outformat = OutputFormat.createPrettyPrint();
        outformat.setEncoding("UTF-8");
        XMLWriter writer = new XMLWriter((OutputStream)os, outformat);
        writer.write(document);
        writer.flush();
        writer.close();
        return ((Object)os).toString();
    }

    private void createDefaultDirectoryServiceBean(Element root, ServerConfigurationV153 serverConfiguration) {
        Element defaultDirectoryServiceElement = root.addElement(ELEMENT_DEFAULT_DIRECTORY_SERVICE);
        defaultDirectoryServiceElement.addAttribute(ATTRIBUTE_ID, VALUE_DIRECTORY_SERVICE);
        defaultDirectoryServiceElement.addAttribute(ATTRIBUTE_INSTANCE_ID, VALUE_DEFAULT);
        defaultDirectoryServiceElement.addAttribute(ATTRIBUTE_WORKING_DIRECTORY, VALUE_EXAMPLE_DOT_COM);
        defaultDirectoryServiceElement.addAttribute(ATTRIBUTE_ALLOW_ANONYMOUS_ACCESS, "" + serverConfiguration.isAllowAnonymousAccess());
        defaultDirectoryServiceElement.addAttribute(ATTRIBUTE_ACCESS_CONTROL_ENABLED, "" + serverConfiguration.isEnableAccessControl());
        defaultDirectoryServiceElement.addAttribute(ATTRIBUTE_DENORMALIZE_OP_ATTRS_ENABLED, "" + serverConfiguration.isDenormalizeOpAttr());
        Element systemPartitionElement = defaultDirectoryServiceElement.addElement(ELEMENT_SYSTEM_PARTITION);
        this.createSystemPartitionBean(systemPartitionElement, serverConfiguration);
        Element partitionsElement = defaultDirectoryServiceElement.addElement(ELEMENT_PARTITIONS);
        this.createUserPartitions(partitionsElement, serverConfiguration);
        Element interceptorsElement = defaultDirectoryServiceElement.addElement(ELEMENT_INTERCEPTORS);
        this.createInterceptors(interceptorsElement, serverConfiguration);
    }

    private void createSystemPartitionBean(Element systemPartitionElement, ServerConfigurationV153 serverConfiguration) {
        Partition systemPartition = null;
        for (Partition partition : serverConfiguration.getPartitions()) {
            if (!partition.isSystemPartition()) continue;
            systemPartition = partition;
            break;
        }
        if (systemPartition != null) {
            this.createPartition(systemPartitionElement, systemPartition);
        }
    }

    private void createUserPartitions(Element partitionsElement, ServerConfigurationV153 serverConfiguration) {
        for (Partition partition : serverConfiguration.getPartitions()) {
            if (partition.isSystemPartition()) continue;
            this.createPartition(partitionsElement, partition);
        }
    }

    private void createPartition(Element element, Partition partition) {
        Element jdbmPartitionElement = element.addElement(ELEMENT_JDBM_PARTITION);
        jdbmPartitionElement.addAttribute(ATTRIBUTE_ID, partition.getId());
        jdbmPartitionElement.addAttribute(ATTRIBUTE_CACHE_SIZE, "" + partition.getCacheSize());
        jdbmPartitionElement.addAttribute(ATTRIBUTE_SUFFIX, partition.getSuffix());
        jdbmPartitionElement.addAttribute(ATTRIBUTE_OPTIMIZER_ENABLED, "" + partition.isEnableOptimizer());
        jdbmPartitionElement.addAttribute(ATTRIBUTE_SYNC_ON_WRITE, "" + partition.isSynchronizationOnWrite());
        this.createIndexedAttributes(jdbmPartitionElement, partition.getIndexedAttributes());
        this.createContextEntry(jdbmPartitionElement, partition.getContextEntry(), partition.getId(), partition.getSuffix());
    }

    private void createIndexedAttributes(Element element, List<IndexedAttribute> indexedAttributes) {
        Element indexedAttributeElement = element.addElement(ELEMENT_INDEXED_ATTRIBUTES);
        if (indexedAttributes != null) {
            for (IndexedAttribute indexedAttribute : indexedAttributes) {
                Element jdbmIndexElement = indexedAttributeElement.addElement(ELEMENT_JDBM_INDEX);
                jdbmIndexElement.addAttribute(ATTRIBUTE_ATTRIBUTE_ID, indexedAttribute.getAttributeId());
                jdbmIndexElement.addAttribute(ATTRIBUTE_CACHE_SIZE, "" + indexedAttribute.getCacheSize());
            }
        }
    }

    private void createContextEntry(Element element, Attributes contextEntry, String id, String dn) {
        element.addElement(ELEMENT_CONTEXT_ENTRY).setText("#" + id + "ContextEntry");
        Element beanElement = element.getDocument().getRootElement().addElement(new QName(ELEMENT_BEAN, NAMESPACE_XBEAN_SPRING));
        beanElement.addAttribute(ATTRIBUTE_ID, id + "ContextEntry");
        beanElement.addAttribute(ATTRIBUTE_CLASS, "org.springframework.beans.factory.config.MethodInvokingFactoryBean");
        Element targetObjectPropertyElement = beanElement.addElement(new QName(ELEMENT_PROPERTY, NAMESPACE_XBEAN_SPRING));
        targetObjectPropertyElement.addAttribute(ATTRIBUTE_NAME, "targetObject");
        Element targetObjectRefElement = targetObjectPropertyElement.addElement(new QName(ELEMENT_REF, NAMESPACE_XBEAN_SPRING));
        targetObjectRefElement.addAttribute(ATTRIBUTE_LOCAL, VALUE_DIRECTORY_SERVICE);
        Element targetMethodPropertyElement = beanElement.addElement(new QName(ELEMENT_PROPERTY, NAMESPACE_XBEAN_SPRING));
        targetMethodPropertyElement.addAttribute(ATTRIBUTE_NAME, "targetMethod");
        targetMethodPropertyElement.addElement(new QName(ELEMENT_VALUE, NAMESPACE_XBEAN_SPRING)).setText("newEntry");
        Element argumentsPropertyElement = beanElement.addElement(new QName(ELEMENT_PROPERTY, NAMESPACE_XBEAN_SPRING));
        argumentsPropertyElement.addAttribute(ATTRIBUTE_NAME, VALUE_ARGUMENTS);
        Element argumentsListElement = argumentsPropertyElement.addElement(new QName(ELEMENT_LIST, NAMESPACE_XBEAN_SPRING));
        Element argumentsAttributesValueElement = argumentsListElement.addElement(new QName(ELEMENT_VALUE, new Namespace("spring", "http://www.springframework.org/schema/beans")));
        StringBuffer sb = new StringBuffer();
        NamingEnumeration<? extends javax.naming.directory.Attribute> ne = contextEntry.getAll();
        while (ne.hasMoreElements()) {
            javax.naming.directory.Attribute attribute = (javax.naming.directory.Attribute)ne.nextElement();
            try {
                NamingEnumeration<?> values = attribute.getAll();
                while (values.hasMoreElements()) {
                    sb.append(attribute.getID() + ": " + values.nextElement() + "\n");
                }
            }
            catch (NamingException e) {
            }
        }
        argumentsAttributesValueElement.setText(sb.toString());
        argumentsListElement.addElement(new QName(ELEMENT_VALUE, NAMESPACE_XBEAN_SPRING)).setText(dn);
    }

    private void createInterceptors(Element interceptorsElement, ServerConfigurationV153 serverConfiguration) {
        List<InterceptorEnum> interceptors = serverConfiguration.getInterceptors();
        if (interceptors.contains((Object)InterceptorEnum.NORMALIZATION)) {
            interceptorsElement.addElement(ELEMENT_NORMALIZATION_INTERCEPTOR);
        }
        if (interceptors.contains((Object)InterceptorEnum.AUTHENTICATION)) {
            interceptorsElement.addElement(ELEMENT_AUTHENTICATION_INTERCEPTOR);
        }
        if (interceptors.contains((Object)InterceptorEnum.REFERRAL)) {
            interceptorsElement.addElement(ELEMENT_REFERRAL_INTERCEPTOR);
        }
        if (interceptors.contains((Object)InterceptorEnum.ACI_AUTHORIZATION)) {
            interceptorsElement.addElement(ELEMENT_ACI_AUTHORIZATION_INTERCEPTOR);
        }
        if (interceptors.contains((Object)InterceptorEnum.DEFAULT_AUTHORIZATION)) {
            interceptorsElement.addElement(ELEMENT_DEFAULT_AUTHORIZATION_INTERCEPTOR);
        }
        if (interceptors.contains((Object)InterceptorEnum.EXCEPTION)) {
            interceptorsElement.addElement(ELEMENT_EXCEPTION_INTERCEPTOR);
        }
        if (interceptors.contains((Object)InterceptorEnum.OPERATIONAL_ATTRIBUTE)) {
            interceptorsElement.addElement(ELEMENT_OPERATIONAL_ATTRIBUTE_INTERCEPTOR);
        }
        if (interceptors.contains((Object)InterceptorEnum.SCHEMA)) {
            interceptorsElement.addElement(ELEMENT_SCHEMA_INTERCEPTOR);
        }
        if (interceptors.contains((Object)InterceptorEnum.SUBENTRY)) {
            interceptorsElement.addElement(ELEMENT_SUBENTRY_INTERCEPTOR);
        }
        if (interceptors.contains((Object)InterceptorEnum.COLLECTIVE_ATTRIBUTE)) {
            interceptorsElement.addElement(ELEMENT_COLLECTIVE_ATTRIBUTE_INTERCEPTOR);
        }
        if (interceptors.contains((Object)InterceptorEnum.EVENT)) {
            interceptorsElement.addElement(ELEMENT_EVENT_INTERCEPTOR);
        }
        if (interceptors.contains((Object)InterceptorEnum.TRIGGER)) {
            interceptorsElement.addElement(ELEMENT_TRIGGER_INTERCEPTOR);
        }
        if (interceptors.contains((Object)InterceptorEnum.REPLICATION)) {
            // empty if block
        }
    }

    private void createChangePasswordServerBean(Element root, ServerConfigurationV153 serverConfiguration) {
        if (serverConfiguration.isEnableChangePassword()) {
            Element changePasswordServerElement = root.addElement(ELEMENT_CHANGE_PASSWORD_SERVER);
            changePasswordServerElement.addAttribute(ATTRIBUTE_ENABLED, "" + serverConfiguration.isEnableChangePassword());
            changePasswordServerElement.addAttribute(ATTRIBUTE_IP_PORT, "" + serverConfiguration.getChangePasswordPort());
            changePasswordServerElement.addElement(VALUE_DIRECTORY_SERVICE).setText("#directoryService");
            changePasswordServerElement.addElement(ELEMENT_DATAGRAM_ACCEPTOR).setText("#datagramAcceptor");
            changePasswordServerElement.addElement(ELEMENT_SOCKET_ACCEPTOR).setText("#socketAcceptor");
        }
    }

    private void createKdcServerBean(Element root, ServerConfigurationV153 serverConfiguration) {
        if (serverConfiguration.isEnableKerberos()) {
            Element kdcServerElement = root.addElement(ELEMENT_KDC_SERVER);
            kdcServerElement.addAttribute(ATTRIBUTE_ENABLED, "" + serverConfiguration.isEnableKerberos());
            kdcServerElement.addAttribute(ATTRIBUTE_IP_PORT, "" + serverConfiguration.getKerberosPort());
            kdcServerElement.addElement(VALUE_DIRECTORY_SERVICE).setText("#directoryService");
            kdcServerElement.addElement(ELEMENT_DATAGRAM_ACCEPTOR).setText("#datagramAcceptor");
            kdcServerElement.addElement(ELEMENT_SOCKET_ACCEPTOR).setText("#socketAcceptor");
        }
    }

    private void createNtpServerBean(Element root, ServerConfigurationV153 serverConfiguration) {
        if (serverConfiguration.isEnableNtp()) {
            Element ntpServerElement = root.addElement(ELEMENT_NTP_SERVER);
            ntpServerElement.addAttribute(ATTRIBUTE_ENABLED, "" + serverConfiguration.isEnableNtp());
            ntpServerElement.addAttribute(ATTRIBUTE_IP_PORT, "" + serverConfiguration.getNtpPort());
            ntpServerElement.addElement(ELEMENT_DATAGRAM_ACCEPTOR).setText("#datagramAcceptor");
            ntpServerElement.addElement(ELEMENT_SOCKET_ACCEPTOR).setText("#socketAcceptor");
        }
    }

    private void createDnsServerBean(Element root, ServerConfigurationV153 serverConfiguration) {
        if (serverConfiguration.isEnableDns()) {
            Element dnsServerElement = root.addElement(ELEMENT_DNS_SERVER);
            dnsServerElement.addAttribute(ATTRIBUTE_ENABLED, "" + serverConfiguration.isEnableDns());
            dnsServerElement.addAttribute(ATTRIBUTE_IP_PORT, "" + serverConfiguration.getDnsPort());
            dnsServerElement.addElement(VALUE_DIRECTORY_SERVICE).setText("#directoryService");
            dnsServerElement.addElement(ELEMENT_DATAGRAM_ACCEPTOR).setText("#datagramAcceptor");
            dnsServerElement.addElement(ELEMENT_SOCKET_ACCEPTOR).setText("#socketAcceptor");
        }
    }

    private void createLdapsServerBean(Element root, ServerConfigurationV153 serverConfiguration) {
        Element ldapServerElement = root.addElement(ELEMENT_LDAP_SERVER);
        ldapServerElement.addAttribute(ATTRIBUTE_ID, ELEMENT_LDAPS_SERVER);
        ldapServerElement.addAttribute(ATTRIBUTE_IP_PORT, "" + serverConfiguration.getLdapsPort());
        ldapServerElement.addAttribute(ATTRIBUTE_ENABLED, "" + serverConfiguration.isEnableLdaps());
        ldapServerElement.addAttribute(ATTRIBUTE_ENABLE_LDAPS, "" + serverConfiguration.isEnableLdaps());
        ldapServerElement.addElement(VALUE_DIRECTORY_SERVICE).setText("#directoryService");
        ldapServerElement.addElement(ELEMENT_SOCKET_ACCEPTOR).setText("#socketAcceptor");
    }

    private void createLdapServerBean(Element root, ServerConfigurationV153 serverConfiguration) {
        Element ldapServerElement = root.addElement(ELEMENT_LDAP_SERVER);
        ldapServerElement.addAttribute(ATTRIBUTE_ID, ELEMENT_LDAP_SERVER);
        ldapServerElement.addAttribute(ATTRIBUTE_ENABLED, "" + serverConfiguration.isEnableLdap());
        ldapServerElement.addAttribute(ATTRIBUTE_IP_PORT, "" + serverConfiguration.getLdapPort());
        ldapServerElement.addAttribute(ATTRIBUTE_ALLOW_ANONYMOUS_ACCESS, "" + serverConfiguration.isAllowAnonymousAccess());
        ldapServerElement.addAttribute(ATTRIBUTE_SASL_HOST, "" + serverConfiguration.getSaslHost());
        ldapServerElement.addAttribute(ATTRIBUTE_SASL_PRINCIPAL, "" + serverConfiguration.getSaslPrincipal());
        ldapServerElement.addAttribute(ATTRIBUTE_SEARCH_BASE_DN, "ou=users,ou=system");
        ldapServerElement.addAttribute(ATTRIBUTE_MAX_TIME_LIMIT, "" + serverConfiguration.getMaxTimeLimit());
        ldapServerElement.addAttribute(ATTRIBUTE_MAX_SIZE_LIMIT, "" + serverConfiguration.getMaxSizeLimit());
        ldapServerElement.addElement(VALUE_DIRECTORY_SERVICE).setText("#directoryService");
        ldapServerElement.addElement(ELEMENT_SOCKET_ACCEPTOR).setText("#socketAcceptor");
        Element saslMechanismHandlersElement = ldapServerElement.addElement(ELEMENT_SASL_MECHANISM_HANDLERS);
        for (SupportedMechanismEnum supportedMechanism : serverConfiguration.getSupportedMechanisms()) {
            switch (supportedMechanism) {
                case SIMPLE: {
                    Element simpleMechanismHandlerElement = saslMechanismHandlersElement.addElement(ELEMENT_SIMPLE_MECHANISM_HANDLER);
                    simpleMechanismHandlerElement.addAttribute(ATTRIBUTE_MECH_NAME, SUPPORTED_MECHANISM_SIMPLE);
                    break;
                }
                case CRAM_MD5: {
                    Element cramMd5MechanismHandlerElement = saslMechanismHandlersElement.addElement(ELEMENT_CRAM_MD5_MECHANISM_HANDLER);
                    cramMd5MechanismHandlerElement.addAttribute(ATTRIBUTE_MECH_NAME, SUPPORTED_MECHANISM_CRAM_MD5);
                    cramMd5MechanismHandlerElement.addAttribute(VALUE_DIRECTORY_SERVICE, "#directoryService");
                    break;
                }
                case DIGEST_MD5: {
                    Element digestMd5MechanismHandlerElement = saslMechanismHandlersElement.addElement(ELEMENT_DIGEST_MD5_MECHANISM_HANDLER);
                    digestMd5MechanismHandlerElement.addAttribute(ATTRIBUTE_MECH_NAME, SUPPORTED_MECHANISM_DIGEST_MD5);
                    digestMd5MechanismHandlerElement.addAttribute(VALUE_DIRECTORY_SERVICE, "#directoryService");
                    break;
                }
                case GSSAPI: {
                    Element gssapiMechanismHandlerElement = saslMechanismHandlersElement.addElement(ELEMENT_GSSAPI_MECHANISM_HANDLER);
                    gssapiMechanismHandlerElement.addAttribute(ATTRIBUTE_MECH_NAME, SUPPORTED_MECHANISM_GSSAPI);
                    gssapiMechanismHandlerElement.addAttribute(VALUE_DIRECTORY_SERVICE, "#directoryService");
                    break;
                }
                case NTLM: {
                    Element ntlmMechanismHandlerElement = saslMechanismHandlersElement.addElement(ELEMENT_NTLM_MECHANISM_HANDLER);
                    ntlmMechanismHandlerElement.addAttribute(ATTRIBUTE_MECH_NAME, SUPPORTED_MECHANISM_NTLM);
                    ntlmMechanismHandlerElement.addAttribute(ATTRIBUTE_NTLM_PROVIDER_FQCN, supportedMechanism.getNtlmProviderFqcn());
                    break;
                }
                case GSS_SPNEGO: {
                    Element gssSpnegoMechanismHandlerElement = saslMechanismHandlersElement.addElement(ELEMENT_NTLM_MECHANISM_HANDLER);
                    gssSpnegoMechanismHandlerElement.addAttribute(ATTRIBUTE_MECH_NAME, SUPPORTED_MECHANISM_GSS_SPNEGO);
                    gssSpnegoMechanismHandlerElement.addAttribute(ATTRIBUTE_NTLM_PROVIDER_FQCN, supportedMechanism.getNtlmProviderFqcn());
                }
            }
        }
        Element saslQopElement = ldapServerElement.addElement(ELEMENT_SASL_QOP);
        for (SaslQualityOfProtectionEnum saslQop : serverConfiguration.getSaslQops()) {
            switch (saslQop) {
                case AUTH: {
                    saslQopElement.addElement(new QName(ELEMENT_VALUE, NAMESPACE_SPRINGFRAMEWORK)).setText(SASL_QOP_AUTH);
                    break;
                }
                case AUTH_INT: {
                    saslQopElement.addElement(new QName(ELEMENT_VALUE, NAMESPACE_SPRINGFRAMEWORK)).setText(SASL_QOP_AUTH_INT);
                    break;
                }
                case AUTH_CONF: {
                    saslQopElement.addElement(new QName(ELEMENT_VALUE, NAMESPACE_SPRINGFRAMEWORK)).setText(SASL_QOP_AUTH_CONF);
                }
            }
        }
        Element saslRealmsElement = ldapServerElement.addElement(ELEMENT_SASL_REALMS);
        for (String saslRealm : serverConfiguration.getSaslRealms()) {
            saslRealmsElement.addElement(new QName(ELEMENT_VALUE, NAMESPACE_SPRINGFRAMEWORK)).setText(saslRealm);
        }
        Element extendedOperationsElement = ldapServerElement.addElement(ELEMENT_EXTENDED_OPERATION_HANDLERS);
        List<ExtendedOperationEnum> extendedOperations = serverConfiguration.getExtendedOperations();
        if (extendedOperations.contains((Object)ExtendedOperationEnum.START_TLS)) {
            extendedOperationsElement.addElement(ELEMENT_START_TLS_HANDLER);
        }
        if (extendedOperations.contains((Object)ExtendedOperationEnum.GRACEFUL_SHUTDOWN)) {
            extendedOperationsElement.addElement(ELEMENT_GRACEFUL_SHUTDOWN_HANDLER);
        }
        if (extendedOperations.contains((Object)ExtendedOperationEnum.LAUNCH_DIAGNOSTIC_UI)) {
            extendedOperationsElement.addElement(ELEMENT_LAUNCH_DIAGNOSTIC_UI_HANDLER);
        }
    }

    private void createApacheDSBean(Element root, ServerConfigurationV153 serverConfiguration) {
        Element apacheDSElement = root.addElement(ELEMENT_APACHE_DS);
        apacheDSElement.addAttribute(ATTRIBUTE_ID, ELEMENT_APACHE_DS);
        apacheDSElement.addAttribute(ATTRIBUTE_SYNCH_PERIOD_MILLIS, "" + serverConfiguration.getSynchronizationPeriod());
        apacheDSElement.addAttribute(ATTRIBUTE_ALLOW_ANONYMOUS_ACCESS, "" + serverConfiguration.isAllowAnonymousAccess());
        apacheDSElement.addElement(VALUE_DIRECTORY_SERVICE).setText("#directoryService");
        apacheDSElement.addElement(ELEMENT_LDAP_SERVER).setText("#ldapServer");
        apacheDSElement.addElement(ELEMENT_LDAPS_SERVER).setText("#ldapsServer");
    }

    private void createCustomEditorConfigurerBean(Element root) {
        Element beanElement = root.addElement(new QName(ELEMENT_BEAN, NAMESPACE_XBEAN_SPRING));
        beanElement.addAttribute(ATTRIBUTE_CLASS, "org.springframework.beans.factory.config.CustomEditorConfigurer");
        Element propertyElement = beanElement.addElement(new QName(ELEMENT_PROPERTY, NAMESPACE_XBEAN_SPRING));
        propertyElement.addAttribute(ATTRIBUTE_NAME, VALUE_CUSTOM_EDITORS);
        Element mapElement = propertyElement.addElement(new QName(ELEMENT_MAP, NAMESPACE_XBEAN_SPRING));
        Element entryElement = mapElement.addElement(new QName(ELEMENT_ENTRY, NAMESPACE_XBEAN_SPRING));
        entryElement.addAttribute(ATTRIBUTE_KEY, "javax.naming.directory.Attributes");
        Element innerBeanElement = entryElement.addElement(new QName(ELEMENT_BEAN, NAMESPACE_XBEAN_SPRING));
        innerBeanElement.addAttribute(ATTRIBUTE_CLASS, "org.apache.directory.server.core.configuration.AttributesPropertyEditor");
    }
}

