/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.model.v151;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import org.apache.directory.studio.apacheds.configuration.StudioEntityResolver;
import org.apache.directory.studio.apacheds.configuration.model.AbstractServerXmlIO;
import org.apache.directory.studio.apacheds.configuration.model.ServerConfiguration;
import org.apache.directory.studio.apacheds.configuration.model.ServerXmlIO;
import org.apache.directory.studio.apacheds.configuration.model.ServerXmlIOException;
import org.apache.directory.studio.apacheds.configuration.model.v151.ExtendedOperation;
import org.apache.directory.studio.apacheds.configuration.model.v151.IndexedAttribute;
import org.apache.directory.studio.apacheds.configuration.model.v151.Interceptor;
import org.apache.directory.studio.apacheds.configuration.model.v151.Messages;
import org.apache.directory.studio.apacheds.configuration.model.v151.Partition;
import org.apache.directory.studio.apacheds.configuration.model.v151.ServerConfigurationV151;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerXmlIOV151
extends AbstractServerXmlIO
implements ServerXmlIO {
    @Override
    protected boolean isValid(Document document) {
        Iterator i = document.getRootElement().elementIterator("bean");
        while (i.hasNext()) {
            String partitionId;
            Element element = (Element)i.next();
            Attribute classAttribute = element.attribute("class");
            if (classAttribute == null || !classAttribute.getValue().equals("org.apache.directory.server.core.partition.impl.btree.MutableBTreePartitionConfiguration") || (partitionId = this.readBeanProperty("id", element)) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public ServerConfiguration parse(InputStream is) throws ServerXmlIOException {
        try {
            SAXReader reader = new SAXReader();
            reader.setEntityResolver((EntityResolver)new StudioEntityResolver());
            Document document = reader.read(is);
            ServerConfigurationV151 serverConfiguration = new ServerConfigurationV151();
            this.parse(document, serverConfiguration);
            return serverConfiguration;
        }
        catch (Exception e) {
            if (e instanceof ServerXmlIOException) {
                throw (ServerXmlIOException)e;
            }
            ServerXmlIOException exception = new ServerXmlIOException(e.getMessage(), e.getCause());
            exception.setStackTrace(e.getStackTrace());
            throw exception;
        }
    }

    private void parse(Document document, ServerConfigurationV151 serverConfiguration) throws NumberFormatException, AbstractServerXmlIO.BooleanFormatException, ServerXmlIOException {
        this.readEnvironmentBean(document, serverConfiguration);
        this.readChangePasswordConfigurationBean(document, serverConfiguration);
        this.readNTPConfigurationBean(document, serverConfiguration);
        this.readDNSConfigurationBean(document, serverConfiguration);
        this.readKDCConfigurationBean(document, serverConfiguration);
        this.readLDAPSConfigurationBean(document, serverConfiguration);
        this.readLDAPConfigurationBean(document, serverConfiguration);
        this.readConfigurationBean(document, serverConfiguration);
    }

    private void readEnvironmentBean(Document document, ServerConfigurationV151 serverConfiguration) {
        String binaryAttributes;
        String password;
        Element environmentBean = this.getBeanElementById(document, "environment");
        String principal = this.readEnvironmentBeanProperty("java.naming.security.principal", environmentBean);
        if (principal != null) {
            serverConfiguration.setPrincipal(principal);
        }
        if ((password = this.readEnvironmentBeanProperty("java.naming.security.credentials", environmentBean)) != null) {
            serverConfiguration.setPassword(password);
        }
        if ((binaryAttributes = this.readEnvironmentBeanProperty("java.naming.ldap.attributes.binary", environmentBean)) != null) {
            String[] attributes;
            for (String attribute : attributes = binaryAttributes.split(" ")) {
                serverConfiguration.addBinaryAttribute(attribute);
            }
        }
    }

    private String readEnvironmentBeanProperty(String property, Element element) {
        Element propsElement;
        Element propertyElement = element.element("property");
        if (propertyElement != null && (propsElement = propertyElement.element("props")) != null) {
            Iterator i = propsElement.elementIterator("prop");
            while (i.hasNext()) {
                Element propElement = (Element)i.next();
                Attribute keyAttribute = propElement.attribute("key");
                if (keyAttribute == null || !keyAttribute.getValue().equals(property)) continue;
                return propElement.getText();
            }
        }
        return null;
    }

    private void readChangePasswordConfigurationBean(Document document, ServerConfigurationV151 serverConfiguration) throws AbstractServerXmlIO.BooleanFormatException, NumberFormatException {
        String ipPort;
        Element changePasswordConfigurationBean = this.getBeanElementById(document, "changePasswordConfiguration");
        String enabled = this.readBeanProperty("enabled", changePasswordConfigurationBean);
        if (enabled != null) {
            serverConfiguration.setEnableChangePassword(this.parseBoolean(enabled));
        }
        if ((ipPort = this.readBeanProperty("ipPort", changePasswordConfigurationBean)) != null) {
            serverConfiguration.setChangePasswordPort(Integer.parseInt(ipPort));
        }
    }

    private void readNTPConfigurationBean(Document document, ServerConfigurationV151 serverConfiguration) throws AbstractServerXmlIO.BooleanFormatException, NumberFormatException {
        String ipPort;
        Element ntpConfigurationBean = this.getBeanElementById(document, "ntpConfiguration");
        String enabled = this.readBeanProperty("enabled", ntpConfigurationBean);
        if (enabled != null) {
            serverConfiguration.setEnableNtp(this.parseBoolean(enabled));
        }
        if ((ipPort = this.readBeanProperty("ipPort", ntpConfigurationBean)) != null) {
            serverConfiguration.setNtpPort(Integer.parseInt(ipPort));
        }
    }

    private void readDNSConfigurationBean(Document document, ServerConfigurationV151 serverConfiguration) throws AbstractServerXmlIO.BooleanFormatException, NumberFormatException {
        String ipPort;
        Element dnsConfigurationBean = this.getBeanElementById(document, "dnsConfiguration");
        String enabled = this.readBeanProperty("enabled", dnsConfigurationBean);
        if (enabled != null) {
            serverConfiguration.setEnableDns(this.parseBoolean(enabled));
        }
        if ((ipPort = this.readBeanProperty("ipPort", dnsConfigurationBean)) != null) {
            serverConfiguration.setDnsPort(Integer.parseInt(ipPort));
        }
    }

    private void readKDCConfigurationBean(Document document, ServerConfigurationV151 serverConfiguration) throws AbstractServerXmlIO.BooleanFormatException, NumberFormatException {
        String ipPort;
        Element kdcConfigurationBean = this.getBeanElementById(document, "kdcConfiguration");
        String enabled = this.readBeanProperty("enabled", kdcConfigurationBean);
        if (enabled != null) {
            serverConfiguration.setEnableKerberos(this.parseBoolean(enabled));
        }
        if ((ipPort = this.readBeanProperty("ipPort", kdcConfigurationBean)) != null) {
            serverConfiguration.setKerberosPort(Integer.parseInt(ipPort));
        }
    }

    private void readLDAPSConfigurationBean(Document document, ServerConfigurationV151 serverConfiguration) throws AbstractServerXmlIO.BooleanFormatException, NumberFormatException {
        String ipPort;
        Element ldapsConfiguration = this.getBeanElementById(document, "ldapsConfiguration");
        String enabled = this.readBeanProperty("enabled", ldapsConfiguration);
        if (enabled != null) {
            serverConfiguration.setEnableLdaps(this.parseBoolean(enabled));
        }
        if ((ipPort = this.readBeanProperty("ipPort", ldapsConfiguration)) != null) {
            serverConfiguration.setLdapsPort(Integer.parseInt(ipPort));
        }
    }

    private void readLDAPConfigurationBean(Document document, ServerConfigurationV151 serverConfiguration) throws AbstractServerXmlIO.BooleanFormatException, NumberFormatException {
        String maxSizeLimit;
        String maxTimeLimit;
        String searchBaseDn;
        Element listElement;
        Element listElement2;
        Element saslQopElement;
        String saslPrincipal;
        String saslHost;
        Element listElement3;
        Element supportedMechanismsElement;
        String allowAnonymousAccess;
        Element ldapConfiguration = this.getBeanElementById(document, "ldapConfiguration");
        String enabled = this.readBeanProperty("enabled", ldapConfiguration);
        if (enabled != null) {
            serverConfiguration.setEnableLdap(this.parseBoolean(enabled));
        } else {
            serverConfiguration.setEnableLdap(true);
        }
        String ipPort = this.readBeanProperty("ipPort", ldapConfiguration);
        if (ipPort != null) {
            serverConfiguration.setLdapPort(Integer.parseInt(ipPort));
        }
        if ((allowAnonymousAccess = this.readBeanProperty("allowAnonymousAccess", ldapConfiguration)) != null) {
            serverConfiguration.setAllowAnonymousAccess(this.parseBoolean(allowAnonymousAccess));
        }
        if ((supportedMechanismsElement = this.getBeanPropertyElement("supportedMechanisms", ldapConfiguration)) != null && (listElement3 = supportedMechanismsElement.element("list")) != null) {
            Iterator i = listElement3.elementIterator("value");
            while (i.hasNext()) {
                serverConfiguration.addSupportedMechanism(((Element)i.next()).getTextTrim());
            }
        }
        if ((saslHost = this.readBeanProperty("saslHost", ldapConfiguration)) != null) {
            serverConfiguration.setSaslHost(saslHost);
        }
        if ((saslPrincipal = this.readBeanProperty("saslPrincipal", ldapConfiguration)) != null) {
            serverConfiguration.setSaslPrincipal(saslPrincipal);
        }
        if ((saslQopElement = this.getBeanPropertyElement("saslQop", ldapConfiguration)) != null && (listElement2 = saslQopElement.element("list")) != null) {
            Iterator i = listElement2.elementIterator("value");
            while (i.hasNext()) {
                serverConfiguration.addSaslQop(((Element)i.next()).getTextTrim());
            }
        }
        Element saslRealmsElement = this.getBeanPropertyElement("saslRealms", ldapConfiguration);
        if (saslQopElement != null && (listElement = saslRealmsElement.element("list")) != null) {
            Iterator i = listElement.elementIterator("value");
            while (i.hasNext()) {
                serverConfiguration.addSaslRealm(((Element)i.next()).getTextTrim());
            }
        }
        if ((searchBaseDn = this.readBeanProperty("searchBaseDn", ldapConfiguration)) != null) {
            serverConfiguration.setSearchBaseDn(searchBaseDn);
        }
        if ((maxTimeLimit = this.readBeanProperty("maxTimeLimit", ldapConfiguration)) != null) {
            serverConfiguration.setMaxTimeLimit(Integer.parseInt(maxTimeLimit));
        }
        if ((maxSizeLimit = this.readBeanProperty("maxSizeLimit", ldapConfiguration)) != null) {
            serverConfiguration.setMaxSizeLimit(Integer.parseInt(maxSizeLimit));
        }
        this.readExtendedOperations(ldapConfiguration, serverConfiguration);
    }

    private void readConfigurationBean(Document document, ServerConfigurationV151 serverConfiguration) throws NumberFormatException, AbstractServerXmlIO.BooleanFormatException, ServerXmlIOException {
        String systemPartitionConfiguration;
        String denormalizeOpAttrsEnabled;
        String accessControlEnabled;
        String allowAnonymousAccess;
        String maxThreads;
        Element configurationBean = this.getBeanElementById(document, "configuration");
        String synchPeriodMillis = this.readBeanProperty("synchPeriodMillis", configurationBean);
        if (synchPeriodMillis != null) {
            serverConfiguration.setSynchronizationPeriod(Long.parseLong(synchPeriodMillis));
        }
        if ((maxThreads = this.readBeanProperty("maxThreads", configurationBean)) != null) {
            serverConfiguration.setMaxThreads(Integer.parseInt(maxThreads));
        }
        if ((allowAnonymousAccess = this.readBeanProperty("allowAnonymousAccess", configurationBean)) != null) {
            serverConfiguration.setAllowAnonymousAccess(this.parseBoolean(allowAnonymousAccess));
        }
        if ((accessControlEnabled = this.readBeanProperty("accessControlEnabled", configurationBean)) != null) {
            serverConfiguration.setEnableAccessControl(this.parseBoolean(accessControlEnabled));
        }
        if ((denormalizeOpAttrsEnabled = this.readBeanProperty("denormalizeOpAttrsEnabled", configurationBean)) != null) {
            serverConfiguration.setDenormalizeOpAttr(this.parseBoolean(denormalizeOpAttrsEnabled));
        }
        if ((systemPartitionConfiguration = this.readBeanProperty("systemPartitionConfiguration", configurationBean)) != null) {
            Partition systemPartition = this.readPartition(document, systemPartitionConfiguration, true);
            if (systemPartition != null) {
                serverConfiguration.addPartition(systemPartition);
            }
        } else {
            throw new ServerXmlIOException(Messages.getString("ServerXmlIOV151.55"));
        }
        this.readOtherPartitions(configurationBean, serverConfiguration);
        this.readInterceptors(configurationBean, serverConfiguration);
    }

    private void readOtherPartitions(Element configurationBean, ServerConfigurationV151 serverConfiguration) throws NumberFormatException, AbstractServerXmlIO.BooleanFormatException {
        Element setElement;
        Element propertyElement = this.getBeanPropertyElement("partitionConfigurations", configurationBean);
        if (propertyElement != null && (setElement = propertyElement.element("set")) != null) {
            Iterator i = setElement.elementIterator("ref");
            while (i.hasNext()) {
                Partition partition;
                Element element = (Element)i.next();
                Attribute beanAttribute = element.attribute("bean");
                if (beanAttribute == null || (partition = this.readPartition(configurationBean.getDocument(), beanAttribute.getValue(), false)) == null) continue;
                serverConfiguration.addPartition(partition);
            }
        }
    }

    private Partition readPartition(Document document, String id, boolean isSystemPartition) throws AbstractServerXmlIO.BooleanFormatException, NumberFormatException {
        Element partitionBean = this.getBeanElementById(document, id);
        if (partitionBean != null) {
            String synchOnWrite;
            String optimizerEnabled;
            String suffix;
            String cacheSize;
            Partition partition = new Partition();
            partition.setSystemPartition(isSystemPartition);
            String partitionId = this.readBeanProperty("id", partitionBean);
            if (partitionId != null) {
                partition.setId(partitionId);
            }
            if ((cacheSize = this.readBeanProperty("cacheSize", partitionBean)) != null) {
                partition.setCacheSize(Integer.parseInt(cacheSize));
            }
            if ((suffix = this.readBeanProperty("suffix", partitionBean)) != null) {
                partition.setSuffix(suffix);
            }
            if ((optimizerEnabled = this.readBeanProperty("optimizerEnabled", partitionBean)) != null) {
                partition.setEnableOptimizer(this.parseBoolean(optimizerEnabled));
            }
            if ((synchOnWrite = this.readBeanProperty("synchOnWrite", partitionBean)) != null) {
                partition.setSynchronizationOnWrite(this.parseBoolean(synchOnWrite));
            }
            partition.setIndexedAttributes(this.readPartitionIndexedAttributes(partitionBean));
            partition.setContextEntry(this.readPartitionContextEntry(partitionBean));
            return partition;
        }
        return null;
    }

    private List<IndexedAttribute> readPartitionIndexedAttributes(Element partitionBean) throws NumberFormatException {
        Element setElement;
        ArrayList<IndexedAttribute> indexedAttributes = new ArrayList<IndexedAttribute>();
        Element propertyElement = this.getBeanPropertyElement("indexedAttributes", partitionBean);
        if (propertyElement != null && (setElement = propertyElement.element("set")) != null) {
            Iterator i = setElement.elementIterator("bean");
            while (i.hasNext()) {
                Element beanElement = (Element)i.next();
                IndexedAttribute ia = this.readIndexedAttribute(beanElement);
                if (ia == null) continue;
                indexedAttributes.add(ia);
            }
        }
        return indexedAttributes;
    }

    private IndexedAttribute readIndexedAttribute(Element beanElement) throws NumberFormatException {
        Attribute classAttribute = beanElement.attribute("class");
        if (classAttribute != null && classAttribute.getValue().equals("org.apache.directory.server.core.partition.impl.btree.MutableIndexConfiguration")) {
            String attributeId = this.readBeanProperty("attributeId", beanElement);
            String cacheSize = this.readBeanProperty("cacheSize", beanElement);
            if (attributeId != null && cacheSize != null) {
                return new IndexedAttribute(attributeId, Integer.parseInt(cacheSize));
            }
        }
        return null;
    }

    private Attributes readPartitionContextEntry(Element partitionBean) {
        Element valueElement;
        Element propertyElement = this.getBeanPropertyElement("contextEntry", partitionBean);
        if (propertyElement != null && (valueElement = propertyElement.element("value")) != null) {
            return this.readContextEntry(valueElement.getText());
        }
        return new BasicAttributes(true);
    }

    private void readInterceptors(Element configurationBean, ServerConfigurationV151 serverConfiguration) {
        Element listElement;
        Element propertyElement = this.getBeanPropertyElement("interceptorConfigurations", configurationBean);
        if (propertyElement != null && (listElement = propertyElement.element("list")) != null) {
            Iterator i = listElement.elementIterator("bean");
            while (i.hasNext()) {
                Interceptor interceptor = this.readInterceptor((Element)i.next());
                if (interceptor == null) continue;
                serverConfiguration.addInterceptor(interceptor);
            }
        }
    }

    private Interceptor readInterceptor(Element element) {
        Attribute classAttribute = element.attribute("class");
        if (classAttribute != null && classAttribute.getValue().equals("org.apache.directory.server.core.configuration.MutableInterceptorConfiguration")) {
            String name = this.readBeanProperty("name", element);
            String interceptorClassName = this.readBeanProperty("interceptorClassName", element);
            if (name != null && interceptorClassName != null) {
                Interceptor interceptor = new Interceptor(name);
                interceptor.setClassType(interceptorClassName);
                return interceptor;
            }
        }
        return null;
    }

    private void readExtendedOperations(Element configurationBean, ServerConfigurationV151 serverConfiguration) {
        Element listElement;
        Element propertyElement = this.getBeanPropertyElement("extendedOperationHandlers", configurationBean);
        if (propertyElement != null && (listElement = propertyElement.element("list")) != null) {
            Iterator i = listElement.elementIterator("bean");
            while (i.hasNext()) {
                ExtendedOperation extendedOperation = this.readExtendedOperation((Element)i.next());
                if (extendedOperation == null) continue;
                serverConfiguration.addExtendedOperation(extendedOperation);
            }
        }
    }

    private ExtendedOperation readExtendedOperation(Element element) {
        Attribute classAttribute = element.attribute("class");
        if (classAttribute != null) {
            return new ExtendedOperation(classAttribute.getValue());
        }
        return null;
    }

    @Override
    public String toXml(ServerConfiguration serverConfiguration) throws IOException {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("beans");
        ServerXmlIOV151.createEnvironmentBean(root, (ServerConfigurationV151)serverConfiguration);
        ServerXmlIOV151.createChangePasswordConfigurationBean(root, (ServerConfigurationV151)serverConfiguration);
        ServerXmlIOV151.createNtpConfigurationBean(root, (ServerConfigurationV151)serverConfiguration);
        ServerXmlIOV151.createDnsConfigurationBean(root, (ServerConfigurationV151)serverConfiguration);
        ServerXmlIOV151.createKdcConfigurationBean(root, (ServerConfigurationV151)serverConfiguration);
        ServerXmlIOV151.createLdapsConfigurationBean(root, (ServerConfigurationV151)serverConfiguration);
        ServerXmlIOV151.createLdapConfigurationBean(root, (ServerConfigurationV151)serverConfiguration);
        ServerXmlIOV151.createConfigurationBean(root, (ServerConfigurationV151)serverConfiguration);
        ServerXmlIOV151.createSystemPartitionConfigurationBean(root, (ServerConfigurationV151)serverConfiguration);
        ServerXmlIOV151.createUserPartitionsConfigurationsBean(root, (ServerConfigurationV151)serverConfiguration);
        ServerXmlIOV151.createCustomEditorsBean(root);
        document.addDocType("beans", "-//SPRING//DTD BEAN//EN", "http://www.springframework.org/dtd/spring-beans.dtd");
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        OutputFormat outformat = OutputFormat.createPrettyPrint();
        outformat.setEncoding("UTF-8");
        XMLWriter writer = new XMLWriter((OutputStream)os, outformat);
        writer.write(document);
        writer.flush();
        writer.close();
        return ((Object)os).toString();
    }

    private static void createEnvironmentBean(Element root, ServerConfigurationV151 serverConfiguration) {
        Element environmentBean = root.addElement("bean");
        environmentBean.addAttribute("id", "environment");
        environmentBean.addAttribute("class", "org.springframework.beans.factory.config.PropertiesFactoryBean");
        Element propertyElement = environmentBean.addElement("property");
        propertyElement.addAttribute("name", "properties");
        Element propsElement = propertyElement.addElement("props");
        Element propElement = propsElement.addElement("prop");
        propElement.addAttribute("key", "java.naming.security.authentication");
        propElement.setText("simple");
        propElement = propsElement.addElement("prop");
        propElement.addAttribute("key", "java.naming.security.principal");
        propElement.setText(serverConfiguration.getPrincipal());
        propElement = propsElement.addElement("prop");
        propElement.addAttribute("key", "java.naming.security.credentials");
        propElement.setText(serverConfiguration.getPassword());
        if (!serverConfiguration.getBinaryAttributes().isEmpty()) {
            propElement = propsElement.addElement("prop");
            propElement.addAttribute("key", "java.naming.ldap.attributes.binary");
            StringBuffer sb = new StringBuffer();
            for (String attribute : serverConfiguration.getBinaryAttributes()) {
                sb.append(attribute);
                sb.append(" ");
            }
            String attributes = sb.toString();
            propElement.setText(attributes.substring(0, attributes.length() - 1));
        }
    }

    private static void createChangePasswordConfigurationBean(Element root, ServerConfigurationV151 serverConfiguration) {
        ServerXmlIOV151.createProtocolConfigurationBean(root, "changePasswordConfiguration", "org.apache.directory.server.changepw.ChangePasswordConfiguration", serverConfiguration.isEnableChangePassword(), serverConfiguration.getChangePasswordPort());
    }

    private static void createNtpConfigurationBean(Element root, ServerConfigurationV151 serverConfiguration) {
        ServerXmlIOV151.createProtocolConfigurationBean(root, "ntpConfiguration", "org.apache.directory.server.ntp.NtpConfiguration", serverConfiguration.isEnableNtp(), serverConfiguration.getNtpPort());
    }

    private static void createDnsConfigurationBean(Element root, ServerConfigurationV151 serverConfiguration) {
        ServerXmlIOV151.createProtocolConfigurationBean(root, "dnsConfiguration", "org.apache.directory.server.dns.DnsConfiguration", serverConfiguration.isEnableDns(), serverConfiguration.getDnsPort());
    }

    private static void createKdcConfigurationBean(Element root, ServerConfigurationV151 serverConfiguration) {
        ServerXmlIOV151.createProtocolConfigurationBean(root, "kdcConfiguration", "org.apache.directory.server.kdc.KdcConfiguration", serverConfiguration.isEnableKerberos(), serverConfiguration.getKerberosPort());
    }

    private static void createLdapsConfigurationBean(Element root, ServerConfigurationV151 serverConfiguration) {
        Element ldapsConfiguration = ServerXmlIOV151.createProtocolConfigurationBean(root, "ldapsConfiguration", "org.apache.directory.server.ldap.LdapConfiguration", serverConfiguration.isEnableLdaps(), serverConfiguration.getLdapsPort());
        Element enableLdapsPropertyElement = ldapsConfiguration.addElement("property");
        enableLdapsPropertyElement.addAttribute("name", "enableLdaps");
        enableLdapsPropertyElement.addAttribute("value", "true");
    }

    private static void createLdapConfigurationBean(Element root, ServerConfigurationV151 serverConfiguration) {
        Element listElement;
        Element ldapConfiguration = ServerXmlIOV151.createProtocolConfigurationBean(root, "ldapConfiguration", "org.apache.directory.server.ldap.LdapConfiguration", serverConfiguration.isEnableLdap(), serverConfiguration.getLdapPort());
        Element propertyElement = ldapConfiguration.addElement("property");
        propertyElement.addAttribute("name", "allowAnonymousAccess");
        propertyElement.addAttribute("value", "" + serverConfiguration.isAllowAnonymousAccess());
        propertyElement = ldapConfiguration.addElement("property");
        propertyElement.addAttribute("name", "supportedMechanisms");
        if (serverConfiguration.getSupportedMechanisms().size() > 1) {
            listElement = propertyElement.addElement("list");
            for (String supportedMechanism : serverConfiguration.getSupportedMechanisms()) {
                listElement.addElement("value").setText(supportedMechanism);
            }
        }
        propertyElement = ldapConfiguration.addElement("property");
        propertyElement.addAttribute("name", "saslHost");
        propertyElement.addAttribute("value", serverConfiguration.getSaslHost());
        propertyElement = ldapConfiguration.addElement("property");
        propertyElement.addAttribute("name", "saslPrincipal");
        propertyElement.addAttribute("value", serverConfiguration.getSaslPrincipal());
        propertyElement = ldapConfiguration.addElement("property");
        propertyElement.addAttribute("name", "saslQop");
        if (serverConfiguration.getSaslQops().size() > 1) {
            listElement = propertyElement.addElement("list");
            for (String saslQop : serverConfiguration.getSaslQops()) {
                listElement.addElement("value").setText(saslQop);
            }
        }
        propertyElement = ldapConfiguration.addElement("property");
        propertyElement.addAttribute("name", "saslRealms");
        if (serverConfiguration.getSaslRealms().size() > 1) {
            listElement = propertyElement.addElement("list");
            for (String saslRealm : serverConfiguration.getSaslRealms()) {
                listElement.addElement("value").setText(saslRealm);
            }
        }
        propertyElement = ldapConfiguration.addElement("property");
        propertyElement.addAttribute("name", "searchBaseDN");
        propertyElement.addAttribute("value", serverConfiguration.getSearchBaseDn());
        propertyElement = ldapConfiguration.addElement("property");
        propertyElement.addAttribute("name", "maxTimeLimit");
        propertyElement.addAttribute("value", "" + serverConfiguration.getMaxTimeLimit());
        propertyElement = ldapConfiguration.addElement("property");
        propertyElement.addAttribute("name", "maxSizeLimit");
        propertyElement.addAttribute("value", "" + serverConfiguration.getMaxSizeLimit());
        propertyElement = ldapConfiguration.addElement("property");
        propertyElement.addAttribute("name", "extendedOperationHandlers");
        if (serverConfiguration.getExtendedOperations().size() > 1) {
            listElement = propertyElement.addElement("list");
            for (ExtendedOperation extendedOperation : serverConfiguration.getExtendedOperations()) {
                listElement.addElement("bean").addAttribute("class", extendedOperation.getClassType());
            }
        }
    }

    private static Element createProtocolConfigurationBean(Element root, String id, String className, boolean enabled, int ipPort) {
        Element protocolConfigurationBean = root.addElement("bean");
        protocolConfigurationBean.addAttribute("id", id);
        protocolConfigurationBean.addAttribute("class", className);
        Element enabledPropertyElement = protocolConfigurationBean.addElement("property");
        enabledPropertyElement.addAttribute("name", "enabled");
        enabledPropertyElement.addAttribute("value", "" + enabled);
        Element ipPortPropertyElement = protocolConfigurationBean.addElement("property");
        ipPortPropertyElement.addAttribute("name", "ipPort");
        ipPortPropertyElement.addAttribute("value", "" + ipPort);
        return protocolConfigurationBean;
    }

    private static void createConfigurationBean(Element root, ServerConfigurationV151 serverConfiguration) {
        Element configurationBean = root.addElement("bean");
        configurationBean.addAttribute("id", "configuration");
        configurationBean.addAttribute("class", "org.apache.directory.server.configuration.MutableServerStartupConfiguration");
        Element propertyElement = configurationBean.addElement("property");
        propertyElement.addAttribute("name", "workingDirectory");
        propertyElement.addAttribute("value", "example.com");
        propertyElement = configurationBean.addElement("property");
        propertyElement.addAttribute("name", "synchPeriodMillis");
        propertyElement.addAttribute("value", "" + serverConfiguration.getSynchronizationPeriod());
        propertyElement = configurationBean.addElement("property");
        propertyElement.addAttribute("name", "maxThreads");
        propertyElement.addAttribute("value", "" + serverConfiguration.getMaxThreads());
        propertyElement = configurationBean.addElement("property");
        propertyElement.addAttribute("name", "allowAnonymousAccess");
        propertyElement.addAttribute("value", "" + serverConfiguration.isAllowAnonymousAccess());
        propertyElement = configurationBean.addElement("property");
        propertyElement.addAttribute("name", "accessControlEnabled");
        propertyElement.addAttribute("value", "" + serverConfiguration.isEnableAccessControl());
        propertyElement = configurationBean.addElement("property");
        propertyElement.addAttribute("name", "denormalizeOpAttrsEnabled");
        propertyElement.addAttribute("value", "" + serverConfiguration.isDenormalizeOpAttr());
        propertyElement = configurationBean.addElement("property");
        propertyElement.addAttribute("name", "ntpConfiguration");
        propertyElement.addAttribute("ref", "ntpConfiguration");
        propertyElement = configurationBean.addElement("property");
        propertyElement.addAttribute("name", "dnsConfiguration");
        propertyElement.addAttribute("ref", "dnsConfiguration");
        propertyElement = configurationBean.addElement("property");
        propertyElement.addAttribute("name", "changePasswordConfiguration");
        propertyElement.addAttribute("ref", "changePasswordConfiguration");
        propertyElement = configurationBean.addElement("property");
        propertyElement.addAttribute("name", "kdcConfiguration");
        propertyElement.addAttribute("ref", "kdcConfiguration");
        propertyElement = configurationBean.addElement("property");
        propertyElement.addAttribute("name", "ldapsConfiguration");
        propertyElement.addAttribute("ref", "ldapsConfiguration");
        propertyElement = configurationBean.addElement("property");
        propertyElement.addAttribute("name", "ldapConfiguration");
        propertyElement.addAttribute("ref", "ldapConfiguration");
        propertyElement = configurationBean.addElement("property");
        propertyElement.addAttribute("name", "systemPartitionConfiguration");
        propertyElement.addAttribute("ref", "systemPartitionConfiguration");
        propertyElement = configurationBean.addElement("property");
        propertyElement.addAttribute("name", "partitionConfigurations");
        if (serverConfiguration.getPartitions().size() > 1) {
            Element setElement = propertyElement.addElement("set");
            int partitionCounter = 1;
            for (Partition partition : serverConfiguration.getPartitions()) {
                if (partition.isSystemPartition()) continue;
                setElement.addElement("ref").addAttribute("bean", "partition-" + partitionCounter);
                ++partitionCounter;
            }
        }
        propertyElement = configurationBean.addElement("property");
        propertyElement.addAttribute("name", "interceptorConfigurations");
        if (serverConfiguration.getInterceptors().size() > 1) {
            Element listElement = propertyElement.addElement("list");
            for (Interceptor interceptor : serverConfiguration.getInterceptors()) {
                Element interceptorBeanElement = listElement.addElement("bean");
                interceptorBeanElement.addAttribute("class", "org.apache.directory.server.core.configuration.MutableInterceptorConfiguration");
                Element interceptorPropertyElement = interceptorBeanElement.addElement("property");
                interceptorPropertyElement.addAttribute("name", "name");
                interceptorPropertyElement.addAttribute("value", interceptor.getName());
                interceptorPropertyElement = interceptorBeanElement.addElement("property");
                interceptorPropertyElement.addAttribute("name", "interceptorClassName");
                interceptorPropertyElement.addAttribute("value", interceptor.getClassType() == null ? "" : interceptor.getClassType());
            }
        }
    }

    private static void createSystemPartitionConfigurationBean(Element root, ServerConfigurationV151 serverConfiguration) {
        Partition systemPartition = null;
        for (Partition partition : serverConfiguration.getPartitions()) {
            if (!partition.isSystemPartition()) continue;
            systemPartition = partition;
            break;
        }
        if (systemPartition != null) {
            ServerXmlIOV151.createPartitionConfigurationBean(root, systemPartition, "systemPartitionConfiguration");
        }
    }

    private static void createUserPartitionsConfigurationsBean(Element root, ServerConfigurationV151 serverConfiguration) {
        int counter = 1;
        for (Partition partition : serverConfiguration.getPartitions()) {
            if (partition.isSystemPartition()) continue;
            ServerXmlIOV151.createPartitionConfigurationBean(root, partition, "partition-" + counter);
            ++counter;
        }
    }

    private static void createPartitionConfigurationBean(Element root, Partition partition, String name) {
        Element partitionBean = root.addElement("bean");
        partitionBean.addAttribute("id", name);
        partitionBean.addAttribute("class", "org.apache.directory.server.core.partition.impl.btree.MutableBTreePartitionConfiguration");
        Element propertyElement = partitionBean.addElement("property");
        propertyElement.addAttribute("name", "id");
        propertyElement.addAttribute("value", partition.getId());
        propertyElement = partitionBean.addElement("property");
        propertyElement.addAttribute("name", "cacheSize");
        propertyElement.addAttribute("value", "" + partition.getCacheSize());
        propertyElement = partitionBean.addElement("property");
        propertyElement.addAttribute("name", "suffix");
        propertyElement.addAttribute("value", partition.getSuffix());
        propertyElement = partitionBean.addElement("property");
        propertyElement.addAttribute("name", "partitionClassName");
        propertyElement.addAttribute("value", "org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmPartition");
        propertyElement = partitionBean.addElement("property");
        propertyElement.addAttribute("name", "optimizerEnabled");
        propertyElement.addAttribute("value", "" + partition.isEnableOptimizer());
        propertyElement = partitionBean.addElement("property");
        propertyElement.addAttribute("name", "synchOnWrite");
        propertyElement.addAttribute("value", "" + partition.isSynchronizationOnWrite());
        propertyElement = partitionBean.addElement("property");
        propertyElement.addAttribute("name", "indexedAttributes");
        if (partition.getIndexedAttributes().size() > 1) {
            Element setElement = propertyElement.addElement("set");
            for (IndexedAttribute indexedAttribute : partition.getIndexedAttributes()) {
                Element beanElement = setElement.addElement("bean");
                beanElement.addAttribute("class", "org.apache.directory.server.core.partition.impl.btree.MutableIndexConfiguration");
                Element beanPropertyElement = beanElement.addElement("property");
                beanPropertyElement.addAttribute("name", "attributeId");
                beanPropertyElement.addAttribute("value", indexedAttribute.getAttributeId());
                beanPropertyElement = beanElement.addElement("property");
                beanPropertyElement.addAttribute("name", "cacheSize");
                beanPropertyElement.addAttribute("value", "" + indexedAttribute.getCacheSize());
            }
        }
        propertyElement = partitionBean.addElement("property");
        propertyElement.addAttribute("name", "contextEntry");
        if (partition.getContextEntry() != null) {
            Element valueElement = propertyElement.addElement("value");
            Attributes contextEntry = partition.getContextEntry();
            StringBuffer sb = new StringBuffer();
            NamingEnumeration<? extends javax.naming.directory.Attribute> ne = contextEntry.getAll();
            while (ne.hasMoreElements()) {
                javax.naming.directory.Attribute attribute = (javax.naming.directory.Attribute)ne.nextElement();
                try {
                    NamingEnumeration<?> values = attribute.getAll();
                    while (values.hasMoreElements()) {
                        sb.append(attribute.getID() + ": " + values.nextElement() + "\n");
                    }
                }
                catch (NamingException e) {
                }
            }
            valueElement.setText(sb.toString());
        }
    }

    private static void createCustomEditorsBean(Element root) {
        Element customEditorsBean = root.addElement("bean");
        customEditorsBean.addAttribute("class", "org.springframework.beans.factory.config.CustomEditorConfigurer");
        Element propertyElement = customEditorsBean.addElement("property");
        propertyElement.addAttribute("name", "customEditors");
        Element mapElement = propertyElement.addElement("map");
        Element entryElement = mapElement.addElement("entry");
        entryElement.addAttribute("key", "javax.naming.directory.Attributes");
        Element entryBeanElement = entryElement.addElement("bean");
        entryBeanElement.addAttribute("class", "org.apache.directory.server.core.configuration.AttributesPropertyEditor");
    }
}

