/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import org.apache.directory.shared.ldap.ldif.LdifReader;
import org.apache.directory.shared.ldap.util.StringTools;
import org.apache.directory.studio.apacheds.configuration.StudioEntityResolver;
import org.apache.directory.studio.apacheds.configuration.model.Messages;
import org.apache.directory.studio.apacheds.configuration.model.ServerXmlIO;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.EntityResolver;

public abstract class AbstractServerXmlIO
implements ServerXmlIO {
    public Element getBeanElementById(Document document, String id) {
        Iterator i = document.getRootElement().elementIterator("bean");
        while (i.hasNext()) {
            Element element = (Element)i.next();
            Attribute idAttribute = element.attribute("id");
            if (idAttribute == null || !idAttribute.getValue().equals(id)) continue;
            return element;
        }
        return null;
    }

    public Element getBeanPropertyElement(String property, Element element) {
        Iterator i = element.elementIterator("property");
        while (i.hasNext()) {
            Element propertyElement = (Element)i.next();
            Attribute nameAttribute = propertyElement.attribute("name");
            if (nameAttribute == null || !nameAttribute.getValue().equals(property)) continue;
            return propertyElement;
        }
        return null;
    }

    public String readBeanProperty(String property, Element element) {
        Element propertyElement = this.getBeanPropertyElement(property, element);
        if (propertyElement != null) {
            Attribute valueAttribute = propertyElement.attribute("value");
            if (valueAttribute != null) {
                return valueAttribute.getValue();
            }
            Attribute refAttribute = propertyElement.attribute("ref");
            if (refAttribute != null) {
                return refAttribute.getValue();
            }
        }
        return null;
    }

    public boolean parseBoolean(String s) throws BooleanFormatException {
        if ("true".equals(s)) {
            return true;
        }
        if ("false".equals(s)) {
            return false;
        }
        throw new BooleanFormatException(NLS.bind((String)Messages.getString("AbstractServerXmlIO.ErrorNotBoolean"), (Object[])new String[]{s}));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Attributes readContextEntry(String text) {
        StringReader strIn = new StringReader(text);
        BufferedReader in = new BufferedReader(strIn);
        String line = null;
        BasicAttributes attributes = new BasicAttributes(true);
        try {
            while ((line = in.readLine()) != null) {
                String addedLine;
                if (line.length() == 0 || StringTools.isEmpty((String)(addedLine = line.trim()))) continue;
                javax.naming.directory.Attribute attribute = LdifReader.parseAttributeValue((String)addedLine);
                javax.naming.directory.Attribute oldAttribute = attributes.get(attribute.getID());
                if (oldAttribute != null) {
                    try {
                        oldAttribute.add(attribute.get());
                        attributes.put(oldAttribute);
                        continue;
                    }
                    catch (NamingException ne) {
                        continue;
                    }
                }
                attributes.put(attribute);
            }
            return attributes;
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return attributes;
    }

    public final boolean isValid(InputStream is) {
        try {
            SAXReader saxReader = new SAXReader();
            saxReader.setEntityResolver((EntityResolver)new StudioEntityResolver());
            return this.isValid(saxReader.read(is));
        }
        catch (Exception e) {
            return false;
        }
    }

    public final boolean isValid(Reader reader) {
        try {
            SAXReader saxReader = new SAXReader();
            saxReader.setEntityResolver((EntityResolver)new StudioEntityResolver());
            return this.isValid(saxReader.read(reader));
        }
        catch (Exception e) {
            return false;
        }
    }

    protected abstract boolean isValid(Document var1);

    public class BooleanFormatException
    extends Exception {
        private static final long serialVersionUID = -6426955193802317452L;

        public BooleanFormatException(String message) {
            super(message);
        }
    }
}

