/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.editor.v153.dialogs;

import org.apache.directory.studio.apacheds.configuration.model.v153.IndexedAttribute;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class IndexedAttributeDialog
extends Dialog {
    private IndexedAttribute indexedAttribute;
    private boolean dirty = false;
    private Text attributeIdText;
    private Text cacheSizeText;

    public IndexedAttributeDialog(IndexedAttribute indexedAttribute) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.indexedAttribute = indexedAttribute;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Indexed Attribute Dialog");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label attributeIdLabel = new Label(composite, 0);
        attributeIdLabel.setText("Attribute ID:");
        this.attributeIdText = new Text(composite, 2048);
        this.attributeIdText.setLayoutData((Object)new GridData(4, 0, true, false));
        Label cacheSizeLabel = new Label(composite, 0);
        cacheSizeLabel.setText("Cache Size:");
        this.cacheSizeText = new Text(composite, 2048);
        this.cacheSizeText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[0-9]*")) {
                    e.doit = false;
                }
            }
        });
        this.cacheSizeText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.initFromInput();
        this.addListeners();
        return composite;
    }

    private void initFromInput() {
        String attributeId = this.indexedAttribute.getAttributeId();
        this.attributeIdText.setText(attributeId == null ? "" : attributeId);
        this.cacheSizeText.setText("" + this.indexedAttribute.getCacheSize());
    }

    private void addListeners() {
        this.attributeIdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IndexedAttributeDialog.this.dirty = true;
            }
        });
        this.cacheSizeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IndexedAttributeDialog.this.dirty = true;
            }
        });
    }

    protected void okPressed() {
        this.indexedAttribute.setAttributeId(this.attributeIdText.getText());
        try {
            this.indexedAttribute.setCacheSize(Integer.parseInt(this.cacheSizeText.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        super.okPressed();
    }

    public IndexedAttribute getIndexedAttribute() {
        return this.indexedAttribute;
    }

    public boolean isDirty() {
        return this.dirty;
    }
}

