/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.editor.v153;

import org.apache.directory.studio.apacheds.configuration.ApacheDSConfigurationPluginConstants;
import org.apache.directory.studio.apacheds.configuration.editor.SaveableFormPage;
import org.apache.directory.studio.apacheds.configuration.editor.ServerConfigurationEditor;
import org.apache.directory.studio.apacheds.configuration.model.v153.ServerConfigurationV153;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class GeneralPage
extends FormPage
implements SaveableFormPage {
    public static final String ID = ServerConfigurationEditor.ID + ".V153.GeneralPage";
    private static final String TITLE = "General";
    private Button allowAnonymousAccessCheckbox;
    private Text maxTimeLimitText;
    private Text maxSizeLimitText;
    private Text synchPeriodText;
    private Text maxThreadsText;
    private Button enableAccesControlCheckbox;
    private Button enableKerberosCheckbox;
    private Button enableChangePasswordCheckbox;
    private Button denormalizeOpAttrCheckbox;
    private Button enableLdapCheckbox;
    private Text ldapPortText;
    private Button enableLdapsCheckbox;
    private Text ldapsPortText;
    private Text kerberosPortText;
    private Button enableNtpCheckbox;
    private Text ntpPortText;
    private Button enableDnsCheckbox;
    private Text dnsPortText;
    private Text changePasswordPortText;

    public GeneralPage(FormEditor editor) {
        super(editor, ID, TITLE);
    }

    protected void createFormContent(IManagedForm managedForm) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getPartControl(), ApacheDSConfigurationPluginConstants.PLUGIN_ID + "." + "configuration_editor_153");
        ScrolledForm form = managedForm.getForm();
        form.setText(TITLE);
        Composite parent = form.getBody();
        TableWrapLayout twl = new TableWrapLayout();
        twl.numColumns = 2;
        parent.setLayout((Layout)twl);
        FormToolkit toolkit = managedForm.getToolkit();
        Composite composite = toolkit.createComposite(parent);
        composite.setLayout((Layout)new GridLayout());
        TableWrapData compositeTableWrapData = new TableWrapData(128, 16, 1, 2);
        compositeTableWrapData.grabHorizontal = true;
        composite.setLayoutData((Object)compositeTableWrapData);
        Composite leftComposite = toolkit.createComposite(parent);
        leftComposite.setLayout((Layout)new GridLayout());
        TableWrapData leftCompositeTableWrapData = new TableWrapData(128, 16);
        leftCompositeTableWrapData.grabHorizontal = true;
        leftComposite.setLayoutData((Object)leftCompositeTableWrapData);
        Composite rightComposite = toolkit.createComposite(parent);
        rightComposite.setLayout((Layout)new GridLayout());
        TableWrapData rightCompositeTableWrapData = new TableWrapData(128, 16);
        rightCompositeTableWrapData.grabHorizontal = true;
        rightComposite.setLayoutData((Object)rightCompositeTableWrapData);
        this.createProtocolsSection(composite, toolkit);
        this.createLimitsSection(leftComposite, toolkit);
        this.createOptionsSection(rightComposite, toolkit);
        this.initFromInput();
        this.addListeners();
    }

    private void createProtocolsSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 256);
        section.setText("Protocols");
        section.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite client = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(client);
        client.setLayout((Layout)new GridLayout(3, true));
        section.setClient((Control)client);
        Composite ldapProtocolComposite = this.createProtocolComposite(toolkit, client);
        this.enableLdapCheckbox = toolkit.createButton(ldapProtocolComposite, "Enable LDAP", 32);
        this.enableLdapCheckbox.setLayoutData((Object)new GridData(0, 0, true, false, 3, 1));
        toolkit.createLabel(ldapProtocolComposite, "    ");
        toolkit.createLabel(ldapProtocolComposite, "Port:");
        this.ldapPortText = this.createPortText(toolkit, ldapProtocolComposite);
        Composite ldapsProtocolComposite = this.createProtocolComposite(toolkit, client);
        this.enableLdapsCheckbox = toolkit.createButton(ldapsProtocolComposite, "Enable LDAPS", 32);
        this.enableLdapsCheckbox.setLayoutData((Object)new GridData(0, 0, true, false, 3, 1));
        toolkit.createLabel(ldapsProtocolComposite, "    ");
        toolkit.createLabel(ldapsProtocolComposite, "Port:");
        this.ldapsPortText = this.createPortText(toolkit, ldapsProtocolComposite);
        Composite kerberosProtocolComposite = this.createProtocolComposite(toolkit, client);
        this.enableKerberosCheckbox = toolkit.createButton(kerberosProtocolComposite, "Enable Kerberos", 32);
        this.enableKerberosCheckbox.setLayoutData((Object)new GridData(0, 0, true, false, 3, 1));
        toolkit.createLabel(kerberosProtocolComposite, "    ");
        toolkit.createLabel(kerberosProtocolComposite, "Port:");
        this.kerberosPortText = this.createPortText(toolkit, kerberosProtocolComposite);
        Composite ntpProtocolComposite = this.createProtocolComposite(toolkit, client);
        this.enableNtpCheckbox = toolkit.createButton(ntpProtocolComposite, "Enable NTP", 32);
        this.enableNtpCheckbox.setLayoutData((Object)new GridData(0, 0, true, false, 3, 1));
        toolkit.createLabel(ntpProtocolComposite, "    ");
        toolkit.createLabel(ntpProtocolComposite, "Port:");
        this.ntpPortText = this.createPortText(toolkit, ntpProtocolComposite);
        Composite dnsProtocolComposite = this.createProtocolComposite(toolkit, client);
        this.enableDnsCheckbox = toolkit.createButton(dnsProtocolComposite, "Enable DNS", 32);
        this.enableDnsCheckbox.setLayoutData((Object)new GridData(0, 0, true, false, 3, 1));
        toolkit.createLabel(dnsProtocolComposite, "    ");
        toolkit.createLabel(dnsProtocolComposite, "Port:");
        this.dnsPortText = this.createPortText(toolkit, dnsProtocolComposite);
        Composite changePasswordProtocolComposite = this.createProtocolComposite(toolkit, client);
        this.enableChangePasswordCheckbox = toolkit.createButton(changePasswordProtocolComposite, "Enable Change Password", 32);
        this.enableChangePasswordCheckbox.setLayoutData((Object)new GridData(0, 0, true, false, 3, 1));
        toolkit.createLabel(changePasswordProtocolComposite, "    ");
        toolkit.createLabel(changePasswordProtocolComposite, "Port:");
        this.changePasswordPortText = this.createPortText(toolkit, changePasswordProtocolComposite);
    }

    private Composite createProtocolComposite(FormToolkit toolkit, Composite parent) {
        Composite protocolComposite = toolkit.createComposite(parent);
        GridLayout protocolGridLayout = new GridLayout(3, false);
        protocolGridLayout.marginWidth = 0;
        protocolGridLayout.marginHeight = 0;
        toolkit.paintBordersFor(protocolComposite);
        protocolComposite.setLayout((Layout)protocolGridLayout);
        return protocolComposite;
    }

    private Text createPortText(FormToolkit toolkit, Composite parent) {
        Text portText = toolkit.createText(parent, "");
        GridData gd = new GridData(0, 0, false, false);
        gd.widthHint = 42;
        portText.setLayoutData((Object)gd);
        portText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[0-9]*")) {
                    e.doit = false;
                }
            }
        });
        portText.setTextLimit(5);
        return portText;
    }

    private void createLimitsSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 256);
        section.setText("Limits");
        section.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite client = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(client);
        GridLayout glayout = new GridLayout(2, false);
        client.setLayout((Layout)glayout);
        section.setClient((Control)client);
        toolkit.createLabel(client, "Max. Time Limit:");
        this.maxTimeLimitText = toolkit.createText(client, "");
        this.maxTimeLimitText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.maxTimeLimitText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[0-9]*")) {
                    e.doit = false;
                }
            }
        });
        toolkit.createLabel(client, "Max. Size Limit:");
        this.maxSizeLimitText = toolkit.createText(client, "");
        this.maxSizeLimitText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.maxSizeLimitText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[0-9]*")) {
                    e.doit = false;
                }
            }
        });
        toolkit.createLabel(client, "Synchronization Period:");
        this.synchPeriodText = toolkit.createText(client, "");
        this.synchPeriodText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.synchPeriodText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[0-9]*")) {
                    e.doit = false;
                }
            }
        });
        toolkit.createLabel(client, "Max. Threads:");
        this.maxThreadsText = toolkit.createText(client, "");
        this.maxThreadsText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.maxThreadsText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[0-9]*")) {
                    e.doit = false;
                }
            }
        });
    }

    private void createOptionsSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 256);
        section.setText("Options");
        section.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite client = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(client);
        client.setLayout((Layout)new GridLayout());
        section.setClient((Control)client);
        this.allowAnonymousAccessCheckbox = toolkit.createButton(client, "Allow Anonymous Access", 32);
        this.allowAnonymousAccessCheckbox.setLayoutData((Object)new GridData(0, 0, true, false));
        this.enableAccesControlCheckbox = toolkit.createButton(client, "Enable Access Control", 32);
        this.enableAccesControlCheckbox.setLayoutData((Object)new GridData(0, 0, true, false));
        this.denormalizeOpAttrCheckbox = toolkit.createButton(client, "Denormalize Operational Attributes", 32);
        this.denormalizeOpAttrCheckbox.setLayoutData((Object)new GridData(0, 0, true, false));
    }

    private void initFromInput() {
        ServerConfigurationV153 configuration = (ServerConfigurationV153)((ServerConfigurationEditor)this.getEditor()).getServerConfiguration();
        this.enableLdapCheckbox.setSelection(configuration.isEnableLdap());
        this.ldapPortText.setEnabled(this.enableLdapCheckbox.getSelection());
        this.ldapPortText.setText("" + configuration.getLdapPort());
        this.enableLdapsCheckbox.setSelection(configuration.isEnableLdaps());
        this.ldapsPortText.setEnabled(this.enableLdapsCheckbox.getSelection());
        this.ldapsPortText.setText("" + configuration.getLdapsPort());
        this.enableKerberosCheckbox.setSelection(configuration.isEnableKerberos());
        this.kerberosPortText.setEnabled(this.enableKerberosCheckbox.getSelection());
        this.kerberosPortText.setText("" + configuration.getKerberosPort());
        this.enableNtpCheckbox.setSelection(configuration.isEnableNtp());
        this.ntpPortText.setEnabled(this.enableNtpCheckbox.getSelection());
        this.ntpPortText.setText("" + configuration.getNtpPort());
        this.enableDnsCheckbox.setSelection(configuration.isEnableDns());
        this.dnsPortText.setEnabled(this.enableDnsCheckbox.getSelection());
        this.dnsPortText.setText("" + configuration.getDnsPort());
        this.enableChangePasswordCheckbox.setSelection(configuration.isEnableChangePassword());
        this.changePasswordPortText.setEnabled(this.enableChangePasswordCheckbox.getSelection());
        this.changePasswordPortText.setText("" + configuration.getChangePasswordPort());
        this.maxTimeLimitText.setText("" + configuration.getMaxTimeLimit());
        this.maxSizeLimitText.setText("" + configuration.getMaxSizeLimit());
        this.synchPeriodText.setText("" + configuration.getSynchronizationPeriod());
        this.maxThreadsText.setText("" + configuration.getMaxThreads());
        this.allowAnonymousAccessCheckbox.setSelection(configuration.isAllowAnonymousAccess());
        this.enableAccesControlCheckbox.setSelection(configuration.isEnableAccessControl());
        this.denormalizeOpAttrCheckbox.setSelection(configuration.isDenormalizeOpAttr());
    }

    private void addListeners() {
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneralPage.this.setEditorDirty();
            }
        };
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralPage.this.setEditorDirty();
            }
        };
        this.enableLdapCheckbox.addSelectionListener((SelectionListener)selectionListener);
        this.enableLdapCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralPage.this.ldapPortText.setEnabled(GeneralPage.this.enableLdapCheckbox.getSelection());
            }
        });
        this.ldapPortText.addModifyListener(modifyListener);
        this.enableLdapsCheckbox.addSelectionListener((SelectionListener)selectionListener);
        this.enableLdapsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralPage.this.ldapsPortText.setEnabled(GeneralPage.this.enableLdapsCheckbox.getSelection());
            }
        });
        this.ldapsPortText.addModifyListener(modifyListener);
        this.enableKerberosCheckbox.addSelectionListener((SelectionListener)selectionListener);
        this.enableKerberosCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralPage.this.kerberosPortText.setEnabled(GeneralPage.this.enableKerberosCheckbox.getSelection());
            }
        });
        this.kerberosPortText.addModifyListener(modifyListener);
        this.enableNtpCheckbox.addSelectionListener((SelectionListener)selectionListener);
        this.enableNtpCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralPage.this.ntpPortText.setEnabled(GeneralPage.this.enableNtpCheckbox.getSelection());
            }
        });
        this.ntpPortText.addModifyListener(modifyListener);
        this.enableDnsCheckbox.addSelectionListener((SelectionListener)selectionListener);
        this.enableDnsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralPage.this.dnsPortText.setEnabled(GeneralPage.this.enableDnsCheckbox.getSelection());
            }
        });
        this.dnsPortText.addModifyListener(modifyListener);
        this.enableChangePasswordCheckbox.addSelectionListener((SelectionListener)selectionListener);
        this.enableChangePasswordCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralPage.this.changePasswordPortText.setEnabled(GeneralPage.this.enableChangePasswordCheckbox.getSelection());
            }
        });
        this.changePasswordPortText.addModifyListener(modifyListener);
        this.maxTimeLimitText.addModifyListener(modifyListener);
        this.maxSizeLimitText.addModifyListener(modifyListener);
        this.synchPeriodText.addModifyListener(modifyListener);
        this.maxThreadsText.addModifyListener(modifyListener);
        this.allowAnonymousAccessCheckbox.addSelectionListener((SelectionListener)selectionListener);
        this.enableAccesControlCheckbox.addSelectionListener((SelectionListener)selectionListener);
        this.denormalizeOpAttrCheckbox.addSelectionListener((SelectionListener)selectionListener);
    }

    private void setEditorDirty() {
        ((ServerConfigurationEditor)this.getEditor()).setDirty(true);
    }

    public void save() {
        ServerConfigurationV153 configuration = (ServerConfigurationV153)((ServerConfigurationEditor)this.getEditor()).getServerConfiguration();
        configuration.setEnableLdap(this.enableLdapCheckbox.getSelection());
        configuration.setLdapPort(Integer.parseInt(this.ldapPortText.getText()));
        configuration.setEnableLdaps(this.enableLdapsCheckbox.getSelection());
        configuration.setLdapsPort(Integer.parseInt(this.ldapsPortText.getText()));
        configuration.setEnableKerberos(this.enableKerberosCheckbox.getSelection());
        configuration.setKerberosPort(Integer.parseInt(this.kerberosPortText.getText()));
        configuration.setEnableNtp(this.enableNtpCheckbox.getSelection());
        configuration.setNtpPort(Integer.parseInt(this.ntpPortText.getText()));
        configuration.setEnableDns(this.enableDnsCheckbox.getSelection());
        configuration.setDnsPort(Integer.parseInt(this.dnsPortText.getText()));
        configuration.setEnableChangePassword(this.enableChangePasswordCheckbox.getSelection());
        configuration.setChangePasswordPort(Integer.parseInt(this.changePasswordPortText.getText()));
        configuration.setMaxTimeLimit(Integer.parseInt(this.maxTimeLimitText.getText()));
        configuration.setMaxSizeLimit(Integer.parseInt(this.maxSizeLimitText.getText()));
        configuration.setSynchronizationPeriod(Long.parseLong(this.synchPeriodText.getText()));
        configuration.setMaxThreads(Integer.parseInt(this.maxThreadsText.getText()));
        configuration.setAllowAnonymousAccess(this.allowAnonymousAccessCheckbox.getSelection());
        configuration.setEnableAccessControl(this.enableAccesControlCheckbox.getSelection());
        configuration.setDenormalizeOpAttr(this.denormalizeOpAttrCheckbox.getSelection());
    }
}

