/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.editor.v151;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.studio.apacheds.configuration.ApacheDSConfigurationPluginConstants;
import org.apache.directory.studio.apacheds.configuration.editor.SaveableFormPage;
import org.apache.directory.studio.apacheds.configuration.editor.ServerConfigurationEditor;
import org.apache.directory.studio.apacheds.configuration.editor.v151.dialogs.BinaryAttributeDialog;
import org.apache.directory.studio.apacheds.configuration.model.v151.ServerConfigurationV151;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class GeneralPage
extends FormPage
implements SaveableFormPage {
    public static final String ID = ServerConfigurationEditor.ID + ".V151.GeneralPage";
    private static final String TITLE = "General";
    private List<String> binaryAttributes;
    private Text principalText;
    private Text passwordText;
    private Button showPasswordCheckbox;
    private Button allowAnonymousAccessCheckbox;
    private Text maxTimeLimitText;
    private Text maxSizeLimitText;
    private Text synchPeriodText;
    private Text maxThreadsText;
    private Button enableAccesControlCheckbox;
    private Button enableKerberosCheckbox;
    private Button enableChangePasswordCheckbox;
    private Button denormalizeOpAttrCheckbox;
    private TableViewer binaryAttributesTableViewer;
    private Button binaryAttributesAddButton;
    private Button binaryAttributesEditButton;
    private Button binaryAttributesDeleteButton;
    private Button enableLdapCheckbox;
    private Text ldapPortText;
    private Button enableLdapsCheckbox;
    private Text ldapsPortText;
    private Text kerberosPortText;
    private Button enableNtpCheckbox;
    private Text ntpPortText;
    private Button enableDnsCheckbox;
    private Text dnsPortText;
    private Text changePasswordPortText;
    private CheckboxTableViewer supportedMechanismsTableViewer;
    private Button selectAllSupportedMechanismsButton;
    private Button deselectAllSupportedMechanismsButton;

    public GeneralPage(FormEditor editor) {
        super(editor, ID, TITLE);
    }

    protected void createFormContent(IManagedForm managedForm) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getPartControl(), ApacheDSConfigurationPluginConstants.PLUGIN_ID + "." + "configuration_editor_151");
        ScrolledForm form = managedForm.getForm();
        form.setText(TITLE);
        Composite parent = form.getBody();
        TableWrapLayout twl = new TableWrapLayout();
        twl.numColumns = 2;
        parent.setLayout((Layout)twl);
        FormToolkit toolkit = managedForm.getToolkit();
        Composite leftComposite = toolkit.createComposite(parent);
        GridLayout leftCompositeGridLayout = new GridLayout();
        leftCompositeGridLayout.marginWidth = 0;
        leftCompositeGridLayout.marginHeight = 0;
        leftComposite.setLayout((Layout)leftCompositeGridLayout);
        TableWrapData leftCompositeTableWrapData = new TableWrapData(128, 16);
        leftCompositeTableWrapData.grabHorizontal = true;
        leftComposite.setLayoutData((Object)leftCompositeTableWrapData);
        this.createAdministratorSettingsSection(leftComposite, toolkit);
        this.createProtocolsSection(leftComposite, toolkit);
        this.createSupportedAuthenticationMechanismsSection(leftComposite, toolkit);
        Composite rightComposite = toolkit.createComposite(parent);
        GridLayout rightCompositeGridLayout = new GridLayout();
        rightCompositeGridLayout.marginWidth = 0;
        rightCompositeGridLayout.marginHeight = 0;
        rightComposite.setLayout((Layout)rightCompositeGridLayout);
        TableWrapData rightCompositeTableWrapData = new TableWrapData(128, 16);
        rightCompositeTableWrapData.grabHorizontal = true;
        rightComposite.setLayoutData((Object)rightCompositeTableWrapData);
        this.createBinaryAttributesSection(rightComposite, toolkit);
        this.createLimitsSection(rightComposite, toolkit);
        this.createOptionsSection(rightComposite, toolkit);
        this.initFromInput();
        this.addListeners();
    }

    private void createAdministratorSettingsSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 384);
        section.marginWidth = 4;
        section.setText("Administrator settings");
        section.setDescription("Set the settings about the administrator of the server.");
        section.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite client = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(client);
        GridLayout glayout = new GridLayout(2, false);
        client.setLayout((Layout)glayout);
        section.setClient((Control)client);
        toolkit.createLabel(client, "Principal:");
        this.principalText = toolkit.createText(client, "");
        this.principalText.setLayoutData((Object)new GridData(4, 0, true, false));
        toolkit.createLabel(client, "Password:");
        this.passwordText = toolkit.createText(client, "");
        this.passwordText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.passwordText.setEchoChar('\u2022');
        toolkit.createLabel(client, "");
        this.showPasswordCheckbox = toolkit.createButton(client, "Show password", 32);
        this.showPasswordCheckbox.setLayoutData((Object)new GridData(0, 0, true, false));
        this.showPasswordCheckbox.setSelection(false);
        this.showPasswordCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GeneralPage.this.showPasswordCheckbox.getSelection()) {
                    GeneralPage.this.passwordText.setEchoChar('\u0000');
                } else {
                    GeneralPage.this.passwordText.setEchoChar('\u2022');
                }
            }
        });
    }

    private void createLimitsSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 256);
        section.marginWidth = 4;
        section.setText("Limits");
        section.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite client = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(client);
        GridLayout glayout = new GridLayout(2, false);
        client.setLayout((Layout)glayout);
        section.setClient((Control)client);
        toolkit.createLabel(client, "Max. Time Limit:");
        this.maxTimeLimitText = toolkit.createText(client, "");
        this.maxTimeLimitText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.maxTimeLimitText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[0-9]*")) {
                    e.doit = false;
                }
            }
        });
        toolkit.createLabel(client, "Max. Size Limit:");
        this.maxSizeLimitText = toolkit.createText(client, "");
        this.maxSizeLimitText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.maxSizeLimitText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[0-9]*")) {
                    e.doit = false;
                }
            }
        });
        toolkit.createLabel(client, "Synchronization Period:");
        this.synchPeriodText = toolkit.createText(client, "");
        this.synchPeriodText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.synchPeriodText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[0-9]*")) {
                    e.doit = false;
                }
            }
        });
        toolkit.createLabel(client, "Max. Threads:");
        this.maxThreadsText = toolkit.createText(client, "");
        this.maxThreadsText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.maxThreadsText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[0-9]*")) {
                    e.doit = false;
                }
            }
        });
    }

    private void createOptionsSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 256);
        section.marginWidth = 4;
        section.setText("Options");
        section.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite client = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(client);
        client.setLayout((Layout)new GridLayout());
        section.setClient((Control)client);
        this.allowAnonymousAccessCheckbox = toolkit.createButton(client, "Allow Anonymous Access", 32);
        this.allowAnonymousAccessCheckbox.setLayoutData((Object)new GridData(0, 0, true, false));
        this.enableAccesControlCheckbox = toolkit.createButton(client, "Enable Access Control", 32);
        this.enableAccesControlCheckbox.setLayoutData((Object)new GridData(0, 0, true, false));
        this.denormalizeOpAttrCheckbox = toolkit.createButton(client, "Denormalize Operational Attributes", 32);
        this.denormalizeOpAttrCheckbox.setLayoutData((Object)new GridData(0, 0, true, false));
    }

    private void createBinaryAttributesSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 384);
        section.marginWidth = 4;
        section.setText("Binary Attributes");
        section.setDescription("Set attribute type names and OID's if you want them to be handled as binary content.");
        section.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite client = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(client);
        GridLayout glayout = new GridLayout(2, false);
        client.setLayout((Layout)glayout);
        section.setClient((Control)client);
        Table binaryAttributesTable = toolkit.createTable(client, 0);
        GridData gd = new GridData(4, 0, true, false, 1, 3);
        gd.heightHint = 103;
        binaryAttributesTable.setLayoutData((Object)gd);
        this.binaryAttributesTableViewer = new TableViewer(binaryAttributesTable);
        this.binaryAttributesTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        GridData buttonsGD = new GridData(4, 1, false, false);
        buttonsGD.widthHint = 61;
        this.binaryAttributesAddButton = toolkit.createButton(client, "Add...", 8);
        this.binaryAttributesAddButton.setLayoutData((Object)buttonsGD);
        this.binaryAttributesEditButton = toolkit.createButton(client, "Edit...", 8);
        this.binaryAttributesEditButton.setEnabled(false);
        this.binaryAttributesEditButton.setLayoutData((Object)buttonsGD);
        this.binaryAttributesDeleteButton = toolkit.createButton(client, "Delete", 8);
        this.binaryAttributesDeleteButton.setEnabled(false);
        this.binaryAttributesDeleteButton.setLayoutData((Object)buttonsGD);
    }

    private void createSupportedAuthenticationMechanismsSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 256);
        section.marginWidth = 4;
        section.setText("Supported Authentication Mechanisms");
        section.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite client = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(client);
        GridLayout glayout = new GridLayout(2, false);
        client.setLayout((Layout)glayout);
        section.setClient((Control)client);
        Table supportedMechanismsTable = toolkit.createTable(client, 32);
        GridData gd = new GridData(4, 0, true, false, 1, 3);
        gd.heightHint = 76;
        supportedMechanismsTable.setLayoutData((Object)gd);
        this.supportedMechanismsTableViewer = new CheckboxTableViewer(supportedMechanismsTable);
        this.supportedMechanismsTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.supportedMechanismsTableViewer.setInput((Object)new String[]{"SIMPLE", "CRAM-MD5", "DIGEST-MD5", "GSSAPI"});
        this.selectAllSupportedMechanismsButton = toolkit.createButton(client, "Select All", 8);
        this.selectAllSupportedMechanismsButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.deselectAllSupportedMechanismsButton = toolkit.createButton(client, "Deselect All", 8);
        this.deselectAllSupportedMechanismsButton.setLayoutData((Object)new GridData(4, 1, false, false));
    }

    private void createProtocolsSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 256);
        section.marginWidth = 4;
        section.setText("Protocols");
        section.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite client = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(client);
        client.setLayout((Layout)new GridLayout(2, true));
        section.setClient((Control)client);
        Composite ldapProtocolComposite = this.createProtocolComposite(toolkit, client);
        this.enableLdapCheckbox = toolkit.createButton(ldapProtocolComposite, "Enable LDAP", 32);
        this.enableLdapCheckbox.setLayoutData((Object)new GridData(0, 0, true, false, 3, 1));
        toolkit.createLabel(ldapProtocolComposite, "    ");
        toolkit.createLabel(ldapProtocolComposite, "Port:");
        this.ldapPortText = this.createPortText(toolkit, ldapProtocolComposite);
        Composite ldapsProtocolComposite = this.createProtocolComposite(toolkit, client);
        this.enableLdapsCheckbox = toolkit.createButton(ldapsProtocolComposite, "Enable LDAPS", 32);
        this.enableLdapsCheckbox.setLayoutData((Object)new GridData(0, 0, true, false, 3, 1));
        toolkit.createLabel(ldapsProtocolComposite, "    ");
        toolkit.createLabel(ldapsProtocolComposite, "Port:");
        this.ldapsPortText = this.createPortText(toolkit, ldapsProtocolComposite);
        Composite kerberosProtocolComposite = this.createProtocolComposite(toolkit, client);
        this.enableKerberosCheckbox = toolkit.createButton(kerberosProtocolComposite, "Enable Kerberos", 32);
        this.enableKerberosCheckbox.setLayoutData((Object)new GridData(0, 0, true, false, 3, 1));
        toolkit.createLabel(kerberosProtocolComposite, "    ");
        toolkit.createLabel(kerberosProtocolComposite, "Port:");
        this.kerberosPortText = this.createPortText(toolkit, kerberosProtocolComposite);
        Composite ntpProtocolComposite = this.createProtocolComposite(toolkit, client);
        this.enableNtpCheckbox = toolkit.createButton(ntpProtocolComposite, "Enable NTP", 32);
        this.enableNtpCheckbox.setLayoutData((Object)new GridData(0, 0, true, false, 3, 1));
        toolkit.createLabel(ntpProtocolComposite, "    ");
        toolkit.createLabel(ntpProtocolComposite, "Port:");
        this.ntpPortText = this.createPortText(toolkit, ntpProtocolComposite);
        Composite dnsProtocolComposite = this.createProtocolComposite(toolkit, client);
        this.enableDnsCheckbox = toolkit.createButton(dnsProtocolComposite, "Enable DNS", 32);
        this.enableDnsCheckbox.setLayoutData((Object)new GridData(0, 0, true, false, 3, 1));
        toolkit.createLabel(dnsProtocolComposite, "    ");
        toolkit.createLabel(dnsProtocolComposite, "Port:");
        this.dnsPortText = this.createPortText(toolkit, dnsProtocolComposite);
        Composite changePasswordProtocolComposite = this.createProtocolComposite(toolkit, client);
        this.enableChangePasswordCheckbox = toolkit.createButton(changePasswordProtocolComposite, "Enable Change Password", 32);
        this.enableChangePasswordCheckbox.setLayoutData((Object)new GridData(0, 0, true, false, 3, 1));
        toolkit.createLabel(changePasswordProtocolComposite, "    ");
        toolkit.createLabel(changePasswordProtocolComposite, "Port:");
        this.changePasswordPortText = this.createPortText(toolkit, changePasswordProtocolComposite);
    }

    private Composite createProtocolComposite(FormToolkit toolkit, Composite parent) {
        Composite protocolComposite = toolkit.createComposite(parent);
        GridLayout protocolGridLayout = new GridLayout(3, false);
        protocolGridLayout.marginWidth = 0;
        protocolGridLayout.marginHeight = 0;
        toolkit.paintBordersFor(protocolComposite);
        protocolComposite.setLayout((Layout)protocolGridLayout);
        return protocolComposite;
    }

    private Text createPortText(FormToolkit toolkit, Composite parent) {
        Text portText = toolkit.createText(parent, "");
        GridData gd = new GridData(0, 0, false, false);
        gd.widthHint = 42;
        portText.setLayoutData((Object)gd);
        portText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[0-9]*")) {
                    e.doit = false;
                }
            }
        });
        portText.setTextLimit(5);
        return portText;
    }

    private void initFromInput() {
        String password;
        ServerConfigurationV151 configuration = (ServerConfigurationV151)((ServerConfigurationEditor)this.getEditor()).getServerConfiguration();
        String principal = configuration.getPrincipal();
        if (principal != null) {
            this.principalText.setText(principal);
        }
        if ((password = configuration.getPassword()) != null) {
            this.passwordText.setText(password);
        }
        this.binaryAttributes = configuration.getBinaryAttributes();
        this.binaryAttributesTableViewer.setInput(this.binaryAttributes);
        this.enableLdapCheckbox.setSelection(configuration.isEnableLdap());
        this.ldapPortText.setEnabled(this.enableLdapCheckbox.getSelection());
        this.ldapPortText.setText("" + configuration.getLdapPort());
        this.enableLdapsCheckbox.setSelection(configuration.isEnableLdaps());
        this.ldapsPortText.setEnabled(this.enableLdapsCheckbox.getSelection());
        this.ldapsPortText.setText("" + configuration.getLdapsPort());
        this.enableKerberosCheckbox.setSelection(configuration.isEnableKerberos());
        this.kerberosPortText.setEnabled(this.enableKerberosCheckbox.getSelection());
        this.kerberosPortText.setText("" + configuration.getKerberosPort());
        this.enableNtpCheckbox.setSelection(configuration.isEnableNtp());
        this.ntpPortText.setEnabled(this.enableNtpCheckbox.getSelection());
        this.ntpPortText.setText("" + configuration.getNtpPort());
        this.enableDnsCheckbox.setSelection(configuration.isEnableDns());
        this.dnsPortText.setEnabled(this.enableDnsCheckbox.getSelection());
        this.dnsPortText.setText("" + configuration.getDnsPort());
        this.enableChangePasswordCheckbox.setSelection(configuration.isEnableChangePassword());
        this.changePasswordPortText.setEnabled(this.enableChangePasswordCheckbox.getSelection());
        this.changePasswordPortText.setText("" + configuration.getChangePasswordPort());
        this.maxTimeLimitText.setText("" + configuration.getMaxTimeLimit());
        this.maxSizeLimitText.setText("" + configuration.getMaxSizeLimit());
        this.synchPeriodText.setText("" + configuration.getSynchronizationPeriod());
        this.maxThreadsText.setText("" + configuration.getMaxThreads());
        this.supportedMechanismsTableViewer.setCheckedElements(configuration.getSupportedMechanisms().toArray());
        this.allowAnonymousAccessCheckbox.setSelection(configuration.isAllowAnonymousAccess());
        this.enableAccesControlCheckbox.setSelection(configuration.isEnableAccessControl());
        this.denormalizeOpAttrCheckbox.setSelection(configuration.isDenormalizeOpAttr());
    }

    private void addListeners() {
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneralPage.this.setEditorDirty();
            }
        };
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralPage.this.setEditorDirty();
            }
        };
        ISelectionChangedListener binaryAttributesTableViewerListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                GeneralPage.this.binaryAttributesEditButton.setEnabled(!event.getSelection().isEmpty());
                GeneralPage.this.binaryAttributesDeleteButton.setEnabled(!event.getSelection().isEmpty());
            }
        };
        IDoubleClickListener binaryAttributesTableViewerDoubleClickListener = new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                GeneralPage.this.editSelectedBinaryAttribute();
            }
        };
        SelectionAdapter binaryAttributesAddButtonListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String newAttribute;
                BinaryAttributeDialog dialog = new BinaryAttributeDialog("");
                if (0 == dialog.open() && dialog.isDirty() && (newAttribute = dialog.getAttribute()) != null && !"".equals(newAttribute) && !GeneralPage.this.binaryAttributes.contains(newAttribute)) {
                    GeneralPage.this.binaryAttributes.add(newAttribute);
                    GeneralPage.this.binaryAttributesTableViewer.refresh();
                    GeneralPage.this.setEditorDirty();
                }
            }
        };
        SelectionAdapter binaryAttributesEditButtonListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralPage.this.editSelectedBinaryAttribute();
            }
        };
        SelectionAdapter binaryAttributesDeleteButtonListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection = (StructuredSelection)GeneralPage.this.binaryAttributesTableViewer.getSelection();
                if (!selection.isEmpty()) {
                    String attribute = (String)selection.getFirstElement();
                    GeneralPage.this.binaryAttributes.remove(attribute);
                    GeneralPage.this.binaryAttributesTableViewer.refresh();
                    GeneralPage.this.setEditorDirty();
                }
            }
        };
        this.selectAllSupportedMechanismsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralPage.this.supportedMechanismsTableViewer.setAllChecked(true);
            }
        });
        this.deselectAllSupportedMechanismsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralPage.this.supportedMechanismsTableViewer.setAllChecked(false);
            }
        });
        this.principalText.addModifyListener(modifyListener);
        this.passwordText.addModifyListener(modifyListener);
        this.enableLdapCheckbox.addSelectionListener((SelectionListener)selectionListener);
        this.enableLdapCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralPage.this.ldapPortText.setEnabled(GeneralPage.this.enableLdapCheckbox.getSelection());
            }
        });
        this.ldapPortText.addModifyListener(modifyListener);
        this.enableLdapsCheckbox.addSelectionListener((SelectionListener)selectionListener);
        this.enableLdapsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralPage.this.ldapsPortText.setEnabled(GeneralPage.this.enableLdapsCheckbox.getSelection());
            }
        });
        this.ldapsPortText.addModifyListener(modifyListener);
        this.enableKerberosCheckbox.addSelectionListener((SelectionListener)selectionListener);
        this.enableKerberosCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralPage.this.kerberosPortText.setEnabled(GeneralPage.this.enableKerberosCheckbox.getSelection());
            }
        });
        this.kerberosPortText.addModifyListener(modifyListener);
        this.enableNtpCheckbox.addSelectionListener((SelectionListener)selectionListener);
        this.enableNtpCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralPage.this.ntpPortText.setEnabled(GeneralPage.this.enableNtpCheckbox.getSelection());
            }
        });
        this.ntpPortText.addModifyListener(modifyListener);
        this.enableDnsCheckbox.addSelectionListener((SelectionListener)selectionListener);
        this.enableDnsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralPage.this.dnsPortText.setEnabled(GeneralPage.this.enableDnsCheckbox.getSelection());
            }
        });
        this.dnsPortText.addModifyListener(modifyListener);
        this.enableChangePasswordCheckbox.addSelectionListener((SelectionListener)selectionListener);
        this.enableChangePasswordCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralPage.this.changePasswordPortText.setEnabled(GeneralPage.this.enableChangePasswordCheckbox.getSelection());
            }
        });
        this.changePasswordPortText.addModifyListener(modifyListener);
        this.supportedMechanismsTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                GeneralPage.this.setEditorDirty();
            }
        });
        this.selectAllSupportedMechanismsButton.addSelectionListener((SelectionListener)selectionListener);
        this.deselectAllSupportedMechanismsButton.addSelectionListener((SelectionListener)selectionListener);
        this.binaryAttributesTableViewer.addSelectionChangedListener(binaryAttributesTableViewerListener);
        this.binaryAttributesTableViewer.addDoubleClickListener(binaryAttributesTableViewerDoubleClickListener);
        this.binaryAttributesAddButton.addSelectionListener((SelectionListener)binaryAttributesAddButtonListener);
        this.binaryAttributesEditButton.addSelectionListener((SelectionListener)binaryAttributesEditButtonListener);
        this.binaryAttributesDeleteButton.addSelectionListener((SelectionListener)binaryAttributesDeleteButtonListener);
        this.maxTimeLimitText.addModifyListener(modifyListener);
        this.maxSizeLimitText.addModifyListener(modifyListener);
        this.synchPeriodText.addModifyListener(modifyListener);
        this.maxThreadsText.addModifyListener(modifyListener);
        this.allowAnonymousAccessCheckbox.addSelectionListener((SelectionListener)selectionListener);
        this.enableAccesControlCheckbox.addSelectionListener((SelectionListener)selectionListener);
        this.denormalizeOpAttrCheckbox.addSelectionListener((SelectionListener)selectionListener);
    }

    private void editSelectedBinaryAttribute() {
        String oldAttribute;
        BinaryAttributeDialog dialog;
        StructuredSelection selection = (StructuredSelection)this.binaryAttributesTableViewer.getSelection();
        if (!selection.isEmpty() && 0 == (dialog = new BinaryAttributeDialog(oldAttribute = (String)selection.getFirstElement())).open() && dialog.isDirty()) {
            this.binaryAttributes.remove(oldAttribute);
            String newAttribute = dialog.getAttribute();
            if (newAttribute != null && !"".equals(newAttribute) && !this.binaryAttributes.contains(newAttribute)) {
                this.binaryAttributes.add(newAttribute);
            }
            this.binaryAttributesTableViewer.refresh();
            this.setEditorDirty();
        }
    }

    private void setEditorDirty() {
        ((ServerConfigurationEditor)this.getEditor()).setDirty(true);
    }

    public void save() {
        ServerConfigurationV151 configuration = (ServerConfigurationV151)((ServerConfigurationEditor)this.getEditor()).getServerConfiguration();
        configuration.setPrincipal(this.principalText.getText());
        configuration.setPassword(this.passwordText.getText());
        configuration.setBinaryAttributes(this.binaryAttributes);
        configuration.setEnableLdap(this.enableLdapCheckbox.getSelection());
        configuration.setLdapPort(Integer.parseInt(this.ldapPortText.getText()));
        configuration.setEnableLdaps(this.enableLdapsCheckbox.getSelection());
        configuration.setLdapsPort(Integer.parseInt(this.ldapsPortText.getText()));
        configuration.setEnableKerberos(this.enableKerberosCheckbox.getSelection());
        configuration.setKerberosPort(Integer.parseInt(this.kerberosPortText.getText()));
        configuration.setEnableNtp(this.enableNtpCheckbox.getSelection());
        configuration.setNtpPort(Integer.parseInt(this.ntpPortText.getText()));
        configuration.setEnableDns(this.enableDnsCheckbox.getSelection());
        configuration.setDnsPort(Integer.parseInt(this.dnsPortText.getText()));
        configuration.setEnableChangePassword(this.enableChangePasswordCheckbox.getSelection());
        configuration.setChangePasswordPort(Integer.parseInt(this.changePasswordPortText.getText()));
        configuration.setMaxTimeLimit(Integer.parseInt(this.maxTimeLimitText.getText()));
        configuration.setMaxSizeLimit(Integer.parseInt(this.maxSizeLimitText.getText()));
        configuration.setSynchronizationPeriod(Long.parseLong(this.synchPeriodText.getText()));
        configuration.setMaxThreads(Integer.parseInt(this.maxThreadsText.getText()));
        ArrayList<String> supportedMechanismsList = new ArrayList<String>();
        for (Object supportedMechanism : this.supportedMechanismsTableViewer.getCheckedElements()) {
            supportedMechanismsList.add((String)supportedMechanism);
        }
        configuration.setSupportedMechanisms(supportedMechanismsList);
        configuration.setAllowAnonymousAccess(this.allowAnonymousAccessCheckbox.getSelection());
        configuration.setEnableAccessControl(this.enableAccesControlCheckbox.getSelection());
        configuration.setDenormalizeOpAttr(this.denormalizeOpAttrCheckbox.getSelection());
    }
}

