/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.editor.v150;

import org.apache.directory.studio.apacheds.configuration.editor.v150.InterceptorsMasterDetailsBlock;
import org.apache.directory.studio.apacheds.configuration.model.v150.Interceptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class InterceptorDetailsPage
implements IDetailsPage {
    private InterceptorsMasterDetailsBlock masterDetailsBlock;
    private IManagedForm mform;
    private Interceptor input;
    private boolean dirty = false;
    private Text nameText;
    private Text classText;
    private ModifyListener textModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            InterceptorDetailsPage.this.masterDetailsBlock.setEditorDirty();
            InterceptorDetailsPage.this.dirty = true;
        }
    };

    public InterceptorDetailsPage(InterceptorsMasterDetailsBlock imdb) {
        this.masterDetailsBlock = imdb;
    }

    public void createContents(Composite parent) {
        FormToolkit toolkit = this.mform.getToolkit();
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 5;
        layout.leftMargin = 5;
        layout.rightMargin = 2;
        layout.bottomMargin = 2;
        parent.setLayout((Layout)layout);
        this.createDetailsSection(parent, toolkit);
    }

    private void createDetailsSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 384);
        section.marginWidth = 10;
        section.setText("Interceptor Details");
        section.setDescription("Set the properties of the interceptor.");
        TableWrapData td = new TableWrapData(128, 16);
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Composite client = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(client);
        GridLayout glayout = new GridLayout(3, false);
        client.setLayout((Layout)glayout);
        section.setClient((Control)client);
        toolkit.createLabel(client, "Name:");
        this.nameText = toolkit.createText(client, "");
        this.nameText.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        toolkit.createLabel(client, "Class:");
        this.classText = toolkit.createText(client, "");
        this.classText.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
    }

    private void addListeners() {
        this.nameText.addModifyListener(this.textModifyListener);
        this.classText.addModifyListener(this.textModifyListener);
    }

    private void removeListeners() {
        this.nameText.removeModifyListener(this.textModifyListener);
        this.classText.removeModifyListener(this.textModifyListener);
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        IStructuredSelection ssel = (IStructuredSelection)selection;
        this.input = ssel.size() == 1 ? (Interceptor)ssel.getFirstElement() : null;
        this.refresh();
    }

    public void commit(boolean onSave) {
        if (this.input != null) {
            this.input.setName(this.nameText.getText());
            this.input.setClassType(this.classText.getText());
        }
    }

    public void dispose() {
    }

    public void initialize(IManagedForm form) {
        this.mform = form;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isStale() {
        return false;
    }

    public void refresh() {
        this.removeListeners();
        String name = this.input.getName();
        this.nameText.setText(name == null ? "" : name);
        String classType = this.input.getClassType();
        this.classText.setText(classType == null ? "" : classType);
        this.addListeners();
    }

    public void setFocus() {
        this.nameText.setFocus();
    }

    public boolean setFormInput(Object input) {
        return false;
    }
}

