/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.editor.v150;

import java.util.List;
import org.apache.directory.studio.apacheds.configuration.ApacheDSConfigurationPluginConstants;
import org.apache.directory.studio.apacheds.configuration.editor.SaveableFormPage;
import org.apache.directory.studio.apacheds.configuration.editor.ServerConfigurationEditor;
import org.apache.directory.studio.apacheds.configuration.editor.v150.dialogs.BinaryAttributeDialog;
import org.apache.directory.studio.apacheds.configuration.model.v150.ServerConfigurationV150;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class GeneralPage
extends FormPage
implements SaveableFormPage {
    public static final String ID = ServerConfigurationEditor.ID + ".BasicPage";
    private static final String TITLE = "General";
    private List<String> binaryAttributes;
    private Text portText;
    private Combo authenticationCombo;
    private Text principalText;
    private Text passwordText;
    private Button showPasswordCheckbox;
    private Button allowAnonymousAccessCheckbox;
    private Text maxTimeLimitText;
    private Text maxSizeLimitText;
    private Text synchPeriodText;
    private Text maxThreadsText;
    private Button enableAccesControlCheckbox;
    private Button enableNTPCheckbox;
    private Button enableKerberosCheckbox;
    private Button enableChangePasswordCheckbox;
    private Button denormalizeOpAttrCheckbox;
    private TableViewer binaryAttributesTableViewer;
    private Button binaryAttributesAddButton;
    private Button binaryAttributesEditButton;
    private Button binaryAttributesDeleteButton;

    public GeneralPage(FormEditor editor) {
        super(editor, ID, TITLE);
    }

    protected void createFormContent(IManagedForm managedForm) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getPartControl(), ApacheDSConfigurationPluginConstants.PLUGIN_ID + "." + "configuration_editor_150");
        ScrolledForm form = managedForm.getForm();
        form.setText(TITLE);
        Composite parent = form.getBody();
        TableWrapLayout twl = new TableWrapLayout();
        twl.numColumns = 2;
        parent.setLayout((Layout)twl);
        FormToolkit toolkit = managedForm.getToolkit();
        this.createSettingsSection(parent, toolkit);
        this.createBinaryAttributesSection(parent, toolkit);
        this.createLimitsSection(parent, toolkit);
        this.createOptionsSection(parent, toolkit);
        this.initFromInput();
        this.addListeners();
    }

    private void createSettingsSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 384);
        section.marginWidth = 4;
        section.setText("Settings");
        section.setDescription("Set the settings of the server.");
        TableWrapData td = new TableWrapData(128, 16);
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Composite client = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(client);
        GridLayout glayout = new GridLayout(2, false);
        client.setLayout((Layout)glayout);
        section.setClient((Control)client);
        toolkit.createLabel(client, "Port:");
        this.portText = toolkit.createText(client, "");
        this.portText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.portText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[0-9]*")) {
                    e.doit = false;
                }
            }
        });
        toolkit.createLabel(client, "Authentication:");
        this.authenticationCombo = new Combo(client, 64);
        this.authenticationCombo.setItems(new String[]{"Simple"});
        this.authenticationCombo.setText("Simple");
        this.authenticationCombo.setEnabled(false);
        this.authenticationCombo.setLayoutData((Object)new GridData(4, 0, true, false));
        toolkit.createLabel(client, "Principal:");
        this.principalText = toolkit.createText(client, "");
        this.principalText.setLayoutData((Object)new GridData(4, 0, true, false));
        toolkit.createLabel(client, "Password:");
        this.passwordText = toolkit.createText(client, "");
        this.passwordText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.passwordText.setEchoChar('\u2022');
        toolkit.createLabel(client, "");
        this.showPasswordCheckbox = toolkit.createButton(client, "Show password", 32);
        this.showPasswordCheckbox.setLayoutData((Object)new GridData(4, 0, true, false));
        this.showPasswordCheckbox.setSelection(false);
        this.showPasswordCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GeneralPage.this.showPasswordCheckbox.getSelection()) {
                    GeneralPage.this.passwordText.setEchoChar('\u0000');
                } else {
                    GeneralPage.this.passwordText.setEchoChar('\u2022');
                }
            }
        });
        this.allowAnonymousAccessCheckbox = toolkit.createButton(client, "Allow Anonymous Access", 32);
        this.allowAnonymousAccessCheckbox.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
    }

    private void createLimitsSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 384);
        section.marginWidth = 4;
        section.setText("Limits");
        section.setDescription("Set the limits of the server.");
        TableWrapData td = new TableWrapData(128, 16);
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Composite client = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(client);
        GridLayout glayout = new GridLayout(2, false);
        client.setLayout((Layout)glayout);
        section.setClient((Control)client);
        toolkit.createLabel(client, "Max. Time Limit:");
        this.maxTimeLimitText = toolkit.createText(client, "");
        this.maxTimeLimitText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.maxTimeLimitText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[0-9]*")) {
                    e.doit = false;
                }
            }
        });
        toolkit.createLabel(client, "Max. Size Limit:");
        this.maxSizeLimitText = toolkit.createText(client, "");
        this.maxSizeLimitText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.maxSizeLimitText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[0-9]*")) {
                    e.doit = false;
                }
            }
        });
        toolkit.createLabel(client, "Synchronization Period:");
        this.synchPeriodText = toolkit.createText(client, "");
        this.synchPeriodText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.synchPeriodText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[0-9]*")) {
                    e.doit = false;
                }
            }
        });
        toolkit.createLabel(client, "Max. Threads:");
        this.maxThreadsText = toolkit.createText(client, "");
        this.maxThreadsText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.maxThreadsText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[0-9]*")) {
                    e.doit = false;
                }
            }
        });
    }

    private void createOptionsSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 384);
        section.marginWidth = 4;
        section.setText("Options");
        section.setDescription("Set the options of the server.");
        TableWrapData td = new TableWrapData(128, 16);
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Composite client = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(client);
        GridLayout glayout = new GridLayout();
        client.setLayout((Layout)glayout);
        section.setClient((Control)client);
        this.enableAccesControlCheckbox = toolkit.createButton(client, "Enable Access Control", 32);
        this.enableAccesControlCheckbox.setLayoutData((Object)new GridData(4, 0, true, false));
        this.enableNTPCheckbox = toolkit.createButton(client, "Enable NTP", 32);
        this.enableNTPCheckbox.setLayoutData((Object)new GridData(4, 0, true, false));
        this.denormalizeOpAttrCheckbox = toolkit.createButton(client, "Denormalize Operational Attributes", 32);
        this.denormalizeOpAttrCheckbox.setLayoutData((Object)new GridData(4, 0, true, false));
        this.enableKerberosCheckbox = toolkit.createButton(client, "Enable Kerberos", 32);
        this.enableKerberosCheckbox.setLayoutData((Object)new GridData(4, 0, true, false));
        this.enableKerberosCheckbox.setEnabled(false);
        this.enableChangePasswordCheckbox = toolkit.createButton(client, "Enable Change Password", 32);
        this.enableChangePasswordCheckbox.setLayoutData((Object)new GridData(4, 0, true, false));
        this.enableChangePasswordCheckbox.setEnabled(false);
    }

    private void createBinaryAttributesSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 384);
        section.marginWidth = 4;
        section.setText("Binary Attributes");
        section.setDescription("Set attribute type names and OID's if you want an them to be handled as binary content.");
        TableWrapData td = new TableWrapData(128, 16);
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Composite client = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(client);
        GridLayout glayout = new GridLayout(2, false);
        client.setLayout((Layout)glayout);
        section.setClient((Control)client);
        Table binaryAttributesTable = toolkit.createTable(client, 0);
        GridData gd = new GridData(4, 0, true, false, 1, 3);
        gd.heightHint = 103;
        binaryAttributesTable.setLayoutData((Object)gd);
        this.binaryAttributesTableViewer = new TableViewer(binaryAttributesTable);
        this.binaryAttributesTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.binaryAttributesTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        GridData buttonsGD = new GridData(4, 1, false, false);
        buttonsGD.widthHint = 61;
        this.binaryAttributesAddButton = toolkit.createButton(client, "Add...", 8);
        this.binaryAttributesAddButton.setLayoutData((Object)buttonsGD);
        this.binaryAttributesEditButton = toolkit.createButton(client, "Edit...", 8);
        this.binaryAttributesEditButton.setEnabled(false);
        this.binaryAttributesEditButton.setLayoutData((Object)buttonsGD);
        this.binaryAttributesDeleteButton = toolkit.createButton(client, "Delete", 8);
        this.binaryAttributesDeleteButton.setEnabled(false);
        this.binaryAttributesDeleteButton.setLayoutData((Object)buttonsGD);
    }

    private void initFromInput() {
        String password;
        ServerConfigurationV150 configuration = (ServerConfigurationV150)((ServerConfigurationEditor)this.getEditor()).getServerConfiguration();
        this.binaryAttributes = configuration.getBinaryAttributes();
        this.binaryAttributesTableViewer.setInput(this.binaryAttributes);
        this.portText.setText("" + configuration.getPort());
        String principal = configuration.getPrincipal();
        if (principal != null) {
            this.principalText.setText(principal);
        }
        if ((password = configuration.getPassword()) != null) {
            this.passwordText.setText(password);
        }
        this.allowAnonymousAccessCheckbox.setSelection(configuration.isAllowAnonymousAccess());
        this.maxTimeLimitText.setText("" + configuration.getMaxTimeLimit());
        this.maxSizeLimitText.setText("" + configuration.getMaxSizeLimit());
        this.synchPeriodText.setText("" + configuration.getSynchronizationPeriod());
        this.maxThreadsText.setText("" + configuration.getMaxThreads());
        this.enableAccesControlCheckbox.setSelection(configuration.isEnableAccessControl());
        this.enableNTPCheckbox.setSelection(configuration.isEnableNTP());
        this.enableKerberosCheckbox.setSelection(configuration.isEnableKerberos());
        this.enableChangePasswordCheckbox.setSelection(configuration.isEnableChangePassword());
        this.denormalizeOpAttrCheckbox.setSelection(configuration.isDenormalizeOpAttr());
    }

    private void addListeners() {
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneralPage.this.setEditorDirty();
            }
        };
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralPage.this.setEditorDirty();
            }
        };
        ISelectionChangedListener binaryAttributesTableViewerListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                GeneralPage.this.binaryAttributesEditButton.setEnabled(!event.getSelection().isEmpty());
                GeneralPage.this.binaryAttributesDeleteButton.setEnabled(!event.getSelection().isEmpty());
            }
        };
        IDoubleClickListener binaryAttributesTableViewerDoubleClickListener = new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                GeneralPage.this.editSelectedBinaryAttribute();
            }
        };
        SelectionAdapter binaryAttributesAddButtonListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String newAttribute;
                BinaryAttributeDialog dialog = new BinaryAttributeDialog("");
                if (0 == dialog.open() && dialog.isDirty() && (newAttribute = dialog.getAttribute()) != null && !"".equals(newAttribute) && !GeneralPage.this.binaryAttributes.contains(newAttribute)) {
                    GeneralPage.this.binaryAttributes.add(newAttribute);
                    GeneralPage.this.binaryAttributesTableViewer.refresh();
                    GeneralPage.this.setEditorDirty();
                }
            }
        };
        SelectionAdapter binaryAttributesEditButtonListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralPage.this.editSelectedBinaryAttribute();
            }
        };
        SelectionAdapter binaryAttributesDeleteButtonListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection = (StructuredSelection)GeneralPage.this.binaryAttributesTableViewer.getSelection();
                if (!selection.isEmpty()) {
                    String attribute = (String)selection.getFirstElement();
                    GeneralPage.this.binaryAttributes.remove(attribute);
                    GeneralPage.this.binaryAttributesTableViewer.refresh();
                    GeneralPage.this.setEditorDirty();
                }
            }
        };
        this.portText.addModifyListener(modifyListener);
        this.authenticationCombo.addModifyListener(modifyListener);
        this.principalText.addModifyListener(modifyListener);
        this.passwordText.addModifyListener(modifyListener);
        this.allowAnonymousAccessCheckbox.addSelectionListener((SelectionListener)selectionListener);
        this.maxTimeLimitText.addModifyListener(modifyListener);
        this.maxSizeLimitText.addModifyListener(modifyListener);
        this.synchPeriodText.addModifyListener(modifyListener);
        this.maxThreadsText.addModifyListener(modifyListener);
        this.enableAccesControlCheckbox.addSelectionListener((SelectionListener)selectionListener);
        this.enableNTPCheckbox.addSelectionListener((SelectionListener)selectionListener);
        this.enableKerberosCheckbox.addSelectionListener((SelectionListener)selectionListener);
        this.enableChangePasswordCheckbox.addSelectionListener((SelectionListener)selectionListener);
        this.denormalizeOpAttrCheckbox.addSelectionListener((SelectionListener)selectionListener);
        this.binaryAttributesTableViewer.addSelectionChangedListener(binaryAttributesTableViewerListener);
        this.binaryAttributesTableViewer.addDoubleClickListener(binaryAttributesTableViewerDoubleClickListener);
        this.binaryAttributesAddButton.addSelectionListener((SelectionListener)binaryAttributesAddButtonListener);
        this.binaryAttributesEditButton.addSelectionListener((SelectionListener)binaryAttributesEditButtonListener);
        this.binaryAttributesDeleteButton.addSelectionListener((SelectionListener)binaryAttributesDeleteButtonListener);
    }

    private void editSelectedBinaryAttribute() {
        String oldAttribute;
        BinaryAttributeDialog dialog;
        StructuredSelection selection = (StructuredSelection)this.binaryAttributesTableViewer.getSelection();
        if (!selection.isEmpty() && 0 == (dialog = new BinaryAttributeDialog(oldAttribute = (String)selection.getFirstElement())).open() && dialog.isDirty()) {
            this.binaryAttributes.remove(oldAttribute);
            String newAttribute = dialog.getAttribute();
            if (newAttribute != null && !"".equals(newAttribute) && !this.binaryAttributes.contains(newAttribute)) {
                this.binaryAttributes.add(newAttribute);
            }
            this.binaryAttributesTableViewer.refresh();
            this.setEditorDirty();
        }
    }

    private void setEditorDirty() {
        ((ServerConfigurationEditor)this.getEditor()).setDirty(true);
    }

    public void save() {
        ServerConfigurationV150 serverConfiguration = (ServerConfigurationV150)((ServerConfigurationEditor)this.getEditor()).getServerConfiguration();
        serverConfiguration.setPort(Integer.parseInt(this.portText.getText()));
        serverConfiguration.setPrincipal(this.principalText.getText());
        serverConfiguration.setPassword(this.passwordText.getText());
        serverConfiguration.setAllowAnonymousAccess(this.allowAnonymousAccessCheckbox.getSelection());
        serverConfiguration.setMaxTimeLimit(Integer.parseInt(this.maxTimeLimitText.getText()));
        serverConfiguration.setMaxSizeLimit(Integer.parseInt(this.maxSizeLimitText.getText()));
        serverConfiguration.setSynchronizationPeriod(Long.parseLong(this.synchPeriodText.getText()));
        serverConfiguration.setMaxThreads(Integer.parseInt(this.maxThreadsText.getText()));
        serverConfiguration.setEnableAccessControl(this.enableAccesControlCheckbox.getSelection());
        serverConfiguration.setEnableNTP(this.enableNTPCheckbox.getSelection());
        serverConfiguration.setEnableKerberos(this.enableKerberosCheckbox.getSelection());
        serverConfiguration.setEnableChangePassword(this.enableChangePasswordCheckbox.getSelection());
        serverConfiguration.setDenormalizeOpAttr(this.denormalizeOpAttrCheckbox.getSelection());
    }
}

