/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.editor;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.PlatformUI;

class PathEditorInput
implements IPathEditorInput {
    private IPath path;

    public PathEditorInput(IPath path) {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        this.path = path;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof PathEditorInput) {
            PathEditorInput input = (PathEditorInput)o;
            return this.path.equals(input.path);
        }
        return false;
    }

    public boolean exists() {
        return this.path.toFile().exists();
    }

    public ImageDescriptor getImageDescriptor() {
        return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(this.path.toString());
    }

    public String getName() {
        return this.path.toFile().getName();
    }

    public String getToolTipText() {
        return this.path.makeRelative().toOSString();
    }

    public IPath getPath() {
        return this.path;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public IPath getErrorMessage(Object element) {
        if (element instanceof PathEditorInput) {
            PathEditorInput input = (PathEditorInput)element;
            return input.getPath();
        }
        return null;
    }
}

