/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.valueeditors;

import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.valueeditors.AbstractDialogValueEditor;

public abstract class AbstractDialogStringValueEditor
extends AbstractDialogValueEditor {
    protected AbstractDialogStringValueEditor() {
    }

    public String getDisplayValue(IValue value) {
        Object obj = this.getRawValue(value);
        return obj == null ? "NULL" : obj.toString();
    }

    protected Object getEmptyRawValue(IAttribute attribute) {
        if (attribute.isString()) {
            return IValue.EMPTY_STRING_VALUE;
        }
        return IValue.EMPTY_BINARY_VALUE;
    }

    public Object getRawValue(IValue value) {
        if (value == null) {
            return null;
        }
        if (value.isString()) {
            return value.getStringValue();
        }
        if (value.isBinary()) {
            return this.isEditable(value.getBinaryValue()) ? value.getStringValue() : null;
        }
        return null;
    }

    private boolean isEditable(byte[] b) {
        if (b == null) {
            return false;
        }
        for (int i = 0; i < b.length; ++i) {
            if (b[i] == 10 || b[i] == 13 || b[i] >= 32 && b[i] <= 127) continue;
            return false;
        }
        return true;
    }

    public Object getStringOrBinaryValue(Object rawValue) {
        if (rawValue == null) {
            return null;
        }
        if (rawValue instanceof String) {
            return rawValue;
        }
        return null;
    }
}

