/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.valueeditors;

import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.valueeditors.AbstractDialogValueEditor;
import org.apache.directory.studio.valueeditors.Messages;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractDialogBinaryValueEditor
extends AbstractDialogValueEditor {
    protected AbstractDialogBinaryValueEditor() {
    }

    public String getDisplayValue(IValue value) {
        if (this.showRawValues()) {
            return AbstractDialogBinaryValueEditor.getPrintableString(value);
        }
        if (value == null) {
            return "NULL";
        }
        if (value.isBinary()) {
            byte[] data = value.getBinaryValue();
            return NLS.bind((String)Messages.getString("AbstractDialogBinaryValueEditor.BinaryDateNBytes"), (Object)data.length);
        }
        return Messages.getString("AbstractDialogBinaryValueEditor.InvalidData");
    }

    public static String getPrintableString(IValue value) {
        if (value == null) {
            return "NULL";
        }
        if (value.isBinary()) {
            byte[] data = value.getBinaryValue();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; data != null && i < data.length && i < 128; ++i) {
                if (data[i] > 32 && data[i] < 127) {
                    sb.append((char)data[i]);
                    continue;
                }
                sb.append('.');
            }
            return sb.toString();
        }
        if (value.isString()) {
            return value.getStringValue();
        }
        return "NULL";
    }

    protected Object getEmptyRawValue(IAttribute attribute) {
        if (attribute.isBinary()) {
            return IValue.EMPTY_BINARY_VALUE;
        }
        return null;
    }

    public Object getRawValue(IValue value) {
        if (value == null) {
            return null;
        }
        if (value.isString()) {
            return value.getBinaryValue();
        }
        if (value.isBinary()) {
            return value.getBinaryValue();
        }
        return null;
    }

    public Object getStringOrBinaryValue(Object rawValue) {
        if (rawValue == null) {
            return null;
        }
        if (rawValue instanceof byte[]) {
            return rawValue;
        }
        return null;
    }
}

