/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.wizards;

import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.studio.connection.core.jobs.StudioRunnableWithProgress;
import org.apache.directory.studio.connection.ui.RunnableContextRunner;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonConstants;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserCategory;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserEntryPage;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserSearchResultPage;
import org.apache.directory.studio.ldapbrowser.common.wizards.Messages;
import org.apache.directory.studio.ldapbrowser.common.wizards.NewEntryAttributesWizardPage;
import org.apache.directory.studio.ldapbrowser.common.wizards.NewEntryDnWizardPage;
import org.apache.directory.studio.ldapbrowser.common.wizards.NewEntryObjectclassWizardPage;
import org.apache.directory.studio.ldapbrowser.common.wizards.NewEntryTypeWizardPage;
import org.apache.directory.studio.ldapbrowser.core.jobs.CreateEntryRunnable;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IBookmark;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.model.impl.DummyEntry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class NewEntryWizard
extends Wizard
implements INewWizard {
    protected NewEntryTypeWizardPage typePage;
    protected NewEntryObjectclassWizardPage ocPage;
    protected NewEntryDnWizardPage dnPage;
    protected NewEntryAttributesWizardPage attributePage;
    protected IEntry selectedEntry;
    protected IBrowserConnection selectedConnection;
    protected boolean originalReadOnlyFlag;
    protected DummyEntry prototypeEntry;

    public NewEntryWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public static String getId() {
        return BrowserCommonConstants.WIZARD_NEW_ENTRY_WIZARD;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object o = selection.getFirstElement();
        if (this.isNewContextEntry()) {
            this.setWindowTitle(Messages.getString("NewEntryWizard.NewContextEntry"));
        } else {
            this.setWindowTitle(Messages.getString("NewEntryWizard.NewEntry"));
        }
        if (o instanceof IEntry) {
            this.selectedEntry = (IEntry)o;
            this.selectedConnection = this.selectedEntry.getBrowserConnection();
        } else if (o instanceof ISearchResult) {
            this.selectedEntry = ((ISearchResult)o).getEntry();
            this.selectedConnection = this.selectedEntry.getBrowserConnection();
        } else if (o instanceof IBookmark) {
            this.selectedEntry = ((IBookmark)o).getEntry();
            this.selectedConnection = this.selectedEntry.getBrowserConnection();
        } else if (o instanceof IAttribute) {
            this.selectedEntry = ((IAttribute)o).getEntry();
            this.selectedConnection = this.selectedEntry.getBrowserConnection();
        } else if (o instanceof IValue) {
            this.selectedEntry = ((IValue)o).getAttribute().getEntry();
            this.selectedConnection = this.selectedEntry.getBrowserConnection();
        } else if (o instanceof ISearch) {
            this.selectedEntry = null;
            this.selectedConnection = ((ISearch)o).getBrowserConnection();
        } else if (o instanceof IBrowserConnection) {
            this.selectedEntry = null;
            this.selectedConnection = (IBrowserConnection)o;
        } else if (o instanceof BrowserCategory) {
            this.selectedEntry = null;
            this.selectedConnection = ((BrowserCategory)o).getParent();
        } else if (o instanceof BrowserSearchResultPage) {
            this.selectedEntry = null;
            this.selectedConnection = ((BrowserSearchResultPage)o).getSearch().getBrowserConnection();
        } else if (o instanceof BrowserEntryPage) {
            this.selectedEntry = null;
            this.selectedConnection = ((BrowserEntryPage)o).getEntry().getBrowserConnection();
        } else {
            this.selectedEntry = null;
            this.selectedConnection = null;
        }
        if (this.selectedConnection != null) {
            if (this.selectedConnection.getConnection() != null) {
                this.originalReadOnlyFlag = this.selectedConnection.getConnection().isReadOnly();
                this.selectedConnection.getConnection().setReadOnly(true);
            }
            this.prototypeEntry = new DummyEntry(new LdapDN(), this.selectedConnection);
        }
    }

    public void addPages() {
        if (this.selectedConnection != null) {
            this.typePage = new NewEntryTypeWizardPage(NewEntryTypeWizardPage.class.getName(), this);
            this.addPage((IWizardPage)this.typePage);
            this.ocPage = new NewEntryObjectclassWizardPage(NewEntryObjectclassWizardPage.class.getName(), this);
            this.addPage((IWizardPage)this.ocPage);
            this.dnPage = new NewEntryDnWizardPage(NewEntryDnWizardPage.class.getName(), this);
            this.addPage((IWizardPage)this.dnPage);
            this.attributePage = new NewEntryAttributesWizardPage(NewEntryAttributesWizardPage.class.getName(), this);
            this.addPage((IWizardPage)this.attributePage);
        } else {
            DummyWizardPage page = new DummyWizardPage();
            this.addPage((IWizardPage)page);
        }
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        if (this.selectedConnection != null) {
            if (this.typePage != null) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp(this.typePage.getControl(), BrowserCommonConstants.PLUGIN_ID + "." + "tools_newentry_wizard");
            }
            if (this.ocPage != null) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp(this.ocPage.getControl(), BrowserCommonConstants.PLUGIN_ID + "." + "tools_newentry_wizard");
            }
            if (this.dnPage != null) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp(this.dnPage.getControl(), BrowserCommonConstants.PLUGIN_ID + "." + "tools_newentry_wizard");
            }
            if (this.attributePage != null) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp(this.attributePage.getControl(), BrowserCommonConstants.PLUGIN_ID + "." + "tools_newentry_wizard");
            }
        }
    }

    public boolean performCancel() {
        if (this.selectedConnection != null && this.selectedConnection.getConnection() != null) {
            this.selectedConnection.getConnection().setReadOnly(this.originalReadOnlyFlag);
        }
        return true;
    }

    public boolean performFinish() {
        try {
            if (this.selectedConnection != null && this.selectedConnection.getConnection() != null) {
                this.selectedConnection.getConnection().setReadOnly(this.originalReadOnlyFlag);
                this.typePage.saveDialogSettings();
                this.dnPage.saveDialogSettings();
                CreateEntryRunnable runnable = new CreateEntryRunnable((IEntry)this.prototypeEntry, this.selectedConnection);
                IStatus status = RunnableContextRunner.execute((StudioRunnableWithProgress)runnable, (IRunnableContext)this.getContainer(), (boolean)true);
                if (!status.isOK()) {
                    this.selectedConnection.getConnection().setReadOnly(true);
                    return false;
                }
                return true;
            }
            return true;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    public IEntry getSelectedEntry() {
        return this.selectedEntry;
    }

    public IBrowserConnection getSelectedConnection() {
        return this.selectedConnection;
    }

    public DummyEntry getPrototypeEntry() {
        return this.prototypeEntry;
    }

    public void setPrototypeEntry(DummyEntry getPrototypeEntry) {
        this.prototypeEntry = getPrototypeEntry;
    }

    public boolean isNewContextEntry() {
        return false;
    }

    class DummyWizardPage
    extends WizardPage {
        protected DummyWizardPage() {
            super("");
            this.setTitle(Messages.getString("NewEntryWizard.NoConnectonSelected"));
            this.setDescription(Messages.getString("NewEntryWizard.NoConnectonSelectedDescription"));
            this.setImageDescriptor(BrowserCommonActivator.getDefault().getImageDescriptor("resources/icons/entry_wizard.gif"));
            this.setPageComplete(true);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout gl = new GridLayout(1, false);
            composite.setLayout((Layout)gl);
            composite.setLayoutData((Object)new GridData(1808));
            this.setControl((Control)composite);
        }
    }
}

