/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.directory.shared.ldap.schema.ObjectClassTypeEnum;
import org.apache.directory.shared.ldap.schema.parsers.AbstractSchemaDescription;
import org.apache.directory.shared.ldap.schema.parsers.ObjectClassDescription;
import org.apache.directory.studio.connection.core.jobs.StudioRunnableWithProgress;
import org.apache.directory.studio.connection.ui.RunnableContextRunner;
import org.apache.directory.studio.connection.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.wizards.Messages;
import org.apache.directory.studio.ldapbrowser.common.wizards.NewEntryWizard;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.jobs.ReloadSchemaRunnable;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.model.impl.Attribute;
import org.apache.directory.studio.ldapbrowser.core.model.impl.DummyEntry;
import org.apache.directory.studio.ldapbrowser.core.model.impl.Value;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewEntryObjectclassWizardPage
extends WizardPage {
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 250;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 400;
    private NewEntryWizard wizard;
    private List<ObjectClassDescription> availableObjectClasses;
    private Text availableObjectClassesInstantSearch;
    private TableViewer availableObjectClassesViewer;
    private List<ObjectClassDescription> selectedObjectClasses;
    private TableViewer selectedObjectClassesViewer;
    private Button addButton;
    private Button removeButton;
    private LabelProvider labelProvider = new LabelProvider(){

        public String getText(Object element) {
            if (element instanceof ObjectClassDescription) {
                ObjectClassDescription ocd = (ObjectClassDescription)element;
                return SchemaUtils.toString((AbstractSchemaDescription)ocd);
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof ObjectClassDescription) {
                ObjectClassDescription ocd = (ObjectClassDescription)element;
                switch (ocd.getKind()) {
                    case STRUCTURAL: {
                        return BrowserCommonActivator.getDefault().getImage("resources/icons/ocd_structural.gif");
                    }
                    case ABSTRACT: {
                        return BrowserCommonActivator.getDefault().getImage("resources/icons/ocd_abstract.gif");
                    }
                    case AUXILIARY: {
                        return BrowserCommonActivator.getDefault().getImage("resources/icons/ocd_auxiliary.gif");
                    }
                }
                return BrowserCommonActivator.getDefault().getImage("resources/icons/ocd.png");
            }
            return super.getImage(element);
        }
    };

    public NewEntryObjectclassWizardPage(String pageName, NewEntryWizard wizard) {
        super(pageName);
        this.setTitle(Messages.getString("NewEntryObjectclassWizardPage.ObjectClasses"));
        this.setDescription(Messages.getString("NewEntryObjectclassWizardPage.ObjectClassesDescription"));
        this.setImageDescriptor(BrowserCommonActivator.getDefault().getImageDescriptor("resources/icons/entry_wizard.gif"));
        this.setPageComplete(false);
        this.wizard = wizard;
        this.availableObjectClasses = new ArrayList<ObjectClassDescription>();
        this.selectedObjectClasses = new ArrayList<ObjectClassDescription>();
    }

    private void validate() {
        if (!this.selectedObjectClasses.isEmpty()) {
            boolean hasOneStructuralOC = false;
            for (ObjectClassDescription ocd : this.selectedObjectClasses) {
                if (ocd.getKind() != ObjectClassTypeEnum.STRUCTURAL) continue;
                hasOneStructuralOC = true;
                break;
            }
            if (!hasOneStructuralOC) {
                this.setMessage(Messages.getString("NewEntryObjectclassWizardPage.SelectStructuralObjectClass"), 2);
            } else {
                this.setMessage(null);
            }
            this.setPageComplete(true);
            this.saveState();
        } else {
            this.setPageComplete(false);
            this.setMessage(null);
        }
    }

    private void loadState() {
        this.availableObjectClasses.clear();
        this.selectedObjectClasses.clear();
        if (this.wizard.getSelectedConnection() != null) {
            this.availableObjectClasses.addAll(this.wizard.getSelectedConnection().getSchema().getObjectClassDescriptions());
            DummyEntry newEntry = this.wizard.getPrototypeEntry();
            IAttribute ocAttribute = newEntry.getAttribute("objectClass");
            if (ocAttribute != null) {
                for (IValue ocValue : ocAttribute.getValues()) {
                    if (ocValue.isEmpty()) continue;
                    ObjectClassDescription ocd = this.wizard.getSelectedConnection().getSchema().getObjectClassDescription(ocValue.getStringValue());
                    this.availableObjectClasses.remove(ocd);
                    this.selectedObjectClasses.add(ocd);
                }
            }
        }
        this.availableObjectClassesViewer.refresh();
        this.selectedObjectClassesViewer.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveState() {
        DummyEntry newEntry = this.wizard.getPrototypeEntry();
        try {
            IValue[] values;
            EventRegistry.suspendEventFiringInCurrentThread();
            IAttribute ocAttribute = newEntry.getAttribute("objectClass");
            if (ocAttribute == null) {
                ocAttribute = new Attribute((IEntry)newEntry, "objectClass");
                newEntry.addAttribute(ocAttribute);
            }
            for (IValue value : values = ocAttribute.getValues()) {
                ocAttribute.deleteValue(value);
            }
            for (ObjectClassDescription ocd : this.selectedObjectClasses) {
                ocAttribute.addValue((IValue)new Value(ocAttribute, ocd.getNames().get(0)));
            }
        }
        finally {
            EventRegistry.resumeEventFiringInCurrentThread();
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.loadState();
            this.validate();
            this.availableObjectClassesInstantSearch.setFocus();
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout(3, false);
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(1808));
        Label availableLabel = new Label(composite, 0);
        availableLabel.setText(Messages.getString("NewEntryObjectclassWizardPage.AvailableObjectClasses"));
        Label buttonLabel = new Label(composite, 0);
        buttonLabel.setText("");
        Label selectedLabel = new Label(composite, 0);
        selectedLabel.setText(Messages.getString("NewEntryObjectclassWizardPage.SelectedObjectClasses"));
        Composite availableObjectClassesComposite = BaseWidgetUtils.createColumnContainer((Composite)composite, (int)1, (int)1);
        Composite availableObjectClassesInstantSearchComposite = BaseWidgetUtils.createColumnContainer((Composite)availableObjectClassesComposite, (int)2, (int)1);
        this.availableObjectClassesInstantSearch = new Text(availableObjectClassesInstantSearchComposite, 2432);
        this.availableObjectClassesInstantSearch.setLayoutData((Object)new GridData(768));
        this.availableObjectClassesInstantSearch.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewEntryObjectclassWizardPage.this.availableObjectClassesViewer.refresh();
                if (NewEntryObjectclassWizardPage.this.availableObjectClassesViewer.getTable().getItemCount() >= 1) {
                    Object item = NewEntryObjectclassWizardPage.this.availableObjectClassesViewer.getElementAt(0);
                    NewEntryObjectclassWizardPage.this.availableObjectClassesViewer.setSelection((ISelection)new StructuredSelection(item));
                }
            }
        });
        this.availableObjectClassesInstantSearch.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    NewEntryObjectclassWizardPage.this.availableObjectClassesViewer.getTable().setFocus();
                } else if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    NewEntryObjectclassWizardPage.this.add(NewEntryObjectclassWizardPage.this.availableObjectClassesViewer.getSelection());
                }
            }
        });
        ControlDecoration availableObjectClassesInstantSearchDecoration = new ControlDecoration((Control)this.availableObjectClassesInstantSearch, 16512, composite);
        availableObjectClassesInstantSearchDecoration.setDescriptionText(Messages.getString("NewEntryObjectclassWizardPage.FilterDescription"));
        availableObjectClassesInstantSearchDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage());
        Button reloadButton = new Button(availableObjectClassesInstantSearchComposite, 0x800008);
        reloadButton.setToolTipText(Messages.getString("NewEntryObjectclassWizardPage.ReloadSchema"));
        reloadButton.setImage(BrowserCommonActivator.getDefault().getImage("resources/icons/refresh.gif"));
        reloadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IBrowserConnection browserConnection = NewEntryObjectclassWizardPage.this.wizard.getSelectedConnection();
                ReloadSchemaRunnable runnable = new ReloadSchemaRunnable(browserConnection);
                RunnableContextRunner.execute((StudioRunnableWithProgress)runnable, (IRunnableContext)NewEntryObjectclassWizardPage.this.wizard.getContainer(), (boolean)true);
                NewEntryObjectclassWizardPage.this.setVisible(true);
            }
        });
        this.availableObjectClassesViewer = new TableViewer(availableObjectClassesComposite);
        GridData data = new GridData(1808);
        data.heightHint = 250;
        data.widthHint = 160;
        this.availableObjectClassesViewer.getTable().setLayoutData((Object)data);
        this.availableObjectClassesViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.availableObjectClassesViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.availableObjectClassesViewer.setSorter(new ViewerSorter());
        this.availableObjectClassesViewer.addFilter((ViewerFilter)new InstantSearchFilter(this.availableObjectClassesInstantSearch));
        this.availableObjectClassesViewer.setInput(this.availableObjectClasses);
        this.availableObjectClassesViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                NewEntryObjectclassWizardPage.this.add(event.getSelection());
            }
        });
        this.availableObjectClassesViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000001 && NewEntryObjectclassWizardPage.this.availableObjectClassesViewer.getTable().getSelectionIndex() <= 0) {
                    NewEntryObjectclassWizardPage.this.availableObjectClassesInstantSearch.setFocus();
                }
            }
        });
        Composite buttonComposite = new Composite(composite, 0);
        gl = new GridLayout(1, true);
        buttonComposite.setLayout((Layout)gl);
        data = new GridData(1808);
        data.heightHint = 250;
        data.horizontalAlignment = 0x1000000;
        buttonComposite.setLayoutData((Object)data);
        Label label0 = new Label(buttonComposite, 0);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        label0.setLayoutData((Object)data);
        this.addButton = BaseWidgetUtils.createButton((Composite)buttonComposite, (String)Messages.getString("NewEntryObjectclassWizardPage.AddButton"), (int)1);
        this.removeButton = BaseWidgetUtils.createButton((Composite)buttonComposite, (String)Messages.getString("NewEntryObjectclassWizardPage.RemoveButton"), (int)1);
        Label label3 = new Label(buttonComposite, 0);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        label3.setLayoutData((Object)data);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewEntryObjectclassWizardPage.this.add(NewEntryObjectclassWizardPage.this.availableObjectClassesViewer.getSelection());
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewEntryObjectclassWizardPage.this.remove(NewEntryObjectclassWizardPage.this.selectedObjectClassesViewer.getSelection());
            }
        });
        this.selectedObjectClassesViewer = new TableViewer(composite);
        data = new GridData(1808);
        data.heightHint = 250;
        data.widthHint = 160;
        this.selectedObjectClassesViewer.getTable().setLayoutData((Object)data);
        this.selectedObjectClassesViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.selectedObjectClassesViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.selectedObjectClassesViewer.setSorter(new ViewerSorter());
        this.selectedObjectClassesViewer.setInput(this.selectedObjectClasses);
        this.selectedObjectClassesViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                NewEntryObjectclassWizardPage.this.remove(event.getSelection());
            }
        });
        this.setControl((Control)composite);
    }

    private void add(ISelection iselection) {
        IStructuredSelection selection = (IStructuredSelection)iselection;
        Schema schema = this.wizard.getSelectedConnection().getSchema();
        for (ObjectClassDescription ocd : selection) {
            if (!this.availableObjectClasses.contains(ocd) || this.selectedObjectClasses.contains(ocd)) continue;
            this.availableObjectClasses.remove(ocd);
            this.selectedObjectClasses.add(ocd);
            List superiorObjectClassDescriptions = SchemaUtils.getSuperiorObjectClassDescriptions((ObjectClassDescription)ocd, (Schema)schema);
            if (superiorObjectClassDescriptions.isEmpty()) continue;
            this.add((ISelection)new StructuredSelection(superiorObjectClassDescriptions));
        }
        this.availableObjectClassesViewer.refresh();
        this.selectedObjectClassesViewer.refresh();
        this.validate();
        if (!"".equals(this.availableObjectClassesInstantSearch.getText())) {
            this.availableObjectClassesInstantSearch.setText("");
            this.availableObjectClassesInstantSearch.setFocus();
        }
    }

    private void remove(ISelection iselection) {
        IStructuredSelection selection = (IStructuredSelection)iselection;
        Schema schema = this.wizard.getSelectedConnection().getSchema();
        for (ObjectClassDescription ocd : selection) {
            if (this.availableObjectClasses.contains(ocd) || !this.selectedObjectClasses.contains(ocd)) continue;
            this.selectedObjectClasses.remove(ocd);
            this.availableObjectClasses.add(ocd);
            List subObjectClassDescriptions = SchemaUtils.getSuperiorObjectClassDescriptions((ObjectClassDescription)ocd, (Schema)schema);
            if (subObjectClassDescriptions.isEmpty()) continue;
            this.remove((ISelection)new StructuredSelection(subObjectClassDescriptions));
        }
        ArrayList<ObjectClassDescription> copy = new ArrayList<ObjectClassDescription>(this.selectedObjectClasses);
        for (ObjectClassDescription ocd : copy) {
            List superiorObjectClassDescriptions = SchemaUtils.getSuperiorObjectClassDescriptions((ObjectClassDescription)ocd, (Schema)schema);
            if (superiorObjectClassDescriptions.isEmpty()) continue;
            this.add((ISelection)new StructuredSelection(superiorObjectClassDescriptions));
        }
        this.availableObjectClassesViewer.refresh();
        this.selectedObjectClassesViewer.refresh();
        this.validate();
    }

    private class InstantSearchFilter
    extends ViewerFilter {
        private Text filterText;

        private InstantSearchFilter(Text filterText) {
            this.filterText = filterText;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof ObjectClassDescription) {
                ObjectClassDescription ocd = (ObjectClassDescription)element;
                Collection lowerCaseIdentifiers = SchemaUtils.getLowerCaseIdentifiers((AbstractSchemaDescription)ocd);
                for (String s : lowerCaseIdentifiers) {
                    if (!s.toLowerCase().startsWith(this.filterText.getText().toLowerCase())) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

