/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.wizards;

import org.apache.directory.studio.ldapbrowser.common.wizards.Messages;
import org.apache.directory.studio.ldapbrowser.common.wizards.NewEntryAttributesWizardPage;
import org.apache.directory.studio.ldapbrowser.common.wizards.NewEntryObjectclassWizardPage;
import org.apache.directory.studio.ldapbrowser.common.wizards.NewEntryWizard;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.impl.DummyEntry;
import org.apache.directory.studio.ldapbrowser.core.utils.CompoundModification;
import org.apache.directory.studio.ldapbrowser.core.utils.ModelConverter;
import org.apache.directory.studio.ldifparser.model.container.LdifContentRecord;
import org.eclipse.jface.wizard.IWizardPage;

public class EditEntryWizard
extends NewEntryWizard {
    public EditEntryWizard(IEntry entry) {
        this.setWindowTitle(Messages.getString("EditEntryWizard.EditEntry"));
        this.setNeedsProgressMonitor(true);
        this.selectedEntry = entry;
        this.selectedConnection = entry.getBrowserConnection();
        try {
            EventRegistry.suspendEventFiringInCurrentThread();
            LdifContentRecord record = ModelConverter.entryToLdifContentRecord((IEntry)this.selectedEntry);
            this.prototypeEntry = ModelConverter.ldifContentRecordToEntry((LdifContentRecord)record, (IBrowserConnection)this.selectedConnection);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            EventRegistry.resumeEventFiringInCurrentThread();
        }
    }

    public void addPages() {
        this.ocPage = new NewEntryObjectclassWizardPage(NewEntryObjectclassWizardPage.class.getName(), this);
        this.addPage((IWizardPage)this.ocPage);
        this.attributePage = new NewEntryAttributesWizardPage(NewEntryAttributesWizardPage.class.getName(), this);
        this.addPage((IWizardPage)this.attributePage);
    }

    public boolean performCancel() {
        return true;
    }

    public boolean performFinish() {
        new CompoundModification().replaceAttributes((IEntry)this.prototypeEntry, this.selectedEntry, (Object)this);
        return true;
    }

    public IEntry getSelectedEntry() {
        return this.selectedEntry;
    }

    public IBrowserConnection getSelectedConnection() {
        return this.selectedConnection;
    }

    public DummyEntry getPrototypeEntry() {
        return this.prototypeEntry;
    }

    public void setPrototypeEntry(DummyEntry getPrototypeEntry) {
        this.prototypeEntry = getPrototypeEntry;
    }
}

