/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.wizards;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.apache.directory.studio.connection.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.connection.ui.widgets.ExtendedContentAssistCommandAdapter;
import org.apache.directory.studio.ldapbrowser.common.widgets.ListContentProposalProvider;
import org.apache.directory.studio.ldapbrowser.common.wizards.AttributeWizard;
import org.apache.directory.studio.ldapbrowser.common.wizards.Messages;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AttributeTypeWizardPage
extends WizardPage {
    private AttributeWizard wizard;
    private boolean initialShowSubschemaAttributesOnly;
    private boolean initialHideExistingAttributes;
    private String parsedAttributeType;
    private String[] possibleAttributeTypes;
    private String[] possibleAttributeTypesSubschemaOnly;
    private String[] possibleAttributeTypesSubschemaOnlyAndExistingHidden;
    private Combo attributeTypeCombo;
    private Button showSubschemAttributesOnlyButton;
    private Button hideExistingAttributesButton;
    private Text previewText;

    public AttributeTypeWizardPage(String pageName, IEntry initialEntry, String initialAttributeDescription, boolean initialShowSubschemaAttributesOnly, boolean initialHideExistingAttributes, AttributeWizard wizard) {
        super(pageName);
        super.setTitle(Messages.getString("AttributeTypeWizardPage.AttributeType"));
        super.setDescription(Messages.getString("AttributeTypeWizardPage.AttributeTypeDescription"));
        super.setPageComplete(false);
        this.wizard = wizard;
        this.initialShowSubschemaAttributesOnly = initialShowSubschemaAttributesOnly;
        this.initialHideExistingAttributes = initialHideExistingAttributes;
        Collection atds = initialEntry.getBrowserConnection().getSchema().getAttributeTypeDescriptions();
        Collection atdNames = SchemaUtils.getNames((Collection)atds);
        this.possibleAttributeTypes = atdNames.toArray(new String[atdNames.size()]);
        Arrays.sort(this.possibleAttributeTypes);
        Collection allAtds = SchemaUtils.getAllAttributeTypeDescriptions((IEntry)initialEntry);
        Collection names = SchemaUtils.getNames((Collection)allAtds);
        this.possibleAttributeTypesSubschemaOnly = names.toArray(new String[0]);
        Arrays.sort(this.possibleAttributeTypesSubschemaOnly);
        HashSet<String> set = new HashSet<String>(Arrays.asList(this.possibleAttributeTypesSubschemaOnly));
        IAttribute[] existingAttributes = initialEntry.getAttributes();
        for (int i = 0; existingAttributes != null && i < existingAttributes.length; ++i) {
            set.remove(existingAttributes[i].getDescription());
        }
        this.possibleAttributeTypesSubschemaOnlyAndExistingHidden = set.toArray(new String[set.size()]);
        Arrays.sort(this.possibleAttributeTypesSubschemaOnlyAndExistingHidden);
        String attributeDescription = initialAttributeDescription;
        if (attributeDescription == null) {
            attributeDescription = "";
        }
        String[] attributeDescriptionComponents = attributeDescription.split(";");
        this.parsedAttributeType = attributeDescriptionComponents[0];
    }

    private void validate() {
        this.previewText.setText(this.wizard.getAttributeDescription());
        this.setPageComplete(!"".equals(this.attributeTypeCombo.getText()));
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.validate();
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(1808));
        BaseWidgetUtils.createLabel((Composite)composite, (String)Messages.getString("AttributeTypeWizardPage.AttributeTypeLabel"), (int)1);
        this.attributeTypeCombo = BaseWidgetUtils.createCombo((Composite)composite, (String[])this.possibleAttributeTypes, (int)-1, (int)1);
        this.attributeTypeCombo.setText(this.parsedAttributeType);
        new ExtendedContentAssistCommandAdapter((Control)this.attributeTypeCombo, (IControlContentAdapter)new ComboContentAdapter(), (IContentProposalProvider)new ListContentProposalProvider(this.possibleAttributeTypes), null, null, true);
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        this.showSubschemAttributesOnlyButton = BaseWidgetUtils.createCheckbox((Composite)composite, (String)Messages.getString("AttributeTypeWizardPage.ShowSubschemaAttributesOnly"), (int)1);
        this.showSubschemAttributesOnlyButton.setSelection(this.initialShowSubschemaAttributesOnly);
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        this.hideExistingAttributesButton = BaseWidgetUtils.createCheckbox((Composite)composite, (String)Messages.getString("AttributeTypeWizardPage.HideExistingAttributes"), (int)1);
        this.hideExistingAttributesButton.setSelection(this.initialHideExistingAttributes);
        Label l = new Label(composite, 0);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        l.setLayoutData((Object)gd);
        BaseWidgetUtils.createLabel((Composite)composite, (String)Messages.getString("AttributeTypeWizardPage.PreviewLabel"), (int)1);
        this.previewText = BaseWidgetUtils.createReadonlyText((Composite)composite, (String)"", (int)1);
        this.attributeTypeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AttributeTypeWizardPage.this.validate();
            }
        });
        this.showSubschemAttributesOnlyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttributeTypeWizardPage.this.updateFilter();
                AttributeTypeWizardPage.this.validate();
            }
        });
        this.hideExistingAttributesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttributeTypeWizardPage.this.updateFilter();
                AttributeTypeWizardPage.this.validate();
            }
        });
        this.updateFilter();
        this.setControl((Control)composite);
    }

    private void updateFilter() {
        this.hideExistingAttributesButton.setEnabled(this.showSubschemAttributesOnlyButton.getSelection());
        if (this.possibleAttributeTypesSubschemaOnly.length == 0) {
            this.showSubschemAttributesOnlyButton.setSelection(false);
            this.showSubschemAttributesOnlyButton.setEnabled(false);
        }
        if (this.possibleAttributeTypesSubschemaOnlyAndExistingHidden.length == 0) {
            this.hideExistingAttributesButton.setEnabled(false);
            this.hideExistingAttributesButton.setSelection(false);
        }
        String value = this.attributeTypeCombo.getText();
        if (this.hideExistingAttributesButton.getSelection() && this.showSubschemAttributesOnlyButton.getSelection()) {
            this.attributeTypeCombo.setItems(this.possibleAttributeTypesSubschemaOnlyAndExistingHidden);
        } else if (this.showSubschemAttributesOnlyButton.getSelection()) {
            this.attributeTypeCombo.setItems(this.possibleAttributeTypesSubschemaOnly);
        } else {
            this.attributeTypeCombo.setItems(this.possibleAttributeTypes);
        }
        this.attributeTypeCombo.setText(value);
    }

    String getAttributeType() {
        if (this.attributeTypeCombo == null | this.attributeTypeCombo.isDisposed()) {
            return "";
        }
        return this.attributeTypeCombo.getText();
    }
}

