/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.search;

import org.apache.directory.studio.connection.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.common.widgets.BrowserWidget;
import org.apache.directory.studio.ldapbrowser.common.widgets.search.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class LimitWidget
extends BrowserWidget {
    private int initialCountLimit;
    private int initialTimeLimit;
    private Group limitGroup;
    private Label countLimitLabel;
    private Text countLimitText;
    private Label timeLimitLabel;
    private Text timeLimitText;

    public LimitWidget(int initialCountLimit, int initialTimeLimit) {
        this.initialCountLimit = initialCountLimit;
        this.initialTimeLimit = initialTimeLimit;
    }

    public LimitWidget() {
        this.initialCountLimit = 0;
        this.initialTimeLimit = 0;
    }

    public void createWidget(Composite parent) {
        this.limitGroup = BaseWidgetUtils.createGroup((Composite)parent, (String)Messages.getString("LimitWidget.Limits"), (int)1);
        GridLayout gl = new GridLayout(2, false);
        this.limitGroup.setLayout((Layout)gl);
        String countLimitToolTipText = Messages.getString("LimitWidget.CountLimitTooltip");
        this.countLimitLabel = BaseWidgetUtils.createLabel((Composite)this.limitGroup, (String)Messages.getString("LimitWidget.CountLimit"), (int)1);
        this.countLimitLabel.setToolTipText(countLimitToolTipText);
        this.countLimitText = BaseWidgetUtils.createText((Composite)this.limitGroup, (String)"", (int)1);
        this.countLimitText.setToolTipText(countLimitToolTipText);
        this.countLimitText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[0-9]*")) {
                    e.doit = false;
                }
            }
        });
        this.countLimitText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LimitWidget.this.notifyListeners();
            }
        });
        String timeLimitToolTipText = Messages.getString("LimitWidget.TimeLimitToolTip");
        this.timeLimitLabel = BaseWidgetUtils.createLabel((Composite)this.limitGroup, (String)Messages.getString("LimitWidget.TimeLimit"), (int)1);
        this.timeLimitLabel.setToolTipText(timeLimitToolTipText);
        this.timeLimitText = BaseWidgetUtils.createText((Composite)this.limitGroup, (String)"", (int)1);
        this.timeLimitText.setToolTipText(timeLimitToolTipText);
        this.timeLimitText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[0-9]*")) {
                    e.doit = false;
                }
            }
        });
        this.timeLimitText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LimitWidget.this.notifyListeners();
            }
        });
        this.setCountLimit(this.initialCountLimit);
        this.setTimeLimit(this.initialTimeLimit);
    }

    public void setCountLimit(int countLimit) {
        this.initialCountLimit = countLimit;
        this.countLimitText.setText(Integer.toString(this.initialCountLimit));
    }

    public void setTimeLimit(int timeLimit) {
        this.initialTimeLimit = timeLimit;
        this.timeLimitText.setText(Integer.toString(this.initialTimeLimit));
    }

    public int getCountLimit() {
        int countLimit;
        try {
            countLimit = new Integer(this.countLimitText.getText());
        }
        catch (NumberFormatException e) {
            countLimit = 0;
        }
        return countLimit;
    }

    public int getTimeLimit() {
        int timeLimit;
        try {
            timeLimit = new Integer(this.timeLimitText.getText());
        }
        catch (NumberFormatException e) {
            timeLimit = 0;
        }
        return timeLimit;
    }

    public void setEnabled(boolean b) {
        this.limitGroup.setEnabled(b);
        this.countLimitLabel.setEnabled(b);
        this.countLimitText.setEnabled(b);
        this.timeLimitLabel.setEnabled(b);
        this.timeLimitText.setEnabled(b);
    }
}

