/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.search;

import javax.naming.InvalidNameException;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.studio.connection.core.DnUtils;
import org.apache.directory.studio.connection.core.jobs.StudioRunnableWithProgress;
import org.apache.directory.studio.connection.ui.RunnableContextRunner;
import org.apache.directory.studio.connection.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.dialogs.SelectEntryDialog;
import org.apache.directory.studio.ldapbrowser.common.widgets.BrowserWidget;
import org.apache.directory.studio.ldapbrowser.common.widgets.HistoryUtils;
import org.apache.directory.studio.ldapbrowser.common.widgets.search.Messages;
import org.apache.directory.studio.ldapbrowser.core.jobs.ReadEntryRunnable;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IRootDSE;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

public class EntryWidget
extends BrowserWidget {
    private Combo dnCombo;
    private Button upButton;
    private Button entryBrowseButton;
    private IBrowserConnection browserConnection;
    private LdapDN dn;
    private LdapDN suffix;
    boolean useLocalName;

    public EntryWidget() {
        this.browserConnection = null;
        this.dn = null;
    }

    public EntryWidget(IBrowserConnection browserConnection, LdapDN dn) {
        this(browserConnection, dn, null, false);
    }

    public EntryWidget(IBrowserConnection browserConnection, LdapDN dn, LdapDN suffix, boolean useLocalName) {
        this.browserConnection = browserConnection;
        this.dn = dn;
        this.suffix = suffix;
        this.useLocalName = useLocalName;
    }

    public void createWidget(final Composite parent) {
        Composite textAndUpComposite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)2, (int)1);
        this.dnCombo = BaseWidgetUtils.createCombo((Composite)textAndUpComposite, (String[])new String[0], (int)-1, (int)1);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.widthHint = 200;
        this.dnCombo.setLayoutData((Object)gd);
        String[] history = HistoryUtils.load("dnHistory");
        this.dnCombo.setItems(history);
        this.dnCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    EntryWidget.this.dn = new LdapDN(EntryWidget.this.dnCombo.getText());
                }
                catch (InvalidNameException e1) {
                    EntryWidget.this.dn = null;
                }
                EntryWidget.this.internalSetEnabled();
                EntryWidget.this.notifyListeners();
            }
        });
        this.upButton = new Button(textAndUpComposite, 8);
        this.upButton.setToolTipText(Messages.getString("EntryWidget.Parent"));
        this.upButton.setImage(BrowserCommonActivator.getDefault().getImage("resources/icons/parent.gif"));
        this.upButton.setEnabled(false);
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EntryWidget.this.dn != null && DnUtils.getParent((LdapDN)EntryWidget.this.dn) != null) {
                    EntryWidget.this.dn = DnUtils.getParent((LdapDN)EntryWidget.this.dn);
                    EntryWidget.this.dnChanged();
                    EntryWidget.this.internalSetEnabled();
                    EntryWidget.this.notifyListeners();
                }
            }
        });
        this.entryBrowseButton = BaseWidgetUtils.createButton((Composite)parent, (String)Messages.getString("EntryWidget.BrowseButton"), (int)1);
        this.entryBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EntryWidget.this.browserConnection != null) {
                    IRootDSE rootEntry = EntryWidget.this.browserConnection.getRootDSE();
                    if (EntryWidget.this.suffix != null && EntryWidget.this.suffix.size() > 0 && (rootEntry = EntryWidget.this.browserConnection.getEntryFromCache(EntryWidget.this.suffix)) == null) {
                        ReadEntryRunnable runnable = new ReadEntryRunnable(EntryWidget.this.browserConnection, EntryWidget.this.suffix);
                        RunnableContextRunner.execute((StudioRunnableWithProgress)runnable, null, (boolean)true);
                        rootEntry = runnable.getReadEntry();
                    }
                    LdapDN initialDN = EntryWidget.this.dn;
                    if (EntryWidget.this.useLocalName && EntryWidget.this.suffix != null && EntryWidget.this.suffix.size() > 0 && initialDN != null && initialDN.size() > 0) {
                        initialDN = DnUtils.composeDn((LdapDN)initialDN, (LdapDN)EntryWidget.this.suffix);
                    }
                    IRootDSE entry = rootEntry;
                    if (initialDN != null && initialDN.size() > 0 && (entry = EntryWidget.this.browserConnection.getEntryFromCache(initialDN)) == null) {
                        ReadEntryRunnable runnable = new ReadEntryRunnable(EntryWidget.this.browserConnection, initialDN);
                        RunnableContextRunner.execute((StudioRunnableWithProgress)runnable, null, (boolean)true);
                        entry = runnable.getReadEntry();
                    }
                    SelectEntryDialog dialog = new SelectEntryDialog(parent.getShell(), Messages.getString("EntryWidget.SelectDN"), (IEntry)rootEntry, (IEntry)entry);
                    dialog.open();
                    IEntry selectedEntry = dialog.getSelectedEntry();
                    if (selectedEntry != null) {
                        EntryWidget.this.dn = selectedEntry.getDn();
                        if (EntryWidget.this.useLocalName && EntryWidget.this.suffix != null && EntryWidget.this.suffix.size() > 0) {
                            EntryWidget.this.dn = DnUtils.getPrefixName((LdapDN)EntryWidget.this.dn, (LdapDN)EntryWidget.this.suffix);
                        }
                        EntryWidget.this.dnChanged();
                        EntryWidget.this.internalSetEnabled();
                        EntryWidget.this.notifyListeners();
                    }
                }
            }
        });
        this.dnChanged();
        this.internalSetEnabled();
    }

    private void dnChanged() {
        if (this.dnCombo != null && this.entryBrowseButton != null) {
            this.dnCombo.setText(this.dn != null ? this.dn.getUpName() : "");
        }
    }

    public void setEnabled(boolean b) {
        this.dnCombo.setEnabled(b);
        if (b) {
            this.dnChanged();
        }
        this.internalSetEnabled();
    }

    private void internalSetEnabled() {
        this.upButton.setEnabled(this.dn != null && DnUtils.getParent((LdapDN)this.dn) != null && this.dnCombo.isEnabled());
        this.entryBrowseButton.setEnabled(this.browserConnection != null && this.dnCombo.isEnabled());
    }

    public void saveDialogSettings() {
        HistoryUtils.save("dnHistory", this.dnCombo.getText());
    }

    public LdapDN getSuffix() {
        return this.suffix;
    }

    public LdapDN getDn() {
        return this.dn;
    }

    public IBrowserConnection getBrowserConnection() {
        return this.browserConnection;
    }

    public void setInput(IBrowserConnection browserConnection, LdapDN dn) {
        this.setInput(browserConnection, dn, null, false);
    }

    public void setInput(IBrowserConnection browserConnection, LdapDN dn, LdapDN suffix, boolean useLocalName) {
        if (this.browserConnection != browserConnection || this.dn != dn || this.suffix != suffix) {
            this.browserConnection = browserConnection;
            this.dn = dn;
            this.suffix = suffix;
            this.useLocalName = useLocalName;
            this.dnChanged();
        }
    }
}

