/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor;

import java.util.Collection;
import org.apache.directory.shared.ldap.schema.parsers.AttributeTypeDescription;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.AbstractOpenEditorAction;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidgetActionGroup;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidgetTableMetadata;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.Messages;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreConstants;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.apache.directory.studio.valueeditors.IValueEditor;
import org.apache.directory.studio.valueeditors.ValueEditorManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class OpenBestEditorAction
extends AbstractOpenEditorAction {
    private IValueEditor bestValueEditor;

    public OpenBestEditorAction(TreeViewer viewer, ValueEditorManager valueEditorManager, EntryEditorWidgetActionGroup actionGroup) {
        super(viewer, valueEditorManager, actionGroup);
    }

    public IValueEditor getBestValueEditor() {
        return this.bestValueEditor;
    }

    public void dispose() {
        this.bestValueEditor = null;
        super.dispose();
    }

    public String getCommandId() {
        return null;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.isEnabled() ? this.bestValueEditor.getValueEditorImageDescriptor() : null;
    }

    public String getText() {
        return this.isEnabled() ? this.bestValueEditor.getValueEditorName() : null;
    }

    public boolean isEnabled() {
        if (this.getSelectedValues().length == 1 && this.getSelectedAttributes().length == 0 && this.viewer.getCellModifier().canModify((Object)this.getSelectedValues()[0], EntryEditorWidgetTableMetadata.VALUE_COLUMN_NAME)) {
            this.bestValueEditor = this.valueEditorManager.getCurrentValueEditor(this.getSelectedValues()[0]);
            this.cellEditor = this.bestValueEditor.getCellEditor();
            return true;
        }
        return false;
    }

    public void run() {
        boolean ok = true;
        if (this.getSelectedValues().length == 1 && this.getSelectedAttributes().length == 0) {
            IValue value = this.getSelectedValues()[0];
            StringBuffer message = new StringBuffer();
            if (value.isEmpty()) {
                AttributeTypeDescription atd;
                IEntry entry;
                Collection allAtds;
                if (value.getAttribute().getValueSize() > 1 && value.getAttribute().getAttributeTypeDescription().isSingleValued()) {
                    message.append(NLS.bind((String)Messages.getString("OpenBestEditorAction.ValueSingleValued"), (Object)value.getAttribute().getDescription()));
                    message.append(BrowserCoreConstants.LINE_SEPARATOR);
                    message.append(BrowserCoreConstants.LINE_SEPARATOR);
                }
                if (!(allAtds = SchemaUtils.getAllAttributeTypeDescriptions((IEntry)(entry = value.getAttribute().getEntry()))).contains(atd = value.getAttribute().getAttributeTypeDescription())) {
                    message.append(NLS.bind((String)Messages.getString("OpenBestEditorAction.AttributeNotInSubSchema"), (Object)value.getAttribute().getDescription()));
                    message.append(BrowserCoreConstants.LINE_SEPARATOR);
                    message.append(BrowserCoreConstants.LINE_SEPARATOR);
                }
            }
            if (!SchemaUtils.isModifiable((AttributeTypeDescription)value.getAttribute().getAttributeTypeDescription())) {
                message.append(NLS.bind((String)Messages.getString("OpenBestEditorAction.ValueNotModifiable"), (Object)value.getAttribute().getDescription()));
                message.append(BrowserCoreConstants.LINE_SEPARATOR);
                message.append(BrowserCoreConstants.LINE_SEPARATOR);
            }
            if (value.isRdnPart() && this.cellEditor != this.valueEditorManager.getRenameValueEditor()) {
                message.append(NLS.bind((String)Messages.getString("OpenBestEditorAction.ValueIsRdnPart"), (Object)value.getAttribute().getDescription()));
                message.append(BrowserCoreConstants.LINE_SEPARATOR);
                message.append(BrowserCoreConstants.LINE_SEPARATOR);
            }
            if (message.length() > 0) {
                if (value.isEmpty()) {
                    message.append(Messages.getString("OpenBestEditorAction.NewValueQuestion"));
                } else {
                    message.append(Messages.getString("OpenBestEditorAction.EditValueQuestion"));
                }
                ok = MessageDialog.openConfirm((Shell)this.getShell(), (String)this.getText(), (String)message.toString());
            }
            if (ok) {
                super.run();
            } else if (value.isEmpty()) {
                value.getAttribute().deleteEmptyValue();
            }
        }
    }
}

