/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor;

import org.apache.directory.studio.connection.core.event.EventRunner;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserSelectionUtils;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidgetActionGroup;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidgetConfiguration;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.OpenDefaultEditorAction;
import org.apache.directory.studio.ldapbrowser.core.events.BulkModificationEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EmptyValueAddedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EmptyValueDeletedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EntryModificationEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EntryUpdateListener;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.events.ValueAddedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.ValueDeletedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.ValueModifiedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.ValueRenamedEvent;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeHierarchy;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;

public class EntryEditorWidgetUniversalListener
implements EntryUpdateListener {
    protected TreeViewer viewer;
    protected EntryEditorWidgetConfiguration configuration;
    protected EntryEditorWidgetActionGroup actionGroup;
    protected OpenDefaultEditorAction startEditAction;
    protected SelectionListener viewerSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            if (EntryEditorWidgetUniversalListener.this.startEditAction.isEnabled()) {
                EntryEditorWidgetUniversalListener.this.startEditAction.run();
            }
        }
    };
    protected MouseListener viewerMouseListener = new MouseAdapter(){

        public void mouseDoubleClick(MouseEvent e) {
            IAttribute[] attributes = BrowserSelectionUtils.getAttributes(EntryEditorWidgetUniversalListener.this.viewer.getSelection());
            IValue[] values = BrowserSelectionUtils.getValues(EntryEditorWidgetUniversalListener.this.viewer.getSelection());
            if (attributes.length == 1 && values.length == 0) {
                if (EntryEditorWidgetUniversalListener.this.viewer.getExpandedState((Object)attributes[0])) {
                    EntryEditorWidgetUniversalListener.this.viewer.collapseToLevel((Object)attributes[0], 1);
                } else {
                    EntryEditorWidgetUniversalListener.this.viewer.expandToLevel((Object)attributes[0], 1);
                }
            }
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
        }
    };
    protected IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (EntryEditorWidgetUniversalListener.this.viewer != null) {
                EntryEditorWidgetUniversalListener.this.viewer.refresh();
            }
        }
    };

    public EntryEditorWidgetUniversalListener(TreeViewer treeViewer, EntryEditorWidgetConfiguration configuration, EntryEditorWidgetActionGroup actionGroup, OpenDefaultEditorAction startEditAction) {
        this.startEditAction = startEditAction;
        this.viewer = treeViewer;
        this.configuration = configuration;
        this.actionGroup = actionGroup;
        this.viewer.getTree().addSelectionListener(this.viewerSelectionListener);
        this.viewer.getTree().addMouseListener(this.viewerMouseListener);
        EventRegistry.addEntryUpdateListener((EntryUpdateListener)this, (EventRunner)BrowserCommonActivator.getDefault().getEventRunner());
        BrowserCommonActivator.getDefault().getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
        this.viewer.getTree().addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                }
            }
        });
    }

    public void dispose() {
        if (this.viewer != null) {
            EventRegistry.removeEntryUpdateListener((EntryUpdateListener)this);
            BrowserCommonActivator.getDefault().getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
            this.startEditAction = null;
            this.viewer = null;
            this.configuration = null;
            this.actionGroup = null;
        }
    }

    public void entryUpdated(EntryModificationEvent event) {
        if (this.viewer == null || this.viewer.getTree() == null || this.viewer.getTree().isDisposed() || this.viewer.getInput() == null || event.getModifiedEntry() != this.viewer.getInput() && !(event instanceof BulkModificationEvent)) {
            return;
        }
        if (this.viewer.isCellEditorActive()) {
            this.viewer.cancelEditing();
        }
        this.viewer.refresh();
        if (event instanceof ValueAddedEvent) {
            ValueAddedEvent vaEvent = (ValueAddedEvent)event;
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)vaEvent.getAddedValue()), true);
            this.viewer.refresh();
        } else if (event instanceof ValueDeletedEvent) {
            ValueDeletedEvent vdEvent = (ValueDeletedEvent)event;
            if (this.viewer.getSelection().isEmpty() && vdEvent.getDeletedValue().getAttribute().getValueSize() > 0) {
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)vdEvent.getDeletedValue().getAttribute().getValues()[0]), true);
            }
        } else if (event instanceof EmptyValueAddedEvent) {
            EmptyValueAddedEvent evaEvent = (EmptyValueAddedEvent)event;
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)evaEvent.getAddedValue()), true);
            if (this.startEditAction.isEnabled() && this.viewer.getControl().isFocusControl()) {
                this.startEditAction.run();
            }
        } else if (event instanceof EmptyValueDeletedEvent) {
            EmptyValueDeletedEvent evdEvent = (EmptyValueDeletedEvent)event;
            if (this.viewer.getSelection().isEmpty() && evdEvent.getDeletedValue().getAttribute().getValueSize() > 0) {
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)evdEvent.getDeletedValue().getAttribute().getValues()[0]), true);
            }
        } else if (event instanceof ValueModifiedEvent) {
            ValueModifiedEvent vmEvent = (ValueModifiedEvent)event;
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)vmEvent.getNewValue()), true);
        } else if (event instanceof ValueRenamedEvent) {
            ValueRenamedEvent vrEvent = (ValueRenamedEvent)event;
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)vrEvent.getNewValue()), true);
        }
    }

    public void setInput(IEntry entry) {
        this.viewer.setInput((Object)entry);
        this.actionGroup.setInput(entry);
        this.expandFoldedAttributes();
    }

    public void setInput(AttributeHierarchy attributeHierarchy) {
        if (attributeHierarchy != this.viewer.getInput()) {
            this.viewer.setInput((Object)attributeHierarchy);
            this.actionGroup.setInput(attributeHierarchy);
            this.expandFoldedAttributes();
        }
    }

    protected void expandFoldedAttributes() {
        if (this.configuration.getPreferences().isAutoExpandFoldedAttributes()) {
            this.viewer.expandAll();
        }
    }
}

