/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor;

import org.apache.directory.studio.ldapbrowser.common.actions.BrowserAction;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidgetActionGroup;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidgetTableMetadata;
import org.apache.directory.studio.valueeditors.ValueEditorManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;

public abstract class AbstractOpenEditorAction
extends BrowserAction
implements FocusListener,
KeyListener {
    protected ValueEditorManager valueEditorManager;
    protected TreeViewer viewer;
    protected CellEditor cellEditor;
    protected EntryEditorWidgetActionGroup actionGroup;

    protected AbstractOpenEditorAction(TreeViewer viewer, ValueEditorManager valueEditorManager, EntryEditorWidgetActionGroup actionGroup) {
        this.viewer = viewer;
        this.valueEditorManager = valueEditorManager;
        this.actionGroup = actionGroup;
    }

    public void dispose() {
        this.valueEditorManager = null;
        this.viewer = null;
        this.cellEditor = null;
        super.dispose();
    }

    public CellEditor getCellEditor() {
        return this.cellEditor;
    }

    public void run() {
        this.activateEditor();
    }

    private void activateEditor() {
        if (!this.viewer.isCellEditorActive() && this.getSelectedValues().length == 1 && this.getSelectedAttributes().length == 0 && this.viewer.getCellModifier().canModify((Object)this.getSelectedValues()[0], EntryEditorWidgetTableMetadata.VALUE_COLUMN_NAME)) {
            this.actionGroup.deactivateGlobalActionHandlers();
            this.viewer.getCellEditors()[1] = this.cellEditor;
            if (this.cellEditor.getControl() != null) {
                this.cellEditor.getControl().addFocusListener((FocusListener)this);
                this.cellEditor.getControl().addKeyListener((KeyListener)this);
            }
            this.viewer.editElement((Object)this.getSelectedValues()[0], 1);
            if (!this.viewer.isCellEditorActive()) {
                this.editorClosed();
            }
        } else {
            this.valueEditorManager.setUserSelectedValueEditor(null);
        }
    }

    private void editorClosed() {
        for (int i = 0; i < this.viewer.getCellEditors().length; ++i) {
            this.viewer.getCellEditors()[i] = null;
        }
        if (this.cellEditor.getControl() != null) {
            this.cellEditor.getControl().removeFocusListener((FocusListener)this);
            this.cellEditor.getControl().removeKeyListener((KeyListener)this);
        }
        this.valueEditorManager.setUserSelectedValueEditor(null);
        this.viewer.setSelection(this.viewer.getSelection());
        this.actionGroup.activateGlobalActionHandlers();
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.editorClosed();
    }

    public void keyPressed(KeyEvent e) {
        if (e.character == '\u001b' && e.stateMask == 0) {
            e.doit = false;
        }
    }

    public void keyReleased(KeyEvent e) {
    }
}

