/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.connection;

import org.apache.directory.shared.ldap.util.LdapURL;
import org.apache.directory.studio.connection.core.ConnectionParameter;
import org.apache.directory.studio.connection.ui.AbstractConnectionParameterPage;
import org.apache.directory.studio.connection.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.common.widgets.connection.Messages;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;

public class EditorParameterPage
extends AbstractConnectionParameterPage {
    private static final String X_MODIFY_MODE = "X-MODIFY-MODE";
    private static final String X_MODIFY_MODE_NO_EMR = "X-MODIFY-MODE-NO-EMR";
    private static final String X_MODIFY_ORDER = "X-MODIFY-ORDER";
    private Combo modifyModeCombo;
    private Combo modifyModeNoEMRCombo;
    private Combo modifyOrderCombo;

    private IBrowserConnection.ModifyMode getModifyMode() {
        return IBrowserConnection.ModifyMode.getByOrdinal((int)this.modifyModeCombo.getSelectionIndex());
    }

    private IBrowserConnection.ModifyMode getModifyModeNoEMR() {
        return IBrowserConnection.ModifyMode.getByOrdinal((int)this.modifyModeNoEMRCombo.getSelectionIndex());
    }

    private IBrowserConnection.ModifyOrder getModifyOrder() {
        return IBrowserConnection.ModifyOrder.getByOrdinal((int)this.modifyOrderCombo.getSelectionIndex());
    }

    protected void createComposite(Composite parent) {
        this.addModifyInput(parent);
    }

    private void addModifyInput(Composite parent) {
        Composite composite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)1, (int)1);
        Group group = BaseWidgetUtils.createGroup((Composite)composite, (String)Messages.getString("EditorParameterPage.ModifyGroup"), (int)1);
        Composite groupComposite = BaseWidgetUtils.createColumnContainer((Composite)group, (int)2, (int)1);
        Label modifyModeLabel = BaseWidgetUtils.createLabel((Composite)groupComposite, (String)Messages.getString("EditorParameterPage.ModifyMode"), (int)1);
        modifyModeLabel.setToolTipText(Messages.getString("EditorParameterPage.ModifyModeTooltip"));
        String[] modifyModeItems = new String[]{Messages.getString("EditorParameterPage.ModifyModeDefault"), Messages.getString("EditorParameterPage.ModifyModeReplace"), Messages.getString("EditorParameterPage.ModifyModeAddDel")};
        this.modifyModeCombo = BaseWidgetUtils.createReadonlyCombo((Composite)groupComposite, (String[])modifyModeItems, (int)0, (int)1);
        this.modifyModeCombo.setToolTipText(Messages.getString("EditorParameterPage.ModifyModeTooltip"));
        Label modifyModeNoEMRLabel = BaseWidgetUtils.createLabel((Composite)groupComposite, (String)Messages.getString("EditorParameterPage.ModifyModeNoEMR"), (int)1);
        modifyModeNoEMRLabel.setToolTipText(Messages.getString("EditorParameterPage.ModifyModeNoEMRTooltip"));
        String[] modifyModeNoEMRItems = new String[]{Messages.getString("EditorParameterPage.ModifyModeDefault"), Messages.getString("EditorParameterPage.ModifyModeReplace"), Messages.getString("EditorParameterPage.ModifyModeAddDel")};
        this.modifyModeNoEMRCombo = BaseWidgetUtils.createReadonlyCombo((Composite)groupComposite, (String[])modifyModeNoEMRItems, (int)0, (int)1);
        this.modifyModeNoEMRCombo.setToolTipText(Messages.getString("EditorParameterPage.ModifyModeNoEMRTooltip"));
        Label modifyOrderLabel = BaseWidgetUtils.createLabel((Composite)groupComposite, (String)Messages.getString("EditorParameterPage.ModifyOrder"), (int)1);
        modifyOrderLabel.setToolTipText(Messages.getString("EditorParameterPage.ModifyOrderTooltip"));
        String[] modifyOrderItems = new String[]{Messages.getString("EditorParameterPage.ModifyOrderDelFirst"), Messages.getString("EditorParameterPage.ModifyOrderAddFirst")};
        this.modifyOrderCombo = BaseWidgetUtils.createReadonlyCombo((Composite)groupComposite, (String[])modifyOrderItems, (int)0, (int)1);
        this.modifyOrderCombo.setToolTipText(Messages.getString("EditorParameterPage.ModifyOrderTooltip"));
    }

    protected void validate() {
    }

    protected void loadParameters(ConnectionParameter parameter) {
        this.connectionParameter = parameter;
        int modifyMode = parameter.getExtendedIntProperty("ldapbrowser.modifyMode");
        this.modifyModeCombo.select(modifyMode);
        int modifyModeNoEMR = parameter.getExtendedIntProperty("ldapbrowser.modifyModeNoEMR");
        this.modifyModeNoEMRCombo.select(modifyModeNoEMR);
        int modifyOrder = parameter.getExtendedIntProperty("ldapbrowser.modifyOrder");
        this.modifyOrderCombo.select(modifyOrder);
    }

    protected void initListeners() {
        this.modifyModeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditorParameterPage.this.connectionPageModified();
            }
        });
        this.modifyModeNoEMRCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditorParameterPage.this.connectionPageModified();
            }
        });
        this.modifyOrderCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditorParameterPage.this.connectionPageModified();
            }
        });
    }

    public void saveParameters(ConnectionParameter parameter) {
        parameter.setExtendedIntProperty("ldapbrowser.modifyMode", this.getModifyMode().getOrdinal());
        parameter.setExtendedIntProperty("ldapbrowser.modifyModeNoEMR", this.getModifyModeNoEMR().getOrdinal());
        parameter.setExtendedIntProperty("ldapbrowser.modifyOrder", this.getModifyOrder().getOrdinal());
    }

    public void saveDialogSettings() {
    }

    public void setFocus() {
    }

    public boolean areParametersModifed() {
        int modifyMode = this.connectionParameter.getExtendedIntProperty("ldapbrowser.modifyMode");
        int modifyModeNoEMR = this.connectionParameter.getExtendedIntProperty("ldapbrowser.modifyModeNoEMR");
        int modifyOrder = this.connectionParameter.getExtendedIntProperty("ldapbrowser.modifyOrder");
        return modifyMode != this.getModifyMode().getOrdinal() || modifyModeNoEMR != this.getModifyModeNoEMR().getOrdinal() || modifyOrder != this.getModifyOrder().getOrdinal();
    }

    public boolean isReconnectionRequired() {
        return this.connectionParameter == null;
    }

    public void mergeParametersToLdapURL(ConnectionParameter parameter, LdapURL ldapUrl) {
        int modifyOrder;
        int modifyModeNoEMR;
        int modifyMode = parameter.getExtendedIntProperty("ldapbrowser.modifyMode");
        if (modifyMode != 0) {
            ldapUrl.getExtensions().add(new LdapURL.Extension(false, X_MODIFY_MODE, parameter.getExtendedProperty("ldapbrowser.modifyMode")));
        }
        if ((modifyModeNoEMR = parameter.getExtendedIntProperty("ldapbrowser.modifyModeNoEMR")) != 0) {
            ldapUrl.getExtensions().add(new LdapURL.Extension(false, X_MODIFY_MODE_NO_EMR, parameter.getExtendedProperty("ldapbrowser.modifyModeNoEMR")));
        }
        if ((modifyOrder = parameter.getExtendedIntProperty("ldapbrowser.modifyOrder")) != 0) {
            ldapUrl.getExtensions().add(new LdapURL.Extension(false, X_MODIFY_ORDER, parameter.getExtendedProperty("ldapbrowser.modifyOrder")));
        }
    }

    public void mergeLdapUrlToParameters(LdapURL ldapUrl, ConnectionParameter parameter) {
        String modifyMode = ldapUrl.getExtensionValue(X_MODIFY_MODE);
        try {
            parameter.setExtendedIntProperty("ldapbrowser.modifyMode", new Integer(modifyMode).intValue());
        }
        catch (NumberFormatException e) {
            parameter.setExtendedIntProperty("ldapbrowser.modifyMode", IBrowserConnection.ModifyMode.DEFAULT.getOrdinal());
        }
        String modifyModeNoEMR = ldapUrl.getExtensionValue(X_MODIFY_MODE_NO_EMR);
        try {
            parameter.setExtendedIntProperty("ldapbrowser.modifyModeNoEMR", new Integer(modifyModeNoEMR).intValue());
        }
        catch (NumberFormatException e) {
            parameter.setExtendedIntProperty("ldapbrowser.modifyModeNoEMR", IBrowserConnection.ModifyMode.DEFAULT.getOrdinal());
        }
        String modifyOrder = ldapUrl.getExtensionValue(X_MODIFY_ORDER);
        try {
            parameter.setExtendedIntProperty("ldapbrowser.modifyOrder", new Integer(modifyOrder).intValue());
        }
        catch (NumberFormatException e) {
            parameter.setExtendedIntProperty("ldapbrowser.modifyOrder", IBrowserConnection.ModifyOrder.DELETE_FIRST.getOrdinal());
        }
    }
}

