/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.browser;

import org.apache.directory.studio.connection.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserPreferences;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class BrowserSorterDialog
extends Dialog {
    public static final String DIALOG_TITLE = Messages.getString("BrowserSorterDialog.BrowserSorting");
    public static final String SORT_BY_NONE = Messages.getString("BrowserSorterDialog.NoSorting");
    public static final String SORT_BY_RDN = Messages.getString("BrowserSorterDialog.RDN");
    public static final String SORT_BY_RDN_VALUE = Messages.getString("BrowserSorterDialog.RDNValue");
    private BrowserPreferences preferences;
    private Combo sortByCombo;
    private Button sortAcendingButton;
    private Button sortDescendingButton;
    private Button leafEntriesFirstButton;
    private Button containerEntriesFirstButton;
    private Button mixedButton;
    private Button metaEntriesLastButton;
    private Text sortLimitText;

    public BrowserSorterDialog(Shell parentShell, BrowserPreferences preferences) {
        super(parentShell);
        this.preferences = preferences;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(DIALOG_TITLE);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            int sortLimit = this.preferences.getSortLimit();
            try {
                sortLimit = Integer.parseInt(this.sortLimitText.getText().trim());
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            IPreferenceStore store = BrowserCommonActivator.getDefault().getPreferenceStore();
            store.setValue("browserLeafEntriesFirst", this.leafEntriesFirstButton.getSelection());
            store.setValue("browserContainerEntriesFirst", this.containerEntriesFirstButton.getSelection());
            store.setValue("browserMetaEntriesLast", this.metaEntriesLastButton.getSelection());
            store.setValue("browserSortLimit", sortLimit);
            store.setValue("browserSortOrder", this.sortDescendingButton.getSelection() ? 2 : 1);
            store.setValue("browserSortBy", this.sortByCombo.getSelectionIndex() == 2 ? 2 : (this.sortByCombo.getSelectionIndex() == 1 ? 1 : 0));
        }
        super.buttonPressed(buttonId);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertHorizontalDLUsToPixels(300);
        composite.setLayoutData((Object)gd);
        Group groupingGroup = BaseWidgetUtils.createGroup((Composite)composite, (String)Messages.getString("BrowserSorterDialog.GroupEntries"), (int)1);
        Composite columGroup = BaseWidgetUtils.createColumnContainer((Composite)groupingGroup, (int)3, (int)1);
        this.leafEntriesFirstButton = BaseWidgetUtils.createRadiobutton((Composite)columGroup, (String)Messages.getString("BrowserSorterDialog.LeafEntriesFirst"), (int)1);
        this.leafEntriesFirstButton.setToolTipText(Messages.getString("BrowserSorterDialog.LeafEntriesFirstToolTip"));
        this.leafEntriesFirstButton.setSelection(this.preferences.isLeafEntriesFirst());
        this.containerEntriesFirstButton = BaseWidgetUtils.createRadiobutton((Composite)columGroup, (String)Messages.getString("BrowserSorterDialog.ContainerEntriesFirst"), (int)1);
        this.containerEntriesFirstButton.setToolTipText(Messages.getString("BrowserSorterDialog.ContainerEntriesFirstToolTip"));
        this.containerEntriesFirstButton.setSelection(this.preferences.isContainerEntriesFirst());
        this.mixedButton = BaseWidgetUtils.createRadiobutton((Composite)columGroup, (String)Messages.getString("BrowserSorterDialog.Mixed"), (int)1);
        this.mixedButton.setToolTipText(Messages.getString("BrowserSorterDialog.MixedToolTip"));
        this.mixedButton.setSelection(!this.preferences.isLeafEntriesFirst() && !this.preferences.isContainerEntriesFirst());
        this.metaEntriesLastButton = BaseWidgetUtils.createCheckbox((Composite)groupingGroup, (String)Messages.getString("BrowserSorterDialog.MetaEntriesLast"), (int)1);
        this.metaEntriesLastButton.setToolTipText(Messages.getString("BrowserSorterDialog.MetaEntriesLastToolTip"));
        this.metaEntriesLastButton.setSelection(this.preferences.isMetaEntriesLast());
        Group sortingGroup = BaseWidgetUtils.createGroup((Composite)composite, (String)Messages.getString("BrowserSorterDialog.SortEntries"), (int)1);
        Composite sortByComposite = BaseWidgetUtils.createColumnContainer((Composite)sortingGroup, (int)4, (int)1);
        BaseWidgetUtils.createLabel((Composite)sortByComposite, (String)Messages.getString("BrowserSorterDialog.SortBy"), (int)1);
        this.sortByCombo = BaseWidgetUtils.createReadonlyCombo((Composite)sortByComposite, (String[])new String[]{SORT_BY_NONE, SORT_BY_RDN, SORT_BY_RDN_VALUE}, (int)0, (int)1);
        this.sortByCombo.select(this.preferences.getSortBy() == 2 ? 2 : (this.preferences.getSortBy() == 1 ? 1 : 0));
        this.sortByCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowserSorterDialog.this.sortAcendingButton.setEnabled(BrowserSorterDialog.this.sortByCombo.getSelectionIndex() != 0);
                BrowserSorterDialog.this.sortDescendingButton.setEnabled(BrowserSorterDialog.this.sortByCombo.getSelectionIndex() != 0);
                BrowserSorterDialog.this.sortLimitText.setEnabled(BrowserSorterDialog.this.sortByCombo.getSelectionIndex() != 0);
            }
        });
        this.sortAcendingButton = BaseWidgetUtils.createRadiobutton((Composite)sortByComposite, (String)Messages.getString("BrowserSorterDialog.Ascending"), (int)1);
        this.sortAcendingButton.setSelection(this.preferences.getSortOrder() == 1);
        this.sortAcendingButton.setEnabled(this.sortByCombo.getSelectionIndex() != 0);
        this.sortDescendingButton = BaseWidgetUtils.createRadiobutton((Composite)sortByComposite, (String)Messages.getString("BrowserSorterDialog.Descending"), (int)1);
        this.sortDescendingButton.setSelection(this.preferences.getSortOrder() == 2);
        this.sortDescendingButton.setEnabled(this.sortByCombo.getSelectionIndex() != 0);
        Composite sortLimitComposite = BaseWidgetUtils.createColumnContainer((Composite)sortingGroup, (int)2, (int)1);
        String sortLimitTooltip = Messages.getString("BrowserSorterDialog.SortLimitToolTip");
        Label sortLimitLabel = BaseWidgetUtils.createLabel((Composite)sortLimitComposite, (String)Messages.getString("BrowserSorterDialog.SortLimit"), (int)1);
        sortLimitLabel.setToolTipText(sortLimitTooltip);
        this.sortLimitText = BaseWidgetUtils.createText((Composite)sortLimitComposite, (String)("" + this.preferences.getSortLimit()), (int)5, (int)1);
        this.sortLimitText.setToolTipText(sortLimitTooltip);
        this.sortLimitText.setEnabled(this.sortByCombo.getSelectionIndex() != 0);
        this.sortLimitText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[0-9]*")) {
                    e.doit = false;
                }
            }
        });
        BrowserSorterDialog.applyDialogFont((Control)composite);
        return composite;
    }
}

