/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.browser;

import java.math.BigInteger;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.studio.connection.core.jobs.StudioRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserPreferences;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.apache.directory.studio.ldapbrowser.core.model.impl.DirectoryMetadataEntry;
import org.apache.directory.studio.ldapbrowser.core.model.impl.RootDSE;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class BrowserSorter
extends ViewerSorter {
    private BrowserPreferences preferences;

    public BrowserSorter(BrowserPreferences preferences) {
        this.preferences = preferences;
    }

    public void connect(TreeViewer viewer) {
        viewer.setSorter((ViewerSorter)this);
    }

    public void dispose() {
    }

    public void sort(Viewer viewer, Object[] elements) {
        if (!(elements == null || this.preferences.getSortLimit() > 0 && elements.length >= this.preferences.getSortLimit() || this.preferences.getSortBy() == 0 && !this.preferences.isLeafEntriesFirst())) {
            BrowserSorter.super.sort(viewer, elements);
        }
    }

    public int category(Object element) {
        if (element instanceof IEntry) {
            IEntry entry = (IEntry)element;
            if ((entry instanceof DirectoryMetadataEntry || entry instanceof RootDSE || entry.isAlias() || entry.isReferral()) && this.preferences.isMetaEntriesLast()) {
                return 3;
            }
            if (entry.isSubentry()) {
                return 0;
            }
            if (!entry.hasChildren() && this.preferences.isLeafEntriesFirst()) {
                return 1;
            }
            if (entry.hasChildren() && this.preferences.isContainerEntriesFirst()) {
                return 1;
            }
            return 2;
        }
        return 4;
    }

    public int compare(Viewer viewer, Object o1, Object o2) {
        if (o1 instanceof StudioRunnableWithProgress) {
            StudioRunnableWithProgress runnable = (StudioRunnableWithProgress)o1;
            for (Object lockedObject : runnable.getLockedObjects()) {
                if (lockedObject instanceof ISearch) {
                    ISearch search = (ISearch)lockedObject;
                    if (o1 == search.getTopSearchRunnable()) {
                        return this.lessThan();
                    }
                    if (o1 != search.getNextSearchRunnable()) continue;
                    return this.greaterThan();
                }
                if (!(lockedObject instanceof IEntry)) continue;
                IEntry entry = (IEntry)lockedObject;
                if (o1 == entry.getTopPageChildrenRunnable()) {
                    return this.lessThan();
                }
                if (o1 != entry.getNextPageChildrenRunnable()) continue;
                return this.greaterThan();
            }
            return this.lessThan();
        }
        if (o2 instanceof StudioRunnableWithProgress) {
            StudioRunnableWithProgress runnable = (StudioRunnableWithProgress)o2;
            for (Object lockedObject : runnable.getLockedObjects()) {
                if (lockedObject instanceof ISearch) {
                    ISearch search = (ISearch)lockedObject;
                    if (o2 == search.getTopSearchRunnable()) {
                        return this.greaterThan();
                    }
                    if (o2 != search.getNextSearchRunnable()) continue;
                    return this.lessThan();
                }
                if (!(lockedObject instanceof IEntry)) continue;
                IEntry entry = (IEntry)lockedObject;
                if (o2 == entry.getTopPageChildrenRunnable()) {
                    return this.greaterThan();
                }
                if (o2 != entry.getNextPageChildrenRunnable()) continue;
                return this.lessThan();
            }
            return this.greaterThan();
        }
        if (o1 == null && o2 == null) {
            return this.equal();
        }
        if (o1 == null && o2 != null) {
            return this.lessThan();
        }
        if (o1 != null && o2 == null) {
            return this.greaterThan();
        }
        if (o1 instanceof IEntry || o2 instanceof IEntry) {
            int cat2;
            if (!(o1 instanceof IEntry) && !(o2 instanceof IEntry)) {
                return this.equal();
            }
            if (!(o1 instanceof IEntry) && o2 instanceof IEntry) {
                return this.lessThan();
            }
            if (o1 instanceof IEntry && !(o2 instanceof IEntry)) {
                return this.greaterThan();
            }
            IEntry entry1 = (IEntry)o1;
            IEntry entry2 = (IEntry)o2;
            int cat1 = this.category(entry1);
            if (cat1 != (cat2 = this.category(entry2))) {
                return cat1 - cat2;
            }
            if (this.preferences.getSortBy() == 0) {
                return this.equal();
            }
            if (this.preferences.getSortBy() == 1) {
                return this.compareRdns(entry1, entry2);
            }
            if (this.preferences.getSortBy() == 2) {
                return this.compareRdnValues(entry1, entry2);
            }
            return this.equal();
        }
        if (o1 instanceof ISearchResult || o2 instanceof ISearchResult) {
            int cat2;
            if (!(o1 instanceof ISearchResult) && !(o2 instanceof ISearchResult)) {
                return this.equal();
            }
            if (!(o1 instanceof ISearchResult) && o2 instanceof ISearchResult) {
                return this.lessThan();
            }
            if (o1 instanceof ISearchResult && !(o2 instanceof ISearchResult)) {
                return this.greaterThan();
            }
            ISearchResult sr1 = (ISearchResult)o1;
            ISearchResult sr2 = (ISearchResult)o2;
            int cat1 = this.category(sr1);
            if (cat1 != (cat2 = this.category(sr2))) {
                return cat1 - cat2;
            }
            if (this.preferences.getSortBy() == 0) {
                return this.equal();
            }
            if (this.preferences.getSortBy() == 1) {
                return this.compareRdns(sr1.getEntry(), sr2.getEntry());
            }
            if (this.preferences.getSortBy() == 2) {
                return this.compareRdnValues(sr1.getEntry(), sr2.getEntry());
            }
            return this.equal();
        }
        return this.equal();
    }

    private int compareRdns(IEntry entry1, IEntry entry2) {
        Rdn rdn1 = entry1.getRdn();
        Rdn rdn2 = entry2.getRdn();
        if (rdn1 == null && rdn2 == null) {
            return this.equal();
        }
        if (rdn1 == null && rdn2 != null) {
            return this.greaterThan();
        }
        if (rdn1 != null && rdn2 == null) {
            return this.lessThan();
        }
        return this.compare(rdn1.getUpName(), rdn2.getUpName());
    }

    private int compareRdnValues(IEntry entry1, IEntry entry2) {
        if (entry1 == null && entry2 == null) {
            return this.equal();
        }
        if (entry1 != null && entry2 == null) {
            return this.greaterThan();
        }
        if (entry1 == null && entry2 != null) {
            return this.lessThan();
        }
        Rdn rdn1 = entry1.getRdn();
        Rdn rdn2 = entry2.getRdn();
        if ((rdn1 == null || rdn1.getValue() == null || "".equals(rdn1.getValue())) && (rdn2 == null || rdn2.getValue() == null || "".equals(rdn2.getValue()))) {
            return this.equal();
        }
        if ((rdn1 == null || rdn1.getValue() == null || "".equals(rdn1.getValue())) && rdn2 != null && rdn2.getValue() != null && !"".equals(rdn2.getValue())) {
            return this.greaterThan();
        }
        if (rdn1 != null && rdn1.getValue() != null && !"".equals(rdn1.getValue()) && (rdn2 == null || rdn2.getValue() == null || "".equals(rdn2.getValue()))) {
            return this.lessThan();
        }
        String rdn1Value = rdn1.getUpValue();
        String rdn2Value = rdn2.getUpValue();
        if (rdn1Value.matches("\\d*") && !rdn2Value.matches("\\d*")) {
            return this.compare(rdn1Value, rdn2Value);
        }
        if (!rdn1Value.matches("\\d*") && rdn2Value.matches("\\d*")) {
            return this.compare(rdn1Value, rdn2Value);
        }
        if (rdn2Value.matches("\\d*") && rdn2Value.matches("\\d*")) {
            BigInteger bi1 = new BigInteger(rdn1Value);
            BigInteger bi2 = new BigInteger(rdn2Value);
            return this.compare(bi1, bi2);
        }
        return this.compare(rdn1Value, rdn2Value);
    }

    private int lessThan() {
        return this.preferences.getSortOrder() == 1 ? -1 : 1;
    }

    private int equal() {
        return 0;
    }

    private int greaterThan() {
        return this.preferences.getSortOrder() == 1 ? 1 : -1;
    }

    private int compare(String s1, String s2) {
        return this.preferences.getSortOrder() == 1 ? s1.compareToIgnoreCase(s2) : s2.compareToIgnoreCase(s1);
    }

    private int compare(BigInteger bi1, BigInteger bi2) {
        return this.preferences.getSortOrder() == 1 ? bi1.compareTo(bi2) : bi2.compareTo(bi1);
    }
}

