/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.browser;

import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserContentProvider;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserLabelProvider;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserPreferences;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserSorter;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Menu;

public class BrowserConfiguration {
    private boolean disposed = false;
    protected BrowserSorter sorter;
    protected BrowserPreferences preferences;
    protected BrowserContentProvider contentProvider;
    protected BrowserLabelProvider labelProvider;
    protected DecoratingLabelProvider decoratingLabelProvider;
    protected MenuManager contextMenuManager;

    public void dispose() {
        if (!this.disposed) {
            if (this.sorter != null) {
                this.sorter.dispose();
                this.sorter = null;
            }
            if (this.preferences != null) {
                this.preferences.dispose();
                this.preferences = null;
            }
            if (this.contentProvider != null) {
                this.contentProvider.dispose();
                this.contentProvider = null;
            }
            if (this.labelProvider != null) {
                this.labelProvider.dispose();
                this.labelProvider = null;
                this.decoratingLabelProvider.dispose();
                this.decoratingLabelProvider = null;
            }
            if (this.contextMenuManager != null) {
                this.contextMenuManager.dispose();
                this.contextMenuManager = null;
            }
            this.disposed = true;
        }
    }

    public IMenuManager getContextMenuManager(TreeViewer viewer) {
        if (this.contextMenuManager == null) {
            this.contextMenuManager = new MenuManager();
            Menu menu = this.contextMenuManager.createContextMenu(viewer.getControl());
            viewer.getControl().setMenu(menu);
        }
        return this.contextMenuManager;
    }

    public BrowserContentProvider getContentProvider(TreeViewer viewer) {
        if (this.contentProvider == null) {
            this.contentProvider = new BrowserContentProvider(viewer, this.getPreferences(), this.getSorter());
        }
        return this.contentProvider;
    }

    public DecoratingLabelProvider getLabelProvider(TreeViewer viewer) {
        if (this.labelProvider == null) {
            this.labelProvider = new BrowserLabelProvider(this.getPreferences());
            this.decoratingLabelProvider = new DecoratingLabelProvider((ILabelProvider)this.labelProvider, BrowserCommonActivator.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator());
        }
        return this.decoratingLabelProvider;
    }

    public BrowserSorter getSorter() {
        if (this.sorter == null) {
            this.sorter = new BrowserSorter(this.getPreferences());
        }
        return this.sorter;
    }

    public BrowserPreferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = new BrowserPreferences();
        }
        return this.preferences;
    }
}

