/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets;

import org.apache.directory.studio.connection.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public abstract class ViewFormWidget {
    protected ViewForm control;
    protected Text infoText;
    protected ToolBar actionToolBar;
    protected IToolBarManager actionToolBarManager;
    protected ToolBar menuToolBar;
    protected MenuManager menuManager;
    protected MenuManager contextMenuManager;

    public void createWidget(Composite parent) {
        this.control = new ViewForm(parent, 0);
        this.control.setLayoutData((Object)new GridData(1808));
        Composite infoTextControl = BaseWidgetUtils.createColumnContainer((Composite)this.control, (int)1, (int)1);
        infoTextControl.setLayoutData((Object)new GridData(1808));
        this.infoText = BaseWidgetUtils.createLabeledText((Composite)infoTextControl, (String)"", (int)1);
        this.infoText.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.control.setTopLeft((Control)infoTextControl);
        this.actionToolBar = new ToolBar((Composite)this.control, 0x820000);
        this.actionToolBar.setLayoutData((Object)new GridData(0x1000008, 0, true, false));
        this.actionToolBarManager = new ToolBarManager(this.actionToolBar);
        this.control.setTopCenter((Control)this.actionToolBar);
        this.menuManager = new MenuManager();
        this.menuToolBar = new ToolBar((Composite)this.control, 0x820000);
        ToolItem ti = new ToolItem(this.menuToolBar, 8, 0);
        ti.setImage(BrowserCommonActivator.getDefault().getImage("resources/icons/pulldown.gif"));
        ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewFormWidget.this.showViewMenu();
            }
        });
        this.control.setTopRight((Control)this.menuToolBar);
        Composite composite = BaseWidgetUtils.createColumnContainer((Composite)this.control, (int)1, (int)1);
        GridLayout gl = new GridLayout();
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        composite.setLayout((Layout)gl);
        Control childControl = this.createContent(composite);
        this.control.setContent((Control)composite);
        this.contextMenuManager = new MenuManager();
        Menu menu = this.contextMenuManager.createContextMenu(childControl);
        childControl.setMenu(menu);
    }

    protected abstract Control createContent(Composite var1);

    private void showViewMenu() {
        Menu aMenu = this.menuManager.createContextMenu((Control)this.control);
        Point topLeft = new Point(0, 0);
        topLeft.y += this.menuToolBar.getBounds().height;
        topLeft = this.menuToolBar.toDisplay(topLeft);
        aMenu.setLocation(topLeft.x, topLeft.y);
        aMenu.setVisible(true);
    }

    public void dispose() {
        if (this.control != null) {
            if (this.contextMenuManager != null) {
                this.contextMenuManager.removeAll();
                this.contextMenuManager.dispose();
                this.contextMenuManager = null;
            }
            if (this.menuToolBar != null) {
                this.menuToolBar.dispose();
                this.menuToolBar = null;
                this.menuManager.dispose();
                this.menuManager = null;
            }
            if (this.actionToolBar != null) {
                this.actionToolBar.dispose();
                this.actionToolBar = null;
                this.actionToolBarManager.removeAll();
                this.actionToolBarManager = null;
            }
            if (this.infoText != null) {
                this.infoText.dispose();
                this.infoText = null;
            }
            this.control.dispose();
            this.control = null;
        }
    }

    public Text getInfoText() {
        return this.infoText;
    }

    public IToolBarManager getToolBarManager() {
        return this.actionToolBarManager;
    }

    public IMenuManager getMenuManager() {
        return this.menuManager;
    }

    public IMenuManager getContextMenuManager() {
        return this.contextMenuManager;
    }

    public Control getControl() {
        return this.control;
    }
}

