/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets;

import java.util.Arrays;
import org.apache.directory.studio.connection.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.common.widgets.BrowserWidget;
import org.apache.directory.studio.ldapbrowser.common.widgets.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

public class OptionsInput
extends BrowserWidget {
    private String title;
    private Group titleGroup;
    private String defaultRawValue;
    private String defaultDisplayValue;
    private Button defaultButton;
    private String[] otherRawValues;
    private String[] otherDisplayValues;
    private Button otherButton;
    private Combo otherCombo;
    private String initialRawValue;
    private boolean asGroup;
    private boolean allowCustomInput;

    public OptionsInput(String title, String defaultDisplayValue, String defaultRawValue, String[] otherDisplayValues, String[] otherRawValues, String initialRawValue, boolean asGroup, boolean allowCustomInput) {
        this.title = title;
        this.defaultDisplayValue = defaultDisplayValue;
        this.defaultRawValue = defaultRawValue;
        this.otherDisplayValues = otherDisplayValues;
        this.otherRawValues = otherRawValues;
        this.initialRawValue = initialRawValue;
        this.asGroup = asGroup;
        this.allowCustomInput = allowCustomInput;
    }

    public void createWidget(Composite parent) {
        Composite composite;
        if (this.asGroup) {
            this.titleGroup = BaseWidgetUtils.createGroup((Composite)parent, (String)this.title, (int)1);
            composite = BaseWidgetUtils.createColumnContainer((Composite)this.titleGroup, (int)1, (int)1);
        } else {
            composite = parent;
            Composite labelComposite = BaseWidgetUtils.createColumnContainer((Composite)composite, (int)1, (int)1);
            BaseWidgetUtils.createLabel((Composite)labelComposite, (String)(this.title + ":"), (int)1);
        }
        Composite defaultComposite = BaseWidgetUtils.createColumnContainer((Composite)composite, (int)1, (int)1);
        this.defaultButton = BaseWidgetUtils.createRadiobutton((Composite)defaultComposite, (String)this.defaultDisplayValue, (int)1);
        this.defaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OptionsInput.this.otherButton.setSelection(false);
                OptionsInput.this.otherCombo.setEnabled(false);
                OptionsInput.this.notifyListeners();
            }
        });
        Composite otherComposite = BaseWidgetUtils.createColumnContainer((Composite)composite, (int)2, (int)1);
        this.otherButton = BaseWidgetUtils.createRadiobutton((Composite)otherComposite, (String)Messages.getString("OptionsInput.Other"), (int)1);
        this.otherButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OptionsInput.this.defaultButton.setSelection(false);
                OptionsInput.this.otherCombo.setEnabled(true);
                OptionsInput.this.notifyListeners();
            }
        });
        this.otherCombo = this.allowCustomInput ? BaseWidgetUtils.createCombo((Composite)otherComposite, (String[])this.otherDisplayValues, (int)0, (int)1) : BaseWidgetUtils.createReadonlyCombo((Composite)otherComposite, (String[])this.otherDisplayValues, (int)0, (int)1);
        this.otherCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OptionsInput.this.notifyListeners();
            }
        });
        this.setRawValue(this.initialRawValue);
    }

    public String getRawValue() {
        if (this.defaultButton.getSelection()) {
            return this.defaultRawValue;
        }
        String t = this.otherCombo.getText();
        for (int i = 0; i < this.otherDisplayValues.length; ++i) {
            if (!t.equals(this.otherDisplayValues[i])) continue;
            return this.otherRawValues[i];
        }
        return t;
    }

    public void setRawValue(String rawValue) {
        int index = Arrays.asList(this.otherRawValues).indexOf(rawValue);
        if (index == -1) {
            index = Arrays.asList(this.otherDisplayValues).indexOf(rawValue);
        }
        if (this.defaultRawValue.equals(rawValue)) {
            this.defaultButton.setSelection(true);
            this.otherButton.setSelection(false);
            this.otherCombo.setEnabled(false);
            this.otherCombo.select(index);
        } else if (index > -1) {
            this.defaultButton.setSelection(false);
            this.otherButton.setSelection(true);
            this.otherCombo.setEnabled(true);
            this.otherCombo.select(index);
        } else {
            this.defaultButton.setSelection(false);
            this.otherButton.setSelection(true);
            this.otherCombo.setEnabled(true);
            this.otherCombo.setText(rawValue);
        }
    }
}

